#ifndef	_EVideo_h
#define _EVideo_h

#include <dmedia/vl.h>
#include <dmedia/vl_vino.h>

typedef struct
{
 int	Source;
 int	Size;				// EvSIZE_FULL, EvSIZE_HALF or Ev_SIZE_QUARTER
 int	XOffset,YOffset,XSize,YSize;	// Cropping
 int	ImageFormat;
 float	Brightness,Contrast,Saturation,RedBalance,GreenBalance,BlueBalance;
} EvVLSetup;

#define	MAX_NUM_OF_DEVICES	16
#define	MAX_NUM_OF_INPUT_NODES	8
#define	MAX_NUM_OF_DRAIN_NODES	8

typedef struct
{
 int		ID;
 char		Name[64];
 int		Number;
 int		Kind;
} EvInputNode;

typedef struct
{
 int		ID;
 char		Name[64];
 int		Number;
 int		Kind;
} EvDrainNode;

typedef struct
{
 VLDev		ID;
 char		Name[32];
 EvInputNode	InputNodes[MAX_NUM_OF_INPUT_NODES];
 EvDrainNode	DrainNodes[MAX_NUM_OF_DRAIN_NODES];
 int		NumOfInputNodes;
 int		NumOfDrainNodes;
} EvDevice;

enum { EvDEVICE_NONE=0,EvDEVICE_VINO };

#define EV_ANY	0

enum { EV_SRC_VINO_DV_IN=1,EV_SRC_VINO_AV_IN};
enum { EvSIZE_FULL,EvSIZE_HALF,EvSIZE_QUARTER };
enum { EvSTATUS_NONE,EvCONNECTED,EvNO_DRAIN,EvNO_PATH,EvPATH_ERROR,EvOK };

#define EvSETUPD_VIDEOFRAMERATE	1
#define EvSETUPD_VIDEOXSIZE	(1<<1)
#define EvSETUPD_VIDEOYSIZE	(1<<2)
#define EvSETUPD_VIDEOSIZEOM	(1<<3)
#define EvSETUPD_ALL		0xF


enum { EvREC_NORMAL=0,EvREC_FRAME,EvREC_INTERVAL };


#ifndef _EvInSource
extern int		Ev_BlueOffset;
extern int		Ev_VideoXSize,Ev_VideoYSize;
extern int		Ev_VideoFrameRate;
extern int		Ev_CanvasXSize,Ev_CanvasYSize;
extern unsigned long*	Ev_VideoBuffer;

extern VLPath		Ev_Path;
extern VLNode		Ev_Source,Ev_DrainScreen,Ev_DrainGFX,Ev_DrainMemory;
extern VLControlValue	val;
extern VLServer		Ev_Server;
extern VLBuffer		Ev_VLBuffer;
extern Boolean		Ev_BufferValid;

extern VLEventMask	Ev_VLEventMask;

extern Boolean		Ev_ConnectedToVideoDaemon;
extern int		Ev_Status;
extern int		Ev_VideoSource,Ev_VideoFormat,Ev_VideoSize;
extern unsigned long	Ev_VideoImageFormat;
extern int		Ev_VideoXSize,Ev_VideoYSize;
extern int		Ev_VideoMaxXSize,Ev_VideoMaxYSize;
extern float		Ev_VideoBrightness,Ev_VideoContrast,Ev_VideoSaturation;
extern float		Ev_VideoZoomX,Ev_VideoZoomY;
extern int		Ev_VCropLeft,Ev_VCropRight,Ev_VCropTop,Ev_VCropBottom;
extern void		Ev_Init();
extern int		Ev_OpenVideo();
extern int		Ev_InitVideo();
extern void		Ev_EnumVLEvent();
#endif	// _EvInSource

#endif	// _EVideo_h
