/*======================================================================*/
/* Xe Widget set							*/
/*									*/
/* XeBoard								*/
/* Private header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-30 23:15:21					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeBoardP_h
#define _XeBoardP_h

#ifdef _XeUSEXm
#include <Xm/ManagerP.h>
#endif // _XeUSEXm

#include <Xe/ManagerP.h>
#include <Xe/Board.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeBoardClassPart
{
 XtPointer	extension;
} XeBoardClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeBoardClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;
 XeBoardClassPart	xeBoard_class;
} XeBoardClassRec;

extern XeBoardClassRec xeBoardClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
 GC		DrawGC;

 Widget		DefaultButton;
 XeFontList	LabelFontList, TextFieldFontList;

 XtCallbackList	MapCallback, UnmapCallback;

 unsigned int	ShadowType;

 Dimension	MarginXSize, MarginYSize;
 Dimension	OldXSize, OldYSize, OldShadowThickness;

 Pixel		LabelColor, ButtonColor, ActiveColor, TroughColor, TextBackgroundColor, TextForegroundColor;

 Boolean	NoResize;
 unsigned char	ResizePolicy;	
// Private variables
} XeBoardPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeBoardRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm

 XeManagerPart		xeManager;

 XeBoardPart		xeBoard;
} XeBoardRec;


#define BB_MarginHeight(w) \
	(((XeBoardWidget)(w))->xeBoard.MarginYSize)

#define BB_MarginWidth(w) \
	(((XeBoardWidget)(w))->xeBoard.MarginXSize)


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeBoardP_h
