/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeClipWindow							*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jan-01 22:59:28				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeClipWindowP_h
#define _XeClipWindowP_h

#include <Xe/ManagerP.h>
#include <Xe/ClipWindow.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeClipWindowClassPart
{
 XtPointer	extension;
} XeClipWindowClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeClipWindowClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;

 XeClipWindowClassPart	xeClipWindow_class;
} XeClipWindowClassRec;

extern XeClipWindowClassRec xeClipWindowClassRec;


// Constraint resources
//
typedef struct _XeClipWindowConstraintPart
{
 Boolean		Resizable;
 Dimension		PreferredXSize, PreferredYSize;
// Xe
 Position		X, Y;
 int			XSize, YSize;
// Xe
} XeClipWindowConstraintPart;


typedef struct _XeClipWindowConstraintRec
{
 XeClipWindowConstraintPart	ClipWindow;
} XeClipWindowConstraintRec, *XeClipWindowConstraints;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Private variables
//
 GC		DrawGC;
} XeClipWindowPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeClipWindowRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm

 XeManagerPart		xeManager;
 XeClipWindowPart	xeClipWindow;
} XeClipWindowRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeClipWindowP_h
