/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeForm							*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jan-26 21:54:45				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeFormP_h
#define _XeFormP_h

#include <Xe/BoardP.h>
#include <Xe/Form.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeFormClassPart
{
 XtPointer	extension;
} XeFormClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeFormClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;

 XeBoardClassPart	xeBoard_class;
 XeFormClassPart	xeForm_class;
} XeFormClassRec;

extern XeFormClassRec xeFormClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Private variables
 Dimension	HorizontalSpacing;
 Dimension	VerticalSpacing;
 int		FractionBase;
 Widget		first_child;

 Boolean	RubberPositioning;
 Boolean	RecomputeSizeIfNotRealized;	// If a child geometry, attacment, managed/unmanaged state changes, resize the XeForm even if it is not realized
 Boolean	processing_constraints;
} XeFormPart;


typedef struct _XeFormAttachmentRec
{
 unsigned char	Type;
 Widget		w;
 int		Percent;
 int		Offset;
 int		Value, TmpValue;
} XeFormAttachmentRec, *XeFormAttachment;


// Constraint resources
//
typedef struct _XeFormConstraintPart
{
 XeFormAttachmentRec	Attachments[4];
 Dimension		PreferredXSize, PreferredYSize;
 Dimension		XSizeByForm, YSizeByForm;
 Widget			next_sibling;

 Position		X, Y;
 int			XSize, YSize;

 int			XSizeProposed, YSizeProposed;	// The size for this child that XeForm's geometry_manager returned with an XtGeometryAlmost

 int			MinXSize, MaxXSize, MinYSize, MaxYSize;
 Boolean		sorted;
 Boolean		resizable;
} XeFormConstraintPart;


typedef struct _XeFormConstraintRec
{
 XeFormConstraintPart		Form;
} XeFormConstraintRec,*XeFormConstraints;



/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeFormRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm

 XeManagerPart		xeManager;

 XeBoardPart		xeBoard;
 XeFormPart		xeForm;
} XeFormRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif


#endif // _XeFormP_h
