/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeFrame							*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1995-Jul-08 18:03:30				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeFrameP_h
#define _XeFrameP_h

#include <Xe/ManagerP.h>
#include <Xe/Frame.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeFrameClassPart
{
 XtPointer	extension;
} XeFrameClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeFrameClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;

 XeFrameClassPart	xeFrame_class;
} XeFrameClassRec;

extern XeFrameClassRec xeFrameClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
 Dimension	MarginXSize,MarginYSize;
 unsigned int	ShadowType;
 Boolean	AdjustEntryXSize, AdjustEntryYSize;

// Private variables
//
 GC		DrawGC;
} XeFramePart;




// Constraint resources
//
typedef struct _XeFrameConstraintPart
{
 Boolean	Resizable;
 Dimension	PreferredXSize, PreferredYSize;

// Xe
 Position	X, Y;
 int		XSize, YSize;
 Dimension	XSizeByFrame, YSizeByFrame;
 int		XSizeProposed, YSizeProposed;	// The size for this child that XeMessageBox's geometry_manager returned with an XtGeometryAlmost
} XeFrameConstraintPart;


typedef struct _XeFrameConstraintRec
{
 XeFrameConstraintPart	Frame;
} XeFrameConstraintRec,*XeFrameConstraints;



/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeFrameRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm

 XeManagerPart		xeManager;
 XeFramePart		xeFrame;
} XeFrameRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeFrameP_h
