/*======================================================================*/
/* Xe Widget set							*/
/*									*/
/* XeLabel								*/
/* Private header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Nov-12 12:44:55					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeLabelP_h
#define _XeLabelP_h

#include <Xe/PrimitiveP.h>
#include <Xe/Label.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeLabelClassPart
{
 XtPointer	extension;
} XeLabelClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeLabelClassRec
{
 CoreClassPart		core_class;
 XePrimitiveClassPart	xePrimitive_class;
 XeLabelClassPart	xeLabel_class;
} XeLabelClassRec;

extern XeLabelClassRec xeLabelClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
 char*			Accelerator;
 XeString		AcceleratorString;	// The resource name is XeNacceleratorText
 Dimension		AcceleratorStringXSize;
 Position		AcceleratorStringX;

 Pixel			ForegroundColor;
 XeString		LabelString;
 EpImage*		LabelRGBAImage, LabelInsensitiveRGBAImage;
 Pixmap			LabelPixmap, LabelPixmapMask, LabelInsensitivePixmap, LabelInsensitivePixmapMask;
 Dimension		MarginLeft, MarginRight, MarginTop, MarginBottom, MarginXSize, MarginYSize;
 Dimension		LabelXSpacing, LabelYSpacing;
 Position		LabelX, LabelY, LabelStringX, LabelStringY, LabelPixmapX, LabelPixmapY;
 XeFontList		LabelFontList;

 unsigned int		ShadowType;
 unsigned char		LabelType, LabelXAlignment, LabelYAlignment;
 int			LabelShadow;
 char			Mnemonic;
 Boolean		RecomputeSize;

// Private variables
 int			LabelXSize, LabelYSize, LabelStringXSize, LabelStringYSize, LabelPixmapXSize, LabelPixmapYSize;
 XeStringBinarySegment*	BinaryLabelString;
 int			SegmentsInLabelString;
 XeStringBinarySegment*	BinaryAcceleratorString;
 int			SegmentsInAcceleratorString;
 GC			DrawGC;
 Pixmap			CachePixmap;
 Boolean		LabelStringCreatedFromName;
} XeLabelPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeLabelRec
{
 CorePart		core;
 XePrimitivePart	xePrimitive;
 XeLabelPart		xeLabel;
} XeLabelRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeLabelP_h
