/*======================================================================*/
/* 'Xe' ERIDANI Widget							*/
/*									*/
/* XePrimitive								*/
/* Private header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Aug-01 23:56:40					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XePrimitiveP_h
#define _XePrimitiveP_h

#include <Xe/XeP.h>
#include <Xe/Primitive.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XePrimitiveClassPart
{
 XtPointer	extension;
} XePrimitiveClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XePrimitiveClassRec
{
 CoreClassPart		core_class;
// XmPrimitiveClassPart	xmPrimitive_class;
 XePrimitiveClassPart	xePrimitive_class;
} XePrimitiveClassRec;

extern XePrimitiveClassRec xePrimitiveClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
 Widget			TraverseLeft, TraverseRight, TraverseUp, TraverseDown;
 XVisualInfo*		VisualInfo;
 int			RedrawPolicy;				// Tells the subclass how to redraw itself
 Dimension		GapWidth, ShadowThickness,
			HighlightThickness;

 Pixel			HighlightColor;
 Pixel			BackgroundColor;			// We have this separately, so we can change the background color without the core widget calling XClearArea on us from its set_values method
 Pixel			ActiveColor;				// Used as background when the pointer is above the widget
 Pixel			TopShadowColor, TopShadowColor2,	// A brighter and a slightly darker TopShadowColor
			BottomShadowColor, BottomShadowColor2,	// A darker and a slightly brighter TopShadowColor
			GapColor;

 XtPointer		UserData;

 Pixel			BubbleBackground;			// Background color for bubble help
 int			BubbleDelay;				// Delay for bubble help (milliseconds, 0=don't display bubble help)
 XeFontList		BubbleFontList;				// FontList for bubble help
 XeString		BubbleString;				// String in 'bubble' help

// Internal variables
//
 Widget			BubbleShellW, BubbleLabelW;
 XtIntervalId		BubbleTimerId;
 Window			ShadowBWindow, ShadowRWindow;		// Cast shadow windows (one on the below and one on the right side of the menu pane)
 Pixmap			ShadowBMask, ShadowRMask;		// Cast shadow masks
 int			ShadowXSize, ShadowYSize;		// Size of the shadows

 Boolean		DoLayoutInExpose;			// Call Layout in expose method before redrawing

 Boolean		HasKeyboardFocus;
 Boolean		ClearBackground;			// Let X clear the background on expose or not
 Boolean		ActiveColorGiven;
 Boolean		ShadowColorsDefined;			// TopShadow and/or BottomShadow colord were given by the application
} XePrimitivePart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XePrimitiveRec
{
 CorePart		core;
// XmPrimitivePart	xmPrimitive;
 XePrimitivePart	xePrimitive;
} XePrimitiveRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XePrimitiveP_h
