/*======================================================================*/
/* 'Xe' ERIDANI Widget set 						*/
/*									*/
/* XePushButton								*/
/* Private header file							*/
/*									*/
/* DATE:	1996-Dec-20 22:41:01					*/
/*									*/
/* Xe(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XePushButtonP_h
#define _XePushButtonP_h

#include <Xe/LabelP.h>
#include <Xe/MenuButtonP.h>
#include <Xe/PushButton.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XePushButtonClassPart
{
 XtPointer	extension;
} XePushButtonClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XePushButtonClassRec
{
 CoreClassPart		core_class;
 XePrimitiveClassPart	xePrimitive_class;
 XeLabelClassPart	xeLabel_class;
 XePushButtonClassPart	xePushButton_class;
} XePushButtonClassRec;

extern XePushButtonClassRec xePushButtonClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
 Pixel			ArmColor;

 EpImage*		ArmRGBAImage, ActiveRGBAImage;
 Pixmap			ArmPixmap, ArmPixmapMask, ActivePixmap, ActivePixmapMask;

 XtCallbackList		ArmCallback, DisarmCallback, ActivateCallback;
 int			DefaultButtonShadowThickness;
 XeString		AcceleratorText;
 char			Mnemonic;
 int			OptionsButtonXSize;
 Boolean		ShowAsDefault, CreateOptionsButton;

// Private variables
 int			DefShadowSpacing;
 unsigned char		DragMode;
 Boolean		Active, Armed,
			ArmColorGiven;
} XePushButtonPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XePushButtonRec
{
 CorePart		core;
 XePrimitivePart	xePrimitive;
 XeLabelPart		xeLabel;
 XeMenuButtonPart	xeMenuButton;
 XePushButtonPart	xePushButton;
} XePushButtonRec;

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XePushButtonP_h
