/*======================================================================*/
/* Xe Widget set							*/
/*									*/
/* XeSeparator								*/
/* Private header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-14 21:36:55					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeSeparatorP_h
#define _XeSeparatorP_h

#include <Xe/PrimitiveP.h>
#include <Xe/Separator.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeSeparatorClassPart
{
 XtPointer	extension;
} XeSeparatorClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeSeparatorClassRec
{
 CoreClassPart		core_class;
 XePrimitiveClassPart	xePrimitive_class;
 XeSeparatorClassPart	xeSeparator_class;
} XeSeparatorClassRec;

extern XeSeparatorClassRec xeSeparatorClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
 unsigned int		ShadowType;
 char			Orientation;

// Private variables
 GC			DrawGC;
 Pixmap			CachePixmap;
} XeSeparatorPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeSeparatorRec
{
 CorePart		core;
 XePrimitivePart	xePrimitive;
 XeSeparatorPart	xeSeparator;
} XeSeparatorRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeSeparatorP_h
