/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeTextField							*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-May-31 23:28:54				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeTextWidgetP_h
#define _XeTextWidgetP_h

#include <Xe/PrimitiveP.h>
#include <Xe/TextField.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeTextFieldClassPart
{
 XtPointer	extension;
} XeTextFieldClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeTextFieldClassRec
{
 CoreClassPart		core_class;
 XePrimitiveClassPart	xePrimitive_class;
 XeTextFieldClassPart	xeTextField_class;
} XeTextFieldClassRec;

extern XeTextFieldClassRec xeTextFieldClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
//
 int			NumOfColumns;
 Pixel			ForegroundColor, TextHighlightColor, SelectColor, CursorColor;
 Pixel			TextBGTopShColor, TextBGBottomShColor;
 Pixel*			TextColors;
 int			NumOfTextColors;
 Dimension		MarginLeft, MarginRight, MarginTop, MarginBottom, MarginXSize, MarginYSize,
			StringAreaXSize, StringAreaYSize;

 Position		StringX, StringY;

 XFontStruct*		Font;
 XeFontList		StringFontList;

 unsigned int		ShadowType;
 unsigned char		StringXAlignment, StringYAlignment;

 char			CursorType;			// XeIBEAM, XeSOLID

 int			StringXOffset, StringYOffset,	// Scroll-offset in pixels. These are synchronized with TopCharacter!
			StringXModulo, StringYModulo;	// ...

 XeTextPosition		TopCharacter,			// Character position where displaying begins
			CursorPosition;
 int			CursorX, CursorY;		// Cursor position in pixels
 int			Columns;

 int			CursorBlinkRate;

 XtCallbackList		ValueChangedCallback, ActivateCallback;
 Boolean		InsertMode;
 Boolean		CursorPositionVisible;

// Private variables
//
 Position		CursorWX, CursorWY;		// Window-relative Cursor position in pixels
 Dimension		CursorXSize, CursorYSize;
 XtIntervalId		CursorTimerID;
 Pixmap			UnderCursorPixmap;		// For blinking the cursor
 XeTextPosition		StringLength,
			SelectionStart, SelectionEnd,
			SelectionAnchor;
 char*			String;
 GC			DrawGC, TextDrawGC;
} XeTextFieldPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeTextFieldRec
{
 CorePart		core;
 XePrimitivePart	xePrimitive;
 XeTextFieldPart	xeTextField;
} XeTextFieldRec;

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeTextFieldWidgetP_h
