#!/bin/csh
#
#  This C shell is used to display the user selected
#  maps.   It first generates maps using the rules 
#  generated by critical area analysis.
#
#  This shell requires 2 input parameters.  The first
#  is the path name for the selected simulation.  The
#  second is the map type the user wants to display.
#
#
#              Zhian Li, 4/15/95
####################################################
#
# MODIFIED BY MIKE FOSTER 2-21-96 to show only
#
# AGNPS output contaminant load, not critical
#
# area
#
# Parameters: $1 is mapflag (map type)
#             $2 is the cell size desired for 
#                purposes of naming the cell_num.map
#                file, e.g. cell_num.map.100 
###################################################
#
#  Switch to the correct directory 

#   cd $1

#  Set the GIS environment variable
  
   setenv GISRC $HOME/.grassrc5 
# 
# 
#  Generate maps 
#
#   FIRST, SET THE RESOLUTION IN THE GRASS MONITOR ITSELF
   
   g.region res=$2
   d.frame -e
#
   r.reclass input=cell_num.map.$2 output=Sed_N.map <N_sed.rules
   r.reclass input=cell_num.map.$2 output=Sol_N.map <N_sol.rules

#  Make the monitor into 4 frames and show three maps for 
#  Sedmiment attatched Nitrogen, soluble Nitrogen, or total 
#  Nitrogen.

########The next statement is no longer needed in the modified
#       version
#       MIKE FOSTER 2-23-96
#       d.mon select=${MONITOR}

        d.frame -e
        d.frame -c frame=f1 at=0,100,0,60
        d.frame -c frame=f2 at=0,80,60,100
        d.frame -c frame=f3 at=80,100,60,100

#  Make a temporary directory if it does not exist

        if ( ! -d $HOME/tmp ) mkdir $HOME/tmp

   switch ( $1 )

     # Reclass and show the map of sediment attatched Nitrogen  
      case 1:
        d.frame -s frame=f3
        echo "Sediment Nitrogen"|d.text size=20 color=red line=2
        echo "Load"|d.text size=20 color=red line=3
        echo "in lbs/acre"|d.text size=20 color=yellow line=4
        cat N.title |d.text size=20 color=yellow line=5
        $GISBASE/etc/agnps50/psu_agnps_max_cat.sh Sed_N.map
        d.frame -s frame=f1
        d.rast map=Sed_N.map.reclass
        d.frame -s frame=f2
        d.legend map=Sed_N.map.reclass lines=20
       breaksw


     # Show the map of soluble Nitrogen  
      case 2:
        d.frame -s frame=f3
        echo "Total Soluble Nitrogen"|d.text size=20 color=red line=2
        echo "Load"|d.text size=20 color=red line=3
        echo "in lbs/acre"|d.text size=20 color=yellow line=4
        cat N.title |d.text size=20 color=yellow line=5
        $GISBASE/etc/agnps50/psu_agnps_max_cat.sh Sol_N.map
        d.frame -s frame=f1
        d.rast map=Sol_N.map.reclass
        d.frame -s frame=f2
        d.legend map=Sol_N.map.reclass lines=20
       breaksw

     endsw


      if ( -f $HOME/tmp/tmp.rule ) rm $HOME/tmp/tmp.rule

     #Show the numbers of the cell map.  ADDED BY MIKE FOSTER
     # 3-31-96.

     d.frame -s frame=f1 
     d.rast.num map=cell_num.map.$2 grid=black
