/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.common;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.common.Exporter;
import com.sun.dhcpmgr.common.ResourceStrings;
import com.sun.dhcpmgr.data.ActionError;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.server.DhcpMgr;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class ExportController {
    Exporter exporter;
    DhcpMgr server;
    String user;
    String file;
    private boolean allNets = false;
    private boolean allMacros = false;
    private boolean allOptions = false;
    private static final Network[] emptyNets = new Network[0];
    private static final String[] emptyMacros = new String[0];
    private static final String[] emptyOptions = new String[0];
    Network[] networks = emptyNets;
    String[] macros = emptyMacros;
    String[] options = emptyOptions;
    private static final int OPTION_DELETE_OPS = 2;
    private static final int MACRO_DELETE_OPS = 2;
    private static final int NETWORK_DELETE_OPS = 2;
    private static final int DEFAULT_OPTION_COUNT = 10;
    private static final int DEFAULT_MACRO_COUNT = 50;
    private static final int DEFAULT_CLIENTS_PER_NET = 150;

    public ExportController(Exporter exporter, DhcpMgr dhcpMgr) {
        this.exporter = exporter;
        this.server = dhcpMgr;
    }

    private void displayException(Exception exception, String string) {
        MessageFormat messageFormat = new MessageFormat(string);
        String[] stringArray = new String[]{exception.getMessage()};
        this.exporter.displayError(messageFormat.format(stringArray));
    }

    public boolean exportData(boolean bl, boolean bl2) throws ExistsException {
        Object object = null;
        boolean bl3 = false;
        boolean bl4 = true;
        if (this.allNets) {
            try {
                this.setNetworks(this.server.getNetMgr().getNetworks());
            }
            catch (Exception exception) {
                this.displayException(exception, ResourceStrings.getString("exp_err_loading_networks"));
                return false;
            }
        }
        int n = this.networks.length + 2;
        int n2 = this.allOptions ? 10 : this.options.length;
        int n3 = 0;
        int n4 = this.allMacros ? 50 : this.macros.length;
        int n5 = 0;
        int n6 = 150 * this.networks.length;
        int n7 = 0;
        int n8 = n2 + n4 + n6;
        if (n8 == 0) {
            this.exporter.displayError(ResourceStrings.getString("exp_err_no_data"));
            return false;
        }
        if (bl) {
            n3 = n2 * 2;
            n5 = n4 * 2;
            n7 = n6 * 2;
            n8 += n3 + n5 + n7;
        }
        try {
            object = this.server.openExportFile(this.file, this.user, n, this.networks, bl2);
            if (object == null) {
                String[] stringArray = new String[]{this.server.getDhcpServiceMgr().getServerName(), this.server.getLockPath()};
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("lock_error"));
                this.exporter.displayError(messageFormat.format(stringArray));
                return false;
            }
        }
        catch (IOException iOException) {
            this.displayException(iOException, ResourceStrings.getString("exp_err_io"));
            return false;
        }
        try {
            try {
                this.exporter.initializeProgress(n8);
                int n9 = 0;
                if (n2 != 0) {
                    this.exporter.updateProgress(n9, ResourceStrings.getString("exp_exporting_options"));
                }
                try {
                    this.server.exportOptions(object, this.allOptions, this.options);
                }
                catch (BridgeException bridgeException) {
                    this.displayException((Exception)((Object)bridgeException), ResourceStrings.getString("exp_err_exporting_options"));
                    throw new InterruptedException();
                }
                n9 += n2;
                if (n4 != 0) {
                    this.exporter.updateProgress(n9, ResourceStrings.getString("exp_exporting_macros"));
                }
                try {
                    this.server.exportMacros(object, this.allMacros, this.macros);
                }
                catch (BridgeException bridgeException) {
                    this.displayException((Exception)((Object)bridgeException), ResourceStrings.getString("exp_err_exporting_macros"));
                    throw new InterruptedException();
                }
                n9 += n4;
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("exp_exporting_network"));
                String[] stringArray = new String[1];
                int n10 = 0;
                while (n10 < this.networks.length) {
                    try {
                        stringArray[0] = this.networks[n10].toString();
                        this.exporter.updateProgress(n9, messageFormat.format(stringArray));
                        this.server.exportNetwork(object, this.networks[n10]);
                        n9 += 150;
                    }
                    catch (BridgeException bridgeException) {
                        MessageFormat messageFormat2 = new MessageFormat(ResourceStrings.getString("exp_err_exporting_network"));
                        String[] stringArray2 = new String[]{stringArray[0], bridgeException.getMessage()};
                        this.exporter.displayError(messageFormat2.format(stringArray2));
                        throw new InterruptedException();
                    }
                    ++n10;
                }
                bl4 = false;
                if (bl) {
                    ActionError[] actionErrorArray;
                    ActionError[] actionErrorArray2;
                    if (n3 != 0) {
                        this.exporter.updateProgress(n9, ResourceStrings.getString("exp_deleting_options"));
                    }
                    if (this.allOptions) {
                        try {
                            actionErrorArray2 = this.server.getDhcptabMgr().deleteAllOptions();
                        }
                        catch (BridgeException bridgeException) {
                            actionErrorArray2 = new ActionError[]{new ActionError(ResourceStrings.getString("all_options"), (Exception)((Object)bridgeException))};
                        }
                    } else {
                        actionErrorArray2 = this.server.getDhcptabMgr().deleteOptions(this.options);
                    }
                    n9 += n3;
                    if (n5 != 0) {
                        this.exporter.updateProgress(n9, ResourceStrings.getString("exp_deleting_macros"));
                    }
                    if (this.allMacros) {
                        try {
                            actionErrorArray = this.server.getDhcptabMgr().deleteAllMacros();
                        }
                        catch (BridgeException bridgeException) {
                            actionErrorArray = new ActionError[]{new ActionError(ResourceStrings.getString("all_macros"), (Exception)((Object)bridgeException))};
                        }
                    } else {
                        actionErrorArray = this.server.getDhcptabMgr().deleteMacros(this.macros);
                    }
                    n9 += n5;
                    messageFormat = new MessageFormat(ResourceStrings.getString("exp_deleting_network"));
                    ArrayList<ActionError> arrayList = new ArrayList<ActionError>();
                    int n11 = 0;
                    while (n11 < this.networks.length) {
                        stringArray[0] = this.networks[n11].toString();
                        this.exporter.updateProgress(n9, messageFormat.format(stringArray));
                        try {
                            this.server.getNetMgr().deleteNetwork(stringArray[0], false, true);
                        }
                        catch (BridgeException bridgeException) {
                            arrayList.add(new ActionError(stringArray[0], (Exception)((Object)bridgeException)));
                        }
                        n9 += 300;
                        ++n11;
                    }
                    this.exporter.updateProgress(n9, ResourceStrings.getString("export_completed"));
                    if (actionErrorArray2 != null && actionErrorArray2.length > 0) {
                        this.exporter.displayErrors(ResourceStrings.getString("exp_err_deleting_options"), ResourceStrings.getString("exp_option"), actionErrorArray2);
                    }
                    if (actionErrorArray != null && actionErrorArray.length > 0) {
                        this.exporter.displayErrors(ResourceStrings.getString("exp_err_deleting_macros"), ResourceStrings.getString("exp_macro"), actionErrorArray);
                    }
                    if (!arrayList.isEmpty()) {
                        this.exporter.displayErrors(ResourceStrings.getString("exp_err_deleting_networks"), ResourceStrings.getString("exp_network"), arrayList.toArray(new ActionError[0]));
                    }
                }
                bl3 = true;
            }
            catch (InterruptedException interruptedException) {
                bl3 = false;
            }
            catch (Exception exception) {
                this.displayException(exception, ResourceStrings.getString("exp_err_io"));
                bl3 = false;
            }
            Object var15_19 = null;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            try {
                this.server.closeExportFile(object, bl4);
            }
            catch (IOException iOException) {
                this.displayException(iOException, ResourceStrings.getString("exp_err_closing_file"));
            }
            throw throwable;
        }
        try {
            this.server.closeExportFile(object, bl4);
        }
        catch (IOException iOException) {
            this.displayException(iOException, ResourceStrings.getString("exp_err_closing_file"));
        }
        return bl3;
    }

    public void setAllMacros() {
        this.allMacros = true;
        this.macros = emptyMacros;
    }

    public void setAllNetworks() {
        this.allNets = true;
        this.networks = emptyNets;
    }

    public void setAllOptions() {
        this.allOptions = true;
        this.options = emptyOptions;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setMacros(String[] stringArray) {
        this.allMacros = false;
        this.macros = stringArray != null ? stringArray : emptyMacros;
    }

    public void setNetworks(Network[] networkArray) {
        this.allNets = false;
        this.networks = networkArray != null ? networkArray : emptyNets;
    }

    public void setOptions(String[] stringArray) {
        this.allOptions = false;
        this.options = stringArray != null ? stringArray : emptyOptions;
    }

    public void setUser(String string) {
        this.user = string;
    }
}

