/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.ResourceStrings;
import com.sun.dhcpmgr.data.ValidationException;
import java.io.Serializable;
import java.text.MessageFormat;

public class Network
implements Serializable,
Comparable {
    private IPAddress address;
    private IPAddress netmask;

    public Network() {
        this.address = new IPAddress();
        this.netmask = new IPAddress();
    }

    public Network(IPAddress iPAddress) {
        this.initialize(iPAddress);
    }

    public Network(IPAddress iPAddress, IPAddress iPAddress2) {
        this.address = iPAddress;
        this.netmask = iPAddress2;
    }

    public Network(String string) throws ValidationException {
        try {
            this.initialize(new IPAddress(string));
        }
        catch (ValidationException validationException) {
            Object[] objectArray = new Object[]{string};
            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_network"));
            String string2 = messageFormat.format(objectArray);
            throw new ValidationException(string2);
        }
    }

    public Network(String string, int n) throws ValidationException {
        try {
            this.address = new IPAddress(string);
        }
        catch (ValidationException validationException) {
            Object[] objectArray = new Object[]{string};
            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_network"));
            String string2 = messageFormat.format(objectArray);
            throw new ValidationException(string2);
        }
        this.netmask = new IPAddress(n);
    }

    public Network(String string, String string2) throws ValidationException {
        try {
            this.address = new IPAddress(string);
        }
        catch (ValidationException validationException) {
            Object[] objectArray = new Object[]{string};
            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_network"));
            String string3 = messageFormat.format(objectArray);
            throw new ValidationException(string3);
        }
        try {
            this.netmask = new IPAddress(string2);
        }
        catch (ValidationException validationException) {
            Object[] objectArray = new Object[]{string2};
            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_netmask"));
            String string4 = messageFormat.format(objectArray);
            throw new ValidationException(string4);
        }
    }

    public int compareTo(Object object) {
        Network network = (Network)object;
        long l = this.getNetworkNumber().getBinaryAddress() - network.getNetworkNumber().getBinaryAddress();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    public boolean containsAddress(IPAddress iPAddress) {
        return (iPAddress.intValue() & this.netmask.intValue()) == (this.address.intValue() & this.netmask.intValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Network)) {
            return false;
        }
        return this.getNetworkNumber().equals(((Network)object).getNetworkNumber());
    }

    public IPAddress getAddress() {
        return this.address;
    }

    public String getBroadcastAddress() {
        byte[] byArray = this.getAddress().getAddress();
        byte[] byArray2 = this.getMask().getAddress();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = (byArray[n] | ~byArray2[n]) & 0xFF;
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(n2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public IPAddress getMask() {
        return this.netmask;
    }

    public IPAddress getNetworkNumber() {
        if (this.netmask.intValue() == 0) {
            return this.address;
        }
        return new IPAddress(this.address.intValue() & this.netmask.intValue());
    }

    private void initialize(IPAddress iPAddress) {
        this.address = iPAddress;
        byte[] byArray = this.address.getAddress();
        int n = byArray[0] & 0xFF;
        try {
            this.netmask = n < 128 ? new IPAddress("255.0.0.0") : (n < 192 ? new IPAddress("255.255.0.0") : new IPAddress("255.255.255.0"));
        }
        catch (ValidationException validationException) {}
    }

    public void setMask(IPAddress iPAddress) {
        this.netmask = iPAddress;
    }

    public String toString() {
        return this.getNetworkNumber().toString();
    }
}

