/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.osservermgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.osservermgr.client.ServiceWrapper;
import com.sun.admin.osservermgr.client.WbemServiceWrapper;
import com.sun.admin.osservermgr.common.OsServerMgrException;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.client.ExternalClientList;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.client.CIMClient;
import java.util.ResourceBundle;

public class ApplicationContext {
    private IClientResource theApp;
    private ToolContext toolContext;
    private AdminMgmtScope scope = null;
    private static int MAX_RETRIES = 2;

    public ApplicationContext(IClientResource iClientResource, ToolContext toolContext) {
        this.theApp = iClientResource;
        this.toolContext = toolContext;
        this.scope = (AdminMgmtScope)toolContext.getParameter("ToolContext.MGMTSCOPE");
    }

    public ApplicationContext(IClientResource iClientResource, ToolContext toolContext, AdminMgmtScope adminMgmtScope) {
        this.theApp = iClientResource;
        this.toolContext = toolContext;
        this.scope = adminMgmtScope;
    }

    private String getServiceType() {
        String string = "Wbem";
        try {
            String string2 = System.getProperty("OsServerMgr.serviceType");
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public ServiceWrapper getServiceWrapper(ToolInfrastructure toolInfrastructure) throws AdminException {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = this.getServiceType();
        String string2 = "com.sun.admin.osservermgr.client." + string + "ServiceWrapper";
        ServiceWrapper serviceWrapper = null;
        try {
            serviceWrapper = (ServiceWrapper)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME");
            OsServerMgrException osServerMgrException = new OsServerMgrException("EXM_SPRT_GUI_SERVICE_NOT_REACHABLE", (Object)string, (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
            throw osServerMgrException;
        }
        catch (Exception exception) {
            throw new OsServerMgrException(exception.getMessage());
        }
        int n = MAX_RETRIES;
        String string4 = "";
        while (n > 0) {
            Object[] objectArray;
            --n;
            try {
                if (serviceWrapper instanceof WbemServiceWrapper) {
                    string4 = this.scope.getMgmtServerName();
                    CIMNameSpace cIMNameSpace = new CIMNameSpace(string4, "root\\cimv2");
                    objectArray = new Object[]{cIMNameSpace, new Integer(1)};
                    CIMClient cIMClient = (CIMClient)toolInfrastructure.getExternalClient(ExternalClientList.CIMWBEM, objectArray);
                    serviceWrapper.init(cIMClient, toolInfrastructure, this.scope);
                }
                n = 0;
            }
            catch (CIMSecurityException cIMSecurityException) {
                objectArray = cIMSecurityException.getID();
                if (objectArray.equals("CIM_ERR_ACCESS_DENIED")) {
                    throw new OsServerMgrException("EXM_CIM_ERR_ACCESS_DENIED");
                }
                if (objectArray.equals("INVALID_CREDENTIAL")) {
                    throw new OsServerMgrException("EXM_INVALID_CREDENTIAL");
                }
                if (objectArray.equals("NO_SUCH_PRINCIPAL")) {
                    throw new OsServerMgrException("EXM_NO_SUCH_PRINCIPAL");
                }
                if (objectArray.equals("CANNOT_ASSUME_ROLE")) {
                    throw new OsServerMgrException("EXM_CANNOT_ASSUME_ROLE");
                }
                throw new OsServerMgrException("EXM_GENERIC_CIMSEC");
            }
            catch (Exception exception) {
                if (exception.getMessage().equals("TIMED_OUT")) {
                    if (n > 0) continue;
                    throw new OsServerMgrException("EXM_CANT_CONNECT_TO_SERVER", string4);
                }
                throw new OsServerMgrException("EXM_CANT_CONNECT_TO_SERVER", string4);
            }
        }
        return serviceWrapper;
    }
}

