/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import com.sun.pdasync.SyncMgr.CRawRecordInfo;
import palm.conduit.Log;

public class RawRecordInfo {
    byte fileHandle;
    int recId;
    short recIndex;
    byte attribs;
    short catId;
    int conduitId;
    int recSize;
    short totalBytes;
    private int nativeBytes;
    int reserved;
    private byte[] bytes;

    RawRecordInfo(int fileHandle, int recId, int recIndex) {
        this.fileHandle = (byte)fileHandle;
        this.recId = recId;
        this.recIndex = (short)recIndex;
    }

    RawRecordInfo(int fileHandle, int recId, int recIndex, short catId, byte[] bytes) {
        this(fileHandle, recId, recIndex);
        this.catId = catId;
        this.setBytes(bytes);
    }

    RawRecordInfo(int fileHandle, int recId, int recIndex, byte[] bytes) {
        this(fileHandle, recId, recIndex);
        this.setBytes(bytes);
    }

    public void copyFromCRawRecordInfo(CRawRecordInfo recInfo) {
        this.fileHandle = recInfo.m_FileHandle_u;
        this.recId = (int)recInfo.m_RecId;
        this.recIndex = recInfo.m_RecIndex_u;
        this.attribs = recInfo.m_Attribs_u;
        this.catId = recInfo.m_CatId;
        this.conduitId = recInfo.m_ConduitId;
        this.recSize = recInfo.m_RecSize_u;
        this.totalBytes = (short)recInfo.m_TotalBytes;
        System.arraycopy(recInfo.m_pBytes_u, 0, this.bytes, 0, recInfo.m_pBytes_u.length);
    }

    public void copyToCRawRecordInfo(CRawRecordInfo recInfo) {
        recInfo.m_FileHandle_u = this.fileHandle;
        recInfo.m_RecId = this.recId;
        recInfo.m_RecIndex_u = this.recIndex;
        recInfo.m_Attribs_u = this.attribs;
        recInfo.m_CatId = this.catId;
        recInfo.m_ConduitId = this.conduitId;
        recInfo.m_RecSize_u = this.recSize;
        recInfo.m_TotalBytes = this.totalBytes;
        recInfo.m_pBytes_u = new byte[this.getBytes().length];
        System.arraycopy(this.getBytes(), 0, recInfo.m_pBytes_u, 0, this.getBytes().length);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    byte[] getBytes() {
        if (this.recSize < this.totalBytes) {
            byte[] newBytes = new byte[this.recSize];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.recSize);
            this.bytes = newBytes;
        }
        return this.bytes;
    }

    void setBytes(byte[] bytes) {
        this.recSize = bytes.length;
        this.totalBytes = (short)bytes.length;
        this.bytes = bytes;
    }

    public String toString() {
        return "fileHandle: " + Integer.toHexString(this.fileHandle) + "\r\n" + "recId: " + Integer.toHexString(this.recId) + "\r\n" + "recIndex: " + Integer.toHexString(this.recIndex) + "\r\n" + "attribs: " + Integer.toHexString(this.attribs) + "\r\n" + "catId: " + Integer.toHexString(this.catId) + "\r\n" + "conduitId: " + Integer.toHexString(this.conduitId) + "\r\n" + "recSize: " + Integer.toHexString(this.recSize) + "\r\n" + "totalBytes: " + Integer.toHexString(this.totalBytes) + "\r\n" + Log.formatBytes(this.getBytes());
    }
}

