/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.ASTMibs;
import com.sun.wbem.compiler.mib2mof.CimCodeGenerator;
import com.sun.wbem.compiler.mib2mof.CodeGenerator;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.ModulesHandler;
import com.sun.wbem.compiler.mib2mof.ParseException;
import com.sun.wbem.compiler.mib2mof.Parser;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.StoreGenerator;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class Mib2Mof {
    private String program;
    private OutputStream out;
    private String specificPackageName = "";
    private String targetDir = ".";
    private String prefix = "";
    private boolean generateCode = true;
    private boolean generateMgrCode = false;
    private boolean generateMgrCodeOnly = false;
    private boolean standAlone = false;
    private boolean forAll = false;
    private String lastFile = "";
    private ASTMibs lastMib;
    private boolean status = true;
    private boolean commentRequested = false;
    private boolean defaultMibCore = true;
    private boolean usageWanted = false;
    private Vector fileList;
    private static final String SOLARIS_MIB_CORE_DIR = "/usr/sadm/mof/";
    private static final String MIB_CORE_FILE = "Solaris_SNMPmib_core.txt";
    private static final String sccs_id = "@(#)Mib2Mof.java 4.12 11/17/99 SMI";

    private Mib2Mof(OutputStream outputStream, String string) {
        this.out = outputStream;
        Trace.setOutput(this.out);
        this.program = string;
    }

    public static int compile(String[] stringArray) {
        Mib2Mof mib2Mof = new Mib2Mof(System.out, "mib2mof");
        return mib2Mof.startCompile(stringArray) ? 0 : 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean doCompile() {
        Object object;
        boolean bl = true;
        FileInputStream fileInputStream = null;
        ModulesHandler modulesHandler = new ModulesHandler();
        ASTMibs aSTMibs = null;
        if (this.defaultMibCore) {
            String string;
            block25: {
                string = MIB_CORE_FILE;
                try {
                    try {
                        fileInputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        string = "/usr/sadm/mof/Solaris_SNMPmib_core.txt";
                    }
                    catch (Exception exception) {
                    }
                    Object var9_7 = null;
                    if (fileInputStream == null) break block25;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                fileInputStream.close();
            }
            Trace.info(MessageHandler.getMessage("compile.info.start.mibcore", string));
            object = null;
            try {
                object = new Parser(new FileInputStream(string));
                aSTMibs = ((Parser)object).Mibs(modulesHandler);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Trace.warning(MessageHandler.getMessage("compile.error.noMibCoreFile", string));
            }
            catch (ParseException parseException) {
                Trace.error(parseException.getMessage());
                bl = false;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                Trace.error(exception.getMessage());
                bl = false;
            }
        }
        int n = this.fileList.size() - 1;
        while (true) {
            if (n < 0) {
                if (modulesHandler.resolve()) break;
                Trace.info(MessageHandler.getMessage("compile.error.stop"));
                return false;
            }
            String string = (String)this.fileList.elementAt(n);
            Trace.info(MessageHandler.getMessage("compile.info.start", string));
            object = null;
            try {
                object = new Parser(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Trace.error(MessageHandler.getMessage("compile.error.noFile", string));
                return false;
            }
            try {
                ASTMibs aSTMibs2;
                this.lastMib = aSTMibs2 = ((Parser)object).Mibs(modulesHandler);
            }
            catch (ParseException parseException) {
                Trace.error(parseException.getMessage());
                bl = false;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                Trace.error(exception.getMessage());
                bl = false;
            }
            --n;
        }
        if (!modulesHandler.buildMibTrees()) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        if (this.defaultMibCore && aSTMibs != null) {
            object = aSTMibs.mibElements();
            while (object.hasMoreElements()) {
                ASTMib aSTMib = (ASTMib)object.nextElement();
                modulesHandler.removeMibModule(aSTMib.getModuleName());
            }
        }
        this.status = this.generateMofCode(modulesHandler) && bl;
        return this.status;
    }

    private int error(String string) {
        Trace.error(string);
        Trace.info(MessageHandler.getMessage("compile.error.stop"));
        return 1;
    }

    private boolean generateAgentCode(ModulesHandler modulesHandler) {
        if (!this.generateCode) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration enumeration = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (enumeration == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        boolean bl = true;
        CodeGenerator codeGenerator = new CodeGenerator(new ResourceManager(), this.specificPackageName, this.prefix, this.targetDir);
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.setDescriptionHandling(this.commentRequested);
            aSTMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.agent", aSTMib.getModuleName()));
            try {
                codeGenerator.generateCode(aSTMib);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean generateMgrCode(ModulesHandler modulesHandler) {
        if (!this.generateMgrCode && !this.generateMgrCodeOnly) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration enumeration = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (enumeration == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        StoreGenerator storeGenerator = new StoreGenerator(new ResourceManager(), this.specificPackageName, this.prefix, this.targetDir);
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.oidtable", aSTMib.getModuleName()));
            try {
                storeGenerator.generateCode(aSTMib);
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private boolean generateMofCode(ModulesHandler modulesHandler) {
        if (!this.generateCode) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration enumeration = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (enumeration == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        boolean bl = true;
        CimCodeGenerator cimCodeGenerator = new CimCodeGenerator(new ResourceManager(), this.specificPackageName, this.prefix, this.targetDir);
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.setDescriptionHandling(this.commentRequested);
            aSTMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.agent", aSTMib.getModuleName()));
            try {
                cimCodeGenerator.generateCode(aSTMib);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        String string = MessageHandler.getMessage("compile.error.internal.outmemory");
        try {
            int n = Mib2Mof.compile(stringArray);
            Trace.conclude();
            System.exit(n);
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                Trace.error(string);
            } else {
                Trace.error(MessageHandler.getMessage("compile.error.internal", throwable.toString()));
                Trace.conclude();
            }
            System.exit(1);
        }
    }

    private void output(String string) {
        try {
            int n = 0;
            while (n < string.length()) {
                this.out.write(string.charAt(n));
                ++n;
            }
            this.out.write(10);
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseArgs(String[] stringArray) {
        this.fileList = new Vector();
        boolean bl = false;
        if (stringArray.length == 0) {
            this.usageWanted = true;
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d")) {
                if (n + 1 >= stringArray.length) {
                    Trace.error(MessageHandler.getMessage("compile.error.option.level", "-d"));
                    return false;
                }
                this.targetDir = stringArray[++n];
            } else if (stringArray[n].equals("-n")) {
                bl = true;
                this.generateCode = false;
                this.generateMgrCode = false;
            } else if (stringArray[n].equals("-a")) {
                this.forAll = true;
            } else {
                if (stringArray[n].equals("-h")) {
                    this.usageWanted = true;
                    return false;
                }
                if (stringArray[n].equals("-q")) {
                    this.commentRequested = true;
                } else if (stringArray[n].equals("-c")) {
                    this.defaultMibCore = false;
                } else {
                    if (stringArray[n].startsWith("-")) {
                        Trace.error(MessageHandler.getMessage("compile.error.option.invalid", stringArray[n]));
                        return false;
                    }
                    this.fileList.addElement(stringArray[n]);
                    this.lastFile = stringArray[n];
                }
            }
            ++n;
        }
        return this.validTargetDir();
    }

    private void run() {
        if (this.fileList != null && this.fileList.size() > 0) {
            this.status = this.doCompile();
        }
    }

    private synchronized boolean startCompile(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            if (this.usageWanted) {
                this.usage();
                return true;
            }
            Trace.setOutput(System.err);
            this.usage();
            return false;
        }
        if (this.fileList.size() == 0) {
            Trace.setOutput(System.err);
            this.usage();
            return false;
        }
        return this.doCompile();
    }

    private void usage() {
        Trace.info("Usage: " + this.program + " <options> <mib files>");
        Trace.info("\n" + MessageHandler.getMessage("usage.where"));
        Trace.info("  -n\t\t" + MessageHandler.getMessage("usage.n"));
        Trace.info("  -d <dir>\t" + MessageHandler.getMessage("usage.dir"));
        Trace.info("  -q\t\t" + MessageHandler.getMessage("usage.q"));
        Trace.info("  -c\t\t" + MessageHandler.getMessage("usage.c"));
        Trace.info("  -a\t\t" + MessageHandler.getMessage("usage.a"));
        Trace.info("  -h\t\t" + MessageHandler.getMessage("usage.h"));
    }

    private boolean validTargetDir() {
        File file;
        if (!this.generateCode) {
            return true;
        }
        try {
            file = new File(this.targetDir);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (!file.exists()) {
            this.error(MessageHandler.getMessage("compile.error.noDir", this.targetDir));
            return false;
        }
        if (!file.canWrite()) {
            this.error(MessageHandler.getMessage("compile.error.noWritePermission", this.targetDir));
            return false;
        }
        return true;
    }
}

