/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.AddressSync;

import com.sun.pdasync.Conduits.AddressSync.AddressSyncConstants;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncRecord;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncUtils;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class SunCardWriter {
    private static int suffix = 0;

    private static boolean createCardPath(String cardName) {
        if (cardName == null || cardName.length() == 0) {
            return false;
        }
        int index = cardName.lastIndexOf(SyncConstants.SEPARATOR);
        String dir = cardName.substring(0, index);
        return SyncUtils.mkdirIfNotExist((String)dir);
    }

    private String firstAndLastname(AddressSyncRecord addrRecord) {
        String firstName = addrRecord.getFirstName();
        String lastName = addrRecord.getName();
        String name = String.valueOf(firstName != null ? String.valueOf(firstName) + " " : "") + (lastName != null ? lastName : "");
        name = name.trim();
        return name;
    }

    public static String semicolonIfEmpty(String field) {
        return AddressSyncUtils.semicolonIfEmpty(field);
    }

    private void writeField(PrintWriter pw, String label, String value) {
        if (!AddressSyncUtils.isEmptyField(value)) {
            if (!AddressSyncUtils.hasNewline(value)) {
                pw.println(String.valueOf(label) + ":" + value);
            } else {
                pw.println(String.valueOf(label) + ";" + "ENCODING=QUOTED-PRINTABLE" + ":" + AddressSyncUtils.replaceNewline(value));
            }
        }
    }

    public File writeHardCoded(AddressSyncRecord addrRec) throws IOException {
        String cardName = addrRec.getCardFilename();
        if (cardName == null || cardName.length() == 0) {
            cardName = String.valueOf(AddressSyncConstants.USER_OWN_VCARDS_DIR) + "Unnamed" + ++suffix;
        }
        if (!SunCardWriter.createCardPath(cardName)) {
            throw new IOException();
        }
        File file = null;
        FileOutputStream fos = null;
        PrintWriter pw = null;
        file = new File(cardName);
        fos = new FileOutputStream(file);
        pw = new PrintWriter(fos);
        pw.println("BEGIN:VCARD");
        pw.println("VERSION:2.1");
        String tmpStr = addrRec.getName();
        String tmpStr1 = addrRec.getFirstName();
        if (!AddressSyncUtils.isEmptyField(tmpStr) || !AddressSyncUtils.isEmptyField(tmpStr1)) {
            pw.println("N:" + SunCardWriter.semicolonIfEmpty(tmpStr) + ";" + SunCardWriter.semicolonIfEmpty(tmpStr1));
        }
        if (!AddressSyncUtils.isEmptyField(tmpStr = this.firstAndLastname(addrRec))) {
            pw.println("FN:" + SunCardWriter.semicolonIfEmpty(tmpStr));
        }
        tmpStr = addrRec.getTitle();
        this.writeField(pw, "TITLE", tmpStr);
        tmpStr = addrRec.getCompany();
        this.writeField(pw, "ORG", tmpStr);
        tmpStr = addrRec.getPhoneLabelValue("E-mail");
        this.writeField(pw, "EMAIL;INTERNET", tmpStr);
        tmpStr = addrRec.getPhoneLabelValue("Work");
        this.writeField(pw, "TEL;WORK", tmpStr);
        tmpStr = addrRec.getPhoneLabelValue("Fax");
        this.writeField(pw, "TEL;FAX;WORK", tmpStr);
        tmpStr = addrRec.getPhoneLabelValue("Home");
        this.writeField(pw, "TEL;HOME", tmpStr);
        tmpStr = addrRec.getPhoneLabelValue("Mobile");
        this.writeField(pw, "TEL;CELL", tmpStr);
        tmpStr = addrRec.getPhoneLabelValue("Pager");
        this.writeField(pw, "TEL;PAGER", tmpStr);
        tmpStr = addrRec.getAddress();
        tmpStr1 = addrRec.getCity();
        String tmpStr2 = addrRec.getState();
        String tmpStr3 = addrRec.getZipCode();
        if (!(AddressSyncUtils.isEmptyField(tmpStr) && AddressSyncUtils.isEmptyField(tmpStr1) && AddressSyncUtils.isEmptyField(tmpStr2) && AddressSyncUtils.isEmptyField(tmpStr3))) {
            String addr = ";;" + SunCardWriter.semicolonIfEmpty(tmpStr) + ";" + SunCardWriter.semicolonIfEmpty(tmpStr1) + ";" + SunCardWriter.semicolonIfEmpty(tmpStr2) + ";" + SunCardWriter.semicolonIfEmpty(tmpStr3);
            this.writeField(pw, "ADR;WORK", addr);
        }
        tmpStr = addrRec.getNote();
        this.writeField(pw, "NOTE", tmpStr);
        int i = 0;
        while (i < 4) {
            tmpStr = addrRec.getCustom(i + 1);
            this.writeField(pw, AddressSyncConstants.EXTRA_PALMPILOT_FIELDS[i][0], tmpStr);
            ++i;
        }
        tmpStr = addrRec.getCountry();
        this.writeField(pw, AddressSyncConstants.EXTRA_PALMPILOT_FIELDS[4][0], tmpStr);
        tmpStr = addrRec.getPhoneLabelValue("Main");
        this.writeField(pw, AddressSyncConstants.EXTRA_PALMPILOT_FIELDS[5][0], tmpStr);
        tmpStr = addrRec.getPhoneLabelValue("Other");
        this.writeField(pw, AddressSyncConstants.EXTRA_PALMPILOT_FIELDS[6][0], tmpStr);
        pw.println("END:VCARD");
        fos.flush();
        pw.flush();
        fos.close();
        pw.close();
        if (addrRec.isPrivate()) {
            SyncUtils.setFilePermission((String)cardName, (String)"600");
        }
        return file;
    }
}

