/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import com.sun.prodreg.Article;
import com.sun.prodreg.PKGArticle;
import com.sun.prodreg.ProdReg;
import com.sun.prodreg.RegException;
import com.sun.prodreg.Revision;
import com.sun.prodreg._;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

class ClusterArticle
extends PKGArticle {
    static PrintStream stderr = System.err;
    private static Vector orphanPKGs;
    private static Vector orphanClusters;
    private static Vector orphanMetaClusters;
    private static String metacluster;
    private static ClusterArticle theMetaCluster;
    private static String prodregPkgs;
    private static ClusterArticle osArticle;
    private static ClusterArticle otherSystem;
    private static ClusterArticle otherNonSystem;
    private static ClusterArticle prodregArticle;
    private static ClusterArticle me;

    ClusterArticle(String string) throws RegException {
        super(string);
    }

    void assessDamage() {
        this.health = 3;
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Article article = (Article)this.getChild(n2);
            article.assessDamage();
            ++n2;
        }
    }

    private static void createAllInstalledPKGs() throws RegException {
        orphanPKGs = new Vector();
        prodregPkgs = "";
        String[] stringArray = new File(String.valueOf(ProdReg.getPkgRoot()) + "/var/sadm/pkg").list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (ProdReg.systemRegistry.readInPkgs.get(string) == null) {
                PKGArticle pKGArticle;
                if (string.endsWith("ws") && string.startsWith("SUNW") && (string.length() == 8 || string.length() == 6)) {
                    pKGArticle = new PKGArticle(string);
                    ProdReg.systemRegistry.add(pKGArticle);
                    prodregPkgs = String.valueOf(prodregPkgs) + string + ' ';
                    pKGArticle.setAttribute("parent", "prodreg.prodreg");
                } else {
                    pKGArticle = new PKGArticle(string);
                    ProdReg.systemRegistry.add(pKGArticle);
                    orphanPKGs.addElement(pKGArticle);
                }
            }
            ++n;
        }
    }

    private static void createWellKnown() throws RegException {
        osArticle = new ClusterArticle("prodreg.os");
        ClusterArticle.osArticle.id = "999999999";
        osArticle.setAttribute("id", "999999999");
        osArticle.setAttribute("title", ClusterArticle.getOSTitle());
        osArticle.setAttribute("description", _.__("solarisdesc"));
        osArticle.setAttribute("uninstall", "x");
        osArticle.setAttribute("vendor", _.__("sunmicro"));
        osArticle.setAttribute("vendorurl", "http://www.sun.com");
        ProdReg.systemRegistry.add(osArticle);
        otherSystem = new ClusterArticle("prodreg.othersystem");
        ClusterArticle.otherSystem.id = "999999999";
        otherSystem.setAttribute("id", "999999999");
        otherSystem.setAttribute("title", _.__("othersystemsw"));
        otherSystem.setAttribute("description", _.__("othersystemswdesc"));
        otherSystem.setAttribute("uninstall", "x");
        otherSystem.setAttribute("vendor", _.__("sunmicro"));
        otherSystem.setAttribute("vendorurl", "http://www.sun.com");
        ProdReg.systemRegistry.add(otherSystem);
        otherNonSystem = new ClusterArticle("prodreg.othernonsystem");
        ClusterArticle.otherNonSystem.id = "999999999";
        otherNonSystem.setAttribute("id", "999999999");
        otherNonSystem.setAttribute("title", _.__("othersw"));
        otherNonSystem.setAttribute("description", _.__("otherswdesc"));
        otherNonSystem.setAttribute("uninstall", "x");
        ProdReg.systemRegistry.add(otherNonSystem);
        prodregArticle = new ClusterArticle("prodreg.prodreg");
        ClusterArticle.prodregArticle.id = "999999999";
        prodregArticle.setAttribute("id", "999999999");
        prodregArticle.setAttribute("title", _.__("prodRegArticle"));
        prodregArticle.setAttribute("description", _.__("prodRegDesc"));
        prodregArticle.setAttribute("uninstall", "x");
        prodregArticle.setAttribute("pkgs", prodregPkgs);
        String string = System.getProperty("prodreg.home", "/usr/bin/");
        try {
            string = new File(string).getCanonicalPath().toString();
        }
        catch (Exception exception) {}
        prodregArticle.setAttribute("installlocation", string);
        prodregArticle.setAttribute("locationflags", "s");
        prodregArticle.revise(ProdReg.versionRes, ProdReg.buildDateRes.substring(0, 10));
        ClusterArticle.prodregArticle.revisions[0].installDate = Revision.nullDate.getTime();
        ProdReg.systemRegistry.add(prodregArticle);
        osArticle.setAttribute("articles", String.valueOf(ClusterArticle.otherSystem.mnemonic) + ' ');
        String string2 = ClusterArticle.otherSystem.id + ' ';
        osArticle.setAttribute("articleids", string2);
        otherSystem.setAttribute("parent", ClusterArticle.osArticle.mnemonic);
        string2 = String.valueOf(ClusterArticle.osArticle.id);
        otherSystem.setAttribute("parentid", string2);
    }

    private static String getOSTitle() {
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(ProdReg.getPkgRoot()) + "/var/sadm/system/admin/INST_RELEASE");
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            if (properties.getProperty("OS").equals("Solaris")) {
                String string;
                if (properties.getProperty("VERSION").equals("2.7")) {
                    ((Hashtable)properties).put("OS", "Solaris 7");
                }
                if ((string = properties.getProperty("VERSION")).startsWith("2.")) {
                    ((Hashtable)properties).put("VERSION", String.valueOf('v') + string + " (SunOS 5." + string.substring(2) + ")");
                }
            }
            return String.valueOf(' ') + properties.getProperty("OS") + ' ' + properties.getProperty("VERSION") + "   [" + properties.getProperty("REV") + ']';
        }
        catch (Exception exception) {
            stderr.println(_.__("readClusterPKGEr", exception.toString()));
            return "Solaris";
        }
    }

    private static String guessWhichCluster(PKGArticle pKGArticle, String string) {
        Article article = null;
        String string2 = pKGArticle.abbreviation;
        if (string2.startsWith("SUNW")) {
            article = PKGArticle.lookupPKG("SUNW" + string2.substring(6));
            if (article == null) {
                article = PKGArticle.lookupPKG("SUNW" + string2.substring(5));
            }
            if (article == null) {
                article = PKGArticle.lookupPKG("SUNWdt" + string2.substring(6));
            }
        }
        if (article != null && ((PKGArticle)article).partOfMetaCluster) {
            String string3 = article.getAttribute("parent", "");
            Article article2 = Article.lookup(string3);
            if (article2 != null) {
                pKGArticle.setAttribute("parent", string3);
                String string4 = article2.getAttribute("pkgs", "");
                string4 = String.valueOf(string4) + pKGArticle.abbreviation + ' ';
                article2.setAttribute("pkgs", string4);
            } else {
                stderr.println("pkg inference failed " + string2 + ' ' + string3);
            }
            pKGArticle.partOfOS = true;
            pKGArticle.partOfMetaCluster = true;
        } else {
            string = String.valueOf(string) + pKGArticle.abbreviation + ' ';
            pKGArticle.setAttribute("parent", ClusterArticle.otherNonSystem.mnemonic);
        }
        return string;
    }

    public void load() {
    }

    private static void markOK(PKGArticle pKGArticle) throws RegException {
        pKGArticle.partOfMetaCluster = true;
        StringTokenizer stringTokenizer = new StringTokenizer(pKGArticle.getAttribute("pkgs", ""), " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            PKGArticle pKGArticle2 = PKGArticle.lookupPKG(string);
            if (pKGArticle2 != null) {
                ClusterArticle.markOK(pKGArticle2);
            } else {
                pKGArticle2 = new PKGArticle(string);
                pKGArticle2.partOfOS = true;
                pKGArticle2.partOfMetaCluster = true;
                ProdReg.systemRegistry.add(pKGArticle2);
                orphanPKGs.addElement(pKGArticle2);
            }
            pKGArticle2.setAttribute("parent", pKGArticle.mnemonic);
        }
    }

    private static void parseOneLine(String string) throws RegException {
        switch (string.charAt(0)) {
            case 'C': {
                if (!string.startsWith("CLUSTER=")) break;
                if (me != null) {
                    throw new Error("cluster out of order");
                }
                me = new ClusterArticle(string.substring(8));
                ProdReg.systemRegistry.add(me);
                me.setAttribute("CLUSTER", string.substring(8));
                orphanClusters.addElement(me);
                return;
            }
            case 'D': {
                if (!string.startsWith("DESC=")) break;
                me.setAttribute("description", string.substring(5));
                return;
            }
            case 'E': {
                if (!string.equals("END")) break;
                if (me == null) {
                    throw new Error("end out of order");
                }
                me = null;
                return;
            }
            case 'M': {
                if (!string.startsWith("METACLUSTER=")) break;
                if (me != null) {
                    throw new Error("metacluster out of order");
                }
                me = new ClusterArticle(string.substring(12));
                ProdReg.systemRegistry.add(me);
                me.setAttribute("METACLUSTER", string.substring(12));
                orphanMetaClusters.addElement(me);
                return;
            }
            case 'N': {
                if (!string.startsWith("NAME=")) break;
                me.setAttribute("title", string.substring(5));
                return;
            }
            case 'S': {
                if (!string.startsWith("SUNW_CSRMEMBER=")) break;
                String string2 = me.getAttribute("pkgs", "");
                String string3 = string.substring(15);
                string2 = String.valueOf(string2) + string3 + " ";
                me.setAttribute("pkgs", string2);
                PKGArticle pKGArticle = PKGArticle.lookupPKG(string3);
                if (pKGArticle != null) {
                    pKGArticle.partOfOS = true;
                }
                return;
            }
            case 'V': {
                if (string.startsWith("VENDOR=")) {
                    me.setAttribute("vendor", string.substring(7));
                    return;
                }
                if (!string.startsWith("VERSION=")) break;
                me.setAttribute("version", string.substring(8));
                return;
            }
        }
    }

    public static void readClusterInfo() {
        try {
            ClusterArticle.createAllInstalledPKGs();
            ClusterArticle.readClusterTOC();
            ClusterArticle.createWellKnown();
            ClusterArticle.rearrange();
        }
        catch (Exception exception) {
            stderr.println(_.__("readClusterPKGEr", exception.toString()));
            exception.printStackTrace();
        }
    }

    private static void readClusterTOC() throws Exception {
        String string;
        FileInputStream fileInputStream;
        orphanClusters = new Vector();
        orphanMetaClusters = new Vector();
        try {
            fileInputStream = new FileInputStream(String.valueOf(ProdReg.getPkgRoot()) + "/var/sadm/system/admin/.clustertoc");
        }
        catch (Exception exception) {
            stderr.println(_.__("readClusterPKGEr", exception.toString()));
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string = bufferedReader.readLine()) != null) {
            ClusterArticle.parseOneLine(string);
        }
        bufferedReader.close();
        ((InputStream)fileInputStream).close();
    }

    private static void rearrange() throws Exception {
        Object object;
        Object object2;
        metacluster = "";
        try {
            FileReader fileReader = new FileReader(String.valueOf(ProdReg.getPkgRoot()) + "/var/sadm/system/admin/CLUSTER");
            object2 = new char[100];
            int n = fileReader.read((char[])object2);
            ((Reader)fileReader).close();
            object = new String((char[])object2, 0, n);
            if (!((String)object).startsWith("CLUSTER=")) {
                throw new Exception("bad format in file CLUSTER");
            }
            metacluster = ((String)object).substring(8, ((String)object).length() - 1);
        }
        catch (Exception exception) {
            stderr.println(_.__("readClusterPKGEr", exception.toString()));
        }
        int n = 0;
        while (n < orphanMetaClusters.size()) {
            object2 = (ClusterArticle)orphanMetaClusters.elementAt(n);
            if (((PKGArticle)object2).abbreviation.equals(metacluster)) {
                ClusterArticle.markOK((PKGArticle)object2);
                theMetaCluster = object2;
            } else {
                ProdReg.systemRegistry.remove((Article)object2);
            }
            ++n;
        }
        n = 0;
        while (n < orphanClusters.size()) {
            object2 = (ClusterArticle)orphanClusters.elementAt(n);
            if (!((PKGArticle)object2).partOfMetaCluster) {
                ProdReg.systemRegistry.remove((Article)object2);
            } else {
                ((Article)object2).setAttribute("parent", metacluster);
            }
            ++n;
        }
        object2 = "";
        String string = "";
        n = 0;
        while (n < orphanPKGs.size()) {
            object = (PKGArticle)orphanPKGs.elementAt(n);
            if (!((PKGArticle)object).partOfOS) {
                object2 = ClusterArticle.guessWhichCluster((PKGArticle)object, (String)object2);
            } else if (!((PKGArticle)object).partOfMetaCluster) {
                string = String.valueOf(string) + ((PKGArticle)object).abbreviation + ' ';
                ((Article)object).setAttribute("parent", ClusterArticle.otherSystem.mnemonic);
            }
            ++n;
        }
        otherNonSystem.setAttribute("pkgs", (String)object2);
        otherSystem.setAttribute("pkgs", string);
        osArticle.setAttribute("pkgs", String.valueOf(metacluster) + ' ');
        if (theMetaCluster != null) {
            theMetaCluster.setAttribute("parent", ClusterArticle.osArticle.mnemonic);
        }
        orphanPKGs = null;
        orphanClusters = null;
        orphanMetaClusters = null;
    }
}

