/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.awt.AboutDialog;
import com.sun.prodreg.awt.ComponentSelectableViewComponentAdapter;
import com.sun.prodreg.awt.ExpandableDialog;
import com.sun.prodreg.awt.FlowLabel;
import com.sun.prodreg.awt.ImagePanel;
import com.sun.prodreg.awt.QueryDialog;
import com.sun.prodreg.awt.RelativeLayout;
import com.sun.prodreg.awt.Separator;
import com.sun.prodreg.awt.TitleBox;
import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.InstallManager;
import com.sun.prodreg.core.ProgressBar;
import com.sun.prodreg.core.UIProvider;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.view.ComponentSelectableView;
import com.sun.prodreg.view.ComponentView;
import com.sun.prodreg.view.ViewManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;

public class ProdRegViewManager
implements ViewManager,
ActionListener {
    private UIProvider provider = null;
    private Frame regFrame = null;
    public static final int FRAME_WIDTH = 800;
    public static final int FRAME_HEIGHT = 600;
    private InstallManager installManager = null;
    private ComponentView summaryView = null;
    private ComponentView moreView = null;
    private ComponentSelectableView treeView = null;
    private Object treeViewLock = new Object();
    private Object moreViewLock = new Object();
    private Object summaryViewLock = new Object();
    private Container summaryContainer = null;
    private Container moreContainer = null;
    private Container treeContainer = null;
    private static String recentDir = "/cdrom";
    private Component aboutButton = null;
    private Component newInstallButton = null;
    private Component uninstallButton = null;
    private Component exitButton = null;
    private Vector errorCache = new Vector();
    public static final int OPTION_UNINSTALL = 1;
    public static final int OPTION_INSTALL = 2;
    private ProgressBar pbar = null;
    private int options = 0;

    public ProdRegViewManager(UIProvider uIProvider, InstallManager installManager, ComponentView componentView, ComponentView componentView2, ComponentSelectableView componentSelectableView) {
        this.treeView = componentSelectableView;
        this.installManager = installManager;
        this.provider = uIProvider;
        this.summaryView = componentView;
        this.moreView = componentView2;
        this.treeContainer = uIProvider.getContainer(new BorderLayout());
        this.moreContainer = uIProvider.getContainer(new BorderLayout());
        this.summaryContainer = uIProvider.getContainer(new BorderLayout());
        this.pbar = uIProvider.getProgressBar();
        this.showGUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.aboutButton)) {
            this.aboutButton.setEnabled(false);
            this.doAbout();
            this.aboutButton.setEnabled(true);
        } else if (object.equals(this.newInstallButton)) {
            FileDialog fileDialog = new FileDialog(this.regFrame, Localizer.resolve("<L ProdRegResources.NewInstallTitle>..."), 0);
            fileDialog.setDirectory(recentDir);
            fileDialog.show();
            if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
                recentDir = fileDialog.getDirectory();
                this.installManager.newInstall(recentDir, fileDialog.getFile());
            }
        } else if (object.equals(this.uninstallButton)) {
            boolean bl = (actionEvent.getModifiers() & 1) != 0;
            this.installManager.newUninstall(bl);
        } else if (object.equals(this.exitButton)) {
            this.close();
            this.installManager.close(0);
        }
    }

    public void close() {
        ((Component)this.regFrame).setVisible(false);
        this.regFrame.dispose();
    }

    private void doAbout() {
        AboutDialog aboutDialog = new AboutDialog(this.regFrame);
        Dimension dimension = this.regFrame.getSize();
        Point point = this.regFrame.getLocationOnScreen();
        ((Component)aboutDialog).setLocation(point.x, point.y);
        aboutDialog.setForeground(Color.black);
        ((Component)aboutDialog).setBackground(Color.lightGray);
        aboutDialog.show();
    }

    private Component getAboutComponent() {
        Container container = this.provider.getContainer(new FlowLayout(2));
        this.aboutButton = this.provider.getButton(Localizer.resolve("<L ProdRegResources.About>"), this);
        container.add(this.aboutButton);
        return container;
    }

    private Component getControlComponent() {
        double[] dArray = new double[]{0.4, 0.4, 0.2};
        Container container = this.provider.getContainer(new RelativeLayout(dArray, 0));
        Container container2 = this.provider.getContainer(new FlowLayout(1));
        Container container3 = this.provider.getContainer(new GridBagLayout());
        Container container4 = this.provider.getContainer(new FlowLayout(2));
        this.newInstallButton = this.provider.getButton(Localizer.resolve("<L ProdRegResources.NewInstall>..."), this);
        this.uninstallButton = this.provider.getButton(Localizer.resolve("<L ProdRegResources.Uninstall>..."), this);
        this.uninstallButton.setEnabled(false);
        this.exitButton = this.provider.getButton(Localizer.resolve("<L ProdRegResources.Exit>"), this);
        container2.add(this.newInstallButton);
        container2.add(this.uninstallButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        container3.add((Component)((Object)this.pbar), gridBagConstraints);
        this.hideProgress();
        container4.add(this.exitButton);
        container.add(container2);
        container.add(container3);
        container.add(container4);
        return container;
    }

    private Component getInfoPanel() {
        double[] dArray = new double[]{0.5, 0.5};
        Container container = this.provider.getContainer(new RelativeLayout(dArray, 1));
        TitleBox titleBox = new TitleBox(Localizer.resolve("<L ProdRegResources.Summary>"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(13, 10, 10, 10);
        Object object = this.summaryViewLock;
        synchronized (object) {
            if (this.summaryView != null && this.summaryView instanceof Component) {
                this.summaryContainer.add((Component)((Object)this.summaryView), "Center");
            }
        }
        titleBox.add((Component)this.summaryContainer, gridBagConstraints);
        container.add(titleBox);
        object = new TitleBox(Localizer.resolve("<L ProdRegResources.MoreInfo>"));
        Object object2 = this.moreViewLock;
        synchronized (object2) {
            if (this.moreView != null && this.moreView instanceof Component) {
                this.moreContainer.add((Component)((Object)this.moreView), "Center");
            }
        }
        ((Container)object).add((Component)this.moreContainer, gridBagConstraints);
        container.add((Component)object);
        return container;
    }

    public ComponentView getMoreiew() {
        Object object = this.moreViewLock;
        synchronized (object) {
            ComponentView componentView = this.moreView;
            Object var3_3 = null;
            return componentView;
        }
    }

    public int getOptions() {
        return this.options;
    }

    public ComponentView getSummaryView() {
        Object object = this.summaryViewLock;
        synchronized (object) {
            ComponentView componentView = this.summaryView;
            Object var3_3 = null;
            return componentView;
        }
    }

    private Component getTreePanel() {
        Container container = this.provider.getContainer(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 2, 5, 2);
        gridBagConstraints.gridwidth = -1;
        Component component = this.provider.getLabel(Localizer.resolve("<L ProdRegResources.InstalledSoftware>"), 2);
        container.add(component, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        Object object = this.treeViewLock;
        synchronized (object) {
            if (this.treeView != null && this.treeView instanceof Component) {
                this.treeContainer.add((Component)((Object)this.treeView), "Center");
            }
        }
        container.add((Component)this.treeContainer, gridBagConstraints);
        return container;
    }

    public ComponentSelectableView getTreeView() {
        Object object = this.treeViewLock;
        synchronized (object) {
            ComponentSelectableView componentSelectableView = this.treeView;
            Object var3_3 = null;
            return componentSelectableView;
        }
    }

    public void hideProgress() {
        ((Component)((Object)this.pbar)).setVisible(false);
        ((Component)((Object)this.pbar)).getParent().repaint();
    }

    public void logError(String string) {
        String string2 = Localizer.resolve("<L ProdRegResources.Error>");
        String string3 = Localizer.resolve("<L ProdRegResources.OK>");
        if (this.regFrame == null || !this.regFrame.isVisible()) {
            this.errorCache.addElement(string);
            return;
        }
        QueryDialog queryDialog = new QueryDialog(null, this.regFrame, string2, string, new String[]{string3}, null);
    }

    public void logMessage(String string) {
    }

    public void logWarning(String string) {
    }

    public int query(String string, String string2, String string3, String[] stringArray) {
        Serializable serializable;
        String string4 = String.valueOf(Localizer.resolve("<L ProdRegResources.More>")) + " >>>";
        String string5 = "<<< " + Localizer.resolve("<L ProdRegResources.Less>");
        if (string2 == null) {
            string2 = Localizer.resolve("<L ProdRegResources.Error>");
        }
        ExpandableDialog expandableDialog = new ExpandableDialog(this.regFrame, string, true);
        expandableDialog.setExpandLabels(string4, string5);
        expandableDialog.setButtons(stringArray);
        FlowLabel flowLabel = new FlowLabel(string2);
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)flowLabel, "Center");
        expandableDialog.setTopComponent(panel);
        if (string3 != null) {
            serializable = new TextArea();
            Panel panel2 = new Panel(new BorderLayout());
            String string6 = Localizer.resolve("<L ProdRegResources.ProgramOutput>:");
            panel2.add(this.provider.getLabel(string6, 0), "North");
            panel2.add((Component)serializable, "Center");
            ((TextComponent)serializable).setEditable(false);
            ((TextArea)serializable).append(string3);
            expandableDialog.setBottomComponent(panel2);
        }
        expandableDialog.pack();
        serializable = this.regFrame.getLocationOnScreen();
        ((Component)expandableDialog).setLocation(((Point)serializable).x + (this.regFrame.getSize().width / 2 - expandableDialog.getSize().width / 2), ((Point)serializable).y + (this.regFrame.getSize().height / 2 - expandableDialog.getSize().height / 2));
        expandableDialog.show();
        return expandableDialog.getButtonPressed();
    }

    public void setMoreView(ComponentView componentView) {
        Object object = this.moreViewLock;
        synchronized (object) {
            this.moreView = componentView;
            if (componentView != null && componentView instanceof Component) {
                this.moreContainer.removeAll();
                this.moreContainer.add((Component)((Object)componentView), "Center");
                this.moreContainer.validate();
                this.moreContainer.invalidate();
            }
        }
    }

    public void setOptions(int n) {
        this.uninstallButton.setEnabled((n & 1) != 0);
        this.newInstallButton.setEnabled((n & 2) != 0);
        this.options = n;
    }

    public void setProgress(int n) {
        this.pbar.setProgress(n);
    }

    public void setProgressMessage(String string) {
        this.pbar.setMessage(string);
    }

    public void setSummaryView(ComponentView componentView) {
        Object object = this.summaryViewLock;
        synchronized (object) {
            this.summaryView = componentView;
            if (componentView != null && componentView instanceof Component) {
                this.summaryContainer.removeAll();
                this.summaryContainer.add((Component)((Object)componentView), "Center");
                this.summaryContainer.validate();
                this.summaryContainer.invalidate();
            }
        }
    }

    public void setTreeView(ComponentSelectableView componentSelectableView) {
        Object object = this.treeViewLock;
        synchronized (object) {
            if (componentSelectableView == null || !(componentSelectableView instanceof Component)) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Image image = toolkit.getImage(this.getClass().getResource("/images/damage.gif"));
                ImagePanel imagePanel = new ImagePanel();
                imagePanel.setImage(image);
                ComponentSelectableViewComponentAdapter componentSelectableViewComponentAdapter = new ComponentSelectableViewComponentAdapter(imagePanel, null);
                componentSelectableView = componentSelectableViewComponentAdapter;
            }
            this.treeView = componentSelectableView;
            this.treeContainer.removeAll();
            this.treeContainer.add((Component)((Object)componentSelectableView), "Center");
            this.treeContainer.validate();
            this.treeContainer.invalidate();
        }
    }

    public void showComponent(ComponentDescription componentDescription) {
        Object object = this.summaryViewLock;
        synchronized (object) {
            this.summaryView.showComponent(componentDescription);
        }
        object = this.moreViewLock;
        synchronized (object) {
            this.moreView.showComponent(componentDescription);
        }
    }

    private void showGUI() {
        Container container = this.provider.getContainer(new GridBagLayout());
        this.regFrame = this.provider.getFrame(Localizer.resolve("<L ProdRegResources.WindowTitle>"), container);
        ((Component)this.regFrame).setSize(800, 600);
        this.regFrame.setForeground(Color.black);
        ((Component)this.regFrame).setBackground(Color.lightGray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        container.add(this.getAboutComponent(), gridBagConstraints);
        container.add((Component)new Separator(1), gridBagConstraints);
        double[] dArray = new double[]{0.4, 0.6};
        Container container2 = this.provider.getContainer(new RelativeLayout(dArray, 0));
        container2.add(this.getTreePanel());
        container2.add(this.getInfoPanel());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        container.add((Component)container2, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)new Separator(1), gridBagConstraints);
        container.add(this.getControlComponent(), gridBagConstraints);
        this.regFrame.addWindowListener(new ProdRegWindowAdapter());
        Toolkit toolkit = this.regFrame.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.regFrame.getSize();
        ((Component)this.regFrame).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        Image image = toolkit.getImage(this.getClass().getResource("/images/winicon.gif"));
        toolkit.prepareImage(image, -1, -1, null);
        this.regFrame.setIconImage(image);
        this.regFrame.show();
        int n = 0;
        while (n < this.errorCache.size()) {
            this.logError((String)this.errorCache.elementAt(n));
            ++n;
        }
    }

    public void showProgress() {
        ((Component)((Object)this.pbar)).setVisible(true);
        ((Component)((Object)this.pbar)).getParent().repaint();
    }

    class ProdRegWindowAdapter
    extends WindowAdapter {
        ProdRegWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ProdRegViewManager.this.close();
            ProdRegViewManager.this.installManager.close(0);
        }
    }
}

