/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.server;

import com.sun.dhcpmgr.bridge.Bridge;
import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.HostExistsException;
import com.sun.dhcpmgr.bridge.NoHostsEntryException;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.server.ResourceStrings;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.net.InetAddress;

public class DhcpHostsTable {
    private static DhcpHostsTable cfgHostsTable = null;
    private DirectoryTable hostsTable;
    private int addrColumn = 0;
    private int cnameColumn = 0;
    private int aliasesColumn = 0;
    private int commentColumn = 0;

    public DhcpHostsTable(String string, String string2) throws BridgeException {
        String string3 = null;
        try {
            string3 = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            throw new BridgeException(ResourceStrings.getString("get_host_err"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.equals("files")) {
            stringBuffer.append("file");
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append(":/");
        stringBuffer.append(string3);
        stringBuffer.append("/");
        if (string.equals("files")) {
            stringBuffer.append(string3);
        } else {
            stringBuffer.append(string2);
        }
        try {
            DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
            this.hostsTable = DirectoryTableFactory.getDirectoryTableInstance((String)stringBuffer.toString());
            TableDefinitions tableDefinitions = this.hostsTable.getTableDefinitionsInstance();
            tableDefinitions.loadTableDefinitions("hosts");
            this.addrColumn = tableDefinitions.getColumnNumber("addr");
            this.cnameColumn = tableDefinitions.getColumnNumber("cname");
            this.aliasesColumn = tableDefinitions.getColumnNumber("aliases");
            this.commentColumn = tableDefinitions.getColumnNumber("comment");
        }
        catch (Throwable throwable) {
            throw new BridgeException(ResourceStrings.getString("hosts_access_err"));
        }
    }

    public synchronized boolean canAccessTable(int n) throws BridgeException {
        int n2 = 0;
        try {
            n2 = this.hostsTable.access("hosts");
        }
        catch (Throwable throwable) {}
        return (n2 & n) == n;
    }

    public synchronized void closeTable() throws BridgeException {
        try {
            this.hostsTable.close();
        }
        catch (Throwable throwable) {
            throw new BridgeException(ResourceStrings.getString("hosts_close_err"));
        }
    }

    public synchronized void createHostsRecord(String string, String string2, String string3) throws BridgeException {
        if (this.getHostName(string) != null) {
            throw new HostExistsException(string);
        }
        if (this.getHostAddress(string2) != null) {
            throw new HostExistsException(string2);
        }
        try {
            DirectoryRow directoryRow = this.hostsTable.getRowInstance();
            directoryRow.putColumn(this.addrColumn, string);
            directoryRow.putColumn(this.cnameColumn, string2);
            directoryRow.putColumn(this.aliasesColumn, "");
            directoryRow.putColumn(this.commentColumn, string3);
            this.hostsTable.addRow(directoryRow);
        }
        catch (Throwable throwable) {
            throw new BridgeException(ResourceStrings.getString("hosts_add_err"));
        }
    }

    public synchronized void deleteHostsRecord(String string) throws BridgeException {
        try {
            DirectoryRow directoryRow = this.hostsTable.getRowInstance();
            directoryRow.putColumn(this.addrColumn, string);
            this.hostsTable.deleteRow(directoryRow);
        }
        catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            throw new NoHostsEntryException(string);
        }
        catch (Throwable throwable) {
            throw new BridgeException(ResourceStrings.getString("hosts_remove_err"));
        }
    }

    public static synchronized DhcpHostsTable getCfgHostsTable(Bridge bridge) throws BridgeException {
        if (cfgHostsTable == null) {
            try {
                DhcpdOptions dhcpdOptions = bridge.readDefaults();
                String string = dhcpdOptions.getHostsResource();
                if (string != null) {
                    String string2 = dhcpdOptions.getHostsDomain();
                    cfgHostsTable = new DhcpHostsTable(string, string2);
                }
            }
            catch (Throwable throwable) {
                throw new BridgeException(throwable.getMessage());
            }
        }
        return cfgHostsTable;
    }

    public synchronized String getHostAddress(String string) {
        String string2 = null;
        try {
            DirectoryRow directoryRow = this.hostsTable.getRowInstance();
            directoryRow.putColumn(this.addrColumn, "");
            directoryRow.putColumn(this.cnameColumn, string);
            directoryRow.putColumn(this.aliasesColumn, "");
            directoryRow.putColumn(this.commentColumn, "");
            directoryRow = this.hostsTable.getFirstRow((SearchTemplate)directoryRow);
            string2 = directoryRow.getColumn(this.addrColumn);
        }
        catch (Throwable throwable) {}
        return string2;
    }

    public synchronized String getHostName(String string) {
        String string2 = null;
        try {
            DirectoryRow directoryRow = this.hostsTable.getRowInstance();
            directoryRow.putColumn(this.addrColumn, string);
            directoryRow.putColumn(this.cnameColumn, "");
            directoryRow.putColumn(this.aliasesColumn, "");
            directoryRow.putColumn(this.commentColumn, "");
            directoryRow = this.hostsTable.getFirstRow((SearchTemplate)directoryRow);
            string2 = directoryRow.getColumn(this.cnameColumn);
        }
        catch (Throwable throwable) {}
        return string2;
    }

    public static boolean isHostsValid(String string, String string2) {
        boolean bl = false;
        try {
            DhcpHostsTable dhcpHostsTable = new DhcpHostsTable(string, string2);
            bl = dhcpHostsTable.canAccessTable(8);
        }
        catch (Throwable throwable) {}
        return bl;
    }

    public synchronized void modifyHostsRecord(String string, String string2, String string3, String string4) throws BridgeException {
        if (this.getHostAddress(string3) != null) {
            throw new HostExistsException(string3);
        }
        try {
            DirectoryRow directoryRow = this.hostsTable.getRowInstance();
            directoryRow.putColumn(this.addrColumn, string);
            DirectoryRow directoryRow2 = this.hostsTable.getRowInstance();
            directoryRow2.putColumn(this.addrColumn, string2);
            directoryRow2.putColumn(this.cnameColumn, string3);
            directoryRow2.putColumn(this.aliasesColumn, "");
            directoryRow2.putColumn(this.commentColumn, string4);
            this.hostsTable.modifyRow(directoryRow, directoryRow2);
        }
        catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            throw new NoHostsEntryException(string);
        }
        catch (Throwable throwable) {
            throw new BridgeException(ResourceStrings.getString("hosts_modify_err"));
        }
    }

    public synchronized void openTable() throws BridgeException {
        try {
            this.hostsTable.open("hosts");
        }
        catch (Throwable throwable) {
            throw new BridgeException(ResourceStrings.getString("hosts_open_err"));
        }
    }
}

