/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.ocf;

import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFServer;
import com.sun.opencard.service.ocf.CTListeningService;
import java.util.Enumeration;
import java.util.Hashtable;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.terminal.Slot;

class OCF_CTListener
implements CTListener {
    private Hashtable svcs = new Hashtable();
    private long waitid = 0L;

    OCF_CTListener() {
    }

    long addWaitingService(CTListeningService cTListeningService) {
        Hashtable hashtable = this.svcs;
        synchronized (hashtable) {
            ++this.waitid;
            this.svcs.put(new Long(this.waitid), cTListeningService);
            long l = this.waitid;
            Object var5_4 = null;
            return l;
        }
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
        try {
            OCF_CTListener.debug("cardInserted", "");
            OCFCardHandle oCFCardHandle = OCFServer.createCardHandle(cardTerminalEvent);
            if (oCFCardHandle == null) {
                OCF_CTListener.debug("cardInserted", "Create card handle failed");
                return;
            }
            OCF_CTListener.debug("cardInserted", oCFCardHandle.toString());
            Hashtable hashtable = this.svcs;
            synchronized (hashtable) {
                Enumeration enumeration = this.svcs.elements();
                while (enumeration.hasMoreElements()) {
                    CTListeningService cTListeningService = (CTListeningService)enumeration.nextElement();
                    cTListeningService.cardInserted(oCFCardHandle, oCFCardHandle.getReaderName());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) {
        try {
            OCF_CTListener.debug("cardRemoved", "");
            Slot slot = cardTerminalEvent.getSlot();
            String string = slot.getCardTerminal().getName();
            OCFCardHandle oCFCardHandle = OCFServer.removeHandle(string);
            Hashtable hashtable = this.svcs;
            synchronized (hashtable) {
                OCF_CTListener.debug("cardRemoved", "signaling " + this.svcs.size() + " threads");
                Enumeration enumeration = this.svcs.elements();
                while (enumeration.hasMoreElements()) {
                    ((CTListeningService)enumeration.nextElement()).cardRemoved(oCFCardHandle, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void debug(String string, String string2) {
        try {
            OCFDebug.debugln("OCFListener : <" + string + "> " + string2);
        }
        catch (Exception exception) {}
    }

    void removeWaitingService(long l) {
        Hashtable hashtable = this.svcs;
        synchronized (hashtable) {
            if (this.svcs.remove(new Long(l)) == null) {
                OCF_CTListener.debug("removeWaitingService", "remove failed");
            }
        }
    }
}

