/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SYS_ACCTCTL_H
#define	_SYS_ACCTCTL_H

#pragma ident	"@(#)acctctl.h	1.1	00/02/14 SMI"

#include <sys/types.h>
#include <sys/bitmap.h>

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Definitions for acctctl() system call
 */

/*
 * modes
 */
#define	AC_PROC		(0x1 << 28)	/* change process accounting settings */
#define	AC_TASK		(0x2 << 28)	/* change task accounting settings */
#define	AC_MODE(x)	((x) & 0xf0000000)

/*
 * options
 */
#define	AC_FILE_SET	(0x01)	/* set accounting file name */
#define	AC_FILE_GET	(0x02)	/* get accounting file name */
#define	AC_RES_SET	(0x04)	/* set (enable/disable) resources */
#define	AC_RES_GET	(0x08)	/* get a list of enabled resources */
#define	AC_OPTION(x)	((x) & 0x0fffffff)

/*
 * resource IDs
 */
#define	AC_NONE		0	/* special end-of-list identifier */
#define	AC_PID		1	/* process ID */
#define	AC_UID		2	/* user ID */
#define	AC_GID		3	/* group ID */
#define	AC_PROJID	4	/* project ID */
#define	AC_TASKID	5	/* task ID */
#define	AC_CPU		6	/* cpu user/system time */
#define	AC_TIME		7	/* start/finish time */
#define	AC_COMMAND	8	/* command name */
#define	AC_TTY		9	/* control tty */
#define	AC_HOSTNAME	10	/* hostname */
#define	AC_MICROSTATE	11	/* microstate accounting */
#define	AC_FLAG		12	/* accounting flags */
#define	AC_MAX_RES	12	/* must be equal to the number above */

#define	AC_MASK_SZ	BT_BITOUL(AC_MAX_RES + 1)

/*
 * resource states
 */
#define	AC_ON		1	/* enabled resource */
#define	AC_OFF		0	/* disabled resource */

typedef struct ac_res {
	int	ar_id;		/* resource ID */
	int	ar_state;	/* resource state; see above */
} ac_res_t;

#ifdef	_KERNEL

#include <sys/vnode.h>

typedef struct ac_info {
	kmutex_t	ac_lock;		/* protect the struct */
	vnode_t		*ac_vnode;		/* exacct file vnode pointer */
	char		*ac_file;		/* exacct file name */
	ulong_t		ac_mask[AC_MASK_SZ];	/* bitmask of resources */
} ac_info_t;

extern struct ac_info *ac_proc;
extern struct ac_info *ac_task;

#else

extern int acctctl(int cmd, void *buf, size_t bufsz);

#endif	/* ifdef _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_ACCTCTL_H */
