/*
 * Copyright (c) 1999 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SMEDIA_H_
#define	_SMEDIA_H_

#pragma ident	"@(#)smedia.h	1.1	99/06/24 SMI"

/*
 * smedia.h header for libsmedia library
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>
#include <sys/dkio.h>
#include <sys/vtoc.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>

typedef struct smdevice_info {
	uchar_t	sm_version;
	int32_t	sm_interface_type;	/* Interface type */
	char	*sm_vendor_name;	/* Vendor name */
	char 	*sm_product_name;	/* Product name */
	char 	*sm_firmware_version;	/* Firmware version */
}smdevice_info_t;


#define	SMDEVICE_INFO_V_0	0

/* Interface Types */

#define	IF_SCSI		0x0
#define	IF_FLOPPY	0x1
#define	IF_PCMCIA	0x2


typedef struct smmedium_property {
	int32_t sm_version;
	int32_t sm_media_type;	/* Medium type */
	int32_t sm_blocksize;	/* Medium block size in bytes */
	int32_t sm_capacity;	/* Medium capacity in no. of blocks */
	int32_t sm_pcyl;	/* No. of cylinders on the medium */
	int32_t sm_nhead;	/* No. of heads */
	int32_t sm_nsect;	/* No. of sectors per cylinder */
}smmedium_prop_t;

#define	SMMEDIA_PROP_V_0	0

/*
 * Media types not defined for DKIOCGMEDIAINFO
 */

#define	SM_REMOVABLE_DISK	0x20005 /* Removable disk */
					/* FIXED_DISK + REMOVABLE */
#define	SM_FLOPPY		0x10002 /* Floppy media */
#define	SM_PCMCIA_MEM		0x20006 /* PCMCIA memory card */
#define	SM_NOT_PRESENT		0xFFFF


#define	MAX_PASSWD_LENGTH		32

#define	PASSWD		0x1000

#define	SM_WRITE_PROTECT_DISABLE	(PASSWD|0x0)
#define	SM_WRITE_PROTECT_NOPASSWD	(PASSWD|0x2)
#define	SM_WRITE_PROTECT_PASSWD		(PASSWD|0x4)
#define	SM_READ_WRITE_PROTECT		(PASSWD|0x8)
#define	SM_TEMP_UNLOCK_MODE		(PASSWD|0x10)
#define	SM_STATUS_UNKNOWN		(PASSWD|0xFF)

#define	SM_UNPROTECTED			SM_WRITE_PROTECT_DISABLE
#define	SM_WRITE_PROTECTED 		SM_WRITE_PROTECT_NOPASSWD
#define	SM_WRITE_PROTECTED_WP   	SM_WRITE_PROTECT_PASSWD
#define	SM_READ_WRITE_PROTECTED 	SM_READ_WRITE_PROTECT


typedef struct smwp_state {
	uchar_t sm_version;
	int32_t	sm_new_state;
	int32_t	sm_passwd_len;
	char	sm_passwd[MAX_PASSWD_LENGTH];
}smwp_state_t;

#define	SMWP_STATE_V_0			0

#define	FORMAT	0x2000

#define	SM_FORMAT_LONG		(FORMAT|0x0001)
#define	SM_FORMAT_QUICK		(FORMAT|0x0002)
#define	SM_FORMAT_FORCE		(FORMAT|0x0003)

/* Floppy specific options */
#define	SM_FORMAT_HD	(FORMAT|0x0011) /* Format high density (1.44MB) */
#define	SM_FORMAT_DD	(FORMAT|0x0012) /* Format Double density (720KB) */
#define	SM_FORMAT_ED	(FORMAT|0x0013) /* Format Extended density (2.88MB) */
#define	SM_FORMAT_MD	(FORMAT|0x0014) /* Format Medium density (1.2MB) */

#define	SM_FORMAT_IMMEDIATE	(FORMAT|0x0021)
#define	SM_FORMAT_BLOCKED	(FORMAT|0x0022)



/* Library interface prototypes */

int smedia_get_device_info(int fd, smdevice_info_t *smdevinfop);
int smedia_get_medium_property(int fd, smmedium_prop_t *smpropp);
int smedia_get_protection_status(int fd);
int smedia_set_protection_status(int fd, smwp_state_t *wpstatep);
int smedia_raw_read(int fd, diskaddr_t blockno, caddr_t buffer,
							len_t nbytes);
int smedia_raw_write(int fd, diskaddr_t blockno, caddr_t buffer,
							len_t nbytes);
int smedia_format(int fd, uint_t flavor, uint_t mode);
int smedia_check_format_status(int fd);
int smedia_format_track(int fd, uint_t trackno, uint_t head,
							uint_t density);
int smedia_eject(int fd);
int smedia_reassign_block(int fd, diskaddr_t blockno);


#ifdef __cplusplus
}
#endif

#endif /* _SMEDIA_H_ */
