/* Gate Specific Code -- BEGIN */
/*
 * Copyright (c) 1998-2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#pragma ident "@(#)xfs_monitor_check.c 1.7 01/01/30 SMI"
/* Gate Specific Code -- END */
/* Sun Cluster Data Services Builder template version 1.0 */
/*
 * xfs_monitor_check.c - Monitor Check method for XFS
 */
#include <rgm/libdsdev.h>
#include "xfs.h"

/*
 * just make a simple validate check on the service
 */

int
main(int argc, char *argv[])
{
	scds_handle_t   scds_handle;
	int	rc;

	/* Process the arguments passed by RGM and initialize syslog */
	if (scds_initialize(&scds_handle, argc, argv) != SCHA_ERR_NOERR) {
		return (1);
	}

	rc =  svc_validate(scds_handle);
	scds_syslog_debug(DBG_LEVEL_HIGH,
	    "monitor_check method "
	    "was called and returned <%d>.", rc);

	/* Free up all the memory allocated by scds_initialize */
	scds_close(&scds_handle);

	/* Return the result of validate method run as part of monitor check */
	return (rc);
}
