/* Gate Specific Code -- BEGIN */
/*
 * Copyright (c) 2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#pragma ident "@(#)xfs_monitor_stop.c 1.5 01/01/30 SMI"
/* Gate Specific Code -- END */
/* Sun Cluster Data Services Builder template version 1.0 */
/*
 * xfs_monitor_stop.c - Monitor Stop method for XFS
 */

#include <rgm/libdsdev.h>
#include "xfs.h"

/*
 * This method stops the fault monitor for a XFS resource.
 * This is done via PMF. The PMF tag for the fault monitor is
 * constructed based on RG-name_RS-name.mon.
 */

int
main(int argc, char *argv[])
{

	scds_handle_t   scds_handle;
	int 	rc;

	/* Process arguments passed by RGM and initialize syslog */
	if (scds_initialize(&scds_handle, argc, argv) != SCHA_ERR_NOERR) {
		return (1);
	}
	rc = mon_stop(scds_handle);

	/* Free up all the memory allocated by scds_initialize */
	scds_close(&scds_handle);

	/* Return the result of monitor stop method */
	return (rc);
}
