/* Gate Specific Code -- BEGIN */
/*
 * Copyright (c) 1998-2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */
#pragma ident "@(#)xfs_probe.c 1.12 01/03/22 SMI"

/* Gate Specific Code -- END */
/* Sun Cluster Data Services Builder template version 1.0 */
/*
 * xfs_probe.c - Probe for XFS
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <rgm/libdsdev.h>
#include "xfs.h"
/* User added code -- BEGIN vvvvvvvvvvvvvvv */
/* User added code -- END   ^^^^^^^^^^^^^^^ */

int
main(int argc, char *argv[])
{
	scds_handle_t	scds_handle;
	scha_err_t 	rc;

	/* Network aware applications code -- BEGIN */
	int		timeout;
	int		port, ip, probe_result;
	hrtime_t	ht1, ht2;
	unsigned long	dt;
	scds_netaddr_list_t *netaddr;
	char *hostname;
	/* Network aware applications code -- END */

	/* User added code -- BEGIN vvvvvvvvvvvvvvv */
	/* User added code -- END   ^^^^^^^^^^^^^^^ */

	if (scds_initialize(&scds_handle, argc, argv) != SCHA_ERR_NOERR)
		return (1);

	/* Network aware applications code -- BEGIN */
	/* Get the ip addresses available for this resource */
	if (scds_get_netaddr_list(scds_handle, &netaddr)) {
		scds_syslog(LOG_ERR,
		    "No network address resource in resource group.");
		scds_close(&scds_handle);
		return (1);
	}

	/* Return an error if there are no network resources */
	if (netaddr == NULL || netaddr->num_netaddrs == 0) {
		scds_syslog(LOG_ERR,
		    "No network address resource in resource group.");
		return (1);
	}

	/*
	 * Get the timeout from the extension props. This means that
	 * each probe iteration will get a full timeout on each network
	 * resource without chopping up the timeout between all of the
	 * network resources configured for this resource.
	 */
	timeout = scds_get_ext_probe_timeout(scds_handle);
	/* Network aware applications code -- END */

	/* User added code -- BEGIN vvvvvvvvvvvvvvv */
	/* User added code -- END   ^^^^^^^^^^^^^^^ */

	for (;;) {

		/*
		 * sleep for a duration of thorough_probe_interval between
		 *  successive probes.
		 */
		scds_fm_sleep(scds_handle,
		    scds_get_rs_thorough_probe_interval(scds_handle));

		/* Network aware applications code -- BEGIN */

		/*
		 * Now probe all netaddress we use.
		 * For each of the netaddress that is probed,
		 * compute the failure history.
		 */
		probe_result = 0;
		/*
		 * Iterate through all the netaddrs calling svc_probe()
		 */
		for (ip = 0; ip < netaddr->num_netaddrs; ip++) {
			/*
			 * Grab the hostname and port on which the
			 * health has to be monitored.
			 */
			hostname = netaddr->netaddrs[ip].hostname;
			port = netaddr->netaddrs[ip].port_proto.port;
			ht1 = gethrtime(); /* Latch probe start time */

			/* User added code -- BEGIN vvvvvvvvvvvvvvv */
			/* User added code -- END   ^^^^^^^^^^^^^^^ */

			probe_result = svc_probe(scds_handle, hostname, port,
			    timeout);

			ht2 = gethrtime();

			/* Convert to milliseconds */
			dt = (ht2 - ht1) / 1e6;

			/* User added code -- BEGIN vvvvvvvvvvvvvvv */
			/* User added code -- END   ^^^^^^^^^^^^^^^ */

			/*
			 * Compute failure history and take action if needed
			 */
			(void) scds_fm_action(scds_handle, probe_result, dt);
		}	/* Each netaddr */

		/* Network aware applications code -- END */
	} 	/* Keep probing forever */
}
