/* Gate Specific Code -- BEGIN */
#
# Copyright (c) 1998-2001 by Sun Microsystems, Inc.
# All rights reserved.
#
#ident  "@(#)dns_update.ksh 1.5     01/01/30 SMI"
/* Gate Specific Code -- END */
#!/bin/ksh
# Sun Cluster Data Services Builder template version 1.0
#
# Update method for DNS.
#
# This method only restarts the fault monitor.
# Other changes may be added by the user.
#

###############################################################################
# Parse program arguments.
#
function parse_args # [args ...]
{
	typeset opt

	while getopts 'R:G:T:' opt
	do
		case "$opt" in

		R)
		# Name of the DNS resource.
		RESOURCE_NAME=$OPTARG
		;;

		G)
		# Name of the resource group in which the resource is
		# configured.
		RESOURCEGROUP_NAME=$OPTARG
		;;

		T)
		# Name of the resource type.
		RESOURCETYPE_NAME=$OPTARG
		;;

		*)
		logger -p ${SYSLOG_FACILITY}.err \
		-t [$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME] \
		"ERROR: Option $OPTARG unknown"
		exit 1
		;;

		esac
	done

}

###############################################################################
# MAIN
##############################################################################

export PATH=/bin:/usr/bin:/usr/cluster/bin:/usr/sbin:/usr/proc/bin:$PATH

# Obtain the syslog facility to use. This will be used to log the messages.
SYSLOG_FACILITY=`scha_cluster_get -O SYSLOG_FACILITY`

# Parse the arguments that have been passed to this method.
parse_args "$@"

PMF_TAG=$RESOURCEGROUP_NAME,$RESOURCE_NAME,0.mon
SYSLOG_TAG=$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME

# We need to know the location of the probe method in order to restart it 
# successfully. This value is obtained from the RT_BASEDIR property of the 
# RTR file.
RT_BASEDIR=`scha_resource_get -O RT_BASEDIR -R $RESOURCE_NAME \
	-G $RESOURCEGROUP_NAME`

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

pmfadm -q $PMF_TAG
if [[ $? == 0 ]]; then
	# User added code -- BEGIN vvvvvvvvvvvvvvv
	# User added code -- END   ^^^^^^^^^^^^^^^

	# kill the monitor that is running already
	pmfadm -k $PMF_TAG KILL
	if [[ $? != 0 ]]; then
		logger -p ${SYSLOG_FACILITY}.err \
			-t [$SYSLOG_TAG] \
			"${ARGV0} Could not kill the monitor"
		exit 1
	else
		# could successfully stop DNS. Log a message.
		logger -p ${SYSLOG_FACILITY}.info \
			-t [$SYSLOG_TAG] \
			"Monitor for DNS successfully stopped. \
			PMF will restart it."
	fi
fi

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

exit 0
