/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.ForeignSwitch;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.perfmon.PerfFabricTreeControl;
import com.qlogic.perfmon.PopupDialog;
import com.qlogic.perfmon.SbmUtilities;
import com.qlogic.perfmon.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.util.IpAddress;
import com.qlogic.util.QHelpUtilities;
import com.qlogic.util.StringUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NewFabricDialog
extends QDialog
implements FabricEventListener {
    JPanel dataPanel = new JPanel();
    GridBagLayout dataLayout = new GridBagLayout();
    JLabel newFabricLabel = new JLabel(PerfFabricTreeControl.getResource("NewFabricDialog.newFabricLabel"));
    JLabel fabricNameLabel = new JLabel(PerfFabricTreeControl.getResource("NewFabricDialog.fabricNameLabel"));
    JLabel ipAddressLabel = new JLabel(PerfFabricTreeControl.getResource("NewFabricDialog.ipAddressLabel"));
    JLabel loginLabel = new JLabel(PerfFabricTreeControl.getResource("NewFabricDialog.loginLabel"));
    JLabel passwordLabel = new JLabel(PerfFabricTreeControl.getResource("NewFabricDialog.passwordLabel"));
    JTextField fabricNameTextField = new JTextField();
    JTextField ipAddressTextField = new JTextField();
    JTextField loginTextField = new JTextField();
    JTextField passwordTextField = new JPasswordField();
    JLabel statusInfoLabel = new JLabel();
    JPanel buttonPanel = new JPanel();
    GridLayout buttonLayout = new GridLayout(1, 2, 8, 0);
    JButton addFabricButton = new JButton(new AddFabricAction());
    JButton cancelButton = new JButton(new CancelAction());
    GridBagLayout newFabricLayout = new GridBagLayout();
    private String fabricName;
    private InetAddress inetAddress;
    private FabricList fabricList;
    private Fabric fabric;
    private boolean fieldsEnabled = true;

    public NewFabricDialog(Frame frame, FabricList fabricList) {
        super(frame);
        this.fabricList = fabricList;
        try {
            this.jbInit();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String string = PerfFabricTreeControl.getResource("NewFabricDialog.title") + " - " + VendorProperties.getFrameTitle();
        this.setTitle(string);
        this.getContentPane().setLayout(this.newFabricLayout);
        this.newFabricLabel.setFont(PerfFabricTreeControl.titleFont);
        this.fabricNameTextField.setPreferredSize(new Dimension(160, 21));
        this.ipAddressTextField.setPreferredSize(new Dimension(160, 21));
        this.loginTextField.setPreferredSize(new Dimension(160, 21));
        this.passwordTextField.setPreferredSize(new Dimension(160, 21));
        this.statusInfoLabel.setPreferredSize(new Dimension(160, 21));
        this.dataPanel.setLayout(this.dataLayout);
        this.dataPanel.add((Component)this.newFabricLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(8, 0, 8, 8), 0, 0));
        this.dataPanel.add((Component)this.fabricNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.ipAddressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.loginLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.fabricNameTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.ipAddressTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.loginTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(12, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.passwordTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.statusInfoLabel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.getContentPane().add((Component)this.dataPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.add((Component)this.addFabricButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.newFabricDialogHelp"));
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getRootPane().setDefaultButton(this.addFabricButton);
        this.pack();
        this.fabricNameTextField.requestFocus();
    }

    public void setControlsEnable(boolean bl) {
        this.addFabricButton.setEnabled(bl);
        this.fabricNameTextField.setEnabled(bl);
        this.ipAddressTextField.setEnabled(bl);
        this.loginTextField.setEnabled(bl);
        this.passwordTextField.setEnabled(bl);
        this.fieldsEnabled = bl;
        if (bl) {
            this.cancelButton.setText(PerfFabricTreeControl.getResource("NewFabricDialog.closeButton"));
            this.statusInfoLabel.setText("");
        } else {
            this.cancelButton.setText(PerfFabricTreeControl.getResource("NewFabricDialog.cancelButton"));
            this.statusInfoLabel.setText(PerfFabricTreeControl.getResource("NewFabricDialog.statusInfoLabelConnecting"));
        }
    }

    private void shutdownDialog() {
        this.setControlsEnable(true);
        if (this.fabric != null) {
            this.fabric.removeEventListener((FabricEventListener)this);
            this.fabric = null;
        }
        this.setVisible(false);
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        ReceiveFabricEventRunnable receiveFabricEventRunnable = new ReceiveFabricEventRunnable(fabricEvent);
        SwingUtilities.invokeLater(receiveFabricEventRunnable);
    }

    private void handleError(String string, String string2, Fabric fabric) {
        this.fabricList.removeFabric(fabric);
        string = string + " - " + VendorProperties.getFrameTitle();
        JOptionPane.showMessageDialog(this, string2, string, 0);
        this.setControlsEnable(true);
    }

    public String getPassword() {
        String string = this.passwordTextField.getText();
        this.passwordTextField.setText("");
        return string;
    }

    public String getUserName() {
        return this.loginTextField.getText();
    }

    public String getFabricName() {
        return this.fabricName;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            if (this.fabric != null) {
                this.fabricList.removeFabric(this.fabric);
            }
            this.shutdownDialog();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(PerfFabricTreeControl.getResource("NewFabricDialog.closeButton"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NewFabricDialog.this.fabric != null) {
                NewFabricDialog.this.fabric.removeEventListener((FabricEventListener)NewFabricDialog.this);
                NewFabricDialog.this.fabricList.removeFabric(NewFabricDialog.this.fabric);
            }
            if (NewFabricDialog.this.fieldsEnabled) {
                NewFabricDialog.this.shutdownDialog();
            } else {
                NewFabricDialog.this.setControlsEnable(true);
            }
        }
    }

    public class ReceiveFabricEventRunnable
    implements Runnable {
        FabricEvent evt;

        ReceiveFabricEventRunnable(FabricEvent fabricEvent) {
            this.evt = fabricEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 2002: {
                    Chassis chassis = (Chassis)this.evt.getValue();
                    if (chassis.getDiscoveredByIpAddress() && chassis instanceof ForeignSwitch) {
                        NewFabricDialog.this.fabricList.removeFabric(this.evt.getFabric());
                        String string = SbmUtilities.reasonToString(chassis.getReasonForStatus());
                        JOptionPane.showMessageDialog(NewFabricDialog.this, PerfFabricTreeControl.getResource("NewFabricDialog.loginFailure") + string);
                        NewFabricDialog.this.setControlsEnable(true);
                        break;
                    }
                    NewFabricDialog.this.shutdownDialog();
                    break;
                }
                case 2022: {
                    String string = PerfFabricTreeControl.getResource("NewFabricDialog.noResponse");
                    String string2 = PerfFabricTreeControl.getResource("NewFabricDialog.noResponseMsg");
                    NewFabricDialog.this.handleError(string, string2, this.evt.getFabric());
                    break;
                }
                case 2021: {
                    String string = PerfFabricTreeControl.getResource("NewFabricDialog.connectionFailure");
                    String string3 = PerfFabricTreeControl.getResource("NewFabricDialog.unableToEstablishConnectionMsg");
                    NewFabricDialog.this.handleError(string, string3, this.evt.getFabric());
                    break;
                }
                case 2015: {
                    String string = PerfFabricTreeControl.getResource("NewFabricDialog.unsupportedSwitchType");
                    String string4 = PerfFabricTreeControl.getResource("NewFabricDialog.unsupportedSwitchTypeMsg");
                    NewFabricDialog.this.handleError(string, string4, this.evt.getFabric());
                    break;
                }
                case 2016: {
                    String string = PerfFabricTreeControl.getResource("NewFabricDialog.tooManySessions");
                    String string5 = PerfFabricTreeControl.getResource("NewFabricDialog.tooManySessionsMsg");
                    NewFabricDialog.this.handleError(string, string5, this.evt.getFabric());
                    break;
                }
                case 2017: {
                    String string = PerfFabricTreeControl.getResource("NewFabricDialog.loginFailure");
                    String string6 = PerfFabricTreeControl.getResource("NewFabricDialog.loginFailureMsg");
                    NewFabricDialog.this.handleError(string, string6, this.evt.getFabric());
                }
            }
        }
    }

    class AddFabricAction
    extends AbstractAction {
        public AddFabricAction() {
            super(PerfFabricTreeControl.getResource("NewFabricDialog.addFabricButton"));
        }

        private void showUnknownHostWarning(String string) {
            Object[] objectArray = new Object[]{string};
            String string2 = PerfFabricTreeControl.getResource("menu.fabric.add.unknownHost");
            JOptionPane.showMessageDialog(NewFabricDialog.this, StringUtilities.formatString(string2, objectArray), PerfFabricTreeControl.getResource("menu.fabric.add"), 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (NewFabricDialog.this.fabric != null) {
                NewFabricDialog.this.fabric.removeEventListener((FabricEventListener)NewFabricDialog.this);
                NewFabricDialog.this.fabricList.removeFabric(NewFabricDialog.this.fabric);
                NewFabricDialog.this.fabric = null;
            }
            if ((string = NewFabricDialog.this.ipAddressTextField.getText()).length() == 0) {
                this.showUnknownHostWarning(string);
                return;
            }
            if (IpAddress.isNumeric(string) && !IpAddress.isValidNumeric(string)) {
                PopupDialog.showDialog(NewFabricDialog.this, 3, PerfFabricTreeControl.getResource("NewFabricDialog.error.badIpAddr"));
                return;
            }
            try {
                NewFabricDialog.this.inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                this.showUnknownHostWarning(string);
                return;
            }
            NewFabricDialog.this.fabricName = NewFabricDialog.this.fabricNameTextField.getText().trim();
            if (NewFabricDialog.this.fabricList != null && NewFabricDialog.this.fabricList.fabricNameExists(NewFabricDialog.this.fabricName)) {
                PopupDialog.showDialog(NewFabricDialog.this, 3, PerfFabricTreeControl.getResource("NewFabricDialog.fabricNameInUse"));
                return;
            }
            if (NewFabricDialog.this.fabricName == null || NewFabricDialog.this.fabricName.equals("")) {
                NewFabricDialog.this.fabricName = NewFabricDialog.this.inetAddress.getHostAddress();
            }
            try {
                NewFabricDialog.this.fabric = NewFabricDialog.this.fabricList.addFabric(NewFabricDialog.this.getInetAddress(), NewFabricDialog.this.getFabricName(), NewFabricDialog.this.getUserName(), NewFabricDialog.this.getPassword());
                NewFabricDialog.this.fabric.start();
                NewFabricDialog.this.fabric.addEventListener((FabricEventListener)NewFabricDialog.this);
                NewFabricDialog.this.setControlsEnable(false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(NewFabricDialog.this, "Fabric already exists");
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object != NewFabricDialog.this.addFabricButton && object != NewFabricDialog.this.cancelButton) {
                System.out.println("NewFabricDialog:  unrecognized " + actionEvent.toString());
            }
            NewFabricDialog.this.shutdownDialog();
        }
    }
}

