/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.ForeignSwitch;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.util.StringUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class OpenFabricDialog
extends JDialog
implements FabricEventListener {
    JPanel dataPanel = new JPanel();
    GridBagLayout dataLayout = new GridBagLayout();
    JLabel newFabricLabel = new JLabel("Open Fabric");
    JLabel fabricNameLabel = new JLabel("Fabric Name:");
    JLabel ipAddressLabel = new JLabel("Ip Address:");
    JLabel loginLabel = new JLabel("Login:");
    JLabel passwordLabel = new JLabel("Password:");
    JTextField fabricNameTextField = new JTextField();
    JTextField ipAddressTextField = new JTextField();
    JTextField loginTextField = new JTextField();
    JTextField passwordTextField = new JPasswordField();
    JLabel statusInfoLabel = new JLabel();
    JPanel buttonPanel = new JPanel();
    GridLayout buttonLayout = new GridLayout(1, 2, 8, 0);
    JButton addFabricButton = new JButton(new AddFabricAction());
    JButton cancelButton = new JButton(new CancelAction());
    GridBagLayout newFabricLayout = new GridBagLayout();
    private String fabricName;
    private InetAddress inetAddress;
    private FabricList fabricList;
    private Fabric fabric;
    private boolean fieldsEnabled = true;

    public OpenFabricDialog(Frame frame, FabricList fabricList) {
        super(frame);
        this.fabricList = fabricList;
        try {
            this.jbInit();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String string = "Open Fabric";
        this.setTitle(string);
        this.getContentPane().setLayout(this.newFabricLayout);
        this.fabricNameTextField.setPreferredSize(new Dimension(160, 21));
        this.ipAddressTextField.setPreferredSize(new Dimension(160, 21));
        this.loginTextField.setPreferredSize(new Dimension(160, 21));
        this.passwordTextField.setPreferredSize(new Dimension(160, 21));
        this.statusInfoLabel.setPreferredSize(new Dimension(160, 21));
        this.dataPanel.setLayout(this.dataLayout);
        this.dataPanel.add((Component)this.newFabricLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(8, 0, 8, 8), 0, 0));
        this.dataPanel.add((Component)this.fabricNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.ipAddressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.loginLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.fabricNameTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.ipAddressTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.loginTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(12, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.passwordTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.statusInfoLabel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.getContentPane().add((Component)this.dataPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.add((Component)this.addFabricButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getRootPane().setDefaultButton(this.addFabricButton);
        this.pack();
        this.fabricNameTextField.requestFocus();
    }

    public void setControlsEnable(boolean bl) {
        this.addFabricButton.setEnabled(bl);
        this.fabricNameTextField.setEnabled(bl);
        this.ipAddressTextField.setEnabled(bl);
        this.loginTextField.setEnabled(bl);
        this.passwordTextField.setEnabled(bl);
        this.fieldsEnabled = bl;
        if (bl) {
            this.cancelButton.setText("Cancel");
            this.statusInfoLabel.setText("");
        } else {
            this.cancelButton.setText("Cancel");
            this.statusInfoLabel.setText("");
        }
    }

    private void shutdownDialog() {
        this.setControlsEnable(true);
        if (this.fabric != null) {
            this.fabric.removeEventListener((FabricEventListener)this);
            this.fabric = null;
        }
        this.setVisible(false);
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        ReceiveFabricEventRunnable receiveFabricEventRunnable = new ReceiveFabricEventRunnable(fabricEvent);
        SwingUtilities.invokeLater(receiveFabricEventRunnable);
    }

    public String getPassword() {
        String string = this.passwordTextField.getText();
        this.passwordTextField.setText("");
        return string;
    }

    public String getUserName() {
        return this.loginTextField.getText();
    }

    public String getFabricName() {
        return this.fabricName;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            if (this.fabric != null) {
                this.fabricList.removeFabric(this.fabric);
            }
            this.shutdownDialog();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("CloseButton");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OpenFabricDialog.this.fabric != null) {
                OpenFabricDialog.this.fabricList.removeFabric(OpenFabricDialog.this.fabric);
            }
            if (OpenFabricDialog.this.fieldsEnabled) {
                OpenFabricDialog.this.shutdownDialog();
            } else {
                OpenFabricDialog.this.setControlsEnable(true);
            }
        }
    }

    public class ReceiveFabricEventRunnable
    implements Runnable {
        FabricEvent evt;

        ReceiveFabricEventRunnable(FabricEvent fabricEvent) {
            this.evt = fabricEvent;
        }

        public void run() {
            if (this.evt.getEventType() == 2002) {
                Chassis chassis = (Chassis)this.evt.getValue();
                if (chassis.getDiscoveredByIpAddress() && chassis instanceof ForeignSwitch) {
                    OpenFabricDialog.this.fabricList.removeFabric(this.evt.getFabric());
                    OpenFabricDialog.this.setControlsEnable(true);
                } else {
                    OpenFabricDialog.this.shutdownDialog();
                }
            }
        }
    }

    class AddFabricAction
    extends AbstractAction {
        public AddFabricAction() {
            super("Open Fabric");
        }

        private void showUnknownHostWarning(String string) {
            Object[] objectArray = new Object[]{string};
            String string2 = "Unknown Host";
            JOptionPane.showMessageDialog(OpenFabricDialog.this, StringUtilities.formatString(string2, objectArray), "Open Fabric", 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = OpenFabricDialog.this.ipAddressTextField.getText();
            try {
                OpenFabricDialog.this.inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                this.showUnknownHostWarning(string);
                return;
            }
            OpenFabricDialog.this.fabricName = OpenFabricDialog.this.fabricNameTextField.getText().trim();
            try {
                OpenFabricDialog.this.fabric = OpenFabricDialog.this.fabricList.addFabric(OpenFabricDialog.this.getInetAddress(), OpenFabricDialog.this.getFabricName(), OpenFabricDialog.this.getUserName(), OpenFabricDialog.this.getPassword());
                OpenFabricDialog.this.fabric.start();
                OpenFabricDialog.this.fabric.addEventListener((FabricEventListener)OpenFabricDialog.this);
                OpenFabricDialog.this.setControlsEnable(false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(OpenFabricDialog.this, "Fabric already exists");
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object != OpenFabricDialog.this.addFabricButton && object != OpenFabricDialog.this.cancelButton) {
                System.out.println("OpenFabricDialog:  unrecognized " + actionEvent.toString());
            }
            OpenFabricDialog.this.shutdownDialog();
        }
    }
}

