/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.Director;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.device.fcfabric.event.FabricListEvent;
import com.qlogic.device.fcfabric.event.FabricListEventListener;
import com.qlogic.device.fcfabric.event.GuiError;
import com.qlogic.device.fcfabric.event.SmlError;
import com.qlogic.device.fcfabric.event.UtilError;
import com.qlogic.perfmon.ChangePasswordDialog;
import com.qlogic.perfmon.FcFabricsFile;
import com.qlogic.perfmon.GraphInternalFrame;
import com.qlogic.perfmon.GraphOption;
import com.qlogic.perfmon.GraphOptionsDialog;
import com.qlogic.perfmon.GraphOptionsFile;
import com.qlogic.perfmon.GraphUpdater;
import com.qlogic.perfmon.Grapher;
import com.qlogic.perfmon.HelpAboutDialog;
import com.qlogic.perfmon.NewFabricDialog;
import com.qlogic.perfmon.PerfCloseSessionsDialog;
import com.qlogic.perfmon.PollingFreqDialog;
import com.qlogic.perfmon.PopupDialog;
import com.qlogic.perfmon.SanSurferTreeNode;
import com.qlogic.perfmon.SanSurferTreeNodeRenderer;
import com.qlogic.perfmon.SbmUtilities;
import com.qlogic.perfmon.UserPreferences;
import com.qlogic.perfmon.UserPreferencesDialog;
import com.qlogic.perfmon.VendorProperties;
import com.qlogic.ui.GenericFileFilter;
import com.qlogic.ui.MDIDesktopPane;
import com.qlogic.ui.MainFrame;
import com.qlogic.ui.QFileChooser;
import com.qlogic.ui.StringFileFilter;
import com.qlogic.ui.WindowMenu;
import com.qlogic.ui.tools.TreeControl;
import com.qlogic.util.CommandInterpreter;
import com.qlogic.util.FinalizerPriority;
import com.qlogic.util.QHelpUtilities;
import com.qlogic.util.QMSJHelp;
import com.qlogic.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultDesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class PerfFabricTreeControl
implements TreeControl,
FabricEventListener,
FabricListEventListener,
ChassisEventListener,
TreeSelectionListener,
MouseListener,
ContainerListener,
GraphUpdater {
    public static boolean DEBUG;
    private static final ResourceBundle resources;
    private static ResourceBundle vendors;
    private static final int TIMER_DELAY = 5000;
    private static final int MAX_FABRICS = 8;
    private static final String BUTTON_FONT_NAME = "dialog.bold";
    public static Font titleFont;
    private String applicationName;
    private String viewName;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private String treeName;
    private JSplitPane splitPane;
    private JPanel statusBar;
    private JLabel statusBarLabel;
    private JMenuBar menuBar;
    private Vector defaultToolBarItems;
    private Vector defaultMenuBarItems;
    private Vector defaultMenuBarItems2;
    private JToolBar toolBar;
    private QMSJHelp hlp;
    private AddFabricAction addFabricAction;
    private RemoveFabricAction removeFabricAction;
    private TileVerticallyDesktopAction tileVertDesktopAction;
    private TileHorizontallyDesktopAction tileHorzDesktopAction;
    private CascadeDesktopAction cascadeDesktopAction;
    private CloseAllGraphsAction closeAllGraphsAction;
    private RediscoverTopologyAction rediscoverTopologyAction;
    private SetPollingAction setPollingAction;
    private JButton addFabricButton;
    private JButton removeFabricButton;
    private static final String TOPOLOGY_PANEL = "Topology Panel";
    private static final String FACEPLATE_PANEL = "Faceplate Panel";
    private static final String PORT_GRAPH_PANEL = "Port Graph Panel";
    private static final String BLANK_PANEL = "Blank Panel";
    private GraphInternalFrame graphIntFrame;
    private JPanel blankPanel;
    private MDIDesktopPane desktopPane;
    private JViewport viewPort;
    private JScrollPane scrollDesktopPane;
    private Vector graphList;
    private Vector graphOptions;
    private Color graphBkgdColor;
    private Color graphGridColor;
    private boolean graphGridFlag;
    private FabricList fabricList;
    private static PerfFabricTreeControl fabricTreeControl;
    private NewFabricDialog newFabricDialog;
    private GraphOptionsDialog graphOptionsDialog;
    private PollingFreqDialog pollingFreqDialog;
    private HelpAboutDialog helpAboutDialog;
    private QFileChooser fileChooser;
    private SwitchActivationListener switchActivationListener;
    private boolean fabricRemoved;
    private int perfMonPollingInterval;
    private PerfCloseSessionsDialog closeSessionsDialog;
    private boolean loadCmdLine;

    private PerfFabricTreeControl() {
        Object object;
        block5: {
            this.applicationName = VendorProperties.getApplicationName();
            this.viewName = "";
            this.treeName = PerfFabricTreeControl.getResource("tree.rootName");
            this.defaultToolBarItems = new Vector();
            this.defaultMenuBarItems = new Vector();
            this.defaultMenuBarItems2 = new Vector();
            this.toolBar = new JToolBar();
            this.hlp = new QMSJHelp();
            this.addFabricAction = new AddFabricAction();
            this.removeFabricAction = new RemoveFabricAction();
            this.tileVertDesktopAction = new TileVerticallyDesktopAction();
            this.tileHorzDesktopAction = new TileHorizontallyDesktopAction();
            this.cascadeDesktopAction = new CascadeDesktopAction();
            this.closeAllGraphsAction = new CloseAllGraphsAction();
            this.rediscoverTopologyAction = new RediscoverTopologyAction();
            this.setPollingAction = new SetPollingAction();
            this.blankPanel = new JPanel();
            this.graphList = new Vector();
            this.graphOptions = new Vector();
            this.graphBkgdColor = Color.black;
            this.graphGridColor = Color.white;
            this.graphGridFlag = true;
            this.perfMonPollingInterval = 1;
            this.loadCmdLine = false;
            try {
                titleFont = new Font("Dialog", 1, 14);
            }
            catch (InternalError internalError) {
                object = internalError.getMessage();
                if (internalError == null) break block5;
                System.err.println((String)object);
            }
        }
        this.setDebug();
        String string = PerfFabricTreeControl.getResource("Finalizer.Priority");
        if (string != null) {
            FinalizerPriority.set(Integer.parseInt(string));
        }
        try {
            vendors = ResourceBundle.getBundle("companyId");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        WorldWideName.setVendors((ResourceBundle)vendors);
        object = new SanSurferTreeNode((Object)this.treeName, 0);
        this.treeModel = new DefaultTreeModel((TreeNode)object);
        this.tree = new JTree(this.treeModel){

            public void paint(Graphics graphics) {
                String string = VendorProperties.getResource("vendor");
                if (string == null || string.equals("qlogic")) {
                    this.setOpaque(false);
                    ImageIcon imageIcon = new ImageIcon(SbmUtilities.getImage("tree_simplify.gif"));
                    Dimension dimension = this.getSize();
                    int n = 0;
                    while (n < dimension.width) {
                        int n2 = 0;
                        while (n2 < dimension.height) {
                            graphics.drawImage(imageIcon.getImage(), n, n2, null, null);
                            n2 += imageIcon.getIconHeight();
                        }
                        n += imageIcon.getIconWidth();
                    }
                }
                super.paint(graphics);
            }
        };
        this.tree.setCellRenderer(new SanSurferTreeNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.addMouseListener(this);
        this.desktopPane = new MDIDesktopPane();
        this.desktopPane.addContainerListener(this);
        this.scrollDesktopPane = new JScrollPane(this.desktopPane);
        this.addFabricButton = new JButton(new AddFabricAction(PerfFabricTreeControl.getResource("toolbar.addFabric"), "NewFabric24Disabled.gif"));
        this.addFabricButton.setToolTipText(PerfFabricTreeControl.getResource("toolbar.addFabricToolTip"));
        this.addFabricButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("NewFabric24.gif")));
        SbmUtilities.setButtonParameters(this.addFabricButton);
        this.defaultToolBarItems.add(this.addFabricButton);
        this.removeFabricButton = new JButton(new RemoveFabricAction(PerfFabricTreeControl.getResource("toolbar.remove"), "RemoveFabric24Disabled.gif"));
        this.removeFabricButton.setToolTipText(PerfFabricTreeControl.getResource("toolbar.removeFabricToolTip"));
        this.removeFabricButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("RemoveFabric24.gif")));
        SbmUtilities.setButtonParameters(this.removeFabricButton);
        this.defaultToolBarItems.add(this.removeFabricButton);
        JButton jButton = new JButton(new HelpAction(PerfFabricTreeControl.getResource("toolbar.help"), "Help24Disabled.gif"));
        jButton.setToolTipText(PerfFabricTreeControl.getResource("toolbar.helpFabricToolTip"));
        jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("Help24.gif")));
        SbmUtilities.setButtonParameters(jButton);
        this.defaultToolBarItems.add(jButton);
        this.rebuildToolBar(true);
        this.menuBar = new JMenuBar();
        this.createDefaultMenuBarItems();
        this.createDefaultMenuBarItems2();
        this.rebuildMenuBar(null);
        this.statusBar = new JPanel();
        this.statusBarLabel = new JLabel(this.applicationName);
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.add((Component)this.statusBarLabel, "West");
        this.fabricList = FabricList.getInstance();
        this.fabricList.addEventListener((FabricListEventListener)this);
        this.switchActivationListener = new SwitchActivationListener();
        this.removeFabricAction.setEnabled(false);
        this.removeFabricButton.setEnabled(false);
        this.rediscoverTopologyAction.setEnabled(false);
    }

    public static PerfFabricTreeControl instance() {
        if (fabricTreeControl == null) {
            try {
                fabricTreeControl = new PerfFabricTreeControl();
            }
            catch (Exception exception) {
                // empty catch block
            }
            FabricUtilities.logMessage((String)(VendorProperties.getApplicationName() + " was started."), (Level)Level.INFO, (String)fabricTreeControl.getClass().getName(), (String)"instance()");
            FabricUtilities.logMessage((String)("User is: " + System.getProperty("user.name")), (Level)Level.INFO, (String)fabricTreeControl.getClass().getName(), (String)"instance()");
        }
        return fabricTreeControl;
    }

    private void createDefaultMenuBarItems() {
        JMenu jMenu = new JMenu(PerfFabricTreeControl.getResource("menu.file"));
        JMenu jMenu2 = new JMenu(PerfFabricTreeControl.getResource("menu.fabric"));
        JMenu jMenu3 = new JMenu(PerfFabricTreeControl.getResource("menu.graph"));
        this.defaultMenuBarItems.removeAllElements();
        this.defaultMenuBarItems.add(jMenu);
        JMenuItem jMenuItem = jMenu.add(new OpenFabricsAction());
        jMenuItem.setMnemonic('O');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem = jMenu.add(new SaveFabricsAsAction());
        jMenuItem.setMnemonic('A');
        jMenuItem = jMenu.add(new SaveGraphStatisticsAction());
        jMenuItem.setMnemonic('C');
        jMenuItem = jMenu.add(new SaveAllGraphStatisticsAction());
        jMenuItem.setMnemonic('l');
        jMenuItem = jMenu.add(new PrintGraphWindowAction());
        jMenuItem.setMnemonic('r');
        jMenuItem = jMenu.add(new ChangePasswordAction());
        jMenuItem.setMnemonic('D');
        jMenuItem = jMenu.add(new UserPreferencesAction());
        jMenuItem.setMnemonic('P');
        jMenu.addSeparator();
        jMenuItem = jMenu.add(new ExitAction());
        jMenuItem.setMnemonic('x');
        jMenu.setMnemonic('F');
        this.defaultMenuBarItems.add(jMenu2);
        jMenuItem = jMenu2.add(this.addFabricAction);
        jMenuItem.setMnemonic('A');
        jMenuItem = jMenu2.add(this.removeFabricAction);
        jMenuItem.setMnemonic('R');
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        if (sanSurferTreeNode != null && sanSurferTreeNode.getNodeType() == 1) {
            jMenu2.addSeparator();
            jMenuItem = jMenu2.add(this.rediscoverTopologyAction);
            jMenuItem.setMnemonic('d');
        }
        jMenu2.setMnemonic('b');
        this.defaultMenuBarItems.add(jMenu3);
        jMenuItem = jMenu3.add(new GraphOptionsAction());
        jMenuItem.setMnemonic('O');
        jMenu3.addSeparator();
        jMenuItem = jMenu3.add(new SetPollingAction());
        jMenuItem.setMnemonic('P');
        jMenu3.setMnemonic('G');
    }

    private void createDefaultMenuBarItems2() {
        WindowMenu windowMenu = new WindowMenu(this.desktopPane);
        JMenu jMenu = new JMenu(PerfFabricTreeControl.getResource("menu.help"));
        this.defaultMenuBarItems2.removeAllElements();
        this.defaultMenuBarItems2.add(windowMenu);
        if (DEBUG) {
            JMenu jMenu2 = new JMenu("Debug");
            this.defaultMenuBarItems2.add(jMenu2);
            jMenu2.add(new DebugAction());
        }
        this.defaultMenuBarItems2.add(jMenu);
        JMenuItem jMenuItem = jMenu.add(new HelpAction());
        jMenuItem.setMnemonic('T');
        jMenuItem = jMenu.add(new HelpAboutAction());
        jMenuItem.setMnemonic('A');
        jMenu.setMnemonic('H');
    }

    public CommandInterpreter getCommandInterpreter() {
        return null;
    }

    public static String getResource(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public Vector getGraphList() {
        Vector<GraphInternalFrame> vector = new Vector<GraphInternalFrame>();
        Component[] componentArray = this.desktopPane.getComponentsInLayer(0);
        int n = 0;
        while (n < componentArray.length) {
            GraphInternalFrame graphInternalFrame = (GraphInternalFrame)componentArray[n];
            if (graphInternalFrame != null) {
                vector.add(graphInternalFrame);
            }
            ++n;
        }
        return vector;
    }

    public void setGraphList(Vector vector) {
        if (this.graphList.isEmpty()) {
            this.graphList = vector;
        } else {
            int n = 0;
            while (n < vector.size()) {
                GraphInternalFrame graphInternalFrame = (GraphInternalFrame)vector.get(n);
                this.graphList.add(graphInternalFrame);
                ++n;
            }
        }
    }

    private QFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new QFileChooser();
            this.fileChooser.setSelectedFile(new File("default.fab"));
            String string = PerfFabricTreeControl.getResource("PerfFabricTreeControl.fabricFileDescription");
            GenericFileFilter genericFileFilter = new GenericFileFilter("fab", string);
            this.fileChooser.addChoosableFileFilter(genericFileFilter);
        }
        return this.fileChooser;
    }

    private SanSurferTreeNode getSelectedNode() {
        SanSurferTreeNode sanSurferTreeNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            sanSurferTreeNode = (SanSurferTreeNode)treePath.getLastPathComponent();
        }
        return sanSurferTreeNode;
    }

    private void checkSelected() {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (sanSurferTreeNode != null) {
            switch (sanSurferTreeNode.getNodeType()) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 99: {
                    bl3 = true;
                }
                case 5: {
                    bl4 = true;
                }
            }
        }
        this.removeFabricAction.setEnabled(this.fabricList.size() > 0);
        this.removeFabricButton.setEnabled(this.fabricList.size() > 0);
        this.rediscoverTopologyAction.setEnabled(bl2);
    }

    public void applyGraphOptions(Vector vector, boolean bl, boolean bl2) {
        this.loadUserGraphOpts();
        if (this.graphOptions == null) {
            return;
        }
        if (bl && this.graphList != null) {
            int n = this.graphList.size();
            int n2 = 0;
            while (n2 < n) {
                ((GraphInternalFrame)this.graphList.elementAt(n2)).applyGraphOptions(this.graphOptions);
                ++n2;
            }
        }
        if (bl2) {
            GraphInternalFrame graphInternalFrame = (GraphInternalFrame)this.desktopPane.getSelectedFrame();
            graphInternalFrame.applyGraphOptions(vector);
        }
    }

    private void setDebug() {
        DEBUG = false;
        String string = PerfFabricTreeControl.getResource("DEBUG");
        if (string != null) {
            DEBUG = string.toLowerCase().equals("true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveStatistics(GraphInternalFrame graphInternalFrame) {
        int n;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        JFrame jFrame = SbmUtilities.getFrame(MainFrame.instance());
        String string = UserPreferences.getInstance().getWorkingDirectory();
        QFileChooser qFileChooser = new QFileChooser(string);
        StringFileFilter stringFileFilter = new StringFileFilter(".xml");
        StringFileFilter stringFileFilter2 = new StringFileFilter(".csv");
        qFileChooser.addChoosableFileFilter(stringFileFilter);
        qFileChooser.addChoosableFileFilter(stringFileFilter2);
        qFileChooser.setFileFilter(stringFileFilter2);
        if (qFileChooser.showSaveDialog(jFrame) != 0) return;
        String string2 = qFileChooser.getSelectedFile().toString();
        if (string2.endsWith(".xml")) {
            bl = true;
        } else if (string2.endsWith(".csv")) {
            bl2 = true;
        } else {
            object = (StringFileFilter)qFileChooser.getFileFilter();
            if (object.equals(stringFileFilter)) {
                bl = true;
                string2 = string2 + ".xml";
            } else {
                bl2 = true;
                string2 = string2 + ".csv";
            }
        }
        object = new File(string2);
        if (((File)object).exists() && (n = JOptionPane.showConfirmDialog(jFrame, PerfFabricTreeControl.getResource("SaveStatistics.theFile") + " " + string2 + " " + PerfFabricTreeControl.getResource("SaveStatistics.overwriteIt"), PerfFabricTreeControl.getResource("SaveStatistics.saveStatistics"), 0)) == 1) {
            return;
        }
        Cursor cursor = jFrame.getCursor();
        jFrame.setCursor(new Cursor(3));
        try {
            try {
                if (bl) {
                    Document document = new Document();
                    try {
                        this.gatherXmlStatistics(document, graphInternalFrame);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        JOptionPane.showMessageDialog(jFrame, PerfFabricTreeControl.getResource("SaveStatistics.missingInformation"));
                        illegalArgumentException.printStackTrace();
                        Object var15_20 = null;
                        jFrame.setCursor(cursor);
                        return;
                    }
                    XMLOutputter xMLOutputter = new XMLOutputter();
                    xMLOutputter.setNewlines(true);
                    xMLOutputter.setIndent("    ");
                    xMLOutputter.output(document, (OutputStream)new FileOutputStream(string2));
                } else if (bl2) {
                    try {
                        FileWriter fileWriter = new FileWriter((File)object);
                        PrintWriter printWriter = new PrintWriter((Writer)fileWriter, true);
                        this.gatherCsvStatistics(graphInternalFrame, printWriter);
                        printWriter.close();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        JOptionPane.showMessageDialog(jFrame, PerfFabricTreeControl.getResource("SaveStatistics.missingInformation"));
                        Object var15_21 = null;
                        jFrame.setCursor(cursor);
                        return;
                    }
                }
                Object var15_22 = null;
            }
            catch (IOException iOException) {
                Object var15_23 = null;
                jFrame.setCursor(cursor);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            jFrame.setCursor(cursor);
            throw throwable;
        }
        jFrame.setCursor(cursor);
    }

    public void gatherXmlStatistics(Document document, GraphInternalFrame graphInternalFrame) {
        Element element = new Element("Statistics");
        if (graphInternalFrame != null) {
            Element element2 = this.getDataSetTag(graphInternalFrame);
            element.addContent(element2);
        } else if (this.graphList != null) {
            int n = this.graphList.size();
            int n2 = 0;
            while (n2 < n) {
                Element element3 = this.getDataSetTag((GraphInternalFrame)this.graphList.elementAt(n2));
                element.addContent(element3);
                ++n2;
            }
        }
        document.setRootElement(element);
    }

    public void gatherCsvStatistics(GraphInternalFrame graphInternalFrame, PrintWriter printWriter) {
        if (graphInternalFrame != null) {
            String string = this.getCsvHeaderString();
            printWriter.write(string);
            printWriter.println();
            this.getCsvData(graphInternalFrame, printWriter);
        } else if (this.graphList != null) {
            String string = this.getCsvHeaderString();
            printWriter.write(string);
            printWriter.println();
            int n = this.graphList.size();
            int n2 = 0;
            while (n2 < n) {
                this.getCsvData((GraphInternalFrame)this.graphList.elementAt(n2), printWriter);
                ++n2;
            }
        }
    }

    public Element getDataSetTag(GraphInternalFrame graphInternalFrame) {
        Sanbox2 sanbox2 = (Sanbox2)graphInternalFrame.getChassis();
        S16Port s16Port = (S16Port)graphInternalFrame.getPort();
        Element element = new Element("DataSet");
        element.setAttribute("Switch", sanbox2.toString());
        element.setAttribute("Port", s16Port.getPortName());
        int n = graphInternalFrame.getGrapher().graphOptions.size();
        GraphOption[] graphOptionArray = new GraphOption[n];
        ArrayList[] arrayListArray = new ArrayList[n];
        int n2 = 0;
        while (n2 < n) {
            GraphOption graphOption = (GraphOption)graphInternalFrame.getGrapher().graphOptions.get(n2);
            graphOptionArray[n2] = (GraphOption)graphInternalFrame.getGrapher().graphOptions.get(n2);
            arrayListArray[n2] = graphInternalFrame.getGrapher().graphCanvas.getGraphData(graphOptionArray[n2].getGraphItem());
            ++n2;
        }
        if (arrayListArray != null) {
            int n3 = 0;
            while (n3 < arrayListArray[0].size()) {
                Element element2 = new Element("DataPoint");
                element2.setAttribute("Sample", Integer.toString(n3 + 1));
                int n4 = 0;
                while (n4 < n) {
                    String string = this.getXmlAttrStr(graphOptionArray[n4].getGraphItem());
                    Long l = new Long(graphInternalFrame.getGrapher().graphCanvas.getGraphValue(arrayListArray[n4], n3));
                    element2.setAttribute(string, l.toString());
                    ++n4;
                }
                element.addContent(element2);
                ++n3;
            }
        }
        return element;
    }

    public void getCsvData(GraphInternalFrame graphInternalFrame, PrintWriter printWriter) {
        String string;
        String string2 = "";
        String string3 = ",";
        String string4 = string = graphInternalFrame.getFabricName();
        string4 = string4 + string3;
        Sanbox2 sanbox2 = (Sanbox2)graphInternalFrame.getChassis();
        string4 = string4 + sanbox2.getChassisName();
        string4 = string4 + string3;
        S16Port s16Port = (S16Port)graphInternalFrame.getPort();
        string4 = string4 + s16Port.getPortName();
        string4 = string4 + string3;
        int n = graphInternalFrame.getGrapher().graphOptions.size();
        GraphOption[] graphOptionArray = new GraphOption[n];
        ArrayList[] arrayListArray = new ArrayList[n];
        int n2 = 0;
        while (n2 < n) {
            graphOptionArray[n2] = (GraphOption)graphInternalFrame.getGrapher().graphOptions.get(n2);
            arrayListArray[n2] = graphInternalFrame.getGrapher().graphCanvas.getGraphData(graphOptionArray[n2].getGraphItem());
            ++n2;
        }
        if (arrayListArray != null) {
            int n3 = 0;
            while (n3 < arrayListArray[0].size()) {
                string2 = string4;
                string2 = string2 + Integer.toString(n3 + 1);
                int n4 = 0;
                while (n4 < n) {
                    string2 = string2 + string3;
                    Long l = new Long(graphInternalFrame.getGrapher().graphCanvas.getGraphValue(arrayListArray[n4], n3));
                    string2 = string2 + l.toString();
                    ++n4;
                }
                printWriter.write(string2);
                printWriter.println();
                ++n3;
            }
        }
    }

    public String getCsvHeaderString() {
        String string = PerfFabricTreeControl.getResource("SaveStatistics.fabric") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.switch") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.port") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.sample") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.totalBytes") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.txBytes") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.rxBytes") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.totalFrames") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.txFrames") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.rxFrames") + ",";
        string = string + PerfFabricTreeControl.getResource("SaveStatistics.totalErrors");
        return string;
    }

    public String getXmlAttrStr(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = PerfFabricTreeControl.getResource("SaveStatistics.xtotalBytes");
                break;
            }
            case 2: {
                string = PerfFabricTreeControl.getResource("SaveStatistics.xtxBytes");
                break;
            }
            case 3: {
                string = PerfFabricTreeControl.getResource("SaveStatistics.xrxBytes");
                break;
            }
            case 4: {
                string = PerfFabricTreeControl.getResource("SaveStatistics.xtotalFrames");
                break;
            }
            case 5: {
                string = PerfFabricTreeControl.getResource("SaveStatistics.xtxFrames");
                break;
            }
            case 6: {
                string = PerfFabricTreeControl.getResource("SaveStatistics.xrxFrames");
                break;
            }
            case 7: {
                string = PerfFabricTreeControl.getResource("SaveStatistics.xtotalErrors");
                break;
            }
            default: {
                string = "Attr" + n;
            }
        }
        return string;
    }

    public GraphInternalFrame getGraphInternalFrame(Grapher grapher) {
        int n = this.graphList.size();
        while (n > 0) {
            GraphInternalFrame graphInternalFrame = (GraphInternalFrame)this.graphList.get(n - 1);
            if (graphInternalFrame.getGrapher() == grapher) {
                return graphInternalFrame;
            }
            --n;
        }
        return null;
    }

    public void closeGrapher(Grapher grapher) {
        GraphInternalFrame graphInternalFrame = this.getGraphInternalFrame(grapher);
        if (graphInternalFrame != null) {
            try {
                graphInternalFrame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            graphInternalFrame.setVisible(false);
            this.desktopPane.remove(graphInternalFrame);
            this.graphList.removeElement(graphInternalFrame);
            this.desktopPane.validate();
        }
    }

    private void addFabric() {
        if (this.newFabricDialog == null) {
            this.newFabricDialog = new NewFabricDialog((Frame)MainFrame.instance(), this.fabricList);
            this.newFabricDialog.setModal(true);
        }
        this.newFabricDialog.setVisible(true);
        this.checkSelected();
    }

    public void graphOptions(Vector vector) {
        if (this.graphOptionsDialog == null) {
            this.graphOptionsDialog = new GraphOptionsDialog((Frame)MainFrame.instance(), this);
            this.graphOptionsDialog.setTitle(PerfFabricTreeControl.getResource("GraphOptionsDialog.defaultTitle"));
            this.graphOptionsDialog.setModal(true);
        }
        if (vector != null) {
            this.graphOptionsDialog.initOptions(vector);
        } else {
            this.graphOptionsDialog.initOptions();
        }
        this.graphOptionsDialog.setVisible(true);
    }

    private void tileGraphs() {
        double d;
        int n;
        double d2;
        Dimension dimension = this.desktopPane.getSize();
        int n2 = this.graphList.size();
        double d3 = Math.sqrt(n2);
        int n3 = (int)d3;
        double d4 = n3;
        if (d4 != d3) {
            ++n3;
        }
        if ((d2 = (double)(n = n2 / n3)) != (d = (double)n2 / (double)n3)) {
            ++n;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = (int)(dimension.getWidth() / (double)n3);
        int n7 = (int)(dimension.getHeight() / (double)n);
        int n8 = 0;
        while (n8 < this.graphList.size()) {
            GraphInternalFrame graphInternalFrame = (GraphInternalFrame)this.graphList.get(n8);
            if (graphInternalFrame != null) {
                graphInternalFrame.setSize(n6, n7);
                graphInternalFrame.setLocation(n4 * n6, n5 * n7);
                if (++n4 == n3) {
                    n4 = 0;
                    ++n5;
                }
            }
            ++n8;
        }
        this.desktopPane.validate();
    }

    private void cascadeGraphs() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getCascadeOffset();
        Component[] componentArray = this.getResetFrames(0);
        int n4 = componentArray.length;
        while (n4 > 0) {
            GraphInternalFrame graphInternalFrame = (GraphInternalFrame)componentArray[n4 - 1];
            if (graphInternalFrame != null) {
                graphInternalFrame.setSize(300, 300);
                graphInternalFrame.setLocation(n3 * n, n3 * n2);
                ++n;
                ++n2;
            }
            --n4;
        }
    }

    private int getCascadeOffset() {
        int n = 0;
        Dimension dimension = this.desktopPane.getSize();
        int n2 = (int)dimension.getHeight();
        int n3 = (int)dimension.getWidth();
        boolean bl = false;
        boolean bl2 = false;
        n = n2 > n3 && n2 > 300 ? (n3 - 300) / this.graphList.size() : (n3 >= n2 && n3 > 300 ? (n2 - 300) / this.graphList.size() : 0);
        if (n > 30) {
            n = 30;
        }
        return n;
    }

    public void tileVertical() {
        Component[] componentArray = this.getResetFrames(0);
        int n = componentArray.length;
        int n2 = (int)Math.sqrt(n);
        int n3 = n2;
        if (n3 * n2 < n) {
            ++n3;
        }
        if (n3 * n2 < n) {
            ++n2;
        }
        int n4 = 300;
        int n5 = 200;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            int n8 = 0;
            while (n8 < n3) {
                componentArray[n6].setBounds(n7 * n4, n8 * n5, n4, n5);
                if (++n6 == n) break;
                ++n8;
            }
            ++n7;
        }
    }

    public void tileHorizontal() {
        Component[] componentArray = this.getResetFrames(0);
        int n = componentArray.length;
        int n2 = (int)Math.sqrt(n);
        int n3 = n2;
        if (n3 * n2 < n) {
            ++n2;
        }
        if (n3 * n2 < n) {
            ++n3;
        }
        int n4 = this.desktopPane.getSize().width / n2;
        int n5 = this.desktopPane.getSize().height / n3;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = 0;
            while (n8 < n2) {
                componentArray[n6].setBounds(n8 * n4, n7 * n5, n4, n5);
                if (++n6 == n) break;
                ++n8;
            }
            ++n7;
        }
    }

    public void cascade() {
        this.cascade(new Rectangle(0, 0, 300, 300), new Dimension(10, 10));
    }

    /*
     * Unable to fully structure code
     */
    public void cascade(Rectangle var1_1, Dimension var2_2) {
        var3_3 = this.getLastAcceptablePoint();
        var4_4 = (Rectangle)var1_1.clone();
        var5_5 = this.getResetFrames(0);
        var6_6 = 0;
        while (var6_6 < var5_5.length) {
            var5_5[var6_6].setBounds(var4_4);
            if ((double)(var4_4.x += var2_2.width) > var3_3.getX()) ** GOTO lbl-1000
            var4_4.y += var2_2.height;
            if ((double)v0 > var3_3.getY()) lbl-1000:
            // 2 sources

            {
                var4_4.x = (int)var3_3.getX();
                var4_4.y = (int)var3_3.getY();
            } else {
                var4_4.x += var2_2.width;
                var4_4.y += var2_2.height;
            }
            ++var6_6;
        }
    }

    protected Component[] getResetFrames(int n) {
        Component[] componentArray = this.desktopPane.getComponentsInLayer(n);
        int n2 = 0;
        while (n2 < componentArray.length) {
            this.resetFrame(componentArray[n2]);
            ++n2;
        }
        return this.desktopPane.getComponentsInLayer(n);
    }

    protected void resetFrame(Component component) {
        block6: {
            JInternalFrame jInternalFrame;
            if (component instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)component;
                try {
                    if (jInternalFrame.isMaximum()) {
                        jInternalFrame.setMaximum(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (!(component instanceof JInternalFrame.JDesktopIcon)) break block6;
            jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame();
            try {
                jInternalFrame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    private void rediscover() {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        SanSurferTreeNode sanSurferTreeNode2 = null;
        Fabric fabric = null;
        if (sanSurferTreeNode != null) {
            switch (sanSurferTreeNode.getNodeType()) {
                case 1: {
                    fabric = (Fabric)sanSurferTreeNode.getUserObject();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 99: {
                    sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getParent();
                    fabric = (Fabric)sanSurferTreeNode2.getUserObject();
                    break;
                }
            }
        }
        if (fabric != null) {
            fabric.rediscover();
        }
    }

    private void removeFabric(Fabric fabric) {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        SanSurferTreeNode sanSurferTreeNode2 = null;
        Fabric fabric2 = null;
        if (fabric != null) {
            fabric2 = fabric;
        } else if (sanSurferTreeNode != null) {
            switch (sanSurferTreeNode.getNodeType()) {
                case 1: {
                    fabric2 = (Fabric)sanSurferTreeNode.getUserObject();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 99: {
                    sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getParent();
                    fabric2 = (Fabric)sanSurferTreeNode2.getUserObject();
                    break;
                }
                case 5: {
                    sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getParent();
                    sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode2.getParent();
                    fabric2 = (Fabric)sanSurferTreeNode2.getUserObject();
                    break;
                }
            }
        }
        if (fabric2 == null) {
            return;
        }
        if (fabric2 != null) {
            if (fabric2.hasSanbox2()) {
                if (this.closeSessionsDialog == null) {
                    this.closeSessionsDialog = new PerfCloseSessionsDialog(MainFrame.instance());
                }
                this.closeSessionsDialog.closeSessions(fabric2);
            }
            this.fabricList.removeFabric(fabric2);
            this.fabricRemoved = true;
            if (this.fabricList.size() == 0) {
                this.setStatusBarText("");
            }
            JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
            int n = 0;
            while (n < jInternalFrameArray.length) {
                GraphInternalFrame graphInternalFrame = (GraphInternalFrame)jInternalFrameArray[n];
                if (graphInternalFrame.isIcon()) {
                    try {
                        graphInternalFrame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (fabric2.getFabricName().equals(graphInternalFrame.getFabricName())) {
                    graphInternalFrame.setVisible(false);
                    this.desktopPane.remove(graphInternalFrame);
                    this.graphList.removeElement(graphInternalFrame);
                }
                ++n;
            }
            this.desktopPane.validate();
        }
        this.checkSelected();
    }

    public void refresh() {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        if (sanSurferTreeNode == null) {
            return;
        }
        Object object = sanSurferTreeNode.getUserObject();
        switch (sanSurferTreeNode.getNodeType()) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
    }

    private void debugMethod() {
    }

    private void showHelpAbout() {
        if (this.helpAboutDialog == null) {
            this.helpAboutDialog = new HelpAboutDialog(MainFrame.instance());
            this.helpAboutDialog.setModal(true);
        }
        this.helpAboutDialog.show();
    }

    private void showHelp() {
        boolean bl = false;
        try {
            bl = QHelpUtilities.displayTopic(VendorProperties.getResource("FabricViewhelp.html"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            PopupDialog.showDialog(MainFrame.instance(), 3, PerfFabricTreeControl.getResource("PerfFabricTreeControl.helpFailed"));
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public MDIDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public String getTreeName() {
        return this.treeName;
    }

    public String getApplicationTitle() {
        return this.applicationName + this.viewName;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    private Dimension rebuildToolBar(boolean bl) {
        Dimension dimension = null;
        this.toolBar.removeAll();
        int n = 0;
        while (n < this.defaultToolBarItems.size()) {
            Component component = (Component)this.defaultToolBarItems.elementAt(n);
            if (component instanceof JButton) {
                if (dimension == null) {
                    dimension = component.getPreferredSize();
                } else {
                    dimension.width = Math.max(dimension.width, component.getPreferredSize().width);
                    dimension.height = Math.max(dimension.height, component.getPreferredSize().height);
                }
            }
            this.toolBar.add(component);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.defaultToolBarItems.size()) {
            Component component = (Component)this.defaultToolBarItems.elementAt(n2);
            if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                jButton.setPreferredSize(dimension);
                jButton.setBorder(new EmptyBorder(jButton.getInsets()));
            }
            ++n2;
        }
        if (bl) {
            this.toolBar.add(Box.createGlue());
        }
        this.toolBar.validate();
        this.toolBar.repaint();
        return dimension;
    }

    private void rebuildToolBar(Vector vector) {
        Component component;
        int n;
        Dimension dimension = this.rebuildToolBar(false);
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                component = (Component)vector.elementAt(n);
                if (component instanceof JButton) {
                    if (dimension == null) {
                        dimension = component.getPreferredSize();
                    } else {
                        dimension.width = Math.max(dimension.width, component.getPreferredSize().width);
                        dimension.height = Math.max(dimension.height, component.getPreferredSize().height);
                    }
                }
                this.toolBar.add(component);
                ++n;
            }
        }
        if (dimension != null) {
            n = 0;
            while (n < this.toolBar.getComponentCount()) {
                component = this.toolBar.getComponentAtIndex(n);
                if (component instanceof JButton) {
                    JButton jButton = (JButton)component;
                    jButton.setPreferredSize(dimension);
                    jButton.setBorder(new EmptyBorder(jButton.getInsets()));
                }
                ++n;
            }
        }
        this.toolBar.add(Box.createGlue());
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    private void addDefaultMenuBarItems(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            JMenu jMenu = (JMenu)vector.elementAt(n);
            JMenu jMenu2 = this.getMenuByName(jMenu.getText());
            if (jMenu2 != null) {
                this.insertMenuItems(jMenu2, jMenu);
            } else {
                this.menuBar.add(jMenu);
            }
            ++n;
        }
    }

    private void addExtendedMenuBarItems(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            JMenu jMenu = (JMenu)vector.elementAt(n);
            JMenu jMenu2 = this.getMenuByName(jMenu.getText());
            if (jMenu2 != null) {
                this.addMenuItems(jMenu2, jMenu);
            } else {
                this.menuBar.add(jMenu);
            }
            ++n;
        }
    }

    private JMenu getMenuByName(String string) {
        int n = 0;
        int n2 = this.menuBar.getMenuCount();
        while (n < n2) {
            if (this.menuBar.getMenu(n).getText().equals(string)) {
                return this.menuBar.getMenu(n);
            }
            ++n;
        }
        return null;
    }

    private void addMenuItems(JMenu jMenu, JMenu jMenu2) {
        int n = jMenu2.getItemCount();
        if (n > 0) {
            jMenu.addSeparator();
            int n2 = 0;
            while (n2 < n) {
                JMenuItem jMenuItem = jMenu2.getItem(n2);
                if (jMenuItem == null) {
                    jMenu.addSeparator();
                } else {
                    jMenu.add(jMenuItem);
                    --n2;
                    --n;
                }
                ++n2;
            }
        }
    }

    private void insertMenuItems(JMenu jMenu, JMenu jMenu2) {
        int n = jMenu2.getItemCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                JMenuItem jMenuItem = jMenu2.getItem(n2);
                if (jMenuItem == null) {
                    jMenu.insertSeparator(n2);
                } else {
                    jMenu.insert(jMenuItem, n2);
                    --n;
                }
                ++n2;
            }
            jMenu.insertSeparator(n2);
        }
    }

    private void rebuildMenuBar(Vector vector) {
        this.menuBar.removeAll();
        this.createDefaultMenuBarItems();
        this.addDefaultMenuBarItems(this.defaultMenuBarItems);
        if (vector != null) {
            this.addExtendedMenuBarItems(vector);
        }
        this.createDefaultMenuBarItems2();
        this.addDefaultMenuBarItems(this.defaultMenuBarItems2);
        this.menuBar.validate();
        this.menuBar.repaint();
    }

    public void startup() {
        QHelpUtilities.initHelpResources("SfvCSHelp");
        String string = System.getProperty("ip");
        String string2 = System.getProperty("login");
        String string3 = System.getProperty("passwd");
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        String string4 = "";
        InetAddress inetAddress = null;
        if (string != null && !string.equals(string4)) {
            this.loadCmdLine = true;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                PopupDialog.showDialog(MainFrame.instance(), 3, PerfFabricTreeControl.getResource("PerfFabricTreeControl.badIpAddr"));
                return;
            }
            String string5 = "";
            if (inetAddress != null) {
                string5 = inetAddress.getHostAddress();
            }
            try {
                Fabric fabric = this.fabricList.addFabric(inetAddress, string5, string2, string3);
                fabric.start();
                fabric.addEventListener((FabricEventListener)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PopupDialog.showDialog(MainFrame.instance(), 3, PerfFabricTreeControl.getResource("PerfFabricTreeControl.fabricOpenFailed"));
                return;
            }
            this.loadUserGraphOpts();
        } else {
            UserPreferences userPreferences = UserPreferences.getInstance();
            String string6 = userPreferences.getUserProperties().getProperty("autoSaveLoad");
            if (string6 != null && string6.equals("true")) {
                this.loadUserGraphOpts();
                if (string6 != null && string6.equals("true") && !FcFabricsFile.readOnStartComplete && !FcFabricsFile.openDefault()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainFrame.instance().requestShutdown();
                        }
                    });
                }
                FcFabricsFile.readOnStartComplete = true;
            } else {
                this.loadUserGraphOpts();
            }
        }
    }

    public void loadUserGraphOpts() {
        this.graphOptions.removeAllElements();
        GraphOptionsFile graphOptionsFile = GraphOptionsFile.getInstance();
        boolean bl = graphOptionsFile.getGraphOptionsString("showBytesCheck").equals("true");
        GraphOption graphOption = new GraphOption(101, Color.black, bl);
        this.graphOptions.add(graphOption);
        bl = graphOptionsFile.getGraphOptionsString("showTotalBytesCheck").equals("true");
        int n = graphOptionsFile.getGraphOptionsColor("showTotalBytesColor");
        Color color = new Color(n);
        graphOption = new GraphOption(1, color, bl);
        this.graphOptions.add(graphOption);
        bl = graphOptionsFile.getGraphOptionsString("showTotalTxBytesCheck").equals("true");
        n = graphOptionsFile.getGraphOptionsColor("showTotalTxBytesColor");
        color = new Color(n);
        graphOption = new GraphOption(2, color, bl);
        this.graphOptions.add(graphOption);
        bl = graphOptionsFile.getGraphOptionsString("showTotalRxBytesCheck").equals("true");
        n = graphOptionsFile.getGraphOptionsColor("showTotalRxBytesColor");
        color = new Color(n);
        graphOption = new GraphOption(3, color, bl);
        this.graphOptions.add(graphOption);
        bl = graphOptionsFile.getGraphOptionsString("showFramesCheck").equals("true");
        graphOption = new GraphOption(102, Color.black, bl);
        this.graphOptions.add(graphOption);
        bl = graphOptionsFile.getGraphOptionsString("showTotalFramesCheck").equals("true");
        n = graphOptionsFile.getGraphOptionsColor("showTotalFramesColor");
        color = new Color(n);
        graphOption = new GraphOption(4, color, bl);
        this.graphOptions.add(graphOption);
        bl = graphOptionsFile.getGraphOptionsString("showTotalTxFramesCheck").equals("true");
        n = graphOptionsFile.getGraphOptionsColor("showTotalTxFramesColor");
        color = new Color(n);
        graphOption = new GraphOption(5, color, bl);
        this.graphOptions.add(graphOption);
        bl = graphOptionsFile.getGraphOptionsString("showTotalRxFramesCheck").equals("true");
        n = graphOptionsFile.getGraphOptionsColor("showTotalRxFramesColor");
        color = new Color(n);
        graphOption = new GraphOption(6, color, bl);
        this.graphOptions.add(graphOption);
        bl = graphOptionsFile.getGraphOptionsString("showErrorsCheck").equals("true");
        n = graphOptionsFile.getGraphOptionsColor("showErrorsColor");
        color = new Color(n);
        graphOption = new GraphOption(7, color, bl);
        this.graphOptions.add(graphOption);
        this.graphGridFlag = graphOptionsFile.getGraphOptionsString("showGridCheck").equals("true");
        n = graphOptionsFile.getGraphOptionsColor("showGridColor");
        this.graphGridColor = new Color(n);
        graphOption = new GraphOption(103, this.graphGridColor, this.graphGridFlag);
        this.graphOptions.add(graphOption);
        n = graphOptionsFile.getGraphOptionsColor("gridBackgroundColor");
        this.graphBkgdColor = new Color(n);
        graphOption = new GraphOption(104, this.graphBkgdColor, true);
        this.graphOptions.add(graphOption);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void addLoadedGraphsToDesktop() {
        if (!this.graphList.isEmpty()) {
            GraphInternalFrame graphInternalFrame = null;
            boolean bl = false;
            int n = 10;
            int n2 = 0;
            while (n2 < this.graphList.size()) {
                GraphInternalFrame graphInternalFrame2 = (GraphInternalFrame)this.graphList.get(n2);
                if (!graphInternalFrame2.isVisible()) {
                    graphInternalFrame2.graphStartup();
                    graphInternalFrame2.setVisible(true);
                    graphInternalFrame2.setLocation(graphInternalFrame2.getDefaultLocation());
                    if (graphInternalFrame2.getSavedSelectState()) {
                        graphInternalFrame = graphInternalFrame2;
                    }
                    this.desktopPane.getDesktopManager().endResizingFrame(graphInternalFrame2);
                    this.desktopPane.add(graphInternalFrame2, graphInternalFrame2.getTitle());
                    this.scrollDesktopPane.validate();
                }
                ++n2;
            }
            this.scrollDesktopPane.validate();
        }
    }

    public void setTarget(JSplitPane jSplitPane) {
        if (this.splitPane != null) {
            this.splitPane.remove(this.desktopPane);
        }
        this.splitPane = jSplitPane;
        int n = this.splitPane.getDividerLocation();
        if (n <= 0) {
            n = 175;
        }
        this.splitPane.setRightComponent(this.scrollDesktopPane);
        this.splitPane.setDividerLocation(n);
        if (!this.graphList.isEmpty()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            JInternalFrame jInternalFrame = null;
            boolean bl = false;
            int n2 = 10;
            int n3 = 0;
            while (n3 < this.graphList.size()) {
                GraphInternalFrame graphInternalFrame = (GraphInternalFrame)this.graphList.get(n3);
                graphInternalFrame.graphStartup();
                graphInternalFrame.setVisible(true);
                graphInternalFrame.setLocation(graphInternalFrame.getDefaultLocation());
                if (graphInternalFrame.getSavedSelectState()) {
                    jInternalFrame = graphInternalFrame;
                }
                this.desktopPane.getDesktopManager().endResizingFrame(graphInternalFrame);
                this.desktopPane.add(graphInternalFrame, graphInternalFrame.getTitle());
                this.scrollDesktopPane.validate();
                ++n3;
            }
            if (jInternalFrame != null) {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.scrollDesktopPane.validate();
        }
    }

    public JComponent getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBarLabel(JLabel jLabel) {
        this.statusBarLabel = jLabel;
    }

    public void setStatusBarText(String string) {
        this.statusBarLabel.setText(string);
    }

    public int getPerfMonPollingInterval() {
        return this.perfMonPollingInterval;
    }

    public void setPerfMonPollingInterval(int n) {
        if (FabricList.getInstance().size() == 0) {
            return;
        }
        Fabric fabric = FabricList.getFirstFabric();
        while (fabric != null) {
            Chassis chassis = fabric.getFirstSwitch();
            while (chassis != null) {
                if (chassis instanceof Sanbox2) {
                    chassis.addChassisEventListener((ChassisEventListener)this);
                    ((Sanbox2)chassis).applyPerfMonInterval(n);
                }
                chassis = fabric.getNextSwitch(chassis);
            }
            fabric = FabricList.getNextFabric((Fabric)fabric);
        }
        this.perfMonPollingInterval = n;
    }

    public void setPollingIntervals(float f) {
        if (FabricList.getInstance().size() == 0) {
            return;
        }
        Fabric fabric = FabricList.getFirstFabric();
        while (fabric != null) {
            fabric.setPollingMultiplier(f);
            fabric = FabricList.getNextFabric((Fabric)fabric);
        }
    }

    public void addProgressBar(JLabel jLabel, JLabel jLabel2) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        this.statusBar.add((Component)jPanel, "East");
    }

    public void updateTarget() {
        int n = this.splitPane.getDividerLocation();
        if (n <= 0) {
            n = 175;
        }
        this.splitPane.setRightComponent(this.scrollDesktopPane);
        this.splitPane.setDividerLocation(n);
    }

    public void shutdown() {
    }

    public boolean isShutdownReady() {
        if (!this.loadCmdLine) {
            UserPreferences userPreferences = UserPreferences.getInstance();
            String string = userPreferences.getUserProperties().getProperty("autoSaveLoad");
            if (string != null && string.equals("true")) {
                int n = 0;
                if ((this.fabricList.size() != 0 || this.fabricRemoved) && !FcFabricsFile.saveOnExitComplete) {
                    try {
                        JFrame jFrame = SbmUtilities.getFrame(this.tree);
                        if (jFrame != null) {
                            jFrame.setState(0);
                        }
                        n = FcFabricsFile.saveDefault();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n < 0) {
                    return false;
                }
            }
            FcFabricsFile.saveOnExitComplete = true;
        }
        if (this.fabricList.size() > 0) {
            PerfFabricTreeControl perfFabricTreeControl = this;
            if (perfFabricTreeControl.fabricList.hasSanbox2()) {
                if (this.closeSessionsDialog == null) {
                    this.closeSessionsDialog = new PerfCloseSessionsDialog(MainFrame.instance());
                }
                this.closeSessionsDialog.closeSessions(this.fabricList);
            }
        }
        return true;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        if (sanSurferTreeNode == null) {
            this.rebuildMenuBar(null);
            this.rebuildToolBar(null);
        } else {
            Object object = sanSurferTreeNode.getUserObject();
            switch (sanSurferTreeNode.getNodeType()) {
                case 0: {
                    this.rebuildMenuBar(null);
                    this.rebuildToolBar(null);
                    break;
                }
                case 1: {
                    this.setStatusBarText("");
                    this.rebuildMenuBar(null);
                    this.rebuildToolBar(null);
                    break;
                }
                case 2: 
                case 3: {
                    JOptionPane.showMessageDialog(this.desktopPane, PerfFabricTreeControl.getResource("PerfFabricTreeControl.cantGraphSwitch"));
                    break;
                }
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 99: {
                    this.rebuildMenuBar(null);
                    this.rebuildToolBar(null);
                    if (!(object instanceof Sanbox2) || ((Sanbox2)object).getFirmwareVersion() != 2) break;
                    JOptionPane.showMessageDialog(this.desktopPane, PerfFabricTreeControl.getResource("PerfFabricTreeControl.cantGraphSwitch.oldFirmware"));
                    break;
                }
                case 5: {
                    FCPort fCPort = (FCPort)object;
                    SanboxChassis sanboxChassis = fCPort.getChassis();
                    if (sanboxChassis.getChassisType() != -1) {
                        this.showGraph(fCPort);
                        this.rebuildMenuBar(null);
                        this.rebuildToolBar(null);
                        break;
                    }
                    JOptionPane.showMessageDialog(this.desktopPane, PerfFabricTreeControl.getResource("PerfFabricTreeControl.nonQlogicSwitch"));
                    break;
                }
            }
        }
        this.checkSelected();
    }

    public void componentAdded(ContainerEvent containerEvent) {
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (!(containerEvent.getChild() instanceof GraphInternalFrame)) {
            return;
        }
        GraphInternalFrame graphInternalFrame = (GraphInternalFrame)containerEvent.getChild();
        if (graphInternalFrame.isClosed()) {
            SanSurferTreeNode sanSurferTreeNode;
            GraphInternalFrame graphInternalFrame2;
            Grapher grapher = graphInternalFrame.getGrapher();
            grapher.stopGraphing();
            SanboxChassis sanboxChassis = null;
            FCPort fCPort = null;
            sanboxChassis = (SanboxChassis)graphInternalFrame.getChassis();
            fCPort = graphInternalFrame.getPort();
            int n = 0;
            while (n < this.graphList.size()) {
                try {
                    graphInternalFrame2 = (GraphInternalFrame)this.graphList.get(n);
                    if (graphInternalFrame2.getPort().equals((Object)graphInternalFrame.getPort())) {
                        this.graphList.removeElement(graphInternalFrame2);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.graphList.size()) {
                try {
                    graphInternalFrame2 = (GraphInternalFrame)this.graphList.get(n3);
                    if (sanboxChassis.equals((Object)((SanboxChassis)graphInternalFrame2.getChassis()))) {
                        ++n2;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n3;
            }
            if (n2 == 0) {
                sanboxChassis.stopPerformanceMonitoring();
            }
            if ((sanSurferTreeNode = this.getSelectedNode()) != null) {
                Object object = sanSurferTreeNode.getUserObject();
                if (object != null && sanSurferTreeNode.getNodeType() == 5) {
                    if (fCPort.equals((Object)((FCPort)object))) {
                        this.tree.clearSelection();
                    }
                } else if (n2 == 0 && object != null && object instanceof Chassis && sanboxChassis.equals((Object)((Chassis)object))) {
                    this.tree.clearSelection();
                }
            }
        }
        if (this.graphList.size() == 0) {
            this.rebuildMenuBar(null);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            TreePath treePath = this.tree.getPathForLocation(n, n2);
            SanSurferTreeNode sanSurferTreeNode = (SanSurferTreeNode)treePath.getLastPathComponent();
            JPopupMenu jPopupMenu = new JPopupMenu();
            Object object = sanSurferTreeNode.getUserObject();
            switch (sanSurferTreeNode.getNodeType()) {
                case 0: {
                    break;
                }
                case 1: {
                    jPopupMenu.add(new RemoveFabricAction());
                    break;
                }
                case 5: {
                    jPopupMenu.add(new ChangePortGraphOptionsAction((S16Port)object));
                    break;
                }
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 99: {
                    if (object instanceof Sanbox2 && ((Sanbox2)object).getFirmwareVersion() == 2) {
                        JOptionPane.showMessageDialog(this.desktopPane, PerfFabricTreeControl.getResource("PerfFabricTreeControl.cantGraphSwitch.oldFirmware"));
                        return;
                    }
                    jPopupMenu.add(new OpenAllGraphsAction((SanboxChassis)object));
                    jPopupMenu.add(new OpenLoggedInGraphsAction((SanboxChassis)object));
                    break;
                }
            }
            jPopupMenu.show(this.tree, n, n2);
        }
    }

    private void focusFabric(Fabric fabric) {
        TreePath treePath = this.createFabricTreePath(fabric);
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
    }

    private void focusSwitch(Fabric fabric, Chassis chassis) {
        SanSurferTreeNode sanSurferTreeNode = this.findFabricTreeNode(fabric);
        TreePath treePath = this.createSwitchTreePath(sanSurferTreeNode, chassis);
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
    }

    public static String getPortNodeText(FCPort fCPort) {
        String string = "";
        S16Port s16Port = (S16Port)fCPort;
        int n = s16Port.getPortNumber();
        String string2 = DeviceUtilities.getResource((String)"FCPort.portNode");
        Object[] objectArray = new Object[]{new Integer(n), s16Port.getPortName()};
        string = StringUtilities.formatString(string2, objectArray);
        return string;
    }

    public void showGraph(FCPort fCPort) {
        JInternalFrame jInternalFrame = null;
        Color color = Color.white;
        boolean bl = true;
        SanboxChassis sanboxChassis = fCPort.getChassis();
        String string = FabricList.getFabric((Chassis)sanboxChassis).getFabricName();
        String string2 = string + ": " + sanboxChassis.getChassisName() + " " + PerfFabricTreeControl.getPortNodeText(fCPort);
        Dimension dimension = this.desktopPane.getSize();
        if (this.graphList.isEmpty()) {
            Vector vector = new Vector();
            vector = (Vector)this.graphOptions.clone();
            Point point = new Point();
            jInternalFrame = new GraphInternalFrame(string2, (Chassis)sanboxChassis, fCPort, point, vector, string, true);
            jInternalFrame.setVisible(true);
            this.graphList.add(jInternalFrame);
            this.desktopPane.add(jInternalFrame, string2);
        } else {
            boolean bl2 = false;
            int n = 0;
            while (n < this.graphList.size()) {
                try {
                    jInternalFrame = (GraphInternalFrame)this.graphList.get(n);
                    if (((GraphInternalFrame)jInternalFrame).getPort().equals((Object)fCPort)) {
                        bl2 = true;
                        if (!jInternalFrame.isClosed()) break;
                        jInternalFrame.setVisible(true);
                        this.desktopPane.add(jInternalFrame, string2);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            if (!bl2) {
                Vector vector = new Vector();
                vector = (Vector)this.graphOptions.clone();
                Point point = this.getDefaultGraphLocation();
                jInternalFrame = new GraphInternalFrame(string2, (Chassis)sanboxChassis, fCPort, point, vector, string, true);
                jInternalFrame.setVisible(true);
                this.graphList.add(jInternalFrame);
                this.desktopPane.add(jInternalFrame, string2);
            }
        }
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.desktopPane.validate();
        this.setStatusBarText("");
    }

    public void showAllLoggedInPortGraphs(Chassis chassis) {
        try {
            int n = 1;
            int n2 = chassis.getPortCount();
            if (chassis.isReachable()) {
                if (chassis.getChassisType() == -1) {
                    JOptionPane.showMessageDialog(this.desktopPane, PerfFabricTreeControl.getResource("PerfFabricTreeControl.nonQlogicSwitch"));
                    return;
                }
                FCPort fCPort = chassis.getFirstPort();
                PortStates portStates = fCPort.getPortStates();
                byte by = portStates.getLoggedIn();
                if (by != 0) {
                    this.showGraph(fCPort);
                }
                while (n < n2) {
                    portStates = (fCPort = chassis.getNextPort(fCPort)).getPortStates();
                    by = portStates.getLoggedIn();
                    if (by != 0) {
                        this.showGraph(fCPort);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
        this.setStatusBarText("");
    }

    public void showAllPortGraphs(Chassis chassis) {
        try {
            int n = 1;
            int n2 = chassis.getPortCount();
            if (chassis.isReachable()) {
                if (chassis.getChassisType() == -1) {
                    JOptionPane.showMessageDialog(this.desktopPane, PerfFabricTreeControl.getResource("PerfFabricTreeControl.nonQlogicSwitch"));
                    return;
                }
                FCPort fCPort = chassis.getFirstPort();
                if (fCPort != null) {
                    this.showGraph(fCPort);
                }
                while (n < n2) {
                    if ((fCPort = chassis.getNextPort(fCPort)) != null) {
                        this.showGraph(fCPort);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
        this.setStatusBarText("");
    }

    private boolean checkSB1GraphOptions() {
        boolean bl = false;
        int n = 0;
        while (n < this.graphOptions.size()) {
            GraphOption graphOption = (GraphOption)this.graphOptions.get(n);
            int n2 = graphOption.getGraphItem();
            if (n2 == 1 || n2 == 2 || n2 == 3) {
                JOptionPane.showMessageDialog(this.desktopPane, PerfFabricTreeControl.getResource("PerfFabricTreeControl.cantGraphBytes"));
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private Point getDefaultGraphLocation() {
        Point point = new Point();
        Point point2 = this.getLastAcceptablePoint();
        GraphInternalFrame graphInternalFrame = (GraphInternalFrame)this.graphList.lastElement();
        Point point3 = graphInternalFrame.getDefaultLocation();
        if (point3.getX() + 20.0 > point2.getX() || point3.getY() + 20.0 > point2.getY()) {
            point.setLocation(point2.getX(), point2.getY());
        } else {
            point.setLocation(point3.getX() + 20.0, point3.getY() + 20.0);
        }
        return point;
    }

    private Point getLastAcceptablePoint() {
        int n;
        int n2 = 0;
        int n3 = 0;
        Dimension dimension = this.desktopPane.getSize();
        int n4 = (int)dimension.getHeight();
        if (n4 >= (n = (int)dimension.getWidth()) && n > 300) {
            n2 = n - 301;
            n3 = n - 301;
        } else if (n4 < n && n4 > 200) {
            n2 = n4 - 201;
            n3 = n4 - 201;
        }
        Point point = new Point(n2, n3);
        return point;
    }

    private boolean validateDefaultGraphLocation(Point point) {
        boolean bl = true;
        Point point2 = this.getLastAcceptablePoint();
        if (point.getX() > point2.getX() || point.getY() > point2.getY()) {
            bl = false;
        }
        return bl;
    }

    private SanSurferTreeNode findRootTreeNode() {
        return (SanSurferTreeNode)this.treeModel.getRoot();
    }

    private SanSurferTreeNode findFabricTreeNode(Fabric fabric) {
        Object[] objectArray;
        SanSurferTreeNode sanSurferTreeNode = this.findRootTreeNode();
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            objectArray = (Object[])sanSurferTreeNode.getChildAt(n);
            if (objectArray.getUserObject().equals(fabric)) {
                return objectArray;
            }
            ++n;
        }
        objectArray = new Object[]{fabric.getFabricName()};
        String string = PerfFabricTreeControl.getResource("PerfFabricTreeControl.noSuchFabric");
        throw new IllegalArgumentException(StringUtilities.formatString(string, objectArray));
    }

    private TreePath createFabricTreePath(Fabric fabric) {
        Object[] objectArray = new Object[]{this.findRootTreeNode(), this.findFabricTreeNode(fabric)};
        return new TreePath(objectArray);
    }

    private SanSurferTreeNode findSwitchTreeNode(SanSurferTreeNode sanSurferTreeNode, Chassis chassis) {
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
            if (sanSurferTreeNode2.getUserObject().equals(chassis)) {
                return sanSurferTreeNode2;
            }
            ++n;
        }
        Object[] objectArray = new Object[]{chassis.toString()};
        String string = PerfFabricTreeControl.getResource("PerfFabricTreeControl.noSuchFcSwitch");
        throw new IllegalArgumentException(StringUtilities.formatString(string, objectArray));
    }

    private SanSurferTreeNode findFCPortTreeNode(SanSurferTreeNode sanSurferTreeNode, FCPort fCPort) {
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
            if (sanSurferTreeNode2.getUserObject().equals(fCPort)) {
                return sanSurferTreeNode2;
            }
            ++n;
        }
        Object[] objectArray = new Object[]{fCPort.toString()};
        String string = PerfFabricTreeControl.getResource("PerfFabricTreeControl.noSuchFcPort");
        throw new IllegalArgumentException(StringUtilities.formatString(string, objectArray));
    }

    private TreePath createSwitchTreePath(SanSurferTreeNode sanSurferTreeNode, Chassis chassis) {
        Object[] objectArray = new Object[]{this.findRootTreeNode(), sanSurferTreeNode, this.findSwitchTreeNode(sanSurferTreeNode, chassis)};
        return new TreePath(objectArray);
    }

    public void receiveEvent(FabricListEvent fabricListEvent) {
        FabricList fabricList = fabricListEvent.getFabricList();
        switch (fabricListEvent.getEventType()) {
            case 5001: {
                Fabric fabric = (Fabric)fabricListEvent.getValue();
                fabric.addEventListener((FabricEventListener)this);
                if (fabric.getComAgent() != null) {
                    // empty if block
                }
                SwingUtilities.invokeLater(new AddFabricRunnable(fabricList, fabric));
                break;
            }
            case 5002: {
                Fabric fabric = (Fabric)fabricListEvent.getValue();
                fabric.removeEventListener((FabricEventListener)this);
                if (fabric.getComAgent() != null) {
                    // empty if block
                }
                SwingUtilities.invokeLater(new RemoveFabricRunnable(fabricList, fabric));
                break;
            }
        }
        FcFabricsFile.fabricsHaveChanged = true;
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        Fabric fabric = fabricEvent.getFabric();
        switch (fabricEvent.getEventType()) {
            case 2002: {
                Chassis chassis = (Chassis)fabricEvent.getValue();
                SwingUtilities.invokeLater(new AddSwitchRunnable(fabric, chassis));
                break;
            }
            case 2003: {
                Chassis chassis = (Chassis)fabricEvent.getValue();
                SwingUtilities.invokeLater(new RemoveSwitchRunnable(fabric, chassis));
                break;
            }
            case 2001: 
            case 2004: 
            case 2005: 
            case 2006: {
                this.tree.repaint();
                break;
            }
            case 2009: {
                break;
            }
            case 2015: 
            case 2016: 
            case 2017: {
                if (this.newFabricDialog != null) {
                    if (this.newFabricDialog.isVisible()) break;
                    this.handleEntrySwitchError(fabricEvent, fabric);
                    break;
                }
                this.handleEntrySwitchError(fabricEvent, fabric);
                break;
            }
        }
    }

    private void handleEntrySwitchError(FabricEvent fabricEvent, Fabric fabric) {
        if (fabricEvent.getEventType() == 2016) {
            String string = PerfFabricTreeControl.getResource("NewFabricDialog.tooManySessions");
            String string2 = PerfFabricTreeControl.getResource("PerfFabricTreeControl.tooManySessionsMsg");
            this.handleError(fabricEvent, fabric, string2, string);
        } else if (fabricEvent.getEventType() == 2015) {
            String string = PerfFabricTreeControl.getResource("NewFabricDialog.unsupportedSwitchType");
            String string3 = PerfFabricTreeControl.getResource("PerfFabricTreeControl.unsupportedSwitchTypeMsg");
            this.handleError(fabricEvent, fabric, string3, string);
        } else if (fabricEvent.getEventType() == 2017) {
            String string = PerfFabricTreeControl.getResource("NewFabricDialog.loginFailure");
            String string4 = PerfFabricTreeControl.getResource("PerfFabricTreeControl.loginFailureMsg") + fabric.getName() + PerfFabricTreeControl.getResource("PerfFabricTreeControl.loginFailureMsg2");
            this.handleError(fabricEvent, fabric, string4, string);
        }
    }

    private void handleError(FabricEvent fabricEvent, Fabric fabric, String string, String string2) {
        int n;
        String string3 = fabric.getIpAddr().getHostAddress();
        string2 = string2 + " - " + VendorProperties.getFrameTitle();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (MainFrame.instance().isVisible() && (n = JOptionPane.showConfirmDialog(MainFrame.instance(), string, string2, 0)) != 1 && n == 0 && fabricEvent.getEventType() == 2017) {
            this.removeFabric(fabric);
            this.checkSelected();
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        switch (chassisEvent.getEventType()) {
            case 203: 
            case 208: 
            case 213: 
            case 253: 
            case 306: 
            case 356: {
                ChassisEventRunnable chassisEventRunnable = new ChassisEventRunnable();
                chassisEventRunnable.setEvent(chassisEvent);
                SwingUtilities.invokeLater(chassisEventRunnable);
                break;
            }
            case 329: {
                break;
            }
            case 328: {
                if (chassisEvent.isSuccessful()) break;
                String string = PerfFabricTreeControl.getResource("PollingFreq.failed") + " " + ((SanboxChassis)chassisEvent.getSource()).getChassisName() + "." + "\n" + this.getFailedString(chassisEvent.getErrorType());
                PopupDialog.showDialog(MainFrame.instance(), 3, string);
            }
        }
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + PerfFabricTreeControl.translateErrorType(errorType) + "]";
    }

    public static String translateErrorType(ErrorType errorType) {
        if (errorType == null) {
            return PerfFabricTreeControl.getResource("ErrorType.none");
        }
        if (errorType instanceof UtilError) {
            switch (errorType.getError()) {
                case 100: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.MS_RAW");
                }
                case 101: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.MS_READY_TO_SEND");
                }
                case 102: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.MS_SENT_READ_TO_RECIEVE");
                }
                case 103: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.MS_RECEIVED_OK");
                }
                case 104: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.MS_RECEIVED_ERROR_CODE");
                }
                case 105: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.MS_RECEIVED_BAD_DATA");
                }
                case 106: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.MS_RECEIVED_WRONG_SEQUENCE_NUMBER");
                }
                case 107: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.MS_TIMED_OUT");
                }
                case 108: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.MS_UNABLE_TO_SEND");
                }
                case 0: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_NO_ERRORS");
                }
                case 1: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_UNKNOWN_MESSAGE_ERROR");
                }
                case 2: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_BAD_DATA_ERROR");
                }
                case 3: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_FLASH_LOAD_FAIL");
                }
                case 4: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_MKII_INTERNAL_ERROR");
                }
                case 5: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_LOGIN_BUSY");
                }
                case 6: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_REJECTED_NOT_ONLINE");
                }
                case 7: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_REJECTED_PORT_INCORRECT_STATE");
                }
                case 8: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_REJECTED_ANOTHER_TEST_ACTIVE");
                }
                case 9: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_CPU_NOT_ABLE_TO_PERFORM");
                }
                case 10: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_SAVED_DATA_INVALID");
                }
                case 11: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_ZONING_DATA_INVALID");
                }
                case 12: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_UNABLE_TO_ROUTE");
                }
                case 14: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_LOGIN_REQUIRED");
                }
                case 13: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_VERSION_NOT_SUPPORTED");
                }
                case 15: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_NO_ENTRY_SWITCH_SESSION");
                }
                case 16: {
                    return PerfFabricTreeControl.getResource("UtilErrorType.EC_NON_QLOGIC_QWITCH");
                }
            }
            return PerfFabricTreeControl.getResource("UtilErrorType.unknown") + errorType.getError();
        }
        if (errorType instanceof GuiError) {
            GuiError guiError = (GuiError)errorType;
            switch (errorType.getError()) {
                case 104: {
                    return PerfFabricTreeControl.getResource("GuiErrorType.receivedAlarm") + " " + guiError.getDesc() + "\"";
                }
                case 102: {
                    return PerfFabricTreeControl.getResource("GuiErrorType.timedOutPollingActiveZoneSet");
                }
                case 100: {
                    return PerfFabricTreeControl.getResource("GuiErrorType.userCanceled");
                }
                case 101: {
                    return PerfFabricTreeControl.getResource("GuiErrorType.outOfMemory");
                }
                case 106: {
                    return PerfFabricTreeControl.getResource("GuiErrorType.errorInFile");
                }
                case 105: {
                    return PerfFabricTreeControl.getResource("GuiErrorType.noEventReceived");
                }
            }
            return PerfFabricTreeControl.getResource("GuiErrorType.unknown") + Integer.toString(errorType.getError());
        }
        if (errorType instanceof SmlError) {
            switch (errorType.getError()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: {
                    String string = Integer.toString(errorType.getError(), 16);
                    return PerfFabricTreeControl.getResource("SmlErrorType.0x" + string);
                }
            }
            String string = Integer.toString(errorType.getError(), 16);
            return PerfFabricTreeControl.getResource("SmlErrorType.unknown") + string;
        }
        return PerfFabricTreeControl.getResource("ErrorType.unknown") + " " + errorType.getError();
    }

    private void rebuildMenuAndToolbars() {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        if (sanSurferTreeNode != null) {
            Object object = sanSurferTreeNode.getUserObject();
            switch (sanSurferTreeNode.getNodeType()) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
            }
        }
    }

    static {
        resources = ResourceBundle.getBundle("PerfTree");
    }

    class InternalFrameManager
    extends DefaultDesktopManager {
        InternalFrameManager() {
        }

        public void endResizingFrame(JComponent jComponent) {
            GraphInternalFrame graphInternalFrame = (GraphInternalFrame)jComponent;
            Grapher grapher = graphInternalFrame.getGrapher();
            grapher.frameResize();
        }

        public void closeFrame(JInternalFrame jInternalFrame) {
            SanSurferTreeNode sanSurferTreeNode;
            GraphInternalFrame graphInternalFrame;
            super.closeFrame(jInternalFrame);
            GraphInternalFrame graphInternalFrame2 = (GraphInternalFrame)jInternalFrame;
            Grapher grapher = graphInternalFrame2.getGrapher();
            grapher.stopGraphing();
            SanboxChassis sanboxChassis = null;
            FCPort fCPort = null;
            sanboxChassis = (SanboxChassis)graphInternalFrame2.getChassis();
            fCPort = graphInternalFrame2.getPort();
            int n = 0;
            while (n < PerfFabricTreeControl.this.graphList.size()) {
                try {
                    graphInternalFrame = (GraphInternalFrame)PerfFabricTreeControl.this.graphList.get(n);
                    if (graphInternalFrame.getPort().equals((Object)graphInternalFrame2.getPort())) {
                        PerfFabricTreeControl.this.graphList.removeElement(graphInternalFrame);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < PerfFabricTreeControl.this.graphList.size()) {
                try {
                    graphInternalFrame = (GraphInternalFrame)PerfFabricTreeControl.this.graphList.get(n3);
                    if (sanboxChassis.equals((Object)((SanboxChassis)graphInternalFrame.getChassis()))) {
                        ++n2;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n3;
            }
            if (n2 == 0) {
                sanboxChassis.stopPerformanceMonitoring();
            }
            if ((sanSurferTreeNode = PerfFabricTreeControl.this.getSelectedNode()) != null) {
                Object object = sanSurferTreeNode.getUserObject();
                if (object != null && sanSurferTreeNode.getNodeType() == 5) {
                    if (fCPort.equals((Object)((FCPort)object))) {
                        PerfFabricTreeControl.this.tree.clearSelection();
                    }
                } else if (n2 == 0 && object != null && object instanceof Chassis && sanboxChassis.equals((Object)((Chassis)object))) {
                    PerfFabricTreeControl.this.tree.clearSelection();
                }
            }
        }
    }

    class ChassisEventRunnable
    implements Runnable {
        ChassisEvent event;

        ChassisEventRunnable() {
        }

        public void setEvent(ChassisEvent chassisEvent) {
            this.event = chassisEvent;
        }

        public void run() {
            Chassis chassis;
            Fabric fabric;
            if (this.event.getEventType() == 306) {
                PerfFabricTreeControl.this.rebuildMenuAndToolbars();
            }
            if ((fabric = FabricList.getFabric((Chassis)(chassis = this.event.getChassis()))) != null) {
                SanSurferTreeNode sanSurferTreeNode = PerfFabricTreeControl.this.findFabricTreeNode(fabric);
                SanSurferTreeNode sanSurferTreeNode2 = PerfFabricTreeControl.this.findSwitchTreeNode(sanSurferTreeNode, chassis);
                ((DefaultTreeModel)PerfFabricTreeControl.this.tree.getModel()).nodeChanged(sanSurferTreeNode2);
                if (this.event.getEventType() == 356) {
                    FCPort fCPort = chassis.getFirstPort();
                    SanSurferTreeNode sanSurferTreeNode3 = PerfFabricTreeControl.this.findFCPortTreeNode(sanSurferTreeNode2, fCPort);
                    ((DefaultTreeModel)PerfFabricTreeControl.this.tree.getModel()).nodeChanged(sanSurferTreeNode3);
                    fCPort = chassis.getNextPort(fCPort);
                    while (fCPort != null) {
                        sanSurferTreeNode3 = PerfFabricTreeControl.this.findFCPortTreeNode(sanSurferTreeNode2, fCPort);
                        ((DefaultTreeModel)PerfFabricTreeControl.this.tree.getModel()).nodeChanged(sanSurferTreeNode3);
                        fCPort = chassis.getNextPort(fCPort);
                    }
                }
                this.doFWChecks(chassis, sanSurferTreeNode2);
            }
            PerfFabricTreeControl.this.tree.repaint();
        }

        public void doFWChecks(Chassis chassis, SanSurferTreeNode sanSurferTreeNode) {
            boolean bl = false;
            if (chassis instanceof Sanbox2 && ((Sanbox2)chassis).getFirmwareVersion() == 2) {
                bl = true;
            }
            switch (sanSurferTreeNode.getNodeType()) {
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 99: {
                    if (sanSurferTreeNode.hasChildren() && bl) {
                        int n = chassis.getPortCount();
                        while (n > 0) {
                            SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)PerfFabricTreeControl.this.treeModel.getChild(sanSurferTreeNode, n - 1);
                            if (sanSurferTreeNode2 != null) {
                                PerfFabricTreeControl.this.treeModel.removeNodeFromParent(sanSurferTreeNode2);
                            }
                            --n;
                        }
                        break;
                    }
                    if (sanSurferTreeNode.hasChildren() || bl) break;
                    this.addPortNodes(chassis, sanSurferTreeNode);
                    break;
                }
            }
        }

        public void addPortNodes(Chassis chassis, SanSurferTreeNode sanSurferTreeNode) {
            FCPort fCPort = chassis.getFirstPort();
            int n = 5;
            int n2 = 0;
            while (n2 < chassis.getPortCount()) {
                if (fCPort != null) {
                    SanSurferTreeNode sanSurferTreeNode2 = new SanSurferTreeNode((Object)fCPort, n);
                    PerfFabricTreeControl.this.treeModel.insertNodeInto(sanSurferTreeNode2, sanSurferTreeNode, n2);
                    fCPort = chassis.getNextPort(fCPort);
                }
                ++n2;
            }
        }
    }

    class RemoveSwitchRunnable
    implements Runnable {
        Fabric fabric;
        Chassis fcSwitch;

        public RemoveSwitchRunnable(Fabric fabric, Chassis chassis) {
            this.fabric = fabric;
            this.fcSwitch = chassis;
        }

        public void run() {
            SanSurferTreeNode sanSurferTreeNode = PerfFabricTreeControl.this.findFabricTreeNode(this.fabric);
            SanSurferTreeNode sanSurferTreeNode2 = PerfFabricTreeControl.this.findSwitchTreeNode(sanSurferTreeNode, this.fcSwitch);
            PerfFabricTreeControl.this.treeModel.removeNodeFromParent(sanSurferTreeNode2);
            FcFabricsFile.fabricsHaveChanged = true;
        }
    }

    class AddSwitchRunnable
    implements Runnable {
        Fabric fabric;
        Chassis fcSwitch;

        public AddSwitchRunnable(Fabric fabric, Chassis chassis) {
            this.fabric = fabric;
            this.fcSwitch = chassis;
        }

        public void run() {
            Object object;
            SanSurferTreeNode sanSurferTreeNode = PerfFabricTreeControl.this.findFabricTreeNode(this.fabric);
            int n = -1;
            if (this.fcSwitch instanceof SanboxChassis) {
                object = (SanboxChassis)this.fcSwitch;
                switch (object.getChassisType()) {
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 0: {
                        n = 3;
                        break;
                    }
                    case 16: {
                        n = 4;
                        break;
                    }
                    case 8: {
                        n = 13;
                        break;
                    }
                    case 30: {
                        n = 15;
                        break;
                    }
                    case 26: {
                        n = 16;
                        break;
                    }
                    case 33: {
                        n = 17;
                        break;
                    }
                }
            } else {
                n = this.fcSwitch instanceof Director ? 14 : 99;
            }
            object = new SanSurferTreeNode((Object)this.fcSwitch, n);
            PerfFabricTreeControl.this.treeModel.insertNodeInto((MutableTreeNode)object, sanSurferTreeNode, sanSurferTreeNode.getChildCount());
            boolean bl = false;
            if (this.fcSwitch instanceof Sanbox2 && ((Sanbox2)this.fcSwitch).getFirmwareVersion() == 2) {
                bl = true;
            }
            if (n != 2 && n != 3 && !bl) {
                FCPort fCPort = this.fcSwitch.getFirstPort();
                n = 5;
                int n2 = 0;
                while (n2 < this.fcSwitch.getPortCount()) {
                    if (fCPort != null) {
                        SanSurferTreeNode sanSurferTreeNode2 = new SanSurferTreeNode((Object)fCPort, n);
                        PerfFabricTreeControl.this.treeModel.insertNodeInto(sanSurferTreeNode2, (MutableTreeNode)object, n2);
                        fCPort = this.fcSwitch.getNextPort(fCPort);
                    }
                    ++n2;
                }
            }
            this.fcSwitch.getEventHandler().addChassisEventListener((ChassisEventListener)PerfFabricTreeControl.this);
            FcFabricsFile.fabricsHaveChanged = true;
        }
    }

    class RemoveFabricRunnable
    implements Runnable {
        FabricList fabricList;
        Fabric fabric;

        public RemoveFabricRunnable(FabricList fabricList, Fabric fabric) {
            this.fabricList = fabricList;
            this.fabric = fabric;
        }

        public void run() {
            SanSurferTreeNode sanSurferTreeNode = PerfFabricTreeControl.this.findFabricTreeNode(this.fabric);
            if (sanSurferTreeNode != null) {
                PerfFabricTreeControl.this.treeModel.removeNodeFromParent(sanSurferTreeNode);
                PerfFabricTreeControl.this.tree.setSelectionRow(0);
            }
        }
    }

    class AddFabricRunnable
    implements Runnable {
        FabricList fabricList;
        Fabric fabric;

        public AddFabricRunnable(FabricList fabricList, Fabric fabric) {
            this.fabricList = fabricList;
            this.fabric = fabric;
        }

        public void run() {
            SanSurferTreeNode sanSurferTreeNode = PerfFabricTreeControl.this.findRootTreeNode();
            SanSurferTreeNode sanSurferTreeNode2 = new SanSurferTreeNode((Object)this.fabric, 1);
            PerfFabricTreeControl.this.treeModel.insertNodeInto(sanSurferTreeNode2, sanSurferTreeNode, sanSurferTreeNode.getChildCount());
            PerfFabricTreeControl.this.focusFabric(this.fabric);
        }
    }

    class SwitchActivationListener
    implements ActionListener {
        SwitchActivationListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof Chassis) {
                // empty if block
            }
        }
    }

    class OpenAllGraphsAction
    extends AbstractAction {
        private SanboxChassis fcSwitch = null;

        public OpenAllGraphsAction(SanboxChassis sanboxChassis) {
            super(PerfFabricTreeControl.getResource("PerfFabricTreeControl.openAllPortGraphs") + sanboxChassis.getChassisName());
            this.fcSwitch = sanboxChassis;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.showAllPortGraphs((Chassis)this.fcSwitch);
        }
    }

    class OpenLoggedInGraphsAction
    extends AbstractAction {
        private SanboxChassis fcSwitch = null;

        public OpenLoggedInGraphsAction(SanboxChassis sanboxChassis) {
            super(PerfFabricTreeControl.getResource("PerfFabricTreeControl.openLoggedInPortGraphs") + sanboxChassis.getChassisName());
            this.fcSwitch = sanboxChassis;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.showAllLoggedInPortGraphs((Chassis)this.fcSwitch);
        }
    }

    class ChangePortGraphOptionsAction
    extends AbstractAction {
        private S16Port sPort = null;

        public ChangePortGraphOptionsAction(S16Port s16Port) {
            super(PerfFabricTreeControl.getResource("PerfFabricTreeControl.changePortGraphOptions") + PerfFabricTreeControl.getPortNodeText((FCPort)s16Port));
            this.sPort = s16Port;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            super(PerfFabricTreeControl.getResource("menu.help.helpTopics"));
        }

        public HelpAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public HelpAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.showHelp();
        }
    }

    class HelpAboutAction
    extends AbstractAction {
        public HelpAboutAction() {
            super(PerfFabricTreeControl.getResource("menu.help.about"));
        }

        public HelpAboutAction(String string) {
            Image image = SbmUtilities.getImage(string);
            ImageIcon imageIcon = new ImageIcon(image);
            this.putValue("SmallIcon", imageIcon);
        }

        public HelpAboutAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.showHelpAbout();
        }
    }

    class DebugAction
    extends AbstractAction {
        public DebugAction() {
            super("Debug");
        }

        public DebugAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public DebugAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.debugMethod();
        }
    }

    class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super(PerfFabricTreeControl.getResource("menu.view.refresh"));
        }

        public RefreshAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public RefreshAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.refresh();
        }
    }

    class RediscoverTopologyAction
    extends AbstractAction {
        public RediscoverTopologyAction() {
            super(PerfFabricTreeControl.getResource("menu.fabric.rediscoverTopo"));
        }

        public RediscoverTopologyAction(String string) {
            Image image = SbmUtilities.getImage(string);
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public RediscoverTopologyAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.rediscover();
        }
    }

    class CascadeDesktopAction
    extends AbstractAction {
        public CascadeDesktopAction() {
            super(PerfFabricTreeControl.getResource("menu.graph.cascadeGraphs"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.cascadeGraphs();
        }
    }

    class TileHorizontallyDesktopAction
    extends AbstractAction {
        public TileHorizontallyDesktopAction() {
            super(PerfFabricTreeControl.getResource("menu.graph.tileHorzGraphs"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.tileHorizontal();
        }
    }

    class TileVerticallyDesktopAction
    extends AbstractAction {
        public TileVerticallyDesktopAction() {
            super(PerfFabricTreeControl.getResource("menu.graph.tileVertGraphs"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.tileVertical();
        }
    }

    class SetPollingAction
    extends AbstractAction {
        public SetPollingAction() {
            super(PerfFabricTreeControl.getResource("menu.graph.polling"));
        }

        public SetPollingAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PerfFabricTreeControl.this.pollingFreqDialog == null) {
                PerfFabricTreeControl.this.pollingFreqDialog = new PollingFreqDialog(MainFrame.instance());
                PerfFabricTreeControl.this.pollingFreqDialog.setModal(true);
            }
            PerfFabricTreeControl.this.pollingFreqDialog.setVisible(true);
        }
    }

    class GraphOptionsAction
    extends AbstractAction {
        public GraphOptionsAction() {
            super(PerfFabricTreeControl.getResource("menu.graph.options"));
        }

        public GraphOptionsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.graphOptions(null);
        }
    }

    class CloseAllGraphsAction
    extends AbstractAction {
        public CloseAllGraphsAction() {
            super(PerfFabricTreeControl.getResource("menu.view.closeAll"));
        }

        public CloseAllGraphsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PerfFabricTreeControl.this.graphList.size();
            while (n > 0) {
                GraphInternalFrame graphInternalFrame = (GraphInternalFrame)PerfFabricTreeControl.this.graphList.get(n - 1);
                if (graphInternalFrame != null) {
                    graphInternalFrame.dispose();
                }
                --n;
            }
        }
    }

    class RemoveFabricAction
    extends AbstractAction {
        public RemoveFabricAction() {
            super(PerfFabricTreeControl.getResource("menu.fabric.remove"));
        }

        public RemoveFabricAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public RemoveFabricAction(String string, Image image) {
            super(string);
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.removeFabric(null);
        }
    }

    class AddFabricAction
    extends AbstractAction {
        public AddFabricAction() {
            super(PerfFabricTreeControl.getResource("menu.fabric.add"));
        }

        public AddFabricAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public AddFabricAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.addFabric();
        }
    }

    class SaveAllGraphStatisticsAction
    extends AbstractAction {
        public SaveAllGraphStatisticsAction() {
            super(PerfFabricTreeControl.getResource("menu.file.saveAllGraphStats"));
        }

        public SaveAllGraphStatisticsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PerfFabricTreeControl.this.saveStatistics(null);
        }
    }

    class SaveGraphStatisticsAction
    extends AbstractAction {
        public SaveGraphStatisticsAction() {
            super(PerfFabricTreeControl.getResource("menu.file.saveGraphStats"));
        }

        public SaveGraphStatisticsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphInternalFrame graphInternalFrame = (GraphInternalFrame)PerfFabricTreeControl.this.desktopPane.getSelectedFrame();
            PerfFabricTreeControl.this.saveStatistics(graphInternalFrame);
        }
    }

    class PrintGraphWindowAction
    extends AbstractAction {
        public PrintGraphWindowAction() {
            super(PerfFabricTreeControl.getResource("menu.file.printGraphWindow"));
        }

        public PrintGraphWindowAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphInternalFrame graphInternalFrame = (GraphInternalFrame)PerfFabricTreeControl.this.desktopPane.getSelectedFrame();
            if (graphInternalFrame != null) {
                graphInternalFrame.printGraphWindow();
            }
        }
    }

    class SaveFabricsAsAction
    extends AbstractAction {
        public SaveFabricsAsAction() {
            super(PerfFabricTreeControl.getResource("menu.file.saveViewAs"));
        }

        public SaveFabricsAsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FcFabricsFile.saveFabricsAs();
        }
    }

    class OpenFabricsAction
    extends AbstractAction {
        public OpenFabricsAction() {
            super(PerfFabricTreeControl.getResource("menu.file.openView"));
        }

        public OpenFabricsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FcFabricsFile.openFabrics();
            PerfFabricTreeControl.this.addLoadedGraphsToDesktop();
        }
    }

    class UserPreferencesAction
    extends AbstractAction {
        public UserPreferencesAction() {
            super(PerfFabricTreeControl.getResource("menu.file.preferences"));
        }

        public UserPreferencesAction(String string) {
            Image image = SbmUtilities.getImage(string);
            ImageIcon imageIcon = new ImageIcon(image);
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UserPreferencesDialog userPreferencesDialog = new UserPreferencesDialog(MainFrame.instance(), true);
            userPreferencesDialog.setVisible(true);
        }
    }

    class ChangePasswordAction
    extends AbstractAction {
        public ChangePasswordAction() {
            super(PerfFabricTreeControl.getResource("menu.file.password"));
        }

        public ChangePasswordAction(String string) {
            Image image = SbmUtilities.getImage(string);
            ImageIcon imageIcon = new ImageIcon(image);
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChangePasswordDialog changePasswordDialog = new ChangePasswordDialog(MainFrame.instance());
            changePasswordDialog.setVisible(true);
        }
    }

    class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(PerfFabricTreeControl.getResource("menu.file.exit"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.instance().requestShutdown();
        }
    }
}

