/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.perfmon.GraphOption;
import com.qlogic.perfmon.GraphUpdater;
import com.qlogic.perfmon.PerfFabricTreeControl;
import com.qlogic.perfmon.VendorProperties;
import com.qlogic.ui.QDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SingleGraphOptionsDialog
extends QDialog
implements FabricEventListener {
    JPanel dataPanel = new JPanel();
    GridBagLayout dataLayout = new GridBagLayout();
    JLabel selectDataLabel = new JLabel(PerfFabricTreeControl.getResource("GraphOptionsDialog.selectData"));
    JLabel bytesWarningLabel = new JLabel(PerfFabricTreeControl.getResource("GraphOptionsDialog.bytesWarning"));
    private boolean selectBytesCheck = true;
    private boolean bytesCheck = true;
    private boolean displayGridCheck = true;
    private boolean selectFramesCheck;
    private boolean framesCheck;
    private boolean errorsCheck;
    private boolean rxBytesCheck;
    private boolean txBytesCheck;
    private boolean rxFramesCheck;
    private boolean txFramesCheck;
    private boolean retroChangesCheck = false;
    private Color totalBytesColor = Color.yellow;
    private Color totalFramesColor = Color.blue;
    private Color totalErrorsColor = Color.red;
    private Color totalRxBytesColor = Color.green;
    private Color totalTxBytesColor = Color.magenta;
    private Color totalRxFramesColor = Color.white;
    private Color totalTxFramesColor = Color.pink;
    private Color gridColor = Color.gray;
    private Color backgroundColor = Color.black;
    private Color tmpbackgroundColor = Color.black;
    private JCheckBox selectBytesCheckBox = new JCheckBox(new SelectBytesBoxAction());
    private JCheckBox selectFramesCheckBox = new JCheckBox(new SelectFramesBoxAction());
    private JCheckBox totalBytesCheckBox = new JCheckBox(PerfFabricTreeControl.getResource("GraphOptionsDialog.totalBytes"), false);
    private JCheckBox totalFramesCheckBox = new JCheckBox(PerfFabricTreeControl.getResource("GraphOptionsDialog.totalFrames"), false);
    private JCheckBox totalErrorsCheckBox = new JCheckBox(PerfFabricTreeControl.getResource("GraphOptionsDialog.totalErrors"), false);
    private JCheckBox totalRxBytesCheckBox = new JCheckBox(PerfFabricTreeControl.getResource("GraphOptionsDialog.totalRxBytes"), false);
    private JCheckBox totalTxBytesCheckBox = new JCheckBox(PerfFabricTreeControl.getResource("GraphOptionsDialog.totalTxBytes"), false);
    private JCheckBox totalRxFramesCheckBox = new JCheckBox(PerfFabricTreeControl.getResource("GraphOptionsDialog.totalRxFrames"), false);
    private JCheckBox totalTxFramesCheckBox = new JCheckBox(PerfFabricTreeControl.getResource("GraphOptionsDialog.totalTxFrames"), false);
    private JCheckBox displayGridCheckBox = new JCheckBox(new DisplayGridAction());
    private JButton totalBytesButton = new JButton(new ChangeTotalBytesAction());
    private JButton totalFramesButton = new JButton(new ChangeTotalFramesAction());
    private JButton totalErrorsButton = new JButton(new ChangeTotalErrorsAction());
    private JButton totalRxBytesButton = new JButton(new ChangeTotalRxBytesAction());
    private JButton totalTxBytesButton = new JButton(new ChangeTotalTxBytesAction());
    private JButton totalRxFramesButton = new JButton(new ChangeTotalRxFramesAction());
    private JButton totalTxFramesButton = new JButton(new ChangeTotalTxFramesAction());
    private JButton graphGridButton = new JButton(new ChangeGridAction());
    private JButton graphBkgdButton = new JButton(new ChangeBackgroundAction());
    private Vector graphOptions = new Vector();
    JPanel selectPanel = new JPanel();
    JPanel bytesPanel = new JPanel();
    JPanel framesPanel = new JPanel();
    JPanel errorsPanel = new JPanel();
    JPanel gridPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    GridLayout buttonLayout = new GridLayout(1, 2, 8, 0);
    JButton okButton = new JButton(new OkAction());
    JButton cancelButton = new JButton(new CancelAction());
    GridBagLayout graphOptionsLayout = new GridBagLayout();
    protected GraphUpdater gOptionsUpdater;
    private Fabric fabric;
    private boolean fieldsEnabled = true;

    public SingleGraphOptionsDialog(Frame frame, GraphUpdater graphUpdater) {
        super(frame);
        try {
            this.jbInit();
            this.setGraphUpdater(graphUpdater);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String string = " - " + VendorProperties.getFrameTitle();
        this.setTitle(string);
        this.getContentPane().setLayout(this.graphOptionsLayout);
        this.selectDataLabel.setFont(PerfFabricTreeControl.titleFont);
        this.bytesWarningLabel.setEnabled(false);
        this.dataPanel.setLayout(this.dataLayout);
        this.dataPanel.add((Component)this.selectDataLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 8, 8), 0, 0));
        this.dataPanel.add((Component)this.selectBytesCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.totalBytesCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.totalTxBytesCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.totalRxBytesCheckBox, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.selectFramesCheckBox, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.totalFramesCheckBox, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.totalTxFramesCheckBox, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.totalRxFramesCheckBox, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.totalErrorsCheckBox, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.displayGridCheckBox, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.graphBkgdButton, new GridBagConstraints(0, 12, 2, 1, 1.0, 0.0, 17, 1, new Insets(16, 8, 4, 8), 0, 0));
        this.dataPanel.add((Component)this.totalBytesButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 4, 8), 0, 0));
        this.dataPanel.add((Component)this.totalTxBytesButton, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 4, 8), 0, 0));
        this.dataPanel.add((Component)this.totalRxBytesButton, new GridBagConstraints(1, 5, 1, 1, 1.4, 0.0, 13, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.totalFramesButton, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 4, 8), 0, 0));
        this.dataPanel.add((Component)this.totalTxFramesButton, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 4, 8), 0, 0));
        this.dataPanel.add((Component)this.totalRxFramesButton, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 4, 8), 0, 0));
        this.dataPanel.add((Component)this.totalErrorsButton, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 4, 8), 0, 0));
        this.dataPanel.add((Component)this.graphGridButton, new GridBagConstraints(1, 11, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 4, 8), 0, 0));
        this.getContentPane().add((Component)this.dataPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getRootPane().setDefaultButton(this.okButton);
        Dimension dimension = this.totalBytesButton.getSize();
        this.totalFramesButton.setSize(dimension);
        this.pack();
        dimension = this.totalBytesButton.getSize();
        this.totalFramesButton.setSize(dimension);
        this.validate();
    }

    private void setButtonBackgroundColor() {
        this.totalBytesButton.setBackground(this.backgroundColor);
        this.totalFramesButton.setBackground(this.backgroundColor);
        this.totalErrorsButton.setBackground(this.backgroundColor);
        this.totalRxBytesButton.setBackground(this.backgroundColor);
        this.totalTxBytesButton.setBackground(this.backgroundColor);
        this.totalRxFramesButton.setBackground(this.backgroundColor);
        this.totalTxFramesButton.setBackground(this.backgroundColor);
        this.graphGridButton.setBackground(this.backgroundColor);
    }

    private void setButtonForegroundColor() {
        this.totalBytesButton.setForeground(this.totalBytesColor);
        this.totalFramesButton.setForeground(this.totalFramesColor);
        this.totalErrorsButton.setForeground(this.totalErrorsColor);
        this.totalRxBytesButton.setForeground(this.totalRxBytesColor);
        this.totalTxBytesButton.setForeground(this.totalTxBytesColor);
        this.totalRxFramesButton.setForeground(this.totalRxFramesColor);
        this.totalTxFramesButton.setForeground(this.totalTxFramesColor);
        this.graphGridButton.setForeground(this.gridColor);
    }

    private void setButtonColors(boolean bl) {
        if (bl) {
            this.setTotalBytesColor(this.totalBytesButton.getForeground());
            this.setTotalFramesColor(this.totalFramesButton.getForeground());
            this.setTotalErrorsColor(this.totalErrorsButton.getForeground());
            this.setTotalRxBytesColor(this.totalRxBytesButton.getForeground());
            this.setTotalTxBytesColor(this.totalTxBytesButton.getForeground());
            this.setTotalRxFramesColor(this.totalRxFramesButton.getForeground());
            this.setTotalTxFramesColor(this.totalTxFramesButton.getForeground());
            this.setGridColor(this.graphGridButton.getForeground());
            this.setBackgroundColor(this.tmpbackgroundColor);
        } else {
            this.setButtonBackgroundColor();
            this.setButtonForegroundColor();
        }
    }

    private void setCheckBoxes(boolean bl) {
        if (bl) {
            this.selectBytesCheck = this.selectBytesCheckBox.isSelected();
            this.bytesCheck = this.totalBytesCheckBox.isSelected();
            this.txBytesCheck = this.totalTxBytesCheckBox.isSelected();
            this.rxBytesCheck = this.totalRxBytesCheckBox.isSelected();
            this.selectFramesCheck = this.selectFramesCheckBox.isSelected();
            this.framesCheck = this.totalFramesCheckBox.isSelected();
            this.txFramesCheck = this.totalTxFramesCheckBox.isSelected();
            this.rxFramesCheck = this.totalRxFramesCheckBox.isSelected();
            this.errorsCheck = this.totalErrorsCheckBox.isSelected();
            this.displayGridCheck = this.displayGridCheckBox.isSelected();
        } else {
            this.selectBytesCheckBox.setSelected(this.selectBytesCheck);
            this.totalBytesCheckBox.setSelected(this.bytesCheck);
            this.totalTxBytesCheckBox.setSelected(this.txBytesCheck);
            this.totalRxBytesCheckBox.setSelected(this.rxBytesCheck);
            this.selectFramesCheckBox.setSelected(this.selectFramesCheck);
            this.totalFramesCheckBox.setSelected(this.framesCheck);
            this.totalTxFramesCheckBox.setSelected(this.txFramesCheck);
            this.totalRxFramesCheckBox.setSelected(this.rxFramesCheck);
            this.totalErrorsCheckBox.setSelected(this.errorsCheck);
            this.displayGridCheckBox.setSelected(this.displayGridCheck);
            this.enableBytes(this.selectBytesCheckBox.isSelected());
            this.enableFrames(this.selectFramesCheckBox.isSelected());
        }
    }

    private void enableBytes(boolean bl) {
        if (bl) {
            this.totalBytesButton.setBackground(this.tmpbackgroundColor);
            this.totalTxBytesButton.setBackground(this.tmpbackgroundColor);
            this.totalRxBytesButton.setBackground(this.tmpbackgroundColor);
        } else {
            this.totalBytesButton.setBackground(this.graphBkgdButton.getBackground());
            this.totalTxBytesButton.setBackground(this.graphBkgdButton.getBackground());
            this.totalRxBytesButton.setBackground(this.graphBkgdButton.getBackground());
        }
        this.totalBytesButton.setEnabled(bl);
        this.totalTxBytesButton.setEnabled(bl);
        this.totalRxBytesButton.setEnabled(bl);
        this.totalBytesCheckBox.setEnabled(bl);
        this.totalTxBytesCheckBox.setEnabled(bl);
        this.totalRxBytesCheckBox.setEnabled(bl);
    }

    private void enableFrames(boolean bl) {
        if (bl) {
            this.totalFramesButton.setBackground(this.tmpbackgroundColor);
            this.totalTxFramesButton.setBackground(this.tmpbackgroundColor);
            this.totalRxFramesButton.setBackground(this.tmpbackgroundColor);
        } else {
            this.totalFramesButton.setBackground(this.graphBkgdButton.getBackground());
            this.totalTxFramesButton.setBackground(this.graphBkgdButton.getBackground());
            this.totalRxFramesButton.setBackground(this.graphBkgdButton.getBackground());
        }
        this.totalFramesButton.setEnabled(bl);
        this.totalTxFramesButton.setEnabled(bl);
        this.totalRxFramesButton.setEnabled(bl);
        this.totalFramesCheckBox.setEnabled(bl);
        this.totalTxFramesCheckBox.setEnabled(bl);
        this.totalRxFramesCheckBox.setEnabled(bl);
    }

    public void setGraphUpdater(GraphUpdater graphUpdater) {
        this.gOptionsUpdater = graphUpdater;
    }

    public Vector getGraphOptions() {
        return this.graphOptions;
    }

    private void setGraphOptions() {
        this.graphOptions.removeAllElements();
        GraphOption graphOption = new GraphOption(101, Color.black, this.selectBytesCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(1, this.totalBytesColor, this.totalBytesCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(2, this.totalTxBytesColor, this.totalTxBytesCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(3, this.totalRxBytesColor, this.totalRxBytesCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(102, Color.black, this.selectFramesCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(4, this.totalFramesColor, this.totalFramesCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(5, this.totalTxFramesColor, this.totalTxFramesCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(6, this.totalRxFramesColor, this.totalRxFramesCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(7, this.totalErrorsColor, this.totalErrorsCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(103, this.gridColor, this.displayGridCheckBox.isSelected());
        this.graphOptions.add(graphOption);
        graphOption = new GraphOption(104, this.backgroundColor, true);
        this.graphOptions.add(graphOption);
    }

    protected void initOptions(Vector vector) {
        this.graphOptions.removeAllElements();
        this.graphOptions = vector;
        int n = 0;
        while (n < vector.size()) {
            try {
                GraphOption graphOption = (GraphOption)this.graphOptions.get(n);
                switch (graphOption.getGraphItem()) {
                    case 1: {
                        this.totalBytesCheckBox.setSelected(graphOption.getGraphItemSelected());
                        this.totalBytesColor = graphOption.getGraphColor();
                        break;
                    }
                    case 2: {
                        this.totalTxBytesCheckBox.setSelected(graphOption.getGraphItemSelected());
                        this.totalTxBytesColor = graphOption.getGraphColor();
                        break;
                    }
                    case 3: {
                        this.totalRxBytesCheckBox.setSelected(graphOption.getGraphItemSelected());
                        this.totalRxBytesColor = graphOption.getGraphColor();
                        break;
                    }
                    case 4: {
                        this.totalFramesCheckBox.setSelected(graphOption.getGraphItemSelected());
                        this.totalFramesColor = graphOption.getGraphColor();
                        break;
                    }
                    case 5: {
                        this.totalTxFramesCheckBox.setSelected(graphOption.getGraphItemSelected());
                        this.totalTxFramesColor = graphOption.getGraphColor();
                        break;
                    }
                    case 6: {
                        this.totalRxFramesCheckBox.setSelected(graphOption.getGraphItemSelected());
                        this.totalRxFramesColor = graphOption.getGraphColor();
                        break;
                    }
                    case 7: {
                        this.totalErrorsCheckBox.setSelected(graphOption.getGraphItemSelected());
                        this.totalErrorsColor = graphOption.getGraphColor();
                        break;
                    }
                    case 101: {
                        this.selectBytesCheckBox.setSelected(graphOption.getGraphItemSelected());
                        break;
                    }
                    case 102: {
                        this.selectFramesCheckBox.setSelected(graphOption.getGraphItemSelected());
                        break;
                    }
                    case 103: {
                        this.displayGridCheckBox.setSelected(graphOption.getGraphItemSelected());
                        this.gridColor = graphOption.getGraphColor();
                        break;
                    }
                    case 104: {
                        this.tmpbackgroundColor = this.backgroundColor = graphOption.getGraphColor();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        this.setButtonBackgroundColor();
        this.setButtonForegroundColor();
        this.enableBytes(this.selectBytesCheckBox.isSelected());
        this.enableFrames(this.selectFramesCheckBox.isSelected());
        this.validate();
    }

    protected int applyOptions() {
        int n = -1;
        return n;
    }

    public boolean getSelectBytesCheck() {
        return this.selectBytesCheck;
    }

    public boolean getSelectFramesCheck() {
        return this.selectFramesCheck;
    }

    public boolean getTotalBytesCheck() {
        return this.bytesCheck;
    }

    public Color getTotalBytesColor() {
        return this.totalBytesColor;
    }

    private void setTotalBytesColor(Color color) {
        this.totalBytesColor = color;
    }

    public boolean getTotalFramesCheck() {
        return this.framesCheck;
    }

    public Color getTotalFramesColor() {
        return this.totalFramesColor;
    }

    private void setTotalFramesColor(Color color) {
        this.totalFramesColor = color;
    }

    public boolean getTotalErrorsCheck() {
        return this.errorsCheck;
    }

    public Color getTotalErrorsColor() {
        return this.totalErrorsColor;
    }

    private void setTotalErrorsColor(Color color) {
        this.totalErrorsColor = color;
    }

    public boolean getTotalRxBytesCheck() {
        return this.rxBytesCheck;
    }

    public Color getTotalRxBytesColor() {
        return this.totalRxBytesColor;
    }

    private void setTotalRxBytesColor(Color color) {
        this.totalRxBytesColor = color;
    }

    public boolean getTotalTxBytesCheck() {
        return this.txBytesCheck;
    }

    public Color getTotalTxBytesColor() {
        return this.totalTxBytesColor;
    }

    private void setTotalTxBytesColor(Color color) {
        this.totalTxBytesColor = color;
    }

    public boolean getTotalRxFramesCheck() {
        return this.rxFramesCheck;
    }

    public Color getTotalRxFramesColor() {
        return this.totalRxFramesColor;
    }

    private void setTotalRxFramesColor(Color color) {
        this.totalRxFramesColor = color;
    }

    public boolean getTotalTxFramesCheck() {
        return this.txFramesCheck;
    }

    public Color getTotalTxFramesColor() {
        return this.totalTxFramesColor;
    }

    private void setTotalTxFramesColor(Color color) {
        this.totalTxFramesColor = color;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    private void setGridColor(Color color) {
        this.gridColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    private void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public boolean getGridFlag() {
        return this.displayGridCheck;
    }

    private void setGridFlag(boolean bl) {
        this.displayGridCheck = bl;
    }

    public void setControlsEnable(boolean bl) {
        this.okButton.setEnabled(bl);
        this.fieldsEnabled = bl;
        this.cancelButton.setText(PerfFabricTreeControl.getResource("GraphOptionsDialog.cancelButton"));
    }

    private void shutdownDialog() {
        this.setControlsEnable(true);
        if (this.fabric != null) {
            this.fabric.removeEventListener((FabricEventListener)this);
            this.fabric = null;
        }
        this.setVisible(false);
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        ReceiveFabricEventRunnable receiveFabricEventRunnable = new ReceiveFabricEventRunnable(fabricEvent);
        SwingUtilities.invokeLater(receiveFabricEventRunnable);
    }

    class ChangeBackgroundAction
    extends AbstractAction {
        public ChangeBackgroundAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.setBackgroundColor"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(SingleGraphOptionsDialog.this, PerfFabricTreeControl.getResource("GraphOptionsDialog.setBackgroundColor"), SingleGraphOptionsDialog.this.graphBkgdButton.getBackground());
            if (color != null) {
                if (SingleGraphOptionsDialog.this.totalBytesButton.isEnabled()) {
                    SingleGraphOptionsDialog.this.totalBytesButton.setBackground(color);
                }
                if (SingleGraphOptionsDialog.this.totalTxBytesButton.isEnabled()) {
                    SingleGraphOptionsDialog.this.totalTxBytesButton.setBackground(color);
                }
                if (SingleGraphOptionsDialog.this.totalRxBytesButton.isEnabled()) {
                    SingleGraphOptionsDialog.this.totalRxBytesButton.setBackground(color);
                }
                if (SingleGraphOptionsDialog.this.totalFramesButton.isEnabled()) {
                    SingleGraphOptionsDialog.this.totalFramesButton.setBackground(color);
                }
                if (SingleGraphOptionsDialog.this.totalTxFramesButton.isEnabled()) {
                    SingleGraphOptionsDialog.this.totalTxFramesButton.setBackground(color);
                }
                if (SingleGraphOptionsDialog.this.totalRxFramesButton.isEnabled()) {
                    SingleGraphOptionsDialog.this.totalRxFramesButton.setBackground(color);
                }
                if (SingleGraphOptionsDialog.this.totalErrorsButton.isEnabled()) {
                    SingleGraphOptionsDialog.this.totalErrorsButton.setBackground(color);
                }
                if (SingleGraphOptionsDialog.this.graphGridButton.isEnabled()) {
                    SingleGraphOptionsDialog.this.graphGridButton.setBackground(color);
                }
                SingleGraphOptionsDialog.this.tmpbackgroundColor = color;
            }
        }
    }

    class ChangeGridAction
    extends AbstractAction {
        public ChangeGridAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.setGridColor"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(SingleGraphOptionsDialog.this, PerfFabricTreeControl.getResource("GraphOptionsDialog.setGridColor"), SingleGraphOptionsDialog.this.graphGridButton.getBackground());
            if (color != null) {
                SingleGraphOptionsDialog.this.graphGridButton.setForeground(color);
            }
        }
    }

    class ChangeTotalTxFramesAction
    extends AbstractAction {
        public ChangeTotalTxFramesAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalTxFramesColor"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(SingleGraphOptionsDialog.this, PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalTxFramesColor"), SingleGraphOptionsDialog.this.totalTxFramesButton.getForeground());
            if (color != null) {
                SingleGraphOptionsDialog.this.totalTxFramesButton.setForeground(color);
            }
        }
    }

    class ChangeTotalRxFramesAction
    extends AbstractAction {
        public ChangeTotalRxFramesAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalRxFramesColor"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(SingleGraphOptionsDialog.this, PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalRxFramesColor"), SingleGraphOptionsDialog.this.totalRxFramesButton.getForeground());
            if (color != null) {
                SingleGraphOptionsDialog.this.totalRxFramesButton.setForeground(color);
            }
        }
    }

    class ChangeTotalTxBytesAction
    extends AbstractAction {
        public ChangeTotalTxBytesAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalTxBytesColor"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(SingleGraphOptionsDialog.this, PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalTxBytesColor"), SingleGraphOptionsDialog.this.totalTxBytesButton.getForeground());
            if (color != null) {
                SingleGraphOptionsDialog.this.totalTxBytesButton.setForeground(color);
            }
        }
    }

    class ChangeTotalRxBytesAction
    extends AbstractAction {
        public ChangeTotalRxBytesAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalRxBytesColor"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(SingleGraphOptionsDialog.this, PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalRxBytesColor"), SingleGraphOptionsDialog.this.totalRxBytesButton.getForeground());
            if (color != null) {
                SingleGraphOptionsDialog.this.totalRxBytesButton.setForeground(color);
            }
        }
    }

    class ChangeTotalErrorsAction
    extends AbstractAction {
        public ChangeTotalErrorsAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalErrorsColor"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(SingleGraphOptionsDialog.this, PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalErrorsColor"), SingleGraphOptionsDialog.this.totalErrorsButton.getForeground());
            if (color != null) {
                SingleGraphOptionsDialog.this.totalErrorsButton.setForeground(color);
            }
        }
    }

    class ChangeTotalFramesAction
    extends AbstractAction {
        public ChangeTotalFramesAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalFramesColor"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(SingleGraphOptionsDialog.this, PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalFramesColor"), SingleGraphOptionsDialog.this.totalFramesButton.getForeground());
            if (color != null) {
                SingleGraphOptionsDialog.this.totalFramesButton.setForeground(color);
            }
        }
    }

    class ChangeTotalBytesAction
    extends AbstractAction {
        public ChangeTotalBytesAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalBytesColor"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(SingleGraphOptionsDialog.this, PerfFabricTreeControl.getResource("GraphOptionsDialog.setTotalBytesColor"), SingleGraphOptionsDialog.this.totalBytesButton.getForeground());
            if (color != null) {
                SingleGraphOptionsDialog.this.totalBytesButton.setForeground(color);
            }
        }
    }

    class SelectFramesBoxAction
    extends AbstractAction {
        public SelectFramesBoxAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.selectFrames"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = SingleGraphOptionsDialog.this.selectFramesCheckBox.isSelected();
            if (bl) {
                SingleGraphOptionsDialog.this.enableFrames(true);
                SingleGraphOptionsDialog.this.enableBytes(false);
                SingleGraphOptionsDialog.this.selectBytesCheckBox.setSelected(false);
            } else {
                SingleGraphOptionsDialog.this.enableFrames(false);
            }
        }
    }

    class SelectBytesBoxAction
    extends AbstractAction {
        public SelectBytesBoxAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.selectBytes"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = SingleGraphOptionsDialog.this.selectBytesCheckBox.isSelected();
            if (bl) {
                SingleGraphOptionsDialog.this.enableBytes(true);
                SingleGraphOptionsDialog.this.enableFrames(false);
                SingleGraphOptionsDialog.this.selectFramesCheckBox.setSelected(false);
            } else {
                SingleGraphOptionsDialog.this.enableBytes(false);
            }
        }
    }

    class DisplayGridAction
    extends AbstractAction {
        public DisplayGridAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.displayGrid"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = SingleGraphOptionsDialog.this.displayGridCheckBox.isSelected();
            if (bl) {
                SingleGraphOptionsDialog.this.graphGridButton.setBackground(SingleGraphOptionsDialog.this.totalBytesButton.getBackground());
                SingleGraphOptionsDialog.this.graphGridButton.setEnabled(true);
            } else {
                SingleGraphOptionsDialog.this.graphGridButton.setBackground(SingleGraphOptionsDialog.this.graphBkgdButton.getBackground());
                SingleGraphOptionsDialog.this.graphGridButton.setEnabled(false);
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.cancelButton"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SingleGraphOptionsDialog.this.setButtonColors(false);
            SingleGraphOptionsDialog.this.setCheckBoxes(false);
            if (SingleGraphOptionsDialog.this.fieldsEnabled) {
                SingleGraphOptionsDialog.this.shutdownDialog();
            } else {
                SingleGraphOptionsDialog.this.setControlsEnable(true);
            }
        }
    }

    public class ReceiveFabricEventRunnable
    implements Runnable {
        FabricEvent evt;

        ReceiveFabricEventRunnable(FabricEvent fabricEvent) {
            this.evt = fabricEvent;
        }

        public void run() {
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super(PerfFabricTreeControl.getResource("GraphOptionsDialog.okButton"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SingleGraphOptionsDialog.this.setButtonColors(true);
            SingleGraphOptionsDialog.this.setCheckBoxes(true);
            SingleGraphOptionsDialog.this.setGraphOptions();
            SingleGraphOptionsDialog.this.setVisible(false);
        }
    }
}

