/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.perfmon.GraphInternalFrame;
import com.qlogic.perfmon.Grapher;
import com.qlogic.ui.MDIDesktopPane;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

class MDIDesktopManager
extends DefaultDesktopManager {
    private MDIDesktopPane desktop;

    public MDIDesktopManager(MDIDesktopPane mDIDesktopPane) {
        this.desktop = mDIDesktopPane;
    }

    public void endResizingFrame(JComponent jComponent) {
        super.endResizingFrame(jComponent);
        GraphInternalFrame graphInternalFrame = (GraphInternalFrame)jComponent;
        Grapher grapher = graphInternalFrame.getGrapher();
        grapher.frameResize();
        this.resizeDesktop();
    }

    public void maximizeFrame(JInternalFrame jInternalFrame) {
        super.maximizeFrame(jInternalFrame);
        GraphInternalFrame graphInternalFrame = (GraphInternalFrame)jInternalFrame;
        Grapher grapher = graphInternalFrame.getGrapher();
        grapher.frameResize();
    }

    public void minimizeFrame(JInternalFrame jInternalFrame) {
        super.minimizeFrame(jInternalFrame);
        GraphInternalFrame graphInternalFrame = (GraphInternalFrame)jInternalFrame;
        Grapher grapher = graphInternalFrame.getGrapher();
        grapher.frameResize();
    }

    public void endDraggingFrame(JComponent jComponent) {
        super.endDraggingFrame(jComponent);
        this.resizeDesktop();
    }

    public void setNormalSize() {
        JScrollPane jScrollPane = this.getScrollPane();
        int n = 0;
        int n2 = 0;
        Insets insets = this.getScrollPaneInsets();
        if (jScrollPane != null) {
            Dimension dimension = jScrollPane.getVisibleRect().getSize();
            if (jScrollPane.getBorder() != null) {
                dimension.setSize(dimension.getWidth() - (double)insets.left - (double)insets.right, dimension.getHeight() - (double)insets.top - (double)insets.bottom);
            }
            dimension.setSize(dimension.getWidth() - 20.0, dimension.getHeight() - 20.0);
            this.desktop.setAllSize(n, n2);
            jScrollPane.invalidate();
            jScrollPane.validate();
        }
    }

    private Insets getScrollPaneInsets() {
        JScrollPane jScrollPane = this.getScrollPane();
        if (jScrollPane == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.getScrollPane().getBorder().getBorderInsets(jScrollPane);
    }

    private JScrollPane getScrollPane() {
        JViewport jViewport;
        if (this.desktop.getParent() instanceof JViewport && (jViewport = (JViewport)this.desktop.getParent()).getParent() instanceof JScrollPane) {
            return (JScrollPane)jViewport.getParent();
        }
        return null;
    }

    protected void resizeDesktop() {
        int n = 0;
        int n2 = 0;
        JScrollPane jScrollPane = this.getScrollPane();
        Insets insets = this.getScrollPaneInsets();
        if (jScrollPane != null) {
            JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
            int n3 = 0;
            while (n3 < jInternalFrameArray.length) {
                if (jInternalFrameArray[n3].getX() + jInternalFrameArray[n3].getWidth() > n) {
                    n = jInternalFrameArray[n3].getX() + jInternalFrameArray[n3].getWidth();
                }
                if (jInternalFrameArray[n3].getY() + jInternalFrameArray[n3].getHeight() > n2) {
                    n2 = jInternalFrameArray[n3].getY() + jInternalFrameArray[n3].getHeight();
                }
                ++n3;
            }
            Dimension dimension = jScrollPane.getVisibleRect().getSize();
            if (jScrollPane.getBorder() != null) {
                dimension.setSize(dimension.getWidth() - (double)insets.left - (double)insets.right, dimension.getHeight() - (double)insets.top - (double)insets.bottom);
            }
            if ((double)n <= dimension.getWidth()) {
                n = (int)dimension.getWidth() - 20;
            }
            if ((double)n2 <= dimension.getHeight()) {
                n2 = (int)dimension.getHeight() - 20;
            }
            this.desktop.setAllSize(n, n2);
            jScrollPane.invalidate();
            jScrollPane.validate();
        }
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        super.closeFrame(jInternalFrame);
    }
}

