/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import hhapplet.BsscFont;
import hhapplet.BsscFontFixPatch;
import hhapplet.ViewSkin;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;

public class BsscImageLabel
extends Canvas
implements Runnable {
    private Image m_bgImage;
    private int m_nbgWidth;
    private int m_nbgHeight;
    private Image m_cachebgImage;
    private int m_nOldWidth;
    private int m_nOldHeight;
    private boolean m_bBgUpdated;
    private Image m_imgbackground;
    private Vector m_vToDo;
    private BsscFont m_bFont;
    private String m_strValue;
    private static int m_nHeading = 4;
    private static int m_nEnding = 4;

    private Image getBackgroundImage() {
        if (this.m_nbgWidth <= 0 || this.m_nbgHeight <= 0 || this.m_bgImage == null) {
            return null;
        }
        Rectangle rectangle = this.getBounds();
        if (rectangle.height == this.m_nOldHeight && rectangle.width == this.m_nOldWidth && !this.m_bBgUpdated) {
            return this.m_cachebgImage;
        }
        this.m_nOldWidth = rectangle.width;
        this.m_nOldHeight = rectangle.height;
        this.m_cachebgImage = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics = this.m_cachebgImage.getGraphics();
        this.drawBackGround(graphics);
        return this.m_cachebgImage;
    }

    public BsscImageLabel(String string) {
        this.m_strValue = string;
        if (ViewSkin.m_PaneColorBg != null) {
            this.setBackground(ViewSkin.m_PaneColorBg);
        }
        if (ViewSkin.m_PaneImageBg != null) {
            this.setBgImage(ViewSkin.m_PaneImageBg);
        }
        if (ViewSkin.m_PaneFont != null) {
            this.m_bFont = ViewSkin.m_PaneFont;
        }
        this.m_vToDo = new Vector();
    }

    public void paint(Graphics graphics) {
        try {
            Rectangle rectangle = this.getBounds();
            Image image = this.createImage(rectangle.width, rectangle.height);
            Graphics graphics2 = image.getGraphics();
            this.m_imgbackground = this.getBackgroundImage();
            if (this.m_imgbackground != null) {
                graphics2.drawImage(this.m_imgbackground, 0, 0, this);
            }
            Font font = null;
            Color color = null;
            if (this.m_bFont != null) {
                font = this.m_bFont.getFont();
                color = this.m_bFont.getColor();
            } else {
                font = new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
                color = Color.black;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.getAscent();
            int n2 = fontMetrics.getLeading();
            graphics2.getFont();
            Color color2 = graphics2.getColor();
            graphics2.setColor(color);
            graphics2.setFont(font);
            graphics2.drawString(this.m_strValue, 0, n + n2 + m_nHeading);
            graphics2.setFont(font);
            graphics2.setColor(color2);
            graphics.drawImage(image, 0, 0, this);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setBgImage(Image image) {
        this.m_bgImage = image;
        this.m_nbgHeight = this.m_bgImage.getHeight(this);
        this.m_nbgWidth = this.m_bgImage.getWidth(this);
    }

    public void dispatchToDo(String string) {
        if (string == "repaint") {
            this.repaint();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image == this.m_bgImage) {
            this.m_nbgWidth = n4;
            this.m_nbgHeight = n5;
            this.m_bBgUpdated = true;
            this.repaint();
            return false;
        }
        return true;
    }

    public void drawBackGround(Graphics graphics) {
        if (this.m_nbgWidth > 0 && this.m_nbgHeight > 0 && this.m_bgImage != null) {
            Rectangle rectangle = this.getBounds();
            int n = 0;
            while (n <= (rectangle.width - 1) / this.m_nbgWidth) {
                int n2 = 0;
                while (n2 <= (rectangle.height - 1) / this.m_nbgHeight) {
                    if (!graphics.drawImage(this.m_bgImage, n * this.m_nbgWidth, n2 * this.m_nbgHeight, this.m_nbgWidth, this.m_nbgHeight, null)) {
                        this.setTimeout("repaint", 100);
                        return;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.m_bBgUpdated) {
                this.m_bBgUpdated = false;
                return;
            }
        } else {
            Color color = graphics.getColor();
            Color color2 = this.getBackground();
            graphics.setColor(color2);
            Rectangle rectangle = this.getBounds();
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension getPreferredSize() {
        new Dimension();
        Font font = null;
        font = this.m_bFont != null ? this.m_bFont.getFont() : new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(font);
        char[] cArray = new char[this.m_strValue.length()];
        this.m_strValue.getChars(0, this.m_strValue.length(), cArray, 0);
        int n = fontMetrics.charsWidth(cArray, 0, this.m_strValue.length());
        int n2 = fontMetrics.getHeight() + m_nHeading + m_nEnding;
        return new Dimension(n, n2);
    }

    public void run() {
        ToDo toDo;
        Vector vector = this.m_vToDo;
        synchronized (vector) {
            toDo = (ToDo)this.m_vToDo.elementAt(0);
            this.m_vToDo.removeElementAt(0);
            Object var4_3 = null;
        }
        try {
            Thread.sleep(toDo.m_nMSec);
            this.dispatchToDo(toDo.m_sToDo);
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
    }

    public final void setTimeout(String string, int n) {
        ToDo toDo = new ToDo(string, n);
        Vector vector = this.m_vToDo;
        synchronized (vector) {
            this.m_vToDo.addElement(toDo);
            Object var6_5 = null;
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void setText(String string) {
        this.m_strValue = string;
    }

    private class ToDo {
        public String m_sToDo;
        public int m_nMSec;

        public ToDo(String string, int n) {
            BsscImageLabel.this.getClass();
            this.m_sToDo = string;
            this.m_nMSec = n;
        }
    }
}

