/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Properties;

public class AppProperties {
    private static final String CLASS_NAME = "AppProperties";
    private final byte[] m_aIoLoFaro = new byte[]{-72, -114, 45, -28, -97, -40, 41, 104};
    private final byte[] m_aDellIoLoFaro = new byte[]{-7, 73, -93, -119, -42, 39, 14, -48};
    private final byte[] m_aNonPosso = new byte[]{-88, 1, -71, -40, -39, 18, 14, -8};
    static final String APPLICATION_TYPE_KEY = new String("node.application.build");
    private boolean m_bPropertiesReady = false;
    private String m_strApplicationProperties = null;

    public AppProperties() {
        String string = CLASS_NAME;
        Trace.traceAt(900, "IN " + string + ".");
        this.loadSettingsFromPropertiesFile();
        this.m_bPropertiesReady = true;
        Trace.traceAt(900, "OUT " + string + ".");
    }

    public boolean isHighAvailability() {
        if (this.toHexString(this.m_aIoLoFaro).compareTo(this.m_strApplicationProperties) == 0) {
            return true;
        }
        return this.isHAsansLunMasking();
    }

    public boolean isHAsansLunMasking() {
        return this.toHexString(this.m_aDellIoLoFaro).compareTo(this.m_strApplicationProperties) == 0;
    }

    public boolean isStandardEdition() {
        boolean bl = false;
        if (this.toHexString(this.m_aNonPosso).compareTo(this.m_strApplicationProperties) == 0) {
            bl = true;
        }
        return bl;
    }

    private void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.byte2hex(byArray[n2], stringBuffer);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void loadSettingsFromPropertiesFile() {
        String string = "AppProperties.loadSettingsFromPropertiesFile";
        String string2 = null;
        Properties properties = null;
        Trace.traceAt(900, "IN " + string + ".");
        this.m_strApplicationProperties = "";
        try {
            properties = new Properties(System.getProperties());
            properties.load(new BufferedInputStream(new FileInputStream(Utilities.LOCAL_PROPERTIES)));
            string2 = properties.getProperty(APPLICATION_TYPE_KEY);
            if (string2 != null) {
                this.m_strApplicationProperties = new String(string2);
            }
        }
        catch (Exception exception) {
            Trace.warn(string + ": cannot load setup values from properties file, using defaults");
        }
        Trace.traceAt(900, "OUT " + string + ".");
    }
}

