/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.QConstants;
import com.qlogic.util.EntryManager;
import com.qlogic.util.EventEntry;
import com.qlogic.util.EventLogListener;
import com.qlogic.util.EventLogNotifyRunnable;
import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class EventManager
extends EntryManager {
    public static final int TOKEN_COUNT = 4;
    private static EventManager m_instance = new EventManager();
    private Vector m_Listeners = new Vector();

    private EventManager() {
    }

    public static EventManager instance() {
        Trace.traceAt(400, "In EventManager.instance");
        Trace.traceAt(400, "Out EventManager.instance.  Returns:  " + m_instance + ".");
        return m_instance;
    }

    public void addEventLogListener(EventLogListener eventLogListener) {
        this.m_Listeners.addElement(eventLogListener);
    }

    public void removeEventLogListener(EventLogListener eventLogListener) {
        this.m_Listeners.removeElement(eventLogListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(EventEntry eventEntry) {
        Object[] objectArray;
        Vector vector = this.m_Listeners;
        synchronized (vector) {
            objectArray = new EventLogListener[this.m_Listeners.size()];
            this.m_Listeners.copyInto(objectArray);
        }
        if (objectArray.length > 0) {
            EventLogNotifyRunnable eventLogNotifyRunnable = new EventLogNotifyRunnable(eventEntry, (EventLogListener[])objectArray);
            SwingUtilities.invokeLater(eventLogNotifyRunnable);
        }
    }

    public synchronized void addEntry(Date date, int n, int n2, String string) {
        EventEntry[] eventEntryArray;
        Trace.traceAt(400, "In EventManager.addEntry");
        if (this.m_Listeners.size() > 0) {
            eventEntryArray = new EventEntry(n, n2, date, string);
            this.notifyListeners((EventEntry)eventEntryArray);
        }
        if (this.m_enabled && this.m_open) {
            try {
                int n3;
                int n4 = new Integer(Utilities.getProperty(QConstants.EVENT_LOG_SIZE_KEY));
                int n5 = 0;
                int n6 = 0;
                eventEntryArray = this.getEntries();
                n5 = eventEntryArray == null ? 0 : eventEntryArray.length;
                boolean bl = true;
                if (n2 == 0) {
                    n3 = new Boolean(Utilities.getProperty(QConstants.LOG_INFORMATIONAL_KEY)).booleanValue();
                    if (n3 == 0) {
                        bl = false;
                    }
                } else if (n2 == 1 && (n3 = new Boolean(Utilities.getProperty(QConstants.LOG_WARNING_KEY)).booleanValue()) == 0) {
                    bl = false;
                }
                if (n5 > n4) {
                    n6 = n5 - n4;
                    if (bl) {
                        ++n6;
                    }
                    this.truncate();
                    n3 = n6;
                    while (n3 < n5) {
                        String string2 = QConstants.DATE_FORMAT.format(eventEntryArray[n3].getTimeStamp());
                        this.m_file.write(string2.getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(Integer.toString(eventEntryArray[n3].getApplicationType()).getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(eventEntryArray[n3].getDescription().getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(Integer.toString(eventEntryArray[n3].getSeverity()).getBytes());
                        this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                        ++n3;
                    }
                }
                if (bl) {
                    String string3 = QConstants.DATE_FORMAT.format(date);
                    this.m_file.write(string3.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(n).getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(string.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(n2).getBytes());
                    this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                }
            }
            catch (IOException iOException) {
                Trace.warn("Add of Entry failed.  Exception " + iOException.toString() + ".");
                iOException.printStackTrace();
            }
        }
        Trace.traceAt(400, "Out EventManager.addEntry");
    }

    public synchronized EventEntry[] getEntries() {
        Trace.traceAt(900, "In EventManager.getEntries()");
        String string = null;
        int n = 3;
        int n2 = 4;
        Date date = null;
        String string2 = null;
        Object var6_6 = null;
        String string3 = "\t\n\r,";
        boolean bl = true;
        this.entryVector.removeAllElements();
        if (this.m_enabled && this.m_open) {
            Object[] objectArray;
            block13: {
                try {
                    if (this.m_file.length() != 0L) {
                        this.m_file.seek(0L);
                        while ((string = this.m_file.readLine()) != null) {
                            objectArray = new StringTokenizer(string, string3);
                            bl = true;
                            if (objectArray.countTokens() == 4) {
                                while (objectArray.hasMoreTokens()) {
                                    try {
                                        date = QConstants.DATE_FORMAT.parse(objectArray.nextToken().trim());
                                    }
                                    catch (ParseException parseException) {
                                        bl = false;
                                        Trace.warn("Failed to parse Event date: " + parseException.toString());
                                    }
                                    try {
                                        n2 = Integer.parseInt(objectArray.nextToken().trim());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        bl = false;
                                        Trace.warn("Failed to parse Event application type: " + numberFormatException.toString());
                                    }
                                    string2 = objectArray.nextToken().trim();
                                    try {
                                        n = Integer.parseInt(objectArray.nextToken().trim());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        bl = false;
                                        Trace.warn("Failed to parse Event severity: " + numberFormatException.toString());
                                    }
                                    if (!bl) continue;
                                    this.entryVector.add(new EventEntry(n2, n, date, string2));
                                }
                                continue;
                            }
                            Trace.traceAt(900, "EventManager.getEntries (): Invalid entry encountered and ignored.");
                        }
                        break block13;
                    }
                    return null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            Trace.traceAt(900, "Returning " + this.entryVector.size() + " Events.");
            objectArray = new EventEntry[this.entryVector.size()];
            this.entryVector.copyInto(objectArray);
            Trace.traceAt(900, "Out EventManager.getEntries().  Returns:  " + this.entryVector.toArray() + ".");
            return objectArray;
        }
        Trace.traceAt(900, "Out EventManager.getEntries().  Returns:  " + null + ".");
        return null;
    }

    protected void finalize() throws Throwable {
        Trace.traceAt(600, "In EventManager.finalize()");
        Trace.traceAt(600, "This should not be called when the application is running.");
        m_instance = null;
        super.finalize();
        Trace.traceAt(600, "Out EventManager.finalize()");
    }
}

