/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic;

import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.text.DateFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class QConstants {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.qlogic.QResource");
    private static final ResourceBundle[] VENDOR_BUNDLES = QConstants.getVendorResource();
    public static final String VENDOR_RESOURCE_KEY = "vendor";
    public static final String DEFAULT_VENDOR = "com.qlogic.qms.hba.vendor.qlogic.VendorResource";
    public static final String BROWSER_LOCATION_KEY;
    public static final String SPLASH_DELAY_KEY = "splash.delay";
    public static final String SPLASH_INFO_KEY = "splash.info";
    public static final String PAINT_VERSION_KEY = "paint.ver";
    public static final String DEFAULT_BROWSER_LOCATION;
    public static final String WARNING_DISPLAY_KEY;
    public static final String WARNING_PERSIST_KEY;
    public static final String CONFIG_CHANGE_PERSIST_KEY;
    public static final String CONFIG_ALARM_KEY = "node.option.config.change";
    public static final String ALARM_LOG_FILENAME_PATH;
    public static final String EVENT_LOG_FILENAME_PATH;
    public static final String HOST_LOG_FILENAME_PATH;
    public static final String ALARM_LOG_SIZE_KEY;
    public static final String EVENT_LOG_SIZE_KEY;
    public static final String LOG_INFORMATIONAL_KEY;
    public static final String LOG_WARNING_KEY;
    public static final String PORT_NUMBER_KEY = "node.instance.portnumber";
    public static final DateFormat DATE_FORMAT;
    public static final String LOG_DATA_DELIMETER = ", ";

    public static String getString(String key) {
        String value = BUNDLE.getString(key);
        Trace.traceAt((int)900, (String)String.valueOf(String.valueOf(new StringBuffer("returning Bundle String:  ").append(value).append(" from key:  ").append(key).append("."))));
        return value;
    }

    public static Object getObject(String key) {
        Object value = BUNDLE.getObject(key);
        Trace.traceAt((int)900, (String)String.valueOf(String.valueOf(new StringBuffer("returning Bundle Object:  ").append(value).append(" from key:  ").append(key).append("."))));
        return value;
    }

    public static String getVendorString(String key) {
        String value = null;
        for (int i = 0; i < VENDOR_BUNDLES.length; ++i) {
            try {
                value = VENDOR_BUNDLES[i].getString(key);
                if (value == null) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Trace.traceAt((int)900, (String)String.valueOf(String.valueOf(new StringBuffer("returning Vendor String:  ").append(value).append(" from key:  ").append(key).append("."))));
        return value;
    }

    public static Object getVendorObject(String key) {
        Object value = null;
        for (int i = 0; i < VENDOR_BUNDLES.length; ++i) {
            try {
                value = VENDOR_BUNDLES[i].getObject(key);
                if (value == null) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Trace.traceAt((int)900, (String)String.valueOf(String.valueOf(new StringBuffer("returning Vendor Object:  ").append(value).append(" from key:  ").append(key).append("."))));
        return value;
    }

    private static final ResourceBundle[] getVendorResource() {
        ResourceBundle[] bundles = null;
        String vendorResource = null;
        int i = 0;
        int j = 0;
        vendorResource = Utilities.getProperty((String)VENDOR_RESOURCE_KEY);
        if (vendorResource != null) {
            ++i;
        }
        do {
            vendorResource = Utilities.getProperty((String)VENDOR_RESOURCE_KEY.concat(String.valueOf(String.valueOf(j))));
            ++j;
            if (vendorResource == null) continue;
            ++i;
        } while (vendorResource != null);
        Trace.traceAt((int)900, (String)String.valueOf(String.valueOf(new StringBuffer("We found ").append(i).append(" resource bundles."))));
        bundles = new ResourceBundle[i];
        i = 0;
        j = 0;
        try {
            vendorResource = Utilities.getProperty((String)VENDOR_RESOURCE_KEY);
            if (vendorResource != null) {
                bundles[i] = ResourceBundle.getBundle(vendorResource);
                ++i;
            }
            do {
                vendorResource = Utilities.getProperty((String)VENDOR_RESOURCE_KEY.concat(String.valueOf(String.valueOf(j))));
                ++j;
                if (vendorResource == null) continue;
                Trace.traceAt((int)900, (String)String.valueOf(String.valueOf(new StringBuffer("Trying to load resource with key '").append(vendorResource).append("'."))));
                bundles[i] = ResourceBundle.getBundle(vendorResource);
                Trace.traceAt((int)900, (String)String.valueOf(String.valueOf(new StringBuffer("Loaded resource with key '").append(vendorResource).append("'."))));
                ++i;
            } while (vendorResource != null);
        }
        catch (MissingResourceException e1) {
            Trace.warn((String)"Failed to load vendor resource: ".concat(String.valueOf(String.valueOf(vendorResource))));
            bundles = new ResourceBundle[1];
            try {
                bundles[0] = ResourceBundle.getBundle(DEFAULT_VENDOR);
            }
            catch (MissingResourceException e2) {
                System.out.println("Fatal Error: No vendor resource!");
                System.exit(1);
            }
        }
        return bundles;
    }

    static {
        VENDOR_RESOURCE_KEY = VENDOR_RESOURCE_KEY;
        DEFAULT_VENDOR = DEFAULT_VENDOR;
        BROWSER_LOCATION_KEY = BUNDLE.getString("node_browser_location");
        SPLASH_DELAY_KEY = SPLASH_DELAY_KEY;
        SPLASH_INFO_KEY = SPLASH_INFO_KEY;
        PAINT_VERSION_KEY = PAINT_VERSION_KEY;
        DEFAULT_BROWSER_LOCATION = BUNDLE.getString("iexplore_exe");
        WARNING_DISPLAY_KEY = BUNDLE.getString("warn_display_key");
        WARNING_PERSIST_KEY = BUNDLE.getString("node_option_warning_persist_enable");
        CONFIG_CHANGE_PERSIST_KEY = BUNDLE.getString("node_option_config_change_persist_enable");
        CONFIG_ALARM_KEY = CONFIG_ALARM_KEY;
        ALARM_LOG_FILENAME_PATH = BUNDLE.getString("alarms_txt");
        EVENT_LOG_FILENAME_PATH = BUNDLE.getString("events_txt");
        HOST_LOG_FILENAME_PATH = BUNDLE.getString("hosts_txt");
        ALARM_LOG_SIZE_KEY = BUNDLE.getString("node_alarm_log_size");
        EVENT_LOG_SIZE_KEY = BUNDLE.getString("node_log_size");
        LOG_INFORMATIONAL_KEY = BUNDLE.getString("node_log");
        LOG_WARNING_KEY = BUNDLE.getString("node_log_warning");
        PORT_NUMBER_KEY = PORT_NUMBER_KEY;
        DATE_FORMAT = (DateFormat)QConstants.getObject("date_formatter");
        LOG_DATA_DELIMETER = LOG_DATA_DELIMETER;
    }
}

