/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.S43Port;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SwitchBlade;
import com.qlogic.device.fcfabric.archiver.SanboxChassisArchiver;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.UtilError;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.Sanbox8000Sml;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.FaceplateListener;
import com.qlogic.qms.fabric.FcPortRenderer;
import com.qlogic.qms.fabric.LoadFirmwareDialog;
import com.qlogic.qms.fabric.NameServerPanel;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.TrapConfigDialogSanbox;
import com.qlogic.qms.fabric.TrapConfigDialogSanbox2;
import com.qlogic.qms.fabric.UserPreferences;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.DateTimeDialogSanbox2;
import com.qlogic.qms.fabric.propertyDialogs.DialogCreateException;
import com.qlogic.qms.fabric.propertyDialogs.ExtCreditDialogSanbox;
import com.qlogic.qms.fabric.propertyDialogs.FirmwareFallbackDialogSanbox2;
import com.qlogic.qms.fabric.propertyDialogs.InternalPortPropertiesDialogSwitchblade;
import com.qlogic.qms.fabric.propertyDialogs.NetworkPropertiesDialogSanbox;
import com.qlogic.qms.fabric.propertyDialogs.NetworkPropertiesDialogSanbox2;
import com.qlogic.qms.fabric.propertyDialogs.PortNameDialogSanbox2;
import com.qlogic.qms.fabric.propertyDialogs.PortPropertiesDialogSanbox;
import com.qlogic.qms.fabric.propertyDialogs.PortPropertiesDialogSanbox2;
import com.qlogic.qms.fabric.propertyDialogs.PortTestDialogSanbox;
import com.qlogic.qms.fabric.propertyDialogs.PortTestDialogSanbox2_1_03;
import com.qlogic.qms.fabric.propertyDialogs.PortTestDialogSanbox2_1_04;
import com.qlogic.qms.fabric.propertyDialogs.RestoreDialogSanbox2;
import com.qlogic.qms.fabric.propertyDialogs.SwitchPropertiesDialogSanbox;
import com.qlogic.qms.fabric.propertyDialogs.SwitchPropertiesDialogSanbox2;
import com.qlogic.qms.fabric.propertyDialogs.TempMonitoringDialogSanbox2;
import com.qlogic.qms.fabric.propertyDialogs.UserAccountDialogSanbox2;
import com.qlogic.qms.fabric.wizards.ExtCreditWizardSanbox2;
import com.qlogic.qms.fabric.wizards.ExtCreditWizardSanbox8000;
import com.qlogic.qms.fabric.wizards.HotSwapWizard;
import com.qlogic.qms.fabric.wizards.zoning.ZoningWizard;
import com.qlogic.qms.fabric.zoning.ActivateZoneSetDialog;
import com.qlogic.qms.fabric.zoning.ZoningConfigDialog;
import com.qlogic.qms.fabric.zoning.ZoningDialog;
import com.qlogic.ui.QFileChooser;
import com.qlogic.ui.QMultiLineLabel;
import com.qlogic.ui.StringFileFilter;
import com.qlogic.util.JDocument;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public abstract class AbstractFaceplate
extends JPanel
implements MouseListener,
ChassisEventListener,
ActionListener {
    protected ListSelectionModel m_SelectionModel = new DefaultListSelectionModel();
    Vector listeners = new Vector();
    ImageIcon faceplateIcon = null;
    Chassis fcSwitch;
    static int mode;
    NameServerPanel nameServerPanel;
    public static final ImageIcon[] copperIcon;
    public static final ImageIcon[] opticalIcon;
    public static final ImageIcon[] unknownIcon;
    public static final ImageIcon[] copperIconV;
    public static final ImageIcon[] opticalIconV;
    public static final ImageIcon[] unknownIconV;
    public static final ImageIcon[] opticalSmallIcon;
    public static final ImageIcon[] unknownSmallIcon;
    public static final ImageIcon[] copperSmallIcon;
    private static LoadFirmwareDialog fwLoadDialog;
    public static boolean imagesNotRead;
    protected JMenu exportMenu = new JMenu(FabricTreeControl.getResource("AbstractFaceplate.exportMenu"));
    private JMenuItem exportNameServerItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.exportNameServer"));
    private JMenuItem exportTrapLogItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.exportTrapLog"));
    protected JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem refreshSwitchItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.refreshSwitch"));
    private JMenuItem selectAllPortsItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.selectAllPorts"));
    protected JMenuItem switchPropertiesItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.switchProperties"));
    protected JMenuItem networkPropertiesItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.networkProperties"));
    protected JMenuItem extCreditWizardItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.extCreditWizard"));
    protected JMenuItem extCreditsItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.extendedCredits"));
    private JMenuItem portNameItem = new JMenuItem(FabricTreeControl.getResource("PortNameDialog.portSymbolicNameMenu"));
    private JMenuItem portPropertiesItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.portProperties"));
    private JMenuItem portDiagnosticItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.portDiagnostics"));
    private JMenuItem loadFirmwareMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.loadFirmware"));
    private JMenuItem activateFirmwareMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.activateFirmware"));
    private JMenuItem firmwareFallbackMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.firmwareFallback"));
    private JMenuItem extCreditWizardMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.extCreditWizard"));
    private JMenuItem extCreditsMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.extendedCredits"));
    private JMenuItem userAccountsMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.userAccounts"));
    private JMenuItem setDateTimeMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.setDateTime"));
    private JMenuItem tempThresholdMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.tempThreshold"));
    private JCheckBoxMenuItem toggleBeaconMenuItem = new JCheckBoxMenuItem(FabricTreeControl.getResource("AbstractFaceplate.toggleBeacon"));
    private JMenuItem resetSwitchMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.resetSwitch"));
    private JMenuItem hotResetMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.hotReset"));
    private JMenuItem warmResetMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.warmReset"));
    private JMenuItem hardResetMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.hardReset"));
    private JMenuItem resetToFactoryDefaultsMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.resetToFactoryDefaults"));
    private JMenuItem switchPropertiesMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.switchProperties"));
    private JMenuItem switchArchiveMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.archive"));
    private JMenuItem switchRestoreMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.restore"));
    private JMenuItem networkPropertiesMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.networkProperties"));
    private JMenuItem editZoningMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.editZoning"));
    private JMenuItem editZoningConfigMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.editZoningConfig"));
    private JMenuItem activateZoneSetMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.activateZoneSet"));
    private JMenuItem deactivateZoneSetMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.deactivateZoneSet"));
    private JMenuItem zoningWizardMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.zoningWizard"));
    private JMenuItem clearTrapLogMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.clearTrapLog"));
    private JMenuItem configureTrapsMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.configureTraps"));
    private JMenuItem configureAlarmThresholdMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.configureAlarmThresholds"));
    private JMenuItem resetPortMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.resetPort"));
    private JMenuItem portNameMenuItem = new JMenuItem(FabricTreeControl.getResource("PortNameDialog.portSymbolicNameMenu"));
    private JMenuItem portPropertiesMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.portProperties"));
    private JMenuItem portDiagnosticMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.portDiagnostics"));
    private JMenuItem resetDefaultZoningMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.resetDefaultZoning"));
    private static JCheckBoxMenuItem viewModesItem;
    private static JCheckBoxMenuItem viewStatesItem;
    private static JCheckBoxMenuItem viewSpeedsItem;
    private static JCheckBoxMenuItem viewMediaItem;
    private JMenuItem hotSwapWizardMenuItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.hotSwapWizard"));
    private static JCheckBoxMenuItem currentView;
    private static final int VIEW_MODES = 0;
    private static final int VIEW_STATES = 1;
    private static final int VIEW_SPEEDS = 2;
    private static final int VIEW_MEDIA = 3;
    private Color normalColor = new Color(0, 204, 0);
    private Color inactiveColor = new Color(153, 153, 153);
    private boolean popupEvent = false;
    private static final int INDEX_ONLINE = 0;
    private static final int INDEX_OFFLINE = 1;
    protected CellRendererPane m_RendererPane = new CellRendererPane();
    protected FcPortRenderer m_PortRenderer = new FcPortRenderer();
    protected boolean kickedOffSwitchReset = false;
    protected boolean resettingDefZoning;
    private static String ONE_GIG_PORT;
    private static String TWO_GIG_PORT;
    private static String AUTO_SPEED_PORT;
    private static String AUTO_SPEED_PORT_LONG;
    private static String NOT_INSTALLED_STR;
    protected PortNameDialogSanbox2 portNameDialogSB2 = null;
    protected PortPropertiesDialogSanbox2 portPropertiesDialogSB2 = null;
    protected PortPropertiesDialogSanbox portPropertiesDialogSB = null;
    protected InternalPortPropertiesDialogSwitchblade internalPortPropertiesDialogSwitchblade = null;
    protected SwitchPropertiesDialogSanbox2 switchPropertiesDialogSB2 = null;
    protected SwitchPropertiesDialogSanbox switchPropertiesDialogSB = null;
    protected NetworkPropertiesDialogSanbox2 networkPropertiesDialogSB2 = null;
    protected NetworkPropertiesDialogSanbox networkPropertiesDialogSB = null;
    protected FirmwareFallbackDialogSanbox2 firmwareFallbackDialogSB2 = null;
    protected DateTimeDialogSanbox2 dateTimeDialogSB2 = null;
    protected ExtCreditWizardSanbox2 extCreditWizardSB2 = null;
    protected ExtCreditWizardSanbox8000 extCreditWizardSB8000 = null;
    protected UserAccountDialogSanbox2 userAccountDialogSB2 = null;
    protected TempMonitoringDialogSanbox2 tempMonitoringDialogSB2 = null;
    protected HotSwapWizard hotSwapWizard = null;

    public abstract Rectangle getPort(int var1);

    protected AbstractFaceplate(Chassis chassis) {
        if (imagesNotRead) {
            AbstractFaceplate.copperIcon[0] = new ImageIcon(SbmUtilities.getImage("copperGbicOnline.gif"));
            AbstractFaceplate.copperIcon[1] = new ImageIcon(SbmUtilities.getImage("copperGbicOffline.gif"));
            AbstractFaceplate.opticalIcon[0] = new ImageIcon(SbmUtilities.getImage("opticalGbicOnline.gif"));
            AbstractFaceplate.opticalIcon[1] = new ImageIcon(SbmUtilities.getImage("opticalGbicOffline.gif"));
            AbstractFaceplate.copperIconV[0] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2CuOnlineV.gif"));
            AbstractFaceplate.copperIconV[1] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2CuOnlineV.gif"));
            AbstractFaceplate.unknownIconV[0] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2UnknownOnlineV.gif"));
            AbstractFaceplate.unknownIconV[1] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2UnknownOfflineV.gif"));
            AbstractFaceplate.opticalIconV[0] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2OptOnlineV.gif"));
            AbstractFaceplate.opticalIconV[1] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2OptOfflineV.gif"));
            AbstractFaceplate.opticalSmallIcon[0] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2OptOnline.gif"));
            AbstractFaceplate.opticalSmallIcon[1] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2OptOffline.gif"));
            AbstractFaceplate.copperSmallIcon[0] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2CuOnline.gif"));
            AbstractFaceplate.copperSmallIcon[1] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2CuOffline.gif"));
            AbstractFaceplate.unknownSmallIcon[0] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2UnknownOnline.gif"));
            AbstractFaceplate.unknownSmallIcon[1] = new ImageIcon(SbmUtilities.getImage("gbicSanbox2UnknownOffline.gif"));
            ONE_GIG_PORT = FabricTreeControl.getResource("S16Port.oneGig");
            TWO_GIG_PORT = FabricTreeControl.getResource("S16Port.twoGig");
            AUTO_SPEED_PORT = FabricTreeControl.getResource("S16Port.autoGig.short");
            AUTO_SPEED_PORT_LONG = FabricTreeControl.getResource("S16Port.autoGig");
            NOT_INSTALLED_STR = FabricTreeControl.getResource("FCPort.portNotInstalled");
            imagesNotRead = false;
        }
        this.fcSwitch = chassis;
        this.registerToListen();
        this.setupPopmenu();
        this.switchPropertiesItem.addActionListener(this);
        this.networkPropertiesItem.addActionListener(this);
        this.extCreditsItem.addActionListener(this);
        this.extCreditWizardItem.addActionListener(this);
        this.portPropertiesItem.addActionListener(this);
        this.portNameItem.addActionListener(this);
        this.portDiagnosticItem.addActionListener(this);
        this.refreshSwitchItem.addActionListener(this);
        this.selectAllPortsItem.addActionListener(this);
        this.exportNameServerItem.addActionListener(this);
        this.exportNameServerItem.setMnemonic('t');
        this.exportTrapLogItem.addActionListener(this);
        this.exportTrapLogItem.setMnemonic('x');
        this.loadFirmwareMenuItem.addActionListener(this);
        this.loadFirmwareMenuItem.setMnemonic('L');
        this.activateFirmwareMenuItem.addActionListener(this);
        this.activateFirmwareMenuItem.setMnemonic('v');
        this.firmwareFallbackMenuItem.addActionListener(this);
        this.firmwareFallbackMenuItem.setMnemonic('f');
        this.extCreditWizardMenuItem.addActionListener(this);
        this.extCreditWizardMenuItem.setMnemonic('c');
        this.userAccountsMenuItem.addActionListener(this);
        this.userAccountsMenuItem.setMnemonic('U');
        this.hotSwapWizardMenuItem.addActionListener(this);
        this.hotSwapWizardMenuItem.setMnemonic('h');
        this.setDateTimeMenuItem.addActionListener(this);
        this.setDateTimeMenuItem.setMnemonic('d');
        this.tempThresholdMenuItem.addActionListener(this);
        this.tempThresholdMenuItem.setMnemonic('h');
        this.toggleBeaconMenuItem.setSelected(false);
        this.toggleBeaconMenuItem.addActionListener(this);
        this.toggleBeaconMenuItem.setMnemonic('g');
        this.resetSwitchMenuItem.addActionListener(this);
        this.resetSwitchMenuItem.setMnemonic('e');
        this.hotResetMenuItem.addActionListener(this);
        this.hotResetMenuItem.setMnemonic('H');
        this.warmResetMenuItem.addActionListener(this);
        this.warmResetMenuItem.setMnemonic('R');
        this.hardResetMenuItem.addActionListener(this);
        this.hardResetMenuItem.setMnemonic('a');
        this.switchPropertiesMenuItem.addActionListener(this);
        this.switchPropertiesMenuItem.setMnemonic('w');
        this.switchArchiveMenuItem.addActionListener(this);
        this.switchArchiveMenuItem.setMnemonic('A');
        this.switchRestoreMenuItem.addActionListener(this);
        if (!this.fcSwitch.getDiscoveredByIpAddress()) {
            this.switchRestoreMenuItem.setEnabled(false);
        }
        this.switchRestoreMenuItem.setMnemonic('R');
        this.networkPropertiesMenuItem.addActionListener(this);
        this.networkPropertiesMenuItem.setMnemonic('N');
        this.extCreditsMenuItem.addActionListener(this);
        this.extCreditsMenuItem.setMnemonic('E');
        this.editZoningMenuItem.addActionListener(this);
        this.editZoningMenuItem.setMnemonic('E');
        this.editZoningConfigMenuItem.addActionListener(this);
        this.editZoningConfigMenuItem.setMnemonic('C');
        this.activateZoneSetMenuItem.addActionListener(this);
        this.activateZoneSetMenuItem.setMnemonic('A');
        this.deactivateZoneSetMenuItem.addActionListener(this);
        this.deactivateZoneSetMenuItem.setMnemonic('D');
        this.zoningWizardMenuItem.addActionListener(this);
        this.zoningWizardMenuItem.setMnemonic('Z');
        this.resetDefaultZoningMenuItem.addActionListener(this);
        this.resetDefaultZoningMenuItem.setMnemonic('R');
        this.resetToFactoryDefaultsMenuItem.addActionListener(this);
        this.resetToFactoryDefaultsMenuItem.setMnemonic('s');
        this.clearTrapLogMenuItem.addActionListener(this);
        this.clearTrapLogMenuItem.setMnemonic('C');
        this.configureTrapsMenuItem.addActionListener(this);
        this.configureTrapsMenuItem.setMnemonic('T');
        this.configureAlarmThresholdMenuItem.addActionListener(this);
        this.configureAlarmThresholdMenuItem.setMnemonic('C');
        this.resetPortMenuItem.addActionListener(this);
        this.resetPortMenuItem.setMnemonic('t');
        this.portPropertiesMenuItem.addActionListener(this);
        this.portPropertiesMenuItem.setMnemonic('r');
        this.portNameMenuItem.addActionListener(this);
        this.portNameMenuItem.setMnemonic('n');
        this.portDiagnosticMenuItem.addActionListener(this);
        this.portDiagnosticMenuItem.setMnemonic('L');
        if (currentView == null) {
            currentView = viewModesItem;
            UserPreferences userPreferences = UserPreferences.getInstance();
            String string = userPreferences.getPortView();
            if (string.equals("modes")) {
                currentView = viewModesItem;
                viewModesItem.setSelected(true);
                this.setMode(0);
            } else if (string.equals("states")) {
                currentView = viewStatesItem;
                viewStatesItem.setSelected(true);
                this.setMode(1);
            } else if (string.equals("speeds")) {
                currentView = viewSpeedsItem;
                viewSpeedsItem.setSelected(true);
                this.setMode(2);
            } else if (string.equals("media")) {
                currentView = viewMediaItem;
                viewMediaItem.setSelected(true);
                this.setMode(3);
            }
        }
        viewModesItem.addActionListener(this);
        viewStatesItem.addActionListener(this);
        viewSpeedsItem.addActionListener(this);
        viewMediaItem.addActionListener(this);
        this.addMouseListener(this);
        this.add(this.m_RendererPane);
    }

    protected void setupPopmenu() {
        this.popupMenu = new JPopupMenu();
        boolean bl = true;
        if (this.fcSwitch.getComAgent().getLoginInfo().getLevel() == 2 || this.fcSwitch.getComAgent().getLoginInfo().getLevel() == 0 || this.fcSwitch.getComAgent().getLoginInfo().getLevel() == 3) {
            bl = false;
        }
        this.popupMenu.add(this.refreshSwitchItem);
        if (this.fcSwitch instanceof SanboxChassis && !bl) {
            this.popupMenu.add(this.selectAllPortsItem);
            this.popupMenu.add(this.switchPropertiesItem);
            this.popupMenu.add(this.networkPropertiesItem);
            if (this.fcSwitch instanceof Sanbox2 && !(this.fcSwitch instanceof SwitchBlade)) {
                this.popupMenu.add(this.extCreditWizardItem);
            } else if (this.fcSwitch instanceof Sanbox) {
                this.popupMenu.add(this.extCreditsItem);
            }
            this.popupMenu.add(this.portPropertiesItem);
            if (this.fcSwitch instanceof Sanbox2) {
                this.popupMenu.add(this.portNameItem);
            }
            this.popupMenu.add(this.portDiagnosticItem);
        }
    }

    protected boolean isReadOnly() {
        return this.fcSwitch.getComAgent().getLoginInfo().getLevel() != 2 && this.fcSwitch.getComAgent().getLoginInfo().getLevel() != 0 && this.fcSwitch.getComAgent().getLoginInfo().getLevel() != 3;
    }

    public Vector getMenuBarExtension() {
        Vector<JMenu> vector = new Vector<JMenu>();
        JMenu jMenu = new JMenu(FabricTreeControl.getResource("AbstractFaceplate.switch"));
        boolean bl = this.isReadOnly();
        if (this.fcSwitch instanceof SanboxChassis) {
            Object object;
            if (!VendorProperties.getResource("vendor").equals("EMC")) {
                jMenu.add(this.switchArchiveMenuItem);
            }
            if (!bl) {
                if (!VendorProperties.getResource("vendor").equals("EMC")) {
                    jMenu.add(this.switchRestoreMenuItem);
                }
                if (this.fcSwitch instanceof Sanbox2) {
                    jMenu.add(this.userAccountsMenuItem);
                    jMenu.add(this.setDateTimeMenuItem);
                    if (!(this.fcSwitch instanceof Sanbox8000)) {
                        jMenu.add(this.tempThresholdMenuItem);
                    } else {
                        object = FabricList.getFabric((Chassis)this.fcSwitch);
                        if (((Sanbox8000)this.fcSwitch).equals(object.getConnectionSwitch())) {
                            jMenu.add(this.hotSwapWizardMenuItem);
                        }
                    }
                }
                jMenu.add(this.switchPropertiesMenuItem);
                jMenu.add(this.networkPropertiesMenuItem);
                jMenu.add(this.toggleBeaconMenuItem);
            }
            if (this.fcSwitch instanceof Sanbox) {
                jMenu.addSeparator();
                if (!bl) {
                    jMenu.add(this.clearTrapLogMenuItem);
                }
                jMenu.add(this.exportTrapLogItem);
                if (!bl) {
                    jMenu.add(this.configureTrapsMenuItem);
                }
            } else if (this.fcSwitch instanceof Sanbox2 && !bl && ((Sanbox2)this.fcSwitch).getFirmwareVersion() != 2) {
                jMenu.addSeparator();
                jMenu.add(this.configureAlarmThresholdMenuItem);
            }
            if (!bl) {
                jMenu.addSeparator();
                if (this.fcSwitch instanceof Sanbox2) {
                    if (((Sanbox2)this.fcSwitch).getFirmwareVersion() >= 3) {
                        jMenu.add(this.loadFirmwareMenuItem);
                    }
                    jMenu.add(this.activateFirmwareMenuItem);
                    jMenu.add(this.firmwareFallbackMenuItem);
                    jMenu.addSeparator();
                    if (((Sanbox2)this.fcSwitch).getFirmwareVersion() >= 6) {
                        object = new JMenu(FabricTreeControl.getResource("AbstractFaceplate.resetSwitch"));
                        ((JMenu)object).add(this.hotResetMenuItem);
                        ((JMenu)object).add(this.warmResetMenuItem);
                        ((JMenu)object).add(this.hardResetMenuItem);
                        ((AbstractButton)object).setMnemonic('e');
                        jMenu.add((JMenuItem)object);
                    } else {
                        jMenu.add(this.resetSwitchMenuItem);
                    }
                } else {
                    jMenu.add(this.resetSwitchMenuItem);
                }
                jMenu.add(this.resetToFactoryDefaultsMenuItem);
            }
            vector.add(jMenu);
            jMenu.setMnemonic('S');
        }
        if (!bl) {
            jMenu = new JMenu(FabricTreeControl.getResource("AbstractFaceplate.port"));
            if (this.fcSwitch instanceof SanboxChassis) {
                jMenu.add(this.portPropertiesMenuItem);
                if (this.fcSwitch instanceof Sanbox2 && !(this.fcSwitch instanceof SwitchBlade)) {
                    jMenu.add(this.extCreditWizardMenuItem);
                } else if (this.fcSwitch instanceof Sanbox) {
                    jMenu.add(this.extCreditsMenuItem);
                }
                if (this.fcSwitch instanceof Sanbox2) {
                    jMenu.add(this.portNameMenuItem);
                    jMenu.add(this.resetPortMenuItem);
                }
                jMenu.add(this.portDiagnosticMenuItem);
                vector.add(jMenu);
                jMenu.setMnemonic('P');
            }
        }
        if (!bl && this.fcSwitch instanceof SanboxChassis) {
            jMenu = new JMenu(FabricTreeControl.getResource("AbstractFaceplate.zoning"));
            jMenu.add(this.editZoningMenuItem);
            jMenu.add(this.editZoningConfigMenuItem);
            jMenu.add(this.activateZoneSetMenuItem);
            jMenu.add(this.deactivateZoneSetMenuItem);
            jMenu.add(this.resetDefaultZoningMenuItem);
            vector.add(jMenu);
            jMenu.setMnemonic('Z');
        }
        if (this.fcSwitch instanceof SanboxChassis) {
            jMenu = new JMenu(FabricTreeControl.getResource("AbstractFaceplate.view"));
            jMenu.add(viewModesItem);
            jMenu.add(viewStatesItem);
            jMenu.add(viewSpeedsItem);
            jMenu.add(viewMediaItem);
            vector.add(jMenu);
            jMenu.setMnemonic('V');
        }
        return vector;
    }

    public void setNameServerPanel(NameServerPanel nameServerPanel) {
        this.nameServerPanel = nameServerPanel;
    }

    public boolean placeFaceplateOnLeft() {
        return false;
    }

    protected void setFaceplateIcon(ImageIcon imageIcon) {
        this.faceplateIcon = imageIcon;
    }

    protected void setMode(int n) {
        mode = n;
        SwingUtilities.invokeLater(new RepaintFaceplateClass());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        if (this.faceplateIcon != null) {
            int n = 0;
            int n2 = 0;
            if (this.placeFaceplateOnLeft()) {
                n2 = 7;
            } else {
                n = 7;
            }
            dimension.setSize(this.faceplateIcon.getIconWidth() + n2, this.faceplateIcon.getIconHeight() + n);
        }
        return dimension;
    }

    void unregisterToListen() {
        if (this.fcSwitch != null) {
            this.fcSwitch.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
        }
    }

    void registerToListen() {
        if (this.fcSwitch != null) {
            this.fcSwitch.getEventHandler().addChassisEventListener((ChassisEventListener)this);
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        String string = VendorProperties.getFrameTitle();
        if (chassisEvent.getChassis() != this.fcSwitch) {
            chassisEvent.getChassis().getEventHandler().removeChassisEventListener((ChassisEventListener)this);
            return;
        }
        switch (chassisEvent.getEventType()) {
            case 306: {
                this.setupPopmenu();
                break;
            }
            case 289: {
                String string2 = chassisEvent.isSuccessful() ? FabricTreeControl.getResource("AbstractFaceplate.traceClearOk") : FabricTreeControl.getResource("AbstractFaceplate.traceClearFailed") + FabricTreeControl.translateErrorType(chassisEvent.getErrorType());
                SwingUtilities.invokeLater(new DisplayMessageRunnable(string2));
                break;
            }
            case 208: 
            case 241: 
            case 378: {
                this.fireStatusChanged();
                break;
            }
            case 260: {
                String string3 = chassisEvent.isSuccessful() ? FabricTreeControl.getResource("AbstractFaceplate.deactivateOk") : FabricTreeControl.getResource("AbstractFaceplate.deactivateFailed") + " " + FabricTreeControl.translateErrorType(chassisEvent.getErrorType());
                SwingUtilities.invokeLater(new DisplayMessageRunnable(string3));
                break;
            }
            case 353: {
                String string4 = chassisEvent.isSuccessful() ? FabricTreeControl.getResource("AbstractFaceplate.shutdownSwitchOk") : FabricTreeControl.getResource("AbstractFaceplate.shutdownSwitchFailed");
                SwingUtilities.invokeLater(new DisplayMessageRunnable(string4));
                break;
            }
            case 252: {
                String string5;
                int n;
                if (!this.kickedOffSwitchReset) {
                    return;
                }
                this.kickedOffSwitchReset = false;
                boolean bl = false;
                if (chassisEvent.getValue() instanceof Boolean) {
                    bl = (Boolean)chassisEvent.getValue();
                }
                ErrorType errorType = chassisEvent.getErrorType();
                if (!(chassisEvent.isSuccessful() || errorType instanceof UtilError && errorType.getError() == 107)) {
                    n = 0;
                    string5 = bl ? FabricTreeControl.getResource("AbstractFaceplate.hotResetFailed") + " " + FabricTreeControl.translateErrorType(chassisEvent.getErrorType()) : FabricTreeControl.getResource("AbstractFaceplate.resetFailed") + " " + FabricTreeControl.translateErrorType(chassisEvent.getErrorType());
                } else {
                    n = 1;
                    string5 = bl ? FabricTreeControl.getResource("AbstractFaceplate.hotResetOK") : FabricTreeControl.getResource("AbstractFaceplate.resetOK");
                }
                JFrame jFrame = SbmUtilities.getFrame(this);
                QMultiLineLabel qMultiLineLabel = new QMultiLineLabel(jFrame, string5);
                string = FabricTreeControl.getResource("AbstractFaceplate.resetSwitch");
                JOptionPane.showMessageDialog(jFrame, qMultiLineLabel, string, n);
                break;
            }
            case 259: {
                if (chassisEvent.isSuccessful()) break;
                String string6 = FabricTreeControl.getResource("AbstractFaceplate.portResetFailed") + FabricTreeControl.translateErrorType(chassisEvent.getErrorType());
                SwingUtilities.invokeLater(new DisplayMessageRunnable(string6));
                break;
            }
            case 276: {
                int n;
                String string7;
                if (!this.resettingDefZoning) {
                    return;
                }
                string = FabricTreeControl.getResource("AbstractFaceplate.resetDefaultZoning");
                if (chassisEvent.isSuccessful()) {
                    string7 = FabricTreeControl.getResource("AbstractFaceplate.resetDefZonesWorked");
                    n = 1;
                } else {
                    string7 = FabricTreeControl.getResource("AbstractFaceplate.resetDefZonesFailed") + FabricTreeControl.translateErrorType(chassisEvent.getErrorType());
                    n = 0;
                }
                SwingUtilities.invokeLater(new DisplayMessageRunnable(string, string7, n));
                this.resettingDefZoning = false;
                break;
            }
            case 246: {
                String string8 = !chassisEvent.isSuccessful() ? FabricTreeControl.getResource("AbstractFaceplate.resetToFactoryDefaultsFailed") + " " + FabricTreeControl.translateErrorType(chassisEvent.getErrorType()) : FabricTreeControl.getResource("AbstractFaceplate.resetToFactoryDefaultsOK");
                SwingUtilities.invokeLater(new DisplayMessageRunnable(string8));
                break;
            }
            case 310: {
                int n = ((SanboxChassis)this.fcSwitch).getSwitchBeaconStatus();
                if (n == 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AbstractFaceplate.this.toggleBeaconMenuItem.setSelected(true);
                        }
                    });
                    break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AbstractFaceplate.this.toggleBeaconMenuItem.setSelected(false);
                    }
                });
                break;
            }
            case 309: {
                int n = ((SanboxChassis)this.fcSwitch).getSwitchBeaconStatus();
                if (n == 1 && !this.toggleBeaconMenuItem.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AbstractFaceplate.this.toggleBeaconMenuItem.setSelected(true);
                        }
                    });
                    break;
                }
                if (n != 0 || !this.toggleBeaconMenuItem.isSelected()) break;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AbstractFaceplate.this.toggleBeaconMenuItem.setSelected(false);
                    }
                });
            }
        }
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new RepaintFaceplateClass());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.m_SelectionModel.setValueIsAdjusting(true);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        FCPort fCPort = this.getPort(n, n2);
        if (fCPort != null) {
            n3 = fCPort.getPortNumber();
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.changeSelection(false, false, n3, true);
            this.doPopupMenu(mouseEvent);
        } else {
            this.changeSelection(mouseEvent.isControlDown(), mouseEvent.isShiftDown(), n3, false);
            this.m_SelectionModel.setValueIsAdjusting(false);
        }
    }

    protected FCPort getPort(int n, int n2) {
        FCPort fCPort = null;
        int n3 = 0;
        if (this.fcSwitch instanceof SanboxChassis) {
            SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
            int n4 = 0;
            while (n4 < sanboxChassis.getPortCount()) {
                Rectangle rectangle;
                if ((rectangle = this.getPort(n3++)) != null && rectangle.contains(n, n2)) {
                    fCPort = sanboxChassis.getPort(n4);
                }
                ++n4;
            }
        }
        return fCPort;
    }

    private void changeSelection(boolean bl, boolean bl2, int n, boolean bl3) {
        int n2 = this.m_SelectionModel.getAnchorSelectionIndex();
        if (bl) {
            if (this.m_SelectionModel.isSelectedIndex(n)) {
                this.m_SelectionModel.removeSelectionInterval(n, n);
            } else {
                this.m_SelectionModel.addSelectionInterval(n, n);
            }
        } else if (bl2 && n2 != -1) {
            this.m_SelectionModel.setSelectionInterval(n2, n);
        } else if (n != -1) {
            if (!this.m_SelectionModel.isSelectedIndex(n)) {
                this.m_SelectionModel.setSelectionInterval(n, n);
            } else if (!bl3) {
                this.m_SelectionModel.setSelectionInterval(n, n);
            }
        } else {
            this.m_SelectionModel.clearSelection();
        }
        this.verifyPortTypeConsisent(n);
        this.fireSelectionChanged();
    }

    protected void verifyPortTypeConsisent(int n) {
    }

    protected void doPopupMenu(MouseEvent mouseEvent) {
        boolean bl = !this.m_SelectionModel.isSelectionEmpty();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.popupMenu.show(this, n, n2);
    }

    public void selectAllPorts() {
        int n = this.m_SelectionModel.getAnchorSelectionIndex();
        this.m_SelectionModel.setSelectionInterval(0, this.fcSwitch.getPortCount() - 1);
        this.verifyPortTypeConsisent(n);
        this.fireSelectionChanged();
    }

    protected boolean internalPortsSelected() {
        Vector vector = this.getSelectedPorts();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            S16Port s16Port = (S16Port)vector.elementAt(n2);
            if (s16Port.getPortNumber() > 0 && s16Port.getPortNumber() < 15) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Vector getSelectedPorts() {
        Vector<FCPort> vector = new Vector<FCPort>();
        if (this.fcSwitch instanceof SanboxChassis) {
            SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
            int n = sanboxChassis.getPortCount();
            int n2 = 0;
            while (n2 < n) {
                if (this.m_SelectionModel.isSelectedIndex(n2)) {
                    vector.addElement(sanboxChassis.getPort(n2));
                }
                ++n2;
            }
        }
        return vector;
    }

    public boolean handlePortViewCheckbox(Object object) {
        if (object == viewModesItem) {
            this.toggleViewItem(viewModesItem);
            this.setMode(0);
        } else if (object == viewStatesItem) {
            this.toggleViewItem(viewStatesItem);
            this.setMode(1);
        } else if (object == viewSpeedsItem) {
            this.toggleViewItem(viewSpeedsItem);
            this.setMode(2);
        } else if (object == viewMediaItem) {
            this.toggleViewItem(viewMediaItem);
            this.setMode(3);
        } else {
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block173: {
            Object object = actionEvent.getSource();
            JFrame jFrame = SbmUtilities.getFrame(this);
            if (jFrame == null) {
                return;
            }
            if (this.handlePortViewCheckbox(object)) {
                return;
            }
            if (object == this.exportNameServerItem) {
                this.exportNameServer();
                return;
            }
            if (object == this.exportTrapLogItem) {
                this.exportTrapLog();
                return;
            }
            if (!this.fcSwitch.isReachable()) {
                PopupDialog.showDialog(jFrame, 3, FabricTreeControl.getResource("AbstractFaceplate.unableToPerform"));
                return;
            }
            if (object == this.editZoningConfigMenuItem) {
                this.doEditZoningConfig();
            }
            if (object == this.editZoningMenuItem) {
                this.doZoning();
            } else if (object == this.activateZoneSetMenuItem) {
                SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
                Zones zones = sanboxChassis.getEportZoningDb();
                if (!this.zoningAllowed()) {
                    SwingUtilities.invokeLater(new DisplayMessageRunnable(FabricTreeControl.getResource("AbstractFaceplate.missingInformation")));
                    return;
                }
                ActivateZoneSetDialog activateZoneSetDialog = new ActivateZoneSetDialog((Frame)jFrame, sanboxChassis, zones);
                activateZoneSetDialog.setVisible(true);
            } else if (object == this.zoningWizardMenuItem) {
                if (this.fcSwitch instanceof SanboxChassis) {
                    Fabric fabric = FabricList.getFabric((Chassis)this.fcSwitch);
                    SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
                    Zones zones = sanboxChassis.getEportZoningDb();
                    ZoningWizard zoningWizard = new ZoningWizard(jFrame, fabric, (SanboxChassis)this.fcSwitch, (Zones)zones.clone());
                    zoningWizard.start();
                    if (zoningWizard.isFinishedOk()) {
                        ZoningDialog zoningDialog = ZoningDialog.zoningDialogFactory(jFrame, fabric, sanboxChassis, zoningWizard.getZones(), false);
                        if (sanboxChassis instanceof Sanbox) {
                            zoningDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.zoningDialogSanboxHelp"));
                        } else if (sanboxChassis instanceof Sanbox8000) {
                            zoningDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.zoningDialogSanbox8000Help"));
                        } else if (sanboxChassis instanceof Sanbox2) {
                            zoningDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.zoningDialogSanbox2Help"));
                        }
                        zoningDialog.setVisible(true);
                    }
                }
            } else if (object == this.deactivateZoneSetMenuItem) {
                if (JOptionPane.showConfirmDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.deactivateWarning"), FabricTreeControl.getResource("AbstractFaceplate.deactivate"), 0) == 0 && this.fcSwitch instanceof SanboxChassis) {
                    ((SanboxChassis)this.fcSwitch).applyDeactivateZoneSet();
                }
            } else if (object == this.resetToFactoryDefaultsMenuItem) {
                if (this.fcSwitch instanceof SanboxChassis && PopupDialog.showDialog(jFrame, 1, FabricTreeControl.getResource("AbstractFaceplate.resetToFactoryDefaults"), FabricTreeControl.getResource("AbstractFaceplate.resetToFactoryDefaultsWarning"))) {
                    ((SanboxChassis)this.fcSwitch).resetToFactoryDefaults();
                }
            } else if (object == this.switchPropertiesItem || object == this.switchPropertiesMenuItem) {
                Fabric fabric = FabricList.getFabric((Chassis)this.fcSwitch);
                if (this.fcSwitch instanceof SanboxChassis) {
                    try {
                        int n = this.fcSwitch.getChassisType();
                        switch (n) {
                            case 8: 
                            case 16: 
                            case 25: 
                            case 26: 
                            case 30: 
                            case 33: {
                                if (this.switchPropertiesDialogSB2 == null) {
                                    this.switchPropertiesDialogSB2 = new SwitchPropertiesDialogSanbox2(jFrame, true, (SanboxChassis)this.fcSwitch, fabric);
                                } else {
                                    this.switchPropertiesDialogSB2.resetDialog((SanboxChassis)this.fcSwitch, fabric);
                                }
                                this.switchPropertiesDialogSB2.setVisible(true);
                                break;
                            }
                            case 0: 
                            case 2: {
                                if (this.switchPropertiesDialogSB == null) {
                                    this.switchPropertiesDialogSB = new SwitchPropertiesDialogSanbox(jFrame, true, (SanboxChassis)this.fcSwitch, fabric);
                                } else {
                                    this.switchPropertiesDialogSB.resetDialog((SanboxChassis)this.fcSwitch, fabric);
                                }
                                this.switchPropertiesDialogSB.setVisible(true);
                            }
                        }
                    }
                    catch (DialogCreateException dialogCreateException) {
                        if (this.fcSwitch instanceof Sanbox && ((Sanbox)this.fcSwitch).hasUnsupportedFw()) {
                            JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.dialogError.oldFirmware"));
                            break block173;
                        }
                        if (this.fcSwitch instanceof Sanbox2 && ((Sanbox2)this.fcSwitch).hasUnsupportedFw()) {
                            JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.dialogError.oldFirmware"));
                            break block173;
                        }
                        JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.dialogError"));
                    }
                }
            } else if (object == this.extCreditsItem || object == this.extCreditsMenuItem) {
                int n = this.fcSwitch.getChassisType();
                switch (n) {
                    case 0: 
                    case 2: {
                        ExtCreditDialogSanbox extCreditDialogSanbox = new ExtCreditDialogSanbox(jFrame, true, (SanboxChassis)this.fcSwitch);
                        extCreditDialogSanbox.show();
                    }
                }
            } else if (object == this.networkPropertiesItem || object == this.networkPropertiesMenuItem) {
                Fabric fabric = FabricList.getFabric((Chassis)this.fcSwitch);
                if (this.fcSwitch instanceof SanboxChassis) {
                    try {
                        int n = this.fcSwitch.getChassisType();
                        switch (n) {
                            case 8: 
                            case 16: 
                            case 25: 
                            case 26: 
                            case 30: 
                            case 33: {
                                if (this.networkPropertiesDialogSB2 == null) {
                                    this.networkPropertiesDialogSB2 = new NetworkPropertiesDialogSanbox2(jFrame, true, (SanboxChassis)this.fcSwitch, fabric);
                                } else {
                                    this.networkPropertiesDialogSB2.resetDialog((SanboxChassis)this.fcSwitch, fabric);
                                }
                                this.networkPropertiesDialogSB2.setVisible(true);
                                break;
                            }
                            case 0: 
                            case 2: {
                                if (this.networkPropertiesDialogSB == null) {
                                    this.networkPropertiesDialogSB = new NetworkPropertiesDialogSanbox(jFrame, true, (SanboxChassis)this.fcSwitch, fabric);
                                } else {
                                    this.networkPropertiesDialogSB.resetDialog((SanboxChassis)this.fcSwitch, fabric);
                                }
                                this.networkPropertiesDialogSB.setVisible(true);
                            }
                        }
                    }
                    catch (DialogCreateException dialogCreateException) {
                        if (this.fcSwitch instanceof Sanbox && ((Sanbox)this.fcSwitch).hasUnsupportedFw()) {
                            JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.dialogError.oldFirmware"));
                            break block173;
                        }
                        if (this.fcSwitch instanceof Sanbox2 && ((Sanbox2)this.fcSwitch).hasUnsupportedFw()) {
                            JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.dialogError.oldFirmware"));
                            break block173;
                        }
                        JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.dialogError"));
                    }
                }
            } else if (object == this.loadFirmwareMenuItem && this.fcSwitch instanceof Sanbox2) {
                String string;
                String string2;
                QMultiLineLabel qMultiLineLabel;
                int n;
                if (fwLoadDialog == null) {
                    fwLoadDialog = new LoadFirmwareDialog(jFrame);
                }
                Sanbox2 sanbox2 = (Sanbox2)this.fcSwitch;
                fwLoadDialog.setSwitch(sanbox2);
                fwLoadDialog.setVisible(true);
                if (!fwLoadDialog.wasSuccessful()) {
                    return;
                }
                boolean bl = sanbox2.canNdcla();
                String string3 = "FlashLoad.uploadComplete";
                int n2 = 6;
                if (bl) {
                    n2 = 19;
                    string3 = string3 + "Ndcla";
                }
                if ((n = JOptionPane.showConfirmDialog(jFrame, qMultiLineLabel = new QMultiLineLabel(jFrame, string2 = FabricTreeControl.getResource(string3), 28, n2), string = FabricTreeControl.getResource("FlashLoad.title"), 0)) == 0) {
                    this.kickedOffSwitchReset = true;
                    if (bl) {
                        sanbox2.hotReset();
                    } else {
                        sanbox2.reset();
                    }
                }
            } else if (object == this.activateFirmwareMenuItem) {
                int n;
                Sanbox2 sanbox2 = (Sanbox2)this.fcSwitch;
                String string = sanbox2.getPendingVersionString();
                String string4 = sanbox2.getFlashVersionString();
                Date date = sanbox2.getPendingTimestamp();
                Date date2 = sanbox2.getFlashTimestamp();
                String string5 = FabricTreeControl.getResource("ActivateFw.pendingVerFmt");
                MessageFormat messageFormat = new MessageFormat(string5);
                String string6 = sanbox2.getPendingVersionString();
                StringBuffer stringBuffer = new StringBuffer(string6 == null ? "" : messageFormat.format(new Object[]{string6}) + "\n\n");
                boolean bl = sanbox2.canNdcla();
                if (bl) {
                    stringBuffer.append(FabricTreeControl.getResource("ActivateFw.hotReset"));
                    n = 19;
                } else {
                    stringBuffer.append(FabricTreeControl.getResource("ActivateFw.reset"));
                    n = 5;
                }
                stringBuffer.append("\n\n");
                if (string != null && string.equals(string4) && date != null && date.equals(date2)) {
                    stringBuffer.append(FabricTreeControl.getResource("ActivateFw.noPendingVer"));
                    n += 2;
                } else {
                    stringBuffer.append(FabricTreeControl.getResource("ActivateFw.continue"));
                }
                QMultiLineLabel qMultiLineLabel = new QMultiLineLabel(jFrame, stringBuffer.toString(), 28, n);
                String string7 = FabricTreeControl.getResource("ActivateFw.title");
                int n3 = JOptionPane.showConfirmDialog(jFrame, qMultiLineLabel, string7, 0);
                if (n3 == 0) {
                    this.kickedOffSwitchReset = true;
                    if (bl) {
                        sanbox2.hotReset();
                    } else {
                        sanbox2.reset();
                    }
                }
            } else if (object == this.firmwareFallbackMenuItem && this.fcSwitch instanceof Sanbox2) {
                Sanbox2 sanbox2 = (Sanbox2)this.fcSwitch;
                if (this.firmwareFallbackDialogSB2 == null) {
                    this.firmwareFallbackDialogSB2 = new FirmwareFallbackDialogSanbox2(jFrame, true, sanbox2);
                } else {
                    this.firmwareFallbackDialogSB2.resetDialog(sanbox2);
                }
                this.firmwareFallbackDialogSB2.setVisible(true);
                if (this.firmwareFallbackDialogSB2.fallbackCompleted()) {
                    int n;
                    String string;
                    String string8 = FabricTreeControl.getResource("FirmwareFallback.title");
                    boolean bl = sanbox2.canNdcla();
                    if (bl) {
                        string = FabricTreeControl.getResource("FirmwareFallback.hotResetRequired");
                        n = 19;
                    } else {
                        string = FabricTreeControl.getResource("FirmwareFallback.resetRequired");
                        n = 6;
                    }
                    QMultiLineLabel qMultiLineLabel = new QMultiLineLabel(jFrame, string, 28, n);
                    int n4 = JOptionPane.showConfirmDialog(jFrame, qMultiLineLabel, string8, 0);
                    if (n4 == 0) {
                        this.kickedOffSwitchReset = true;
                        if (bl) {
                            sanbox2.hotReset();
                        } else {
                            sanbox2.reset();
                        }
                    }
                }
            } else if ((object == this.extCreditWizardMenuItem || object == this.extCreditWizardItem) && this.fcSwitch instanceof Sanbox2) {
                if (this.fcSwitch instanceof SwitchBlade) {
                    return;
                }
                if (this.fcSwitch instanceof Sanbox8000) {
                    if (this.extCreditWizardSB8000 == null) {
                        this.extCreditWizardSB8000 = new ExtCreditWizardSanbox8000(jFrame, (Sanbox8000)this.fcSwitch);
                    } else {
                        this.extCreditWizardSB8000.resetWizard((Sanbox8000)this.fcSwitch);
                    }
                    this.extCreditWizardSB8000.start();
                } else {
                    if (this.extCreditWizardSB2 == null) {
                        this.extCreditWizardSB2 = new ExtCreditWizardSanbox2(jFrame, (Sanbox2)this.fcSwitch);
                    } else {
                        this.extCreditWizardSB2.resetWizard((Sanbox2)this.fcSwitch);
                    }
                    this.extCreditWizardSB2.start();
                }
            } else if (object == this.userAccountsMenuItem && this.fcSwitch instanceof Sanbox2) {
                if (this.userAccountDialogSB2 == null) {
                    this.userAccountDialogSB2 = new UserAccountDialogSanbox2(jFrame, true, (Sanbox2)this.fcSwitch);
                } else {
                    this.userAccountDialogSB2.resetDialog((Sanbox2)this.fcSwitch);
                }
                this.userAccountDialogSB2.setVisible(true);
            } else if (object == this.hotSwapWizardMenuItem && this.fcSwitch instanceof Sanbox8000Sml) {
                if (this.hotSwapWizard == null) {
                    this.hotSwapWizard = new HotSwapWizard(jFrame, (Sanbox8000Sml)this.fcSwitch);
                } else {
                    this.hotSwapWizard.resetWizard((Sanbox8000Sml)this.fcSwitch);
                }
                this.hotSwapWizard.start();
            } else if (object == this.setDateTimeMenuItem && this.fcSwitch instanceof Sanbox2) {
                if (this.dateTimeDialogSB2 == null) {
                    this.dateTimeDialogSB2 = new DateTimeDialogSanbox2(jFrame, true, (Sanbox2)this.fcSwitch);
                } else {
                    this.dateTimeDialogSB2.resetDialog((Sanbox2)this.fcSwitch);
                }
                this.dateTimeDialogSB2.setVisible(true);
            } else if (object == this.tempThresholdMenuItem && this.fcSwitch instanceof Sanbox2 && !(this.fcSwitch instanceof Sanbox8000)) {
                if (this.tempMonitoringDialogSB2 == null) {
                    this.tempMonitoringDialogSB2 = new TempMonitoringDialogSanbox2(jFrame, true, (Sanbox2)this.fcSwitch);
                } else {
                    this.tempMonitoringDialogSB2.resetDialog((Sanbox2)this.fcSwitch);
                }
                this.tempMonitoringDialogSB2.setVisible(true);
            } else if (object == this.toggleBeaconMenuItem && this.fcSwitch instanceof SanboxChassis) {
                int n = ((SanboxChassis)this.fcSwitch).getSwitchBeaconStatus();
                switch (n) {
                    case 1: {
                        ((SanboxChassis)this.fcSwitch).applyBeaconToggle(false);
                        break;
                    }
                    case 0: {
                        ((SanboxChassis)this.fcSwitch).applyBeaconToggle(true);
                        break;
                    }
                    default: {
                        ((SanboxChassis)this.fcSwitch).applyBeaconToggle(false);
                        break;
                    }
                }
            } else if (object == this.switchArchiveMenuItem) {
                this.archiveSwitch();
            } else if (object == this.switchRestoreMenuItem) {
                this.restoreSwitch();
            } else if (object == this.hotResetMenuItem) {
                String string = FabricTreeControl.getResource("AbstractFaceplate.hotResetWarning");
                QMultiLineLabel qMultiLineLabel = new QMultiLineLabel(jFrame, string, 28, 18);
                int n = JOptionPane.showConfirmDialog(jFrame, qMultiLineLabel, this.resetSwitchMenuItem.getText(), 0);
                if (n == 0 && this.fcSwitch instanceof SanboxChassis) {
                    this.kickedOffSwitchReset = true;
                    ((Sanbox2Sml)this.fcSwitch).hotReset();
                }
            } else if (object == this.resetSwitchMenuItem || object == this.warmResetMenuItem || object == this.hardResetMenuItem) {
                String string = FabricTreeControl.getResource("AbstractFaceplate.resetWarning");
                QMultiLineLabel qMultiLineLabel = new QMultiLineLabel(jFrame, string);
                int n = JOptionPane.showConfirmDialog(jFrame, qMultiLineLabel, this.resetSwitchMenuItem.getText(), 0);
                if (n == 0 && this.fcSwitch instanceof SanboxChassis) {
                    this.kickedOffSwitchReset = true;
                    if (object == this.hardResetMenuItem) {
                        ((Sanbox2Sml)this.fcSwitch).hardReset();
                    } else {
                        ((SanboxChassis)this.fcSwitch).reset();
                    }
                }
            } else if (object == this.configureTrapsMenuItem) {
                if (this.fcSwitch instanceof Sanbox) {
                    TrapConfigDialogSanbox trapConfigDialogSanbox = new TrapConfigDialogSanbox((Frame)jFrame, (Sanbox)this.fcSwitch);
                    trapConfigDialogSanbox.setVisible(true);
                }
            } else if (object == this.configureAlarmThresholdMenuItem) {
                if (this.fcSwitch instanceof Sanbox2) {
                    TrapConfigDialogSanbox2 trapConfigDialogSanbox2 = new TrapConfigDialogSanbox2((Frame)jFrame, (Sanbox2)this.fcSwitch);
                    trapConfigDialogSanbox2.setVisible(true);
                }
            } else if (object == this.clearTrapLogMenuItem) {
                if (this.fcSwitch instanceof Sanbox && JOptionPane.showConfirmDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.clearTrapLogMessage"), this.clearTrapLogMenuItem.getText(), 0) == 0) {
                    Sanbox sanbox = (Sanbox)this.fcSwitch;
                    sanbox.clearTrapLog();
                }
            } else if (object == this.portPropertiesItem || object == this.portPropertiesMenuItem) {
                Vector vector = this.getSelectedPorts();
                if (this.fcSwitch instanceof SanboxChassis) {
                    if (this.fcSwitch instanceof Sanbox2) {
                        if (this.internalPortsSelected() && this.fcSwitch.getChassisType() == 33) {
                            if (this.internalPortPropertiesDialogSwitchblade == null) {
                                this.internalPortPropertiesDialogSwitchblade = new InternalPortPropertiesDialogSwitchblade(jFrame, true, (SanboxChassis)this.fcSwitch, vector);
                            } else {
                                this.internalPortPropertiesDialogSwitchblade.resetDialog((SanboxChassis)this.fcSwitch, vector);
                            }
                            this.internalPortPropertiesDialogSwitchblade.show();
                        } else {
                            if (this.portPropertiesDialogSB2 == null) {
                                this.portPropertiesDialogSB2 = new PortPropertiesDialogSanbox2(jFrame, true, (SanboxChassis)this.fcSwitch, vector);
                            } else {
                                this.portPropertiesDialogSB2.resetDialog((SanboxChassis)this.fcSwitch, vector);
                            }
                            this.portPropertiesDialogSB2.show();
                        }
                    } else if (this.fcSwitch instanceof Sanbox) {
                        int n = vector.size();
                        int n5 = 0;
                        while (n5 < n) {
                            S43Port s43Port = (S43Port)vector.elementAt(n5);
                            if (s43Port.getPortStates() != null && s43Port.getPortStates().getPortType() == 6) {
                                PopupDialog.showDialog(jFrame, 3, FabricTreeControl.getResource("AbstractFaceplate.donorPortSelectedError"));
                                return;
                            }
                            ++n5;
                        }
                        if (this.portPropertiesDialogSB == null) {
                            this.portPropertiesDialogSB = new PortPropertiesDialogSanbox(jFrame, true, (SanboxChassis)this.fcSwitch, vector);
                        } else {
                            this.portPropertiesDialogSB.resetDialog((SanboxChassis)this.fcSwitch, vector);
                        }
                        this.portPropertiesDialogSB.show();
                    }
                }
            } else if (object == this.portNameItem || object == this.portNameMenuItem) {
                if (this.fcSwitch instanceof Sanbox2) {
                    S16Port s16Port = (S16Port)this.getSelectedPorts().elementAt(0);
                    if (this.portNameDialogSB2 == null) {
                        this.portNameDialogSB2 = new PortNameDialogSanbox2(jFrame, true, (SanboxChassis)this.fcSwitch, s16Port);
                    } else {
                        this.portNameDialogSB2.resetDialog((SanboxChassis)this.fcSwitch, s16Port);
                    }
                    this.portNameDialogSB2.show();
                }
            } else if (object == this.portDiagnosticItem || object == this.portDiagnosticMenuItem) {
                AbstractFaceplate.doPortTestDialog(jFrame, this.fcSwitch, this.getSelectedPorts(), false);
            } else if (object == this.resetPortMenuItem) {
                boolean bl;
                if (!(this.fcSwitch instanceof Sanbox2)) {
                    PopupDialog.showDialog(jFrame, 3, FabricTreeControl.getResource("AbstractFaceplate.portResetUnavailable"));
                    return;
                }
                Vector vector = this.getSelectedPorts();
                if (vector != null && vector.size() > 0 && (bl = PopupDialog.showDialog(jFrame, 1, FabricTreeControl.getResource("AbstractFaceplate.portResetDisrupt")))) {
                    int n = vector.size();
                    int n6 = 0;
                    while (n6 < n) {
                        FCPort fCPort = (FCPort)vector.elementAt(n6);
                        ((Sanbox2)this.fcSwitch).resetPort(fCPort.getPortNumber());
                        ++n6;
                    }
                }
            } else if (object == this.refreshSwitchItem) {
                this.fireDoRefresh();
            } else if (object == this.selectAllPortsItem) {
                this.selectAllPorts();
            } else if (object == this.resetDefaultZoningMenuItem) {
                this.resetDefaultZoning();
            }
        }
        this.fireCleanup();
    }

    public static void doPortTestDialog(JFrame jFrame, Chassis chassis, Vector vector, boolean bl) {
        FCPort fCPort = vector.size() >= 1 ? (FCPort)vector.elementAt(0) : chassis.getFirstPort();
        if (chassis instanceof Sanbox2) {
            if (((Sanbox2)chassis).getFirmwareVersion() == 2) {
                PortTestDialogSanbox2_1_03 portTestDialogSanbox2_1_03 = new PortTestDialogSanbox2_1_03(jFrame, true, (SanboxChassis)chassis, fCPort, bl);
                portTestDialogSanbox2_1_03.show();
            } else {
                PortTestDialogSanbox2_1_04 portTestDialogSanbox2_1_04 = new PortTestDialogSanbox2_1_04(jFrame, true, (SanboxChassis)chassis, fCPort, bl);
                portTestDialogSanbox2_1_04.show();
            }
        } else if (chassis instanceof Sanbox) {
            PortTestDialogSanbox portTestDialogSanbox = new PortTestDialogSanbox(jFrame, true, (SanboxChassis)chassis, fCPort);
            portTestDialogSanbox.show();
        }
    }

    public static void doPortProperties(JFrame jFrame, Chassis chassis, Vector vector) {
    }

    private void toggleViewItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        currentView.setSelected(jCheckBoxMenuItem == currentView);
        currentView = jCheckBoxMenuItem;
    }

    private void exportNameServer() {
        JFrame jFrame = SbmUtilities.getFrame(this);
        SbmUtilities.export(jFrame, VendorProperties.getFrameTitle(), this.nameServerPanel.exportData(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void archiveSwitch() {
        int n;
        File file;
        JFrame jFrame = SbmUtilities.getFrame(this);
        SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
        String string = UserPreferences.getInstance().getWorkingDirectory();
        QFileChooser qFileChooser = new QFileChooser(string);
        StringFileFilter stringFileFilter = new StringFileFilter(".xml");
        qFileChooser.setFileFilter(stringFileFilter);
        qFileChooser.addChoosableFileFilter(stringFileFilter);
        SanboxChassisArchiver sanboxChassisArchiver = sanboxChassis.getArchiver();
        JDocument jDocument = new JDocument();
        try {
            sanboxChassisArchiver.archiveSwitch(sanboxChassis, jDocument);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.missingInformation"));
            return;
        }
        if (qFileChooser.showSaveDialog(jFrame) != 0) return;
        String string2 = qFileChooser.getSelectedFile().toString();
        if (!string2.endsWith(".xml")) {
            string2 = string2 + ".xml";
        }
        if ((file = new File(string2)).exists() && (n = JOptionPane.showConfirmDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.theFile") + " " + string2 + " " + FabricTreeControl.getResource("AbstractFaceplate.overwriteIt"), FabricTreeControl.getResource("AbstractFaceplate.archiveTitle"), 0)) == 1) {
            return;
        }
        Cursor cursor = jFrame.getCursor();
        jFrame.setCursor(new Cursor(3));
        try {
            try {
                XMLOutputter xMLOutputter = new XMLOutputter();
                xMLOutputter.setNewlines(true);
                xMLOutputter.setIndent("    ");
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                xMLOutputter.output((Document)jDocument, (OutputStream)fileOutputStream);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("AbstractFaceplate.errorWriting") + " " + iOException.getMessage(), FabricTreeControl.getResource("AbstractFaceplate.archiveTitle"), 0);
                Object var14_17 = null;
                jFrame.setCursor(cursor);
                return;
            }
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            jFrame.setCursor(cursor);
            throw throwable;
        }
        jFrame.setCursor(cursor);
    }

    private void restoreSwitch() {
        SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
        if (!sanboxChassis.getDiscoveredByIpAddress()) {
            JFrame jFrame = SbmUtilities.getFrame(this);
            JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.nonConnectionSwitch"));
            return;
        }
        JFrame jFrame = SbmUtilities.getFrame(this);
        if (this.fcSwitch instanceof Sanbox2) {
            RestoreDialogSanbox2 restoreDialogSanbox2 = new RestoreDialogSanbox2(jFrame, true, (Sanbox2)this.fcSwitch);
            restoreDialogSanbox2.setVisible(true);
        }
    }

    private void exportTrapLog() {
        Sanbox sanbox = (Sanbox)this.fcSwitch;
        String string = sanbox.decodeLog();
        JFrame jFrame = SbmUtilities.getFrame(this);
        SbmUtilities.export(jFrame, VendorProperties.getFrameTitle(), string);
    }

    private void resetDefaultZoning() {
        String string = FabricTreeControl.getResource("AbstractFaceplate.resetDefZonesOk");
        String string2 = VendorProperties.getFrameTitle() + " - " + FabricTreeControl.getResource("AbstractFaceplate.resetDefaultZoning");
        JOptionPane jOptionPane = new JOptionPane(string, 1, 2);
        JDialog jDialog = jOptionPane.createDialog(this, string2);
        jDialog.setResizable(false);
        jDialog.show();
        Object object = jOptionPane.getValue();
        if (object == null || !(object instanceof Integer) || (Integer)object == 2) {
            return;
        }
        this.resettingDefZoning = true;
        if (this.fcSwitch instanceof SanboxChassis) {
            ((SanboxChassis)this.fcSwitch).resetDefaultZoning();
        }
    }

    public boolean zoningAllowed() {
        SanboxChassis sanboxChassis;
        Zones zones;
        return this.fcSwitch instanceof SanboxChassis && this.fcSwitch.getOverallStatus() != 3 && (zones = (sanboxChassis = (SanboxChassis)this.fcSwitch).getEportZoningDb()).getCurrentWithSwitch() && (this.fcSwitch.getComAgent().getLoginInfo().getLevel() == 2 || this.fcSwitch.getComAgent().getLoginInfo().getLevel() == 0 || this.fcSwitch.getComAgent().getLoginInfo().getLevel() == 3);
    }

    public void doEditZoningConfig() {
        block2: {
            if (!(this.fcSwitch instanceof SanboxChassis)) break block2;
            JFrame jFrame = SbmUtilities.getFrame(this);
            SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
            try {
                ZoningConfigDialog zoningConfigDialog = new ZoningConfigDialog(jFrame, sanboxChassis);
                zoningConfigDialog.setVisible(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                SwingUtilities.invokeLater(new DisplayMessageRunnable(FabricTreeControl.getResource("AbstractFaceplate.missingInformation")));
            }
        }
    }

    public void doZoning() {
        block9: {
            if (!(this.fcSwitch instanceof SanboxChassis)) break block9;
            JFrame jFrame = SbmUtilities.getFrame(this);
            SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
            Zones zones = sanboxChassis.getEportZoningDb();
            if (!this.zoningAllowed()) {
                SwingUtilities.invokeLater(new DisplayMessageRunnable(FabricTreeControl.getResource("AbstractFaceplate.missingInformation")));
                return;
            }
            if (zones.getErrorReading() && JOptionPane.showConfirmDialog(jFrame, FabricTreeControl.getResource("AbstractFaceplate.editWithErrorInZoning"), FabricTreeControl.getResource("AbstractFaceplate.editZoning"), 0) != 0) {
                return;
            }
            try {
                Fabric fabric = FabricList.getFabric((Chassis)sanboxChassis);
                ZoningDialog zoningDialog = ZoningDialog.zoningDialogFactory(jFrame, fabric, sanboxChassis, (Zones)zones.clone(), true);
                if (sanboxChassis instanceof Sanbox) {
                    zoningDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.zoningDialogSanboxHelp"));
                } else if (sanboxChassis instanceof Sanbox8000) {
                    zoningDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.zoningDialogSanbox8000Help"));
                } else if (sanboxChassis instanceof Sanbox2) {
                    zoningDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.zoningDialogSanbox2Help"));
                }
                zoningDialog.setVisible(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                SwingUtilities.invokeLater(new DisplayMessageRunnable(FabricTreeControl.getResource("AbstractFaceplate.notAllDataRead")));
            }
        }
    }

    protected String getPowerSupplyStatus() {
        String string;
        int n;
        int n2 = this.fcSwitch.getPowerSupplyCount();
        if (n2 == 0) {
            n = 4;
        } else {
            n = -1;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.fcSwitch.getPowerSupplyStatus(n3);
                n = n != 3 ? Math.max(n4, n) : n4;
                ++n3;
            }
        }
        switch (n) {
            case 0: {
                string = FabricTreeControl.getResource("AbstractFaceplate.powerStatusOk");
                break;
            }
            case 1: {
                string = FabricTreeControl.getResource("AbstractFaceplate.powerStatusWarning");
                break;
            }
            case 2: {
                string = FabricTreeControl.getResource("AbstractFaceplate.powerStatusCritical");
                break;
            }
            case 4: {
                string = FabricTreeControl.getResource("AbstractFaceplate.powerStatusNoSensors");
                break;
            }
            default: {
                string = FabricTreeControl.getResource("AbstractFaceplate.powerStatusUnknown");
            }
        }
        return string;
    }

    Vector getListeners() {
        return this.listeners;
    }

    void setListeners(Vector vector) {
        this.listeners = vector != null ? vector : new Vector();
    }

    public void removeListener(FaceplateListener faceplateListener) {
        if (this.listeners.contains(faceplateListener)) {
            this.listeners.remove(faceplateListener);
        }
    }

    public void addListener(FaceplateListener faceplateListener) {
        if (!this.listeners.contains(faceplateListener)) {
            this.listeners.add(faceplateListener);
        }
    }

    public void fireSelectionChanged() {
        Vector vector = this.getSelectedPorts();
        int n = 0;
        while (n < this.listeners.size()) {
            FaceplateListener faceplateListener = (FaceplateListener)this.listeners.elementAt(n);
            faceplateListener.portSelectionChanged(vector);
            ++n;
        }
        this.resetPortMenuItem.setEnabled(vector.size() > 0);
        this.portPropertiesMenuItem.setEnabled(vector.size() > 0);
        this.portPropertiesItem.setEnabled(vector.size() > 0);
        this.portNameMenuItem.setEnabled(vector.size() == 1);
        this.portNameItem.setEnabled(vector.size() == 1);
        this.portDiagnosticMenuItem.setEnabled(vector.size() > 0);
        this.portDiagnosticItem.setEnabled(vector.size() > 0);
        this.repaint();
    }

    public void fireCleanup() {
        int n = 0;
        while (n < this.listeners.size()) {
            FaceplateListener faceplateListener = (FaceplateListener)this.listeners.elementAt(n);
            faceplateListener.cleanupPopup();
            ++n;
        }
        this.repaint();
    }

    public void fireStatusChanged() {
        int n = 0;
        while (n < this.listeners.size()) {
            FaceplateListener faceplateListener = (FaceplateListener)this.listeners.elementAt(n);
            faceplateListener.statusChanged();
            ++n;
        }
        this.repaint();
    }

    public void fireDoRefresh() {
        int n = 0;
        while (n < this.listeners.size()) {
            FaceplateListener faceplateListener = (FaceplateListener)this.listeners.elementAt(n);
            faceplateListener.doRefresh();
            ++n;
        }
        this.repaint();
    }

    protected void paintFaceplate(Graphics graphics) {
        if (this.faceplateIcon != null) {
            this.faceplateIcon.paintIcon(this, graphics, 0, 0);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintFaceplate(graphics);
        if (this.fcSwitch != null && this.fcSwitch instanceof SanboxChassis) {
            SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
            int n = 0;
            while (n < sanboxChassis.getPortCount()) {
                Rectangle rectangle = this.getPort(n);
                if (rectangle != null) {
                    FCPort fCPort = sanboxChassis.getPort(n);
                    this.prepareRenderer(this.m_PortRenderer, fCPort);
                    this.m_RendererPane.paintComponent(graphics, this.m_PortRenderer, this, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.getPowerSupplyCount()) {
                this.paintPowerSupply(n2, graphics);
                ++n2;
            }
        }
    }

    protected abstract int getPowerSupplyCount();

    protected void paintPowerSupply(int n, Graphics graphics) {
    }

    protected void paintPowerSupply(int n, Graphics graphics, int n2, int n3, int n4, int n5) {
        SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
        Color color = graphics.getColor();
        int n6 = 4;
        if (n < sanboxChassis.getPowerSupplyCount()) {
            n6 = sanboxChassis.getPowerSupplyStatus(n);
        }
        switch (n6) {
            case 0: {
                break;
            }
            case 2: 
            case 3: {
                graphics.setColor(Color.red);
                Shape shape = graphics.getClip();
                graphics.setClip(n2, n3, n4 + 1, n5 + 1);
                graphics.drawRect(n2, n3, n4, n5);
                int n7 = n2 - n4;
                while (n7 < n2 + n4 + n5) {
                    graphics.drawLine(n7, n3, n7 + n5, n3 + n5);
                    graphics.drawLine(n7, n3, n7 - n5, n3 + n5);
                    n7 += 5;
                }
                graphics.setClip(shape.getBounds());
                break;
            }
            case 4: {
                graphics.setColor(Color.black);
                graphics.fillRect(n2, n3, n4, n5);
            }
        }
        graphics.setColor(color);
        graphics.setPaintMode();
    }

    protected void paintLeds(Graphics graphics) {
    }

    protected String getPortTypeString(int n) {
        String string = new String();
        switch (n) {
            case 6: {
                string = FabricTreeControl.getResource("AbstractFaceplate.donorPort");
                break;
            }
            case 7: {
                string = FabricTreeControl.getResource("AbstractFaceplate.ePort");
                break;
            }
            case 2: {
                string = FabricTreeControl.getResource("AbstractFaceplate.flPort");
                break;
            }
            case 1: {
                string = FabricTreeControl.getResource("AbstractFaceplate.fPort");
                break;
            }
            case 4: {
                string = FabricTreeControl.getResource("AbstractFaceplate.slPort");
                break;
            }
            case 5: {
                string = FabricTreeControl.getResource("AbstractFaceplate.tlPort");
                break;
            }
            case 3: {
                string = FabricTreeControl.getResource("AbstractFaceplate.tPort");
                break;
            }
            case 8: {
                string = FabricTreeControl.getResource("AbstractFaceplate.gPort");
                break;
            }
            case 9: {
                string = FabricTreeControl.getResource("AbstractFaceplate.glPort");
                break;
            }
            case 0: {
                string = FabricTreeControl.getResource("AbstractFaceplate.unknown");
                break;
            }
            default: {
                string = FabricTreeControl.getResource("AbstractFaceplate.inactivePort");
            }
        }
        return string;
    }

    protected String getPortModeString(FCPort fCPort) {
        String string = "";
        PortStates portStates = fCPort.getPortStates();
        if (portStates != null) {
            switch (portStates.getPortType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return this.getPortTypeString(portStates.getPortType());
                }
            }
            return this.getPortTypeString(portStates.getConfigPortType());
        }
        string = this.getPortTypeString(0);
        return string;
    }

    public static String getLongAdminPortSpeedString(FCPort fCPort) {
        if (fCPort instanceof S16Port && ((S16Port)fCPort).getAdminPortSpeed() == 3) {
            return AUTO_SPEED_PORT_LONG;
        }
        return AbstractFaceplate.getAdminPortSpeedString(fCPort);
    }

    public static String getAdminPortSpeedString(FCPort fCPort) {
        String string = FabricTreeControl.getResource("AbstractFaceplate.unknown");
        if (fCPort instanceof S16Port) {
            S16Port s16Port = (S16Port)fCPort;
            switch (s16Port.getAdminPortSpeed()) {
                case 2: {
                    return TWO_GIG_PORT;
                }
                case 1: {
                    return ONE_GIG_PORT;
                }
                case 3: {
                    return AUTO_SPEED_PORT;
                }
                case 0: {
                    return string;
                }
            }
            return string;
        }
        return ONE_GIG_PORT;
    }

    public static String getLongOperPortSpeedString(FCPort fCPort) {
        if (fCPort instanceof S16Port && ((S16Port)fCPort).getOperationalPortSpeed() == 3) {
            return AUTO_SPEED_PORT_LONG;
        }
        return AbstractFaceplate.getOperPortSpeedString(fCPort);
    }

    public static String getOperPortSpeedString(FCPort fCPort) {
        String string = FabricTreeControl.getResource("AbstractFaceplate.unknown");
        if (fCPort instanceof S16Port) {
            S16Port s16Port = (S16Port)fCPort;
            switch (s16Port.getOperationalPortSpeed()) {
                case 2: {
                    return TWO_GIG_PORT;
                }
                case 1: {
                    return ONE_GIG_PORT;
                }
                case 3: {
                    return AUTO_SPEED_PORT;
                }
                case 4: {
                    return NOT_INSTALLED_STR;
                }
                case 0: {
                    return string;
                }
            }
            return string;
        }
        return ONE_GIG_PORT;
    }

    protected String getPortStateString(FCPort fCPort) {
        String string = FabricTreeControl.getResource("AbstractFaceplate.unknown");
        PortStates portStates = fCPort.getPortStates();
        if (portStates == null) {
            return string;
        }
        if (this.fcSwitch instanceof Sanbox2) {
            block0 : switch (portStates.getOperationalAdminState()) {
                case 1: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portOn");
                    break;
                }
                case 2: 
                case 5: {
                    switch (portStates.getActiveAdminState()) {
                        case 1: {
                            string = FabricTreeControl.getResource("AbstractFaceplate.inactivePort");
                            break block0;
                        }
                        case 2: {
                            string = FabricTreeControl.getResource("AbstractFaceplate.portOff");
                        }
                    }
                    break;
                }
                case 3: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portTest");
                    break;
                }
                case 4: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portDown");
                    break;
                }
                case 6: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portIsolated");
                }
            }
        } else if (this.fcSwitch instanceof Sanbox) {
            switch (portStates.getOperationalAdminState()) {
                case 1: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portOn");
                    break;
                }
                case 2: {
                    switch (portStates.getActiveAdminState()) {
                        case 1: {
                            string = FabricTreeControl.getResource("AbstractFaceplate.inactivePort");
                            break;
                        }
                        case 2: {
                            string = FabricTreeControl.getResource("AbstractFaceplate.portOff");
                        }
                    }
                    break;
                }
                case 3: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portTest");
                    break;
                }
                case 4: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portDown");
                    break;
                }
                case 6: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portIsolated");
                }
            }
        }
        return string;
    }

    protected Color getPortStateColor(FCPort fCPort) {
        Color color = Color.gray;
        PortStates portStates = fCPort.getPortStates();
        if (portStates != null) {
            int n = this.fcSwitch.getChassisType();
            switch (portStates.getLoggedIn()) {
                case 0: {
                    color = this.inactiveColor;
                    break;
                }
                case 1: {
                    color = this.normalColor;
                    break;
                }
                default: {
                    color = this.inactiveColor;
                }
            }
        }
        return color;
    }

    protected Color getGbicModeColor(FCPort fCPort) {
        return this.getPortStateColor(fCPort);
    }

    protected Icon getGbicIcon(FCPort fCPort) {
        Icon icon = null;
        PortStates portStates = fCPort.getPortStates();
        if (portStates != null) {
            int n = portStates.getLoggedIn() == 1 ? 0 : 1;
            icon = this.getGbicIcon(fCPort, n);
        }
        return icon;
    }

    protected abstract Icon getGbicIcon(FCPort var1, int var2);

    protected Icon getGBICIcon(FCPort fCPort, int n) {
        switch (fCPort.getGbicType()) {
            case 3: 
            case 5: {
                return copperIcon[n];
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return opticalIcon[n];
            }
        }
        return null;
    }

    protected Icon getSFPIcon(FCPort fCPort, int n) {
        switch (fCPort.getGbicType()) {
            case 3: 
            case 5: {
                return copperSmallIcon[n];
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                return opticalSmallIcon[n];
            }
            case 7: 
            case 99: {
                return null;
            }
        }
        return unknownSmallIcon[n];
    }

    protected Icon getSFPIconV(FCPort fCPort, int n) {
        switch (fCPort.getGbicType()) {
            case 3: 
            case 5: {
                return copperIconV[n];
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                return opticalIconV[n];
            }
            case 7: 
            case 8: 
            case 99: {
                return null;
            }
        }
        return unknownIconV[n];
    }

    protected void preparePortModeRenderer(JLabel jLabel, FCPort fCPort) {
        jLabel.setIcon(null);
        jLabel.setText(this.getPortModeString(fCPort));
        jLabel.setBackground(this.getPortStateColor(fCPort));
    }

    protected void preparePortStateRenderer(JLabel jLabel, FCPort fCPort) {
        jLabel.setIcon(null);
        jLabel.setText(this.getPortStateString(fCPort));
        jLabel.setBackground(this.getPortStateColor(fCPort));
    }

    protected void preparePortSpeedRenderer(JLabel jLabel, FCPort fCPort) {
        jLabel.setIcon(null);
        jLabel.setText(AbstractFaceplate.getOperPortSpeedString(fCPort));
        jLabel.setBackground(this.getPortStateColor(fCPort));
    }

    protected void prepareGbicModeRenderer(JLabel jLabel, FCPort fCPort) {
        Icon icon = this.getGbicIcon(fCPort);
        if (icon == null) {
            jLabel.setIcon(null);
            jLabel.setText("");
        } else {
            jLabel.setIcon(icon);
            jLabel.setText(null);
        }
        jLabel.setBackground(this.getGbicModeColor(fCPort));
    }

    protected void prepareRenderer(JLabel jLabel, FCPort fCPort) {
        switch (mode) {
            case 0: {
                this.preparePortModeRenderer(jLabel, fCPort);
                break;
            }
            case 1: {
                this.preparePortStateRenderer(jLabel, fCPort);
                break;
            }
            case 2: {
                this.preparePortSpeedRenderer(jLabel, fCPort);
                break;
            }
            case 3: {
                this.prepareGbicModeRenderer(jLabel, fCPort);
            }
        }
        this.m_PortRenderer.setSelected(this.m_SelectionModel.isSelectedIndex(fCPort.getPortNumber()));
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        FCPort fCPort = this.getPort(mouseEvent.getX(), mouseEvent.getY());
        if (fCPort != null) {
            string = fCPort.toString() + " ";
            switch (mode) {
                case 0: {
                    string = string + this.getPortModeTooltip(fCPort);
                    break;
                }
                case 1: {
                    string = string + this.getPortStateTooltip(fCPort);
                    break;
                }
                case 2: {
                    string = string + this.getPortStateTooltip(fCPort);
                    break;
                }
                case 3: {
                    string = string + this.getGbicModeTooltip(fCPort);
                }
            }
        } else {
            string = this.getLedTooltip(mouseEvent.getX(), mouseEvent.getY());
        }
        return string;
    }

    protected String getPortModeTooltip(FCPort fCPort) {
        String string = "";
        PortStates portStates = fCPort.getPortStates();
        if (portStates != null) {
            switch (portStates.getPortType()) {
                case 7: {
                    string = FabricTreeControl.getResource("PortPropertiesDialog.ePortButton");
                    break;
                }
                case 6: {
                    string = FabricTreeControl.getResource("PortPropertiesDialog.donorPortButton");
                    break;
                }
                case 2: {
                    string = FabricTreeControl.getResource("PortPropertiesDialog.flPortButton");
                    break;
                }
                case 1: {
                    string = FabricTreeControl.getResource("PortPropertiesDialog.fPortButton");
                    break;
                }
                case 4: {
                    string = FabricTreeControl.getResource("PortPropertiesDialog.slPortButton");
                    break;
                }
                case 5: {
                    string = FabricTreeControl.getResource("PortPropertiesDialog.tlPortButton");
                    break;
                }
                case 3: {
                    string = FabricTreeControl.getResource("PortPropertiesDialog.tPortButton");
                    break;
                }
                case 8: {
                    string = FabricTreeControl.getResource("PortPropertiesDialog.gPortButton");
                    break;
                }
                case 9: {
                    string = FabricTreeControl.getResource("PortPropertiesDialog.glPortButton");
                    break;
                }
                case 0: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.inactivePort");
                }
            }
        } else {
            string = FabricTreeControl.getResource("AbstractFaceplate.unknown");
        }
        if (fCPort instanceof S16Port) {
            string = string + " " + AbstractFaceplate.getOperPortSpeedString(fCPort);
        }
        return string;
    }

    protected String getPortStateTooltip(FCPort fCPort) {
        String string = FabricTreeControl.getResource("AbstractFaceplate.portOff");
        PortStates portStates = fCPort.getPortStates();
        if (portStates != null) {
            block0 : switch (portStates.getOperationalAdminState()) {
                case 1: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portOn");
                    break;
                }
                case 2: {
                    switch (portStates.getActiveAdminState()) {
                        case 1: {
                            string = FabricTreeControl.getResource("AbstractFaceplate.inactivePort");
                            break block0;
                        }
                        case 2: {
                            string = FabricTreeControl.getResource("AbstractFaceplate.portOff");
                            break block0;
                        }
                    }
                    string = FabricTreeControl.getResource("AbstractFaceplate.portOff");
                    break;
                }
                case 3: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portTest");
                    break;
                }
                case 4: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portDown");
                    break;
                }
                case 6: {
                    string = FabricTreeControl.getResource("AbstractFaceplate.portIsolated");
                }
            }
        } else {
            string = FabricTreeControl.getResource("AbstractFaceplate.unknown");
        }
        if (fCPort instanceof S16Port) {
            string = string + " " + AbstractFaceplate.getOperPortSpeedString(fCPort);
        }
        return string;
    }

    protected String getGbicModeTooltip(FCPort fCPort) {
        String string = SbmUtilities.getGbicModeString(fCPort);
        if (fCPort instanceof S16Port) {
            string = string + " " + AbstractFaceplate.getOperPortSpeedString(fCPort);
        }
        return string;
    }

    protected String getLedTooltip(int n, int n2) {
        return null;
    }

    static {
        copperIcon = new ImageIcon[2];
        opticalIcon = new ImageIcon[2];
        unknownIcon = new ImageIcon[2];
        copperIconV = new ImageIcon[2];
        opticalIconV = new ImageIcon[2];
        unknownIconV = new ImageIcon[2];
        opticalSmallIcon = new ImageIcon[2];
        unknownSmallIcon = new ImageIcon[2];
        copperSmallIcon = new ImageIcon[2];
        imagesNotRead = true;
        viewModesItem = new JCheckBoxMenuItem(FabricTreeControl.getResource("AbstractFaceplate.viewModes"));
        viewStatesItem = new JCheckBoxMenuItem(FabricTreeControl.getResource("AbstractFaceplate.viewStates"));
        viewSpeedsItem = new JCheckBoxMenuItem(FabricTreeControl.getResource("AbstractFaceplate.viewSpeeds"));
        viewMediaItem = new JCheckBoxMenuItem(FabricTreeControl.getResource("AbstractFaceplate.viewMedia"));
        currentView = null;
    }

    class RepaintFaceplateClass
    implements Runnable {
        RepaintFaceplateClass() {
        }

        public void run() {
            AbstractFaceplate.this.repaint();
        }
    }

    class DisplayMessageRunnable
    implements Runnable {
        JFrame frame;
        int msgType = 1;
        String str;
        JOptionPane pane = new JOptionPane();
        String title = VendorProperties.getFrameTitle();

        public DisplayMessageRunnable(String string) {
            this.frame = SbmUtilities.getFrame(AbstractFaceplate.this);
            this.str = string;
        }

        public DisplayMessageRunnable(String string, String string2, int n) {
            this.frame = SbmUtilities.getFrame(AbstractFaceplate.this);
            this.str = string2;
            this.title = this.title + " - " + string;
            this.msgType = n;
        }

        public void run() {
            JDialog jDialog = this.pane.createDialog(this.frame, this.title);
            jDialog.setResizable(false);
            this.pane.setMessage(this.str);
            this.pane.setMessageType(this.msgType);
            jDialog.pack();
            jDialog.show();
        }
    }
}

