/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTableModel;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.ui.tools.SmartScrollingTable;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class BladeInfoPanel
extends JPanel
implements ChassisEventListener {
    FabricTableModel model = new FabricTableModel();
    JTable table = new SmartScrollingTable((TableModel)this.model);
    Chassis theSwitch = null;
    Vector bladeList = null;

    public BladeInfoPanel() {
        this.setEmptyTable();
        this.setLayout(new GridLayout(1, 1));
        this.table.getColumnModel().setColumnSelectionAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(3);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.add(jScrollPane);
    }

    public void setSelectedBlades(Vector vector) {
        if (this.theSwitch != null) {
            this.theSwitch.removeChassisEventListener((ChassisEventListener)this);
        }
        this.bladeList = vector;
        if (vector == null || vector.size() < 1) {
            this.theSwitch = null;
        } else {
            this.theSwitch = ((Sanbox8000Blade)vector.elementAt(0)).getChassis();
            this.theSwitch.addChassisEventListener((ChassisEventListener)this);
        }
        this.setupTable();
        this.fillTableData();
        this.repaint();
    }

    public void setEmptyTable() {
        this.model.setColumnCount(0);
        this.model.setRowCount(0);
    }

    public void setupTable() {
        Object object;
        this.setEmptyTable();
        if (this.theSwitch != null && this.theSwitch instanceof SanboxChassis) {
            object = (SanboxChassis)this.theSwitch;
            this.model.addColumn(object.getChassisName());
            int n = 0;
            while (n < this.bladeList.size()) {
                Sanbox8000Blade sanbox8000Blade = (Sanbox8000Blade)this.bladeList.elementAt(n);
                String string = this.getColumnName(sanbox8000Blade);
                this.model.addColumn(string);
                ++n;
            }
            this.model.addRow(FabricTreeControl.getResource("BladeInfoPanel.state"));
            this.model.addRow(FabricTreeControl.getResource("BladeInfoPanel.configAdminState"));
            this.model.addRow(FabricTreeControl.getResource("BladeInfoPanel.operState"));
            this.model.addRow(FabricTreeControl.getResource("BladeInfoPanel.diagnosticStatus"));
            this.model.addRow(FabricTreeControl.getResource("BladeInfoPanel.tempStatus"));
            this.model.addRow(FabricTreeControl.getResource("BladeInfoPanel.creditPool"));
            this.model.addRow(FabricTreeControl.getResource("BladeInfoPanel.serialNumber"));
            this.model.addRow(FabricTreeControl.getResource("BladeInfoPanel.zirconVersion"));
        } else {
            this.model.addColumn("No blades selected.");
        }
        object = this.table.getColumnModel();
        TableColumn tableColumn = object.getColumn(0);
        if (tableColumn != null) {
            tableColumn.setMinWidth(150);
        }
        int n = 1;
        while (n < this.table.getColumnCount()) {
            tableColumn = object.getColumn(n);
            ++n;
        }
    }

    private String getColumnName(Sanbox8000Blade sanbox8000Blade) {
        return sanbox8000Blade.toString();
    }

    public void fillTableData() {
        if (this.bladeList == null) {
            this.setEmptyTable();
            return;
        }
        int n = this.bladeList.size();
        String string = new String("<html><Font color=#ff0000>");
        int n2 = 0;
        while (n2 < n) {
            Sanbox8000Blade sanbox8000Blade = (Sanbox8000Blade)this.bladeList.elementAt(n2);
            String string2 = sanbox8000Blade.toString();
            int n3 = 0;
            n3 = 1;
            while (n3 < this.model.getColumnCount()) {
                if (this.model.getColumnName(n3).equals(string2)) break;
                ++n3;
            }
            if (n3 < this.model.getColumnCount()) {
                int n4 = 0;
                this.model.setValueAt(this.translateBladeState(sanbox8000Blade.getBladeState()), n4++, n3);
                this.model.setValueAt(this.translateBladeOperState(sanbox8000Blade.getBladeConfigState()), n4++, n3);
                if (sanbox8000Blade.getBladeState() != 3) {
                    this.model.setValueAt(this.translateBladeOperState(sanbox8000Blade.getBladeOperState()), n4++, n3);
                    this.model.setValueAt(this.translateBladeDiagStatus(sanbox8000Blade.getDiagStatus()), n4++, n3);
                    this.model.setValueAt(this.translateBladeTempStatus(sanbox8000Blade.getTempStatus()), n4++, n3);
                    this.model.setValueAt(Integer.toString(sanbox8000Blade.getUnusedCreditPool()), n4++, n3);
                    String string3 = sanbox8000Blade.getSerialNumber();
                    if (string3 == null) {
                        string3 = FabricTreeControl.getResource("BladeInfoPanel.na");
                    }
                    this.model.setValueAt(string3, n4++, n3);
                    string3 = sanbox8000Blade.getZirconVersion();
                    if (string3 == null) {
                        string3 = FabricTreeControl.getResource("BladeInfoPanel.na");
                    }
                    this.model.setValueAt(string3, n4++, n3);
                } else {
                    this.model.setValueAt(FabricTreeControl.getResource("BladeInfoPanel.na"), n4++, n3);
                    this.model.setValueAt(FabricTreeControl.getResource("BladeInfoPanel.na"), n4++, n3);
                    this.model.setValueAt(FabricTreeControl.getResource("BladeInfoPanel.na"), n4++, n3);
                    this.model.setValueAt(FabricTreeControl.getResource("BladeInfoPanel.na"), n4++, n3);
                    this.model.setValueAt(FabricTreeControl.getResource("BladeInfoPanel.na"), n4++, n3);
                    this.model.setValueAt(FabricTreeControl.getResource("BladeInfoPanel.na"), n4++, n3);
                }
            }
            ++n2;
        }
    }

    private String translateBladeState(int n) {
        switch (n) {
            case 2: {
                return FabricTreeControl.getResource("BladeState.bad");
            }
            case 1: {
                return FabricTreeControl.getResource("BladeState.good");
            }
            case 3: {
                return FabricTreeControl.getResource("BladeState.notInstalled");
            }
        }
        return FabricTreeControl.getResource("BladeState.unknown");
    }

    private String translateBladeOperState(int n) {
        switch (n) {
            case 0: {
                return FabricTreeControl.getResource("BladeOperState.online");
            }
            case 1: {
                return FabricTreeControl.getResource("BladeOperState.offline");
            }
            case 2: {
                return FabricTreeControl.getResource("BladeOperState.diag");
            }
            case 3: {
                return FabricTreeControl.getResource("BladeOperState.downed");
            }
            case 4: {
                return FabricTreeControl.getResource("BladeOperState.notInstalled");
            }
        }
        return FabricTreeControl.getResource("BladeOperState.unknown");
    }

    private String translateBladeDiagStatus(int n) {
        switch (n) {
            case 3: {
                return FabricTreeControl.getResource("BladeDiagStatus.compromised");
            }
            case 2: {
                return FabricTreeControl.getResource("BladeDiagStatus.failed");
            }
            case 1: {
                return FabricTreeControl.getResource("BladeDiagStatus.passed");
            }
        }
        return FabricTreeControl.getResource("BladeDiagStatus.unknown");
    }

    private String translateBladeTempStatus(int n) {
        switch (n) {
            case 0: {
                return FabricTreeControl.getResource("BladeTempStatus.unknown");
            }
            case 1: {
                return FabricTreeControl.getResource("BladeTempStatus.normal");
            }
            case 2: {
                return FabricTreeControl.getResource("BladeTempStatus.warm");
            }
            case 3: {
                return FabricTreeControl.getResource("BladeTempStatus.overheating");
            }
        }
        return FabricTreeControl.getResource("BladeDiagStatus.unknown");
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        switch (chassisEvent.getEventType()) {
            case 225: 
            case 330: {
                SwingUtilities.invokeLater(new FillTableClass());
            }
        }
    }

    class FillTableClass
    implements Runnable {
        FillTableClass() {
        }

        public void run() {
            BladeInfoPanel.this.fillTableData();
            BladeInfoPanel.this.repaint();
        }
    }
}

