/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.ForeignSwitch;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.device.fcfabric.event.FabricListEvent;
import com.qlogic.device.fcfabric.event.FabricListEventListener;
import com.qlogic.qms.fabric.AbstractFaceplate;
import com.qlogic.qms.fabric.LoginFabricDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DiagPort
extends Thread
implements FabricListEventListener,
FabricEventListener,
ChassisEventListener,
ActionListener {
    FabricList list;
    Fabric fab;
    String ip;
    String port;
    String user;
    String password;
    int events;
    LoginFabricDialog newFabricDialog;
    JFrame frame = new JFrame();
    Timer timer;

    public static void main(String[] stringArray) {
        DiagPort diagPort = new DiagPort();
        diagPort.run();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            this.timer.stop();
            this.timer = null;
            if (this.fab != null) {
                this.list.removeFabric(this.fab);
                this.fab = null;
                SwingUtilities.invokeLater(new NewFabDialog(this.frame, this.list));
            } else {
                System.exit(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Fabric fabric;
        this.list = FabricList.getInstance();
        this.list.addEventListener((FabricListEventListener)this);
        this.ip = System.getProperty("ip");
        this.port = System.getProperty("port");
        this.user = System.getProperty("username");
        if (this.user == null) {
            this.user = "";
        }
        this.password = System.getProperty("password");
        if (this.password == null) {
            this.password = "";
        }
        if (this.ip != null) {
            try {
                fabric = this.list.addFabric(InetAddress.getByName(this.ip), this.user, this.password);
                fabric.start();
                this.timer = new Timer(20000, this);
                this.timer.start();
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("Bad ip address " + this.ip);
                SwingUtilities.invokeLater(new NewFabDialog(this.frame, this.list));
            }
        } else {
            SwingUtilities.invokeLater(new NewFabDialog(this.frame, this.list));
        }
        fabric = this.list;
        synchronized (fabric) {
            try {
                this.list.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        switch (chassisEvent.getEventType()) {
            case 225: 
            case 269: {
                --this.events;
                if (this.events != 0) break;
                chassisEvent.getChassis().removeChassisEventListener((ChassisEventListener)this);
                this.cancelTimer();
                this.doDialog((SanboxChassis)chassisEvent.getChassis());
            }
        }
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        switch (fabricEvent.getEventType()) {
            case 2002: {
                Chassis chassis = (Chassis)fabricEvent.getValue();
                Fabric fabric = fabricEvent.getFabric();
                if (chassis.getDiscoveredByIpAddress() && chassis instanceof ForeignSwitch) {
                    fabricEvent.getFabric().removeEventListener((FabricEventListener)this);
                    this.list.removeFabric(fabricEvent.getFabric());
                    this.cancelTimer();
                    SwingUtilities.invokeLater(new NewFabDialog(this.frame, this.list));
                    return;
                }
                if (fabric.getConnectionSwitch() != chassis || !(chassis instanceof SanboxChassis)) break;
                this.events = 2;
                chassis.addChassisEventListener((ChassisEventListener)this);
            }
        }
    }

    public void cancelTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private void doDialog(SanboxChassis sanboxChassis) {
        SwingUtilities.invokeLater(new DoDialogClass(sanboxChassis));
    }

    public void receiveEvent(FabricListEvent fabricListEvent) {
        if (fabricListEvent.getEventType() == 5001) {
            this.fab = (Fabric)fabricListEvent.getValue();
            this.fab.addEventListener((FabricEventListener)this);
        }
        if (fabricListEvent.getEventType() == 5002) {
            this.fab = (Fabric)fabricListEvent.getValue();
            this.fab.removeEventListener((FabricEventListener)this);
            this.fab = null;
        }
    }

    public class DoDialogClass
    implements Runnable {
        SanboxChassis sb;

        public DoDialogClass(SanboxChassis sanboxChassis) {
            this.sb = sanboxChassis;
        }

        public void run() {
            int n;
            Vector<FCPort> vector = new Vector<FCPort>();
            if (DiagPort.this.port != null && (n = Integer.parseInt(DiagPort.this.port)) < this.sb.getPortCount()) {
                FCPort fCPort = this.sb.getPort(n);
                vector.add(fCPort);
            }
            AbstractFaceplate.doPortTestDialog(DiagPort.this.frame, (Chassis)this.sb, vector, true);
            System.exit(0);
        }
    }

    public class NewFabDialog
    implements Runnable {
        JFrame frame;
        FabricList list;

        public NewFabDialog(JFrame jFrame, FabricList fabricList) {
            this.frame = jFrame;
            this.list = fabricList;
        }

        public void run() {
            if (DiagPort.this.newFabricDialog == null) {
                DiagPort.this.newFabricDialog = new LoginFabricDialog((Frame)this.frame, this.list);
                DiagPort.this.newFabricDialog.setUserNameField(DiagPort.this.user);
                DiagPort.this.newFabricDialog.setPasswordField(DiagPort.this.password);
                DiagPort.this.newFabricDialog.setIpAddressField(DiagPort.this.ip);
                DiagPort.this.newFabricDialog.setModal(true);
                DiagPort.this.newFabricDialog.setVisible(true);
                if (DiagPort.this.newFabricDialog.getCancelled()) {
                    System.exit(0);
                } else {
                    DiagPort.this.user = DiagPort.this.newFabricDialog.getUserName();
                    DiagPort.this.password = DiagPort.this.newFabricDialog.getPassword();
                    InetAddress inetAddress = DiagPort.this.newFabricDialog.getInetAddress();
                    if (inetAddress != null) {
                        DiagPort.this.ip = inetAddress.getHostAddress();
                    }
                }
            }
        }
    }
}

