/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Director;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.Status;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.device.fcfabric.event.FabricListEvent;
import com.qlogic.device.fcfabric.event.FabricListEventListener;
import com.qlogic.device.fcfabric.event.FwLoadError;
import com.qlogic.device.fcfabric.event.GuiError;
import com.qlogic.device.fcfabric.event.SmlError;
import com.qlogic.device.fcfabric.event.UtilError;
import com.qlogic.qms.fabric.ChangePasswordDialog;
import com.qlogic.qms.fabric.CloseSessionsDialog;
import com.qlogic.qms.fabric.ComActivityDisplay;
import com.qlogic.qms.fabric.FaceplatePanel;
import com.qlogic.qms.fabric.FcFabricsFile;
import com.qlogic.qms.fabric.HelpAboutDialog;
import com.qlogic.qms.fabric.NewFabricDialog;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.SanSurferTreeNode;
import com.qlogic.qms.fabric.SanSurferTreeNodeRenderer;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.TopologyPanel;
import com.qlogic.qms.fabric.UserPreferences;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.InitialStartupDialog;
import com.qlogic.qms.fabric.propertyDialogs.UserPreferencesDialog;
import com.qlogic.ui.GenericFileFilter;
import com.qlogic.ui.MainFrame;
import com.qlogic.ui.QFileChooser;
import com.qlogic.ui.Topology;
import com.qlogic.ui.actions.LogoAction;
import com.qlogic.ui.eventBrowser.EventBrowser;
import com.qlogic.ui.eventBrowser.EventEntry;
import com.qlogic.ui.eventBrowser.EventList;
import com.qlogic.ui.tools.QLogicLogo;
import com.qlogic.ui.tools.TreeControl;
import com.qlogic.ui.topology.TopologySelectionEvent;
import com.qlogic.ui.topology.TopologySelectionListener;
import com.qlogic.ui.topology.TopologySelectionModel;
import com.qlogic.util.CommandInterpreter;
import com.qlogic.util.FinalizerPriority;
import com.qlogic.util.QHelpUtilities;
import com.qlogic.util.QMSJHelp;
import com.qlogic.util.StringUtilities;
import com.qlogic.util.Utilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FabricTreeControl
implements TreeControl,
FabricEventListener,
FabricListEventListener,
ChassisEventListener,
TreeSelectionListener {
    public static boolean DEBUG;
    private static final ResourceBundle resources;
    private static ResourceBundle vendors;
    private static final int TIMER_DELAY = 5000;
    private static final int MAX_FABRICS = 8;
    private static final String BUTTON_FONT_NAME = "dialog.bold";
    public static Font titleFont;
    private String applicationName;
    private String viewName;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private String treeName;
    private JSplitPane splitPane;
    private JPanel statusBar;
    private JLabel statusBarLabel;
    private JMenuBar menuBar;
    private Vector defaultToolBarItems;
    private Vector defaultMenuBarItems;
    private Vector defaultMenuBarItems2;
    private JToolBar toolBar;
    private JButton eventBrowserButton;
    private QMSJHelp hlp;
    private JMenuItem removeFabricItem;
    private JMenuItem rediscoverTopologyItem;
    private JMenuItem perfmonItem;
    private static final String TOPOLOGY_PANEL = "Topology Panel";
    private static final String FACEPLATE_PANEL = "Faceplate Panel";
    private static final String BLANK_PANEL = "Blank Panel";
    private JPanel sansurferPanel;
    private CardLayout sansurferLayout;
    private TopologyPanel topologyPanel;
    private FaceplatePanel faceplatePanel;
    private JPanel blankPanel;
    private FabricList fabricList;
    private static FabricTreeControl fabricTreeControl;
    private NewFabricDialog newFabricDialog;
    private CloseSessionsDialog closeSessionsDialog;
    private HelpAboutDialog helpAboutDialog;
    private QFileChooser fileChooser;
    private SwitchActivationListener switchActivationListener;
    private SwitchSelectionListener switchSelectionListener;
    private ComActivityDisplay comActivityDisplay;
    private boolean fabricRemoved;
    private boolean loadCmdLine;
    private EventList eventList;
    private EventBrowser eventBrowser;
    private boolean eventBrowserEnabled;

    private FabricTreeControl() {
        Object object;
        block7: {
            this.applicationName = VendorProperties.getApplicationName();
            this.viewName = "";
            this.treeName = FabricTreeControl.getResource("tree.rootName");
            this.defaultToolBarItems = new Vector();
            this.defaultMenuBarItems = new Vector();
            this.defaultMenuBarItems2 = new Vector();
            this.toolBar = new JToolBar();
            this.hlp = new QMSJHelp();
            this.removeFabricItem = new JMenuItem(FabricTreeControl.getResource("menu.fabric.remove"));
            this.rediscoverTopologyItem = new JMenuItem(FabricTreeControl.getResource("menu.fabric.rediscoverTopo"));
            this.perfmonItem = new JMenuItem(FabricTreeControl.getResource("menu.fabric.perfmon"));
            this.sansurferPanel = new JPanel();
            this.sansurferLayout = new CardLayout();
            this.blankPanel = new JPanel();
            this.comActivityDisplay = null;
            this.loadCmdLine = false;
            this.eventList = new EventList();
            this.eventBrowser = new EventBrowser(this.eventList);
            this.eventBrowserEnabled = true;
            try {
                titleFont = new Font("Dialog", 1, 14);
            }
            catch (InternalError internalError) {
                object = internalError.getMessage();
                if (internalError == null) break block7;
                System.err.println((String)object);
            }
        }
        this.setDebug();
        String string = FabricTreeControl.getResource("Finalizer.Priority");
        if (string != null) {
            FinalizerPriority.set(Integer.parseInt(string));
        }
        try {
            vendors = ResourceBundle.getBundle("companyId");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        WorldWideName.setVendors((ResourceBundle)vendors);
        object = new SanSurferTreeNode((Object)this.treeName, 0);
        this.treeModel = new DefaultTreeModel((TreeNode)object);
        this.tree = new JTree(this.treeModel){

            public void paint(Graphics graphics) {
                String string = VendorProperties.getResource("vendor");
                if (string == null || string.equals("qlogic")) {
                    this.setOpaque(false);
                    ImageIcon imageIcon = new ImageIcon(SbmUtilities.getImage("tree_simplify.gif"));
                    Dimension dimension = this.getSize();
                    int n = 0;
                    while (n < dimension.width) {
                        int n2 = 0;
                        while (n2 < dimension.height) {
                            graphics.drawImage(imageIcon.getImage(), n, n2, null, null);
                            n2 += imageIcon.getIconHeight();
                        }
                        n += imageIcon.getIconWidth();
                    }
                }
                super.paint(graphics);
            }
        };
        this.tree.setCellRenderer(new SanSurferTreeNodeRenderer(null));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        JButton jButton = new JButton(new AddFabricAction(FabricTreeControl.getResource("toolbar.addFabric"), "NewFabric24Disabled.gif"));
        jButton.setToolTipText(FabricTreeControl.getResource("toolbar.addFabricToolTip"));
        jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("NewFabric24.gif")));
        SbmUtilities.setButtonParameters(jButton);
        this.defaultToolBarItems.add(jButton);
        jButton = new JButton(new OpenFabricsAction(FabricTreeControl.getResource("toolbar.openView"), "Open24Disabled.gif"));
        jButton.setToolTipText(FabricTreeControl.getResource("toolbar.openViewToolTip"));
        jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("Open24.gif")));
        SbmUtilities.setButtonParameters(jButton);
        this.defaultToolBarItems.add(jButton);
        jButton = new JButton(new SaveFabricsAsAction(FabricTreeControl.getResource("toolbar.saveViewAs"), "SaveAs24Disabled.gif"));
        jButton.setToolTipText(FabricTreeControl.getResource("toolbar.saveFabricsAsToolTip"));
        jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("SaveAs24.gif")));
        SbmUtilities.setButtonParameters(jButton);
        this.defaultToolBarItems.add(jButton);
        jButton = new JButton(new RefreshAction(FabricTreeControl.getResource("toolbar.refresh"), "Refresh24Disabled.gif"));
        jButton.setToolTipText(FabricTreeControl.getResource("toolbar.refreshFabricToolTip"));
        jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("Refresh24.gif")));
        SbmUtilities.setButtonParameters(jButton);
        this.defaultToolBarItems.add(jButton);
        this.eventBrowserButton = new JButton(new ShowEventsAction(FabricTreeControl.getResource("toolbar.showEvents"), "Events24Disabled.gif"));
        this.eventBrowserButton.setToolTipText(FabricTreeControl.getResource("toolbar.showEventsToolTip"));
        this.eventBrowserButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("Events24.gif")));
        this.eventBrowserButton.setEnabled(this.getEventBrowserEnabled());
        SbmUtilities.setButtonParameters(this.eventBrowserButton);
        this.defaultToolBarItems.add(this.eventBrowserButton);
        if (DEBUG) {
            jButton = new JButton(new DebugAction("Debug", "Debug24.gif"));
            jButton.setToolTipText("Debug");
            jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("Debug24.gif")));
            SbmUtilities.setButtonParameters(jButton);
            this.defaultToolBarItems.add(jButton);
        }
        if (!VendorProperties.getResource("vendor").equals("EMC")) {
            jButton = new JButton(new HelpAction(FabricTreeControl.getResource("toolbar.help"), "Help24Disabled.gif"));
            jButton.setToolTipText(FabricTreeControl.getResource("toolbar.helpFabricToolTip"));
            jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("Help24.gif")));
            SbmUtilities.setButtonParameters(jButton);
            this.defaultToolBarItems.add(jButton);
        }
        this.rebuildToolBar(true);
        this.removeFabricItem.addActionListener(new RemoveFabricAction());
        this.rediscoverTopologyItem.addActionListener(new RediscoverTopologyAction());
        this.perfmonItem.addActionListener(new PerfmonAction());
        this.menuBar = new JMenuBar();
        this.createDefaultMenuBarItems();
        this.createDefaultMenuBarItems2();
        this.rebuildMenuBar(null);
        this.statusBar = new JPanel();
        this.statusBarLabel = new JLabel(this.applicationName);
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.add((Component)this.statusBarLabel, "West");
        this.fabricList = FabricList.getInstance();
        this.fabricList.addEventListener((FabricListEventListener)this);
        this.sansurferPanel.setLayout(this.sansurferLayout);
        this.sansurferPanel.add((Component)this.blankPanel, BLANK_PANEL);
        this.switchActivationListener = new SwitchActivationListener();
        this.switchSelectionListener = new SwitchSelectionListener();
        this.removeFabricItem.setEnabled(false);
        this.rediscoverTopologyItem.setEnabled(false);
        this.perfmonItem.setEnabled(false);
        this.comActivityDisplay = new ComActivityDisplay(this, this.applicationName);
    }

    public static FabricTreeControl instance() {
        if (fabricTreeControl == null) {
            fabricTreeControl = new FabricTreeControl();
            String string = VendorProperties.getResource("application.titleBarIcon");
            if (string != null) {
                MainFrame.instance().setIconImage(SbmUtilities.getImage(string));
            }
            FabricUtilities.logMessage((String)(VendorProperties.getApplicationName() + " was started."), (Level)Level.INFO, (String)fabricTreeControl.getClass().getName(), (String)"instance()");
            FabricUtilities.logMessage((String)("User is: " + System.getProperty("user.name")), (Level)Level.INFO, (String)fabricTreeControl.getClass().getName(), (String)"instance()");
        }
        return fabricTreeControl;
    }

    private void createDefaultMenuBarItems() {
        SanSurferTreeNode sanSurferTreeNode;
        JMenu jMenu = new JMenu(FabricTreeControl.getResource("menu.file"));
        JMenu jMenu2 = new JMenu(FabricTreeControl.getResource("menu.fabric"));
        this.defaultMenuBarItems.removeAllElements();
        this.defaultMenuBarItems.add(jMenu);
        JMenuItem jMenuItem = jMenu.add(new OpenFabricsAction());
        jMenuItem.setMnemonic('O');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem = jMenu.add(new SaveFabricsAsAction());
        jMenuItem.setMnemonic('A');
        jMenuItem = jMenu.add(new ChangePasswordAction());
        jMenuItem.setMnemonic('D');
        if (!VendorProperties.getResource("vendor").equals("EMC")) {
            jMenuItem = jMenu.add(new UserPreferencesAction());
            jMenuItem.setMnemonic('P');
        }
        jMenu.addSeparator();
        jMenuItem = jMenu.add(new ExitAction());
        jMenuItem.setMnemonic('x');
        jMenu.setMnemonic('F');
        this.defaultMenuBarItems.add(jMenu2);
        jMenuItem = jMenu2.add(new AddFabricAction());
        jMenuItem.setMnemonic('A');
        jMenuItem = jMenu2.add(this.removeFabricItem);
        jMenuItem.setMnemonic('R');
        boolean bl = false;
        String string = Utilities.getProperty((String)"perfmon.option");
        if (string != null && string.equals("true")) {
            bl = true;
        }
        if ((sanSurferTreeNode = this.getSelectedNode()) != null && sanSurferTreeNode.getNodeType() == 1) {
            jMenu2.addSeparator();
            jMenuItem = jMenu2.add(this.rediscoverTopologyItem);
            jMenuItem.setMnemonic('d');
            if (bl) {
                jMenuItem = jMenu2.add(this.perfmonItem);
                jMenuItem.setMnemonic('t');
            }
            jMenuItem = jMenu2.add(new ShowEventsAction());
            jMenuItem.setMnemonic('e');
            jMenuItem.setEnabled(this.getEventBrowserEnabled());
        }
        jMenu2.setMnemonic('b');
    }

    private void createDefaultMenuBarItems2() {
        JMenu jMenu = new JMenu(FabricTreeControl.getResource("menu.view"));
        JMenu jMenu2 = new JMenu(FabricTreeControl.getResource("menu.help"));
        this.defaultMenuBarItems2.removeAllElements();
        this.defaultMenuBarItems2.add(jMenu);
        JMenuItem jMenuItem = jMenu.add(new RefreshAction());
        jMenuItem.setMnemonic('R');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        jMenu.setMnemonic('V');
        if (DEBUG) {
            JMenu jMenu3 = new JMenu("Debug");
            this.defaultMenuBarItems2.add(jMenu3);
            jMenu3.add(new DebugAction());
        }
        this.defaultMenuBarItems2.add(jMenu2);
        if (!VendorProperties.getResource("vendor").equals("EMC")) {
            jMenuItem = jMenu2.add(new HelpAction());
            jMenuItem.setMnemonic('H');
        }
        jMenuItem = jMenu2.add(new HelpAboutAction());
        jMenuItem.setMnemonic('A');
        jMenu2.setMnemonic('H');
    }

    public CommandInterpreter getCommandInterpreter() {
        return null;
    }

    public static String getResource(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String translateErrorType(ErrorType errorType) {
        if (errorType == null) {
            return FabricTreeControl.getResource("ErrorType.none");
        }
        if (errorType instanceof UtilError) {
            switch (errorType.getError()) {
                case 100: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_RAW");
                }
                case 101: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_READY_TO_SEND");
                }
                case 102: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_SENT_READ_TO_RECIEVE");
                }
                case 103: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_RECEIVED_OK");
                }
                case 104: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_RECEIVED_ERROR_CODE");
                }
                case 105: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_RECEIVED_BAD_DATA");
                }
                case 106: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_RECEIVED_WRONG_SEQUENCE_NUMBER");
                }
                case 107: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_TIMED_OUT");
                }
                case 108: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_UNABLE_TO_SEND");
                }
                case 109: {
                    return FabricTreeControl.getResource("UtilErrorType.MS_NO_CONNECTION");
                }
                case 0: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_NO_ERRORS");
                }
                case 1: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_UNKNOWN_MESSAGE_ERROR");
                }
                case 2: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_BAD_DATA_ERROR");
                }
                case 3: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_FLASH_LOAD_FAIL");
                }
                case 4: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_MKII_INTERNAL_ERROR");
                }
                case 5: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_LOGIN_BUSY");
                }
                case 6: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_REJECTED_NOT_ONLINE");
                }
                case 7: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_REJECTED_PORT_INCORRECT_STATE");
                }
                case 8: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_REJECTED_ANOTHER_TEST_ACTIVE");
                }
                case 9: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_CPU_NOT_ABLE_TO_PERFORM");
                }
                case 10: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_SAVED_DATA_INVALID");
                }
                case 11: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_ZONING_DATA_INVALID");
                }
                case 12: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_UNABLE_TO_ROUTE");
                }
                case 14: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_LOGIN_REQUIRED");
                }
                case 13: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_VERSION_NOT_SUPPORTED");
                }
                case 15: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_NO_ENTRY_SWITCH_SESSION");
                }
                case 16: {
                    return FabricTreeControl.getResource("UtilErrorType.EC_NON_QLOGIC_QWITCH");
                }
            }
            return FabricTreeControl.getResource("UtilErrorType.unknown") + errorType.getError();
        }
        if (errorType instanceof GuiError) {
            GuiError guiError = (GuiError)errorType;
            switch (errorType.getError()) {
                case 104: {
                    return FabricTreeControl.getResource("GuiErrorType.receivedAlarm") + " " + guiError.getDesc() + "\"";
                }
                case 102: {
                    return FabricTreeControl.getResource("GuiErrorType.timedOutPollingActiveZoneSet");
                }
                case 100: {
                    return FabricTreeControl.getResource("GuiErrorType.userCanceled");
                }
                case 101: {
                    return FabricTreeControl.getResource("GuiErrorType.outOfMemory");
                }
                case 106: {
                    return FabricTreeControl.getResource("GuiErrorType.errorInFile");
                }
                case 105: {
                    return FabricTreeControl.getResource("GuiErrorType.noEventReceived");
                }
                case 107: {
                    return FabricTreeControl.getResource("GuiErrorType.errorParsingResponse");
                }
            }
            return FabricTreeControl.getResource("GuiErrorType.unknown") + Integer.toString(errorType.getError());
        }
        if (errorType instanceof SmlError) {
            switch (errorType.getError()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: {
                    String string = Integer.toString(errorType.getError(), 16);
                    return FabricTreeControl.getResource("SmlErrorType.0x" + string);
                }
            }
            String string = Integer.toString(errorType.getError(), 16);
            return FabricTreeControl.getResource("SmlErrorType.unknown") + string;
        }
        if (errorType instanceof FwLoadError) {
            return FabricTreeControl.getResource("FwLoadError." + errorType.getError());
        }
        return FabricTreeControl.getResource("ErrorType.unknown") + " " + errorType.getError();
    }

    private QFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new QFileChooser();
            this.fileChooser.setSelectedFile(new File("default.fab"));
            String string = FabricTreeControl.getResource("FabricTreeControl.fabricFileDescription");
            GenericFileFilter genericFileFilter = new GenericFileFilter("fab", string);
            this.fileChooser.addChoosableFileFilter(genericFileFilter);
        }
        return this.fileChooser;
    }

    private SanSurferTreeNode getSelectedNode() {
        SanSurferTreeNode sanSurferTreeNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            sanSurferTreeNode = (SanSurferTreeNode)treePath.getLastPathComponent();
        }
        return sanSurferTreeNode;
    }

    private void checkSelected() {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (sanSurferTreeNode != null) {
            switch (sanSurferTreeNode.getNodeType()) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 99: {
                    bl3 = true;
                }
            }
        }
        this.removeFabricItem.setEnabled(bl2 || bl3);
        this.rediscoverTopologyItem.setEnabled(bl2);
        this.perfmonItem.setEnabled(bl2);
    }

    private void setDebug() {
        DEBUG = false;
        String string = FabricTreeControl.getResource("DEBUG");
        if (string != null) {
            DEBUG = string.toLowerCase().equals("true");
        }
    }

    private void addFabric() {
        if (this.newFabricDialog == null) {
            this.newFabricDialog = new NewFabricDialog((Frame)MainFrame.instance(), this.fabricList);
            this.newFabricDialog.setModal(true);
        }
        this.newFabricDialog.setVisible(true);
    }

    private void invokePerfmon() {
        String string;
        File file;
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        SanSurferTreeNode sanSurferTreeNode2 = null;
        Fabric fabric = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (sanSurferTreeNode != null) {
            switch (sanSurferTreeNode.getNodeType()) {
                case 1: {
                    fabric = (Fabric)sanSurferTreeNode.getUserObject();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 99: {
                    sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getParent();
                    fabric = (Fabric)sanSurferTreeNode2.getUserObject();
                    break;
                }
            }
            if (fabric != null) {
                string2 = "-Dip=" + fabric.getIpAddr().getHostAddress();
                string3 = "-Dlogin=" + fabric.getUserName();
                string4 = "-Dpasswd=" + fabric.getPassword();
            }
        }
        if (!(file = new File(string = this.getPerfmonPath())).exists()) {
            PopupDialog.showDialog((Frame)MainFrame.instance(), 3, FabricTreeControl.getResource("menu.fabric.perfmon.notFound"));
            return;
        }
        String[] stringArray = null;
        stringArray = fabric == null ? new String[]{string} : new String[]{string, string2, string3, string4};
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(stringArray);
        }
        catch (IOException iOException) {
            PopupDialog.showDialog((Frame)MainFrame.instance(), 3, FabricTreeControl.getResource("menu.fabric.perfmon.failed"));
        }
    }

    private String getPerfmonPath() {
        String string = Utilities.getProperty((String)"perfmon.installDir");
        String string2 = Utilities.getProperty((String)"perfmon.executable");
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "SANsurferFabricView";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith(File.separator)) {
            stringBuffer.append(File.separator);
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private void rediscover() {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        SanSurferTreeNode sanSurferTreeNode2 = null;
        Fabric fabric = null;
        if (sanSurferTreeNode != null) {
            switch (sanSurferTreeNode.getNodeType()) {
                case 1: {
                    fabric = (Fabric)sanSurferTreeNode.getUserObject();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 99: {
                    sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getParent();
                    fabric = (Fabric)sanSurferTreeNode2.getUserObject();
                    break;
                }
            }
        }
        if (fabric != null) {
            fabric.rediscover();
        }
    }

    private void removeFabric() {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        SanSurferTreeNode sanSurferTreeNode2 = null;
        Fabric fabric = null;
        if (sanSurferTreeNode != null) {
            switch (sanSurferTreeNode.getNodeType()) {
                case 1: {
                    fabric = (Fabric)sanSurferTreeNode.getUserObject();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 99: {
                    sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getParent();
                    fabric = (Fabric)sanSurferTreeNode2.getUserObject();
                    break;
                }
            }
        }
        if (fabric == null) {
            return;
        }
        if (fabric.hasSanbox2()) {
            if (this.closeSessionsDialog == null) {
                this.closeSessionsDialog = new CloseSessionsDialog((Frame)MainFrame.instance());
            }
            this.closeSessionsDialog.closeSessions(fabric);
        }
        this.fabricList.removeFabric(fabric);
        this.fabricRemoved = true;
        if (this.fabricList.size() == 0) {
            this.setStatusBarText("");
            this.sansurferLayout.show(this.sansurferPanel, BLANK_PANEL);
        }
    }

    public void refresh() {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        if (sanSurferTreeNode == null) {
            return;
        }
        Object object = sanSurferTreeNode.getUserObject();
        switch (sanSurferTreeNode.getNodeType()) {
            case 1: {
                this.topologyPanel.refresh();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.faceplatePanel.refresh();
                break;
            }
        }
    }

    private void debugMethod() {
    }

    private void showHelpAbout() {
        if (this.helpAboutDialog == null) {
            this.helpAboutDialog = new HelpAboutDialog((JFrame)MainFrame.instance());
        }
        this.helpAboutDialog.show();
    }

    private void showHelp() {
        boolean bl = false;
        try {
            bl = QHelpUtilities.displayTopic(VendorProperties.getResource("help.html"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            PopupDialog.showDialog((Frame)MainFrame.instance(), 3, FabricTreeControl.getResource("FabricTreeControl.helpFailed"));
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public String getTreeName() {
        return this.treeName;
    }

    public String getApplicationTitle() {
        return this.applicationName + this.viewName;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    private Dimension rebuildToolBar(boolean bl) {
        Accessible accessible;
        Object object;
        Dimension dimension = null;
        this.toolBar.removeAll();
        int n = 0;
        while (n < this.defaultToolBarItems.size()) {
            Component component = (Component)this.defaultToolBarItems.elementAt(n);
            if (component instanceof JButton) {
                if (dimension == null) {
                    dimension = component.getPreferredSize();
                } else {
                    dimension.width = Math.max(dimension.width, component.getPreferredSize().width);
                    dimension.height = Math.max(dimension.height, component.getPreferredSize().height);
                }
            }
            this.toolBar.add(component);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.defaultToolBarItems.size()) {
            object = (Component)this.defaultToolBarItems.elementAt(n2);
            if (object instanceof JButton) {
                accessible = (JButton)object;
                ((JComponent)((Object)accessible)).setPreferredSize(dimension);
                ((JComponent)((Object)accessible)).setBorder(new EmptyBorder(((JComponent)((Object)accessible)).getInsets()));
            }
            ++n2;
        }
        object = VendorProperties.getResource("vendor");
        if (object == null || ((String)object).equals("qlogic")) {
            if (bl) {
                accessible = new ImageIcon(SbmUtilities.getImage("logo_small.gif"));
                QLogicLogo qLogicLogo = new QLogicLogo((Icon)((Object)accessible));
                qLogicLogo.addActionListener((ActionListener)new LogoAction("http://www.qlogic.com"));
                qLogicLogo.setAlignmentY(0.5f);
                this.toolBar.add((Component)qLogicLogo);
            }
            if (bl) {
                this.toolBar.add(Box.createGlue());
            }
        }
        this.toolBar.validate();
        this.toolBar.repaint();
        return dimension;
    }

    private void rebuildToolBar(Vector vector) {
        String string;
        Object object;
        Serializable serializable;
        int n;
        Dimension dimension = this.rebuildToolBar(false);
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                serializable = (Component)vector.elementAt(n);
                if (serializable instanceof JButton) {
                    if (dimension == null) {
                        dimension = ((Component)serializable).getPreferredSize();
                    } else {
                        dimension.width = Math.max(dimension.width, ((Component)serializable).getPreferredSize().width);
                        dimension.height = Math.max(dimension.height, ((Component)serializable).getPreferredSize().height);
                    }
                }
                this.toolBar.add((Component)serializable);
                ++n;
            }
        }
        if (dimension != null) {
            n = 0;
            while (n < this.toolBar.getComponentCount()) {
                serializable = this.toolBar.getComponentAtIndex(n);
                if (serializable instanceof JButton) {
                    object = (JButton)serializable;
                    ((JComponent)object).setPreferredSize(dimension);
                    ((JComponent)object).setBorder(new EmptyBorder(((JComponent)object).getInsets()));
                }
                ++n;
            }
        }
        if ((string = VendorProperties.getResource("vendor")) == null || string.equals("qlogic")) {
            serializable = new ImageIcon(SbmUtilities.getImage("logo_small.gif"));
            object = new QLogicLogo((Icon)((Object)serializable));
            object.addActionListener((ActionListener)new LogoAction("http://www.qlogic.com"));
            object.setAlignmentY(0.5f);
            this.toolBar.add((Component)object);
        }
        this.toolBar.add(Box.createGlue());
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    private void addDefaultMenuBarItems(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            JMenu jMenu = (JMenu)vector.elementAt(n);
            JMenu jMenu2 = this.getMenuByName(jMenu.getText());
            if (jMenu2 != null) {
                this.insertMenuItems(jMenu2, jMenu);
            } else {
                this.menuBar.add(jMenu);
            }
            ++n;
        }
    }

    private void addExtendedMenuBarItems(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            JMenu jMenu = (JMenu)vector.elementAt(n);
            JMenu jMenu2 = this.getMenuByName(jMenu.getText());
            if (jMenu2 != null) {
                this.addMenuItems(jMenu2, jMenu);
            } else {
                this.menuBar.add(jMenu);
            }
            ++n;
        }
    }

    private JMenu getMenuByName(String string) {
        int n = 0;
        int n2 = this.menuBar.getMenuCount();
        while (n < n2) {
            if (this.menuBar.getMenu(n).getText().equals(string)) {
                return this.menuBar.getMenu(n);
            }
            ++n;
        }
        return null;
    }

    private void addMenuItems(JMenu jMenu, JMenu jMenu2) {
        int n = jMenu2.getItemCount();
        if (n > 0) {
            jMenu.addSeparator();
            int n2 = 0;
            while (n2 < n) {
                JMenuItem jMenuItem = jMenu2.getItem(n2);
                if (jMenuItem == null) {
                    jMenu.addSeparator();
                } else {
                    jMenu.add(jMenuItem);
                    --n2;
                    --n;
                }
                ++n2;
            }
        }
    }

    private void insertMenuItems(JMenu jMenu, JMenu jMenu2) {
        int n = jMenu2.getItemCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                JMenuItem jMenuItem = jMenu2.getItem(n2);
                if (jMenuItem == null) {
                    jMenu.insertSeparator(n2);
                } else {
                    jMenu.insert(jMenuItem, n2);
                    --n;
                }
                ++n2;
            }
            jMenu.insertSeparator(n2);
        }
    }

    private void rebuildMenuBar(Vector vector) {
        this.menuBar.removeAll();
        this.createDefaultMenuBarItems();
        this.addDefaultMenuBarItems(this.defaultMenuBarItems);
        if (vector != null) {
            this.addExtendedMenuBarItems(vector);
        }
        this.createDefaultMenuBarItems2();
        this.addDefaultMenuBarItems(this.defaultMenuBarItems2);
        this.menuBar.validate();
        this.menuBar.repaint();
    }

    public void startup() {
        QHelpUtilities.initHelpResources("SbmCSHelp");
        String string = System.getProperty("ipaddr");
        String string2 = System.getProperty("login");
        String string3 = "";
        if (string2 == null) {
            string2 = "";
        }
        UserPreferences userPreferences = UserPreferences.getInstance();
        String string4 = userPreferences.getUserProperties().getProperty("autoSaveLoad");
        String string5 = userPreferences.getUserProperties().getProperty("startUpDialog");
        String string6 = userPreferences.getUserProperties().getProperty("eventBrowser");
        if (string6 != null) {
            if (string6.equals("true")) {
                this.setEventBrowserEnabled(true);
            } else {
                this.setEventBrowserEnabled(false);
            }
        }
        String string7 = "";
        InetAddress inetAddress = null;
        if (string != null && !string.equals(string7)) {
            this.loadCmdLine = true;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                PopupDialog.showDialog((Frame)MainFrame.instance(), 3, FabricTreeControl.getResource("FabricTreeControl.badIpAddr"));
                return;
            }
            String string8 = "";
            if (inetAddress != null) {
                string8 = inetAddress.getHostAddress();
            }
            try {
                if (this.newFabricDialog == null) {
                    this.newFabricDialog = new NewFabricDialog((Frame)MainFrame.instance(), this.fabricList);
                    this.newFabricDialog.setModal(true);
                }
                this.newFabricDialog.setIpAddressField(string);
                this.newFabricDialog.setUserNameField(string2);
                this.newFabricDialog.setPasswordField(string3);
                if (!string2.equals("") && string3.equals("")) {
                    this.newFabricDialog.passwordTextField.requestFocus();
                    this.newFabricDialog.validate();
                    this.newFabricDialog.setVisible(true);
                }
                this.newFabricDialog.addFabricButton.requestFocus();
                this.newFabricDialog.addFabricButton.doClick();
                this.newFabricDialog.setVisible(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PopupDialog.showDialog((Frame)MainFrame.instance(), 3, FabricTreeControl.getResource("FabricTreeControl.fabricOpenFailed"));
                return;
            }
        } else {
            if (string4 != null && string4.equals("true")) {
                if (!FcFabricsFile.readOnStartComplete) {
                    if (!FcFabricsFile.defaultFileExists()) {
                        if (string5.equals("true")) {
                            this.showStartupDialog();
                        }
                    } else if (!FcFabricsFile.openDefault()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MainFrame.instance().requestShutdown();
                            }
                        });
                    }
                }
            } else if (string5.equals("true")) {
                this.showStartupDialog();
            }
            FcFabricsFile.readOnStartComplete = true;
        }
    }

    protected void showStartupDialog() {
        InitialStartupDialog initialStartupDialog = new InitialStartupDialog((JFrame)MainFrame.instance(), true);
        initialStartupDialog.setVisible(true);
        int n = initialStartupDialog.getStartupSelection();
        switch (n) {
            case 0: {
                this.addFabric();
                break;
            }
            case 1: {
                PopupDialog.showDialog((Frame)MainFrame.instance(), 3, "This feature is under construction");
                break;
            }
            case 2: {
                FcFabricsFile.openFabrics();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                MainFrame.instance().requestShutdown();
            }
        }
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setTarget(JSplitPane jSplitPane) {
        if (this.splitPane != null) {
            this.splitPane.remove(this.sansurferPanel);
        }
        this.splitPane = jSplitPane;
        int n = this.splitPane.getDividerLocation();
        if (n <= 0) {
            n = 175;
        }
        this.splitPane.setRightComponent(this.sansurferPanel);
        this.splitPane.setDividerLocation(n);
        MainFrame.instance().validate();
    }

    public JComponent getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBarLabel(JLabel jLabel) {
        this.statusBarLabel = jLabel;
    }

    public void setStatusBarText(String string) {
        this.statusBarLabel.setText(string);
    }

    public void addProgressBar(JLabel jLabel, JLabel jLabel2) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        this.statusBar.add((Component)jPanel, "East");
    }

    public void updateTarget() {
        int n = this.splitPane.getDividerLocation();
        if (n <= 0) {
            n = 175;
        }
        this.splitPane.setRightComponent(this.sansurferPanel);
        this.splitPane.setDividerLocation(n);
    }

    public void shutdown() {
    }

    public boolean isShutdownReady() {
        if (!this.loadCmdLine) {
            UserPreferences userPreferences = UserPreferences.getInstance();
            String string = userPreferences.getUserProperties().getProperty("autoSaveLoad");
            if (string != null && string.equals("true")) {
                int n = 0;
                if ((this.fabricList.size() != 0 || this.fabricRemoved) && !FcFabricsFile.saveOnExitComplete) {
                    try {
                        JFrame jFrame = SbmUtilities.getFrame(this.tree);
                        if (jFrame != null) {
                            jFrame.setState(0);
                        }
                        n = FcFabricsFile.saveDefault();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n < 0) {
                    return false;
                }
            }
            FcFabricsFile.saveOnExitComplete = true;
        }
        if (this.fabricList.size() > 0) {
            FabricTreeControl fabricTreeControl = this;
            if (fabricTreeControl.fabricList.hasSanbox2()) {
                if (this.closeSessionsDialog == null) {
                    this.closeSessionsDialog = new CloseSessionsDialog((Frame)MainFrame.instance());
                }
                this.closeSessionsDialog.closeSessions(this.fabricList);
            }
        }
        return true;
    }

    public boolean getEventBrowserEnabled() {
        return this.eventBrowserEnabled;
    }

    public void setEventBrowserEnabled(boolean bl) {
        this.eventBrowserEnabled = bl;
        if (this.eventBrowserEnabled) {
            this.eventList = new EventList();
            this.eventBrowser = new EventBrowser(this.eventList);
        } else if (this.eventBrowser != null) {
            this.eventBrowser.setVisible(false);
            this.eventBrowser = null;
            this.eventList = null;
        }
        this.eventBrowserButton.setEnabled(this.eventBrowserEnabled);
        this.rebuildMenuAndToolbars();
    }

    public void enterEvent(int n, Object object, String string, String string2) {
        if (this.eventBrowserEnabled) {
            this.eventList.enter(n, object, string, string2);
        }
    }

    public void enterEvent(EventEntry eventEntry) {
        if (this.eventBrowserEnabled) {
            this.eventList.add(eventEntry);
        }
    }

    public void enterDebugEvent(String string) {
        if (this.eventBrowserEnabled) {
            this.eventList.enter(string);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object;
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        if (sanSurferTreeNode == null) {
            object = this.findRootTreeNode();
            if (((DefaultMutableTreeNode)object).getChildCount() == 0) {
                this.sansurferLayout.show(this.sansurferPanel, BLANK_PANEL);
                this.rebuildMenuBar(null);
                this.rebuildToolBar(null);
            }
        } else {
            object = sanSurferTreeNode.getUserObject();
            switch (sanSurferTreeNode.getNodeType()) {
                case 0: {
                    this.sansurferLayout.show(this.sansurferPanel, BLANK_PANEL);
                    this.rebuildMenuBar(null);
                    this.rebuildToolBar(null);
                    break;
                }
                case 1: {
                    this.setStatusBarText("");
                    this.showFabric((Fabric)object);
                    this.viewName = " - Topology";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 99: {
                    this.showSwitch((Chassis)object);
                    this.viewName = " - Faceplate";
                    break;
                }
            }
        }
        if ((object = SbmUtilities.getFrame(this.tree)) != null) {
            ((Frame)object).setTitle(this.getApplicationTitle());
        }
        this.checkSelected();
    }

    public void showFabric(Fabric fabric) {
        TopologySelectionModel topologySelectionModel;
        Topology topology;
        if (this.topologyPanel == null) {
            this.topologyPanel = new TopologyPanel(fabric);
            this.sansurferPanel.add((Component)this.topologyPanel, TOPOLOGY_PANEL);
            this.sansurferPanel.validate();
        } else {
            topology = this.topologyPanel.getCurrentTopology();
            topology.removeTopologyActionListener(this.switchActivationListener);
            topologySelectionModel = topology.getSelectionModel();
            topologySelectionModel.addSelectionListener(this.switchSelectionListener);
            this.topologyPanel.setFabric(fabric);
        }
        topology = this.topologyPanel.getCurrentTopology();
        topology.addTopologyActionListener(this.switchActivationListener);
        topologySelectionModel = topology.getSelectionModel();
        topologySelectionModel.addSelectionListener(this.switchSelectionListener);
        CardLayout cardLayout = (CardLayout)this.sansurferPanel.getLayout();
        cardLayout.show(this.sansurferPanel, TOPOLOGY_PANEL);
        this.rebuildToolBar(this.topologyPanel.getToolBarExtension());
        this.rebuildMenuBar(this.topologyPanel.getMenuBarExtension());
        this.setStatusBarText("");
    }

    private void focusFabric(Fabric fabric) {
        TreePath treePath = this.createFabricTreePath(fabric);
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
    }

    public void showSwitch(Chassis chassis) {
        if (this.faceplatePanel == null) {
            this.faceplatePanel = new FaceplatePanel(chassis);
            this.sansurferPanel.add((Component)this.faceplatePanel, FACEPLATE_PANEL);
            this.sansurferPanel.validate();
        } else {
            this.faceplatePanel.setSelectedSwitch(chassis);
        }
        CardLayout cardLayout = (CardLayout)this.sansurferPanel.getLayout();
        cardLayout.show(this.sansurferPanel, FACEPLATE_PANEL);
        this.rebuildToolBar(this.faceplatePanel.getToolBarExtension());
        this.rebuildMenuBar(this.faceplatePanel.getMenuBarExtension());
        this.setStatusBarText("");
    }

    private void focusSwitch(Fabric fabric, Chassis chassis) {
        SanSurferTreeNode sanSurferTreeNode = this.findFabricTreeNode(fabric);
        TreePath treePath = this.createSwitchTreePath(sanSurferTreeNode, chassis);
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
    }

    private SanSurferTreeNode findRootTreeNode() {
        return (SanSurferTreeNode)this.treeModel.getRoot();
    }

    private SanSurferTreeNode findFabricTreeNode(Fabric fabric) {
        Object[] objectArray;
        SanSurferTreeNode sanSurferTreeNode = this.findRootTreeNode();
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            objectArray = (Object[])sanSurferTreeNode.getChildAt(n);
            if (objectArray.getUserObject().equals(fabric)) {
                return objectArray;
            }
            ++n;
        }
        objectArray = new Object[]{fabric.getFabricName()};
        String string = FabricTreeControl.getResource("FabricTreeControl.noSuchFabric");
        throw new IllegalArgumentException(StringUtilities.formatString(string, objectArray));
    }

    private TreePath createFabricTreePath(Fabric fabric) {
        Object[] objectArray = new Object[]{this.findRootTreeNode(), this.findFabricTreeNode(fabric)};
        return new TreePath(objectArray);
    }

    private SanSurferTreeNode findSwitchTreeNode(SanSurferTreeNode sanSurferTreeNode, Chassis chassis) {
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
            if (sanSurferTreeNode2.getUserObject().equals(chassis)) {
                return sanSurferTreeNode2;
            }
            ++n;
        }
        Object[] objectArray = new Object[]{chassis.toString()};
        String string = FabricTreeControl.getResource("FabricTreeControl.noSuchFcSwitch");
        throw new IllegalArgumentException(StringUtilities.formatString(string, objectArray));
    }

    private TreePath createSwitchTreePath(SanSurferTreeNode sanSurferTreeNode, Chassis chassis) {
        Object[] objectArray = new Object[]{this.findRootTreeNode(), sanSurferTreeNode, this.findSwitchTreeNode(sanSurferTreeNode, chassis)};
        return new TreePath(objectArray);
    }

    public void receiveEvent(FabricListEvent fabricListEvent) {
        String string = FabricTreeControl.getResource("FabricTreeControl.event.topology");
        FabricList fabricList = fabricListEvent.getFabricList();
        switch (fabricListEvent.getEventType()) {
            case 5001: {
                Fabric fabric = (Fabric)fabricListEvent.getValue();
                fabric.addEventListener((FabricEventListener)this);
                if (fabric.getComAgent() != null) {
                    this.comActivityDisplay.removeComAgent(fabric.getComAgent());
                    this.comActivityDisplay.addComAgent(fabric.getComAgent());
                }
                String string2 = FabricTreeControl.getResource("FabricTreeControl.event.addFabric");
                this.enterEvent(100, fabric, string, StringUtilities.formatString1(string2, fabric));
                SwingUtilities.invokeLater(new AddFabricRunnable(fabricList, fabric));
                break;
            }
            case 5002: {
                Fabric fabric = (Fabric)fabricListEvent.getValue();
                fabric.removeEventListener((FabricEventListener)this);
                if (fabric.getComAgent() != null) {
                    this.comActivityDisplay.removeComAgent(fabric.getComAgent());
                }
                String string3 = FabricTreeControl.getResource("FabricTreeControl.event.removeFabric");
                this.enterEvent(100, fabric, string, StringUtilities.formatString1(string3, fabric));
                SwingUtilities.invokeLater(new RemoveFabricRunnable(fabricList, fabric));
                break;
            }
        }
        FcFabricsFile.fabricsHaveChanged = true;
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        String string = FabricTreeControl.getResource("FabricTreeControl.event.topology");
        Fabric fabric = fabricEvent.getFabric();
        switch (fabricEvent.getEventType()) {
            case 2002: {
                Chassis chassis = (Chassis)fabricEvent.getValue();
                SwingUtilities.invokeLater(new AddSwitchRunnable(fabric, chassis));
                String string2 = FabricTreeControl.getResource("FabricTreeControl.event.addSwitch");
                this.enterEvent(100, fabric, string, StringUtilities.formatString1(string2, chassis));
                break;
            }
            case 2003: {
                Chassis chassis = (Chassis)fabricEvent.getValue();
                SwingUtilities.invokeLater(new RemoveSwitchRunnable(fabric, chassis));
                String string3 = FabricTreeControl.getResource("FabricTreeControl.event.removeSwitch");
                this.enterEvent(100, fabric, string, StringUtilities.formatString1(string3, chassis));
                break;
            }
            case 2001: {
                SwingUtilities.invokeLater(new FabricEventRunnable(fabricEvent));
                int n = fabric.getOverallStatus();
                int n2 = EventEntry.convertStatus(n);
                string = FabricTreeControl.getResource("FabricTreeControl.event.status");
                String string4 = FabricTreeControl.getResource("FabricTreeControl.event.fabricStatus");
                this.enterEvent(n2, fabric, string, StringUtilities.formatString1(string4, Status.toString((int)n)));
                break;
            }
            case 2004: {
                FabricLink fabricLink = (FabricLink)fabricEvent.getValue();
                String string5 = FabricTreeControl.getResource("FabricTreeControl.event.addLink");
                this.enterEvent(100, fabric, string, StringUtilities.formatString1(string5, fabricLink));
                break;
            }
            case 2005: {
                FabricLink fabricLink = (FabricLink)fabricEvent.getValue();
                String string6 = FabricTreeControl.getResource("FabricTreeControl.event.removeLink");
                this.enterEvent(100, fabric, string, StringUtilities.formatString1(string6, fabricLink));
                break;
            }
            case 2006: {
                FabricLink fabricLink = (FabricLink)fabricEvent.getValue();
                int n = fabricLink.getState();
                int n3 = EventEntry.convertStatus(n);
                string = FabricTreeControl.getResource("FabricTreeControl.event.status");
                String string7 = FabricTreeControl.getResource("FabricTreeControl.event.linkStatus");
                this.enterEvent(n3, fabric, string, StringUtilities.formatString2(string7, Status.toString((int)n), fabricLink.toString()));
                break;
            }
            case 2009: {
                this.comActivityDisplay.addComAgent(fabric.getComAgent());
                break;
            }
        }
        this.tree.repaint();
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        Object object;
        Chassis chassis = chassisEvent.getChassis();
        switch (chassisEvent.getEventType()) {
            case 203: 
            case 208: {
                int n = EventEntry.convertStatus(chassis.getOverallStatus());
                String string = SbmUtilities.reasonToString(chassis.getReasonForStatus());
                String string2 = FabricTreeControl.getResource("FabricTreeControl.event.status");
                this.enterEvent(n, chassis, string2, string);
                break;
            }
            case 306: {
                String string = FabricTreeControl.getResource("FabricTreeControl.event.login");
                this.enterEvent(100, chassis, string, chassis.getComAgent().getLoginInfo().getLevelString());
                break;
            }
            case 213: 
            case 253: {
                break;
            }
            case 262: {
                try {
                    object = (String)chassisEvent.getValue();
                    int n = ((String)object).indexOf(91);
                    object = new String(((String)object).substring(n));
                    this.enterEvent(new ParsedAlarm(System.currentTimeMillis(), chassis, (String)object));
                }
                catch (Exception exception) {
                    this.enterDebugEvent("Unparsable alarm: " + chassisEvent.getValue());
                }
                break;
            }
            case 277: {
                this.addAlarmsToEventList((Sanbox2)chassis);
                break;
            }
            default: {
                return;
            }
        }
        object = new ChassisEventRunnable();
        ((ChassisEventRunnable)object).setEvent(chassisEvent);
        SwingUtilities.invokeLater((Runnable)object);
    }

    void addAlarmsToEventList(Sanbox2 sanbox2) {
        Vector vector = sanbox2.getAlarmLog();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                int n = string.indexOf(91) + 1;
                n = string.indexOf(91, n);
                this.enterEvent(new ParsedAlarm((Chassis)sanbox2, new String(string.substring(n))));
            }
            catch (Exception exception) {
                this.eventList.enter("Unparsable alarm: " + string);
            }
        }
    }

    private void rebuildMenuAndToolbars() {
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        if (sanSurferTreeNode != null) {
            Object object = sanSurferTreeNode.getUserObject();
            switch (sanSurferTreeNode.getNodeType()) {
                case 1: {
                    this.rebuildToolBar(this.topologyPanel.getToolBarExtension());
                    this.rebuildMenuBar(this.topologyPanel.getMenuBarExtension());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.rebuildToolBar(this.faceplatePanel.getToolBarExtension());
                    this.rebuildMenuBar(this.faceplatePanel.getMenuBarExtension());
                    break;
                }
                default: {
                    this.rebuildToolBar(null);
                    this.rebuildMenuBar(null);
                }
            }
        }
    }

    static {
        resources = ResourceBundle.getBundle("SANsurfer2");
    }

    class FabricEventRunnable
    implements Runnable {
        FabricEvent event;

        public FabricEventRunnable(FabricEvent fabricEvent) {
            this.event = fabricEvent;
        }

        public void run() {
            Fabric fabric = this.event.getFabric();
            SanSurferTreeNode sanSurferTreeNode = FabricTreeControl.this.findFabricTreeNode(fabric);
            ((DefaultTreeModel)FabricTreeControl.this.tree.getModel()).nodeChanged(sanSurferTreeNode);
            FabricTreeControl.this.tree.repaint();
        }
    }

    class ChassisEventRunnable
    implements Runnable {
        ChassisEvent event;

        ChassisEventRunnable() {
        }

        public void setEvent(ChassisEvent chassisEvent) {
            this.event = chassisEvent;
        }

        public void run() {
            Chassis chassis;
            Fabric fabric;
            if (this.event.getEventType() == 306) {
                FabricTreeControl.this.rebuildMenuAndToolbars();
            }
            if ((fabric = FabricList.getFabric((Chassis)(chassis = this.event.getChassis()))) != null) {
                SanSurferTreeNode sanSurferTreeNode = FabricTreeControl.this.findFabricTreeNode(fabric);
                SanSurferTreeNode sanSurferTreeNode2 = FabricTreeControl.this.findSwitchTreeNode(sanSurferTreeNode, chassis);
                ((DefaultTreeModel)FabricTreeControl.this.tree.getModel()).nodeChanged(sanSurferTreeNode2);
            }
            FabricTreeControl.this.tree.repaint();
        }
    }

    static class ParsedAlarm
    extends EventEntry {
        static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss.SSS yyyy");

        public ParsedAlarm(long l, Chassis chassis, String string) throws ParseException {
            this(chassis, string);
            this.date = new Date(l);
        }

        public ParsedAlarm(Chassis chassis, String string) throws ParseException {
            String string2;
            this.severity = new Integer(500);
            this.source = chassis.toString();
            this.description = string;
            int n = string.indexOf(91) + 1;
            int n2 = string.indexOf(93, n);
            this.date = new Date(dateFormat.parse(string.substring(n, n2)).getTime());
            n = n2 + 2;
            n2 = string.indexOf(93, n);
            if (string.charAt(n) != 'A') {
                string2 = string.substring(n, n2);
            } else {
                int n3 = string.indexOf(46, n);
                if (n3 >= 0 && n3 <= n2) {
                    string2 = string.substring(n + 1, n3);
                } else {
                    string2 = string.substring(n + 1, n2);
                    int n4 = Integer.parseInt(string2);
                    string2 = Integer.toHexString(n4);
                }
                String string3 = FabricTreeControl.getResource("AlarmLogPanel.AlarmType" + string2);
                if (string3 != null) {
                    string2 = string3;
                }
            }
            String string4 = FabricTreeControl.getResource("FabricTreeControl.event.alarm");
            this.type = string4 == null ? string2 : StringUtilities.formatString1(string4, string2);
        }
    }

    class RemoveSwitchRunnable
    implements Runnable {
        Fabric fabric;
        Chassis fcSwitch;

        public RemoveSwitchRunnable(Fabric fabric, Chassis chassis) {
            this.fabric = fabric;
            this.fcSwitch = chassis;
        }

        public void run() {
            SanSurferTreeNode sanSurferTreeNode = FabricTreeControl.this.findFabricTreeNode(this.fabric);
            SanSurferTreeNode sanSurferTreeNode2 = FabricTreeControl.this.findSwitchTreeNode(sanSurferTreeNode, this.fcSwitch);
            FabricTreeControl.this.treeModel.removeNodeFromParent(sanSurferTreeNode2);
            FcFabricsFile.fabricsHaveChanged = true;
        }
    }

    class AddSwitchRunnable
    implements Runnable {
        Fabric fabric;
        Chassis fcSwitch;

        public AddSwitchRunnable(Fabric fabric, Chassis chassis) {
            this.fabric = fabric;
            this.fcSwitch = chassis;
        }

        public void run() {
            Object object;
            SanSurferTreeNode sanSurferTreeNode = FabricTreeControl.this.findFabricTreeNode(this.fabric);
            int n = -1;
            if (this.fcSwitch instanceof SanboxChassis) {
                object = (SanboxChassis)this.fcSwitch;
                switch (object.getChassisType()) {
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 0: {
                        n = 3;
                        break;
                    }
                    case 16: {
                        n = 4;
                        break;
                    }
                    case 8: {
                        n = 14;
                        break;
                    }
                    case 30: {
                        n = 16;
                        break;
                    }
                    case 26: {
                        n = 17;
                        break;
                    }
                    case 33: 
                    case 38: {
                        n = 18;
                        break;
                    }
                }
            } else {
                n = this.fcSwitch instanceof Director ? 15 : 99;
            }
            object = new SanSurferTreeNode((Object)this.fcSwitch, n);
            FabricTreeControl.this.treeModel.insertNodeInto((MutableTreeNode)object, sanSurferTreeNode, sanSurferTreeNode.getChildCount());
            this.fcSwitch.getEventHandler().addChassisEventListener((ChassisEventListener)FabricTreeControl.this);
            FcFabricsFile.fabricsHaveChanged = true;
        }
    }

    class RemoveFabricRunnable
    implements Runnable {
        FabricList fabricList;
        Fabric fabric;

        public RemoveFabricRunnable(FabricList fabricList, Fabric fabric) {
            this.fabricList = fabricList;
            this.fabric = fabric;
        }

        public void run() {
            SanSurferTreeNode sanSurferTreeNode = FabricTreeControl.this.findFabricTreeNode(this.fabric);
            if (sanSurferTreeNode != null) {
                FabricTreeControl.this.treeModel.removeNodeFromParent(sanSurferTreeNode);
                FabricTreeControl.this.tree.setSelectionRow(0);
            }
        }
    }

    class AddFabricRunnable
    implements Runnable {
        FabricList fabricList;
        Fabric fabric;

        public AddFabricRunnable(FabricList fabricList, Fabric fabric) {
            this.fabricList = fabricList;
            this.fabric = fabric;
        }

        public void run() {
            SanSurferTreeNode sanSurferTreeNode = FabricTreeControl.this.findRootTreeNode();
            SanSurferTreeNode sanSurferTreeNode2 = new SanSurferTreeNode((Object)this.fabric, 1);
            FabricTreeControl.this.treeModel.insertNodeInto(sanSurferTreeNode2, sanSurferTreeNode, sanSurferTreeNode.getChildCount());
            FabricTreeControl.this.focusFabric(this.fabric);
        }
    }

    class SwitchActivationListener
    implements ActionListener {
        SwitchActivationListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof Chassis) {
                Chassis chassis = (Chassis)object;
                Fabric fabric = FabricTreeControl.this.topologyPanel.getCurrentFabric();
                FabricTreeControl.this.focusSwitch(fabric, chassis);
            }
        }
    }

    class SwitchSelectionListener
    implements TopologySelectionListener {
        SwitchSelectionListener() {
        }

        public void selectionChanged(TopologySelectionEvent topologySelectionEvent) {
            FabricTreeControl.this.rebuildMenuAndToolbars();
        }
    }

    class ShowEventsAction
    extends AbstractAction {
        public ShowEventsAction() {
            super(FabricTreeControl.getResource("menu.view.showEvents"));
        }

        public ShowEventsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FabricTreeControl.this.eventBrowser.setVisible(true);
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            super(FabricTreeControl.getResource("menu.help.helpTopics"));
        }

        public HelpAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public HelpAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FabricTreeControl.this.showHelp();
        }
    }

    class HelpAboutAction
    extends AbstractAction {
        public HelpAboutAction() {
            super(FabricTreeControl.getResource("menu.help.about"));
        }

        public HelpAboutAction(String string) {
            Image image = SbmUtilities.getImage(string);
            ImageIcon imageIcon = new ImageIcon(image);
            this.putValue("SmallIcon", imageIcon);
        }

        public HelpAboutAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FabricTreeControl.this.showHelpAbout();
        }
    }

    class DebugAction
    extends AbstractAction {
        public DebugAction() {
            super("Debug");
        }

        public DebugAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public DebugAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FabricTreeControl.this.debugMethod();
        }
    }

    class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super(FabricTreeControl.getResource("menu.view.refresh"));
        }

        public RefreshAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public RefreshAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FabricTreeControl.this.refresh();
        }
    }

    class RediscoverTopologyAction
    extends AbstractAction {
        public RediscoverTopologyAction() {
            super(FabricTreeControl.getResource("menu.fabric.rediscoverTopo"));
        }

        public RediscoverTopologyAction(String string) {
            Image image = SbmUtilities.getImage(string);
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public RediscoverTopologyAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FabricTreeControl.this.rediscover();
        }
    }

    class RemoveFabricAction
    extends AbstractAction {
        public RemoveFabricAction() {
            super(FabricTreeControl.getResource("menu.fabric.remove"));
        }

        public RemoveFabricAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public RemoveFabricAction(String string, Image image) {
            super(string);
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FabricTreeControl.this.removeFabric();
        }
    }

    class PerfmonAction
    extends AbstractAction {
        public PerfmonAction() {
            super(FabricTreeControl.getResource("menu.fabric.perfmon"));
        }

        public PerfmonAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FabricTreeControl.this.invokePerfmon();
        }
    }

    class AddFabricAction
    extends AbstractAction {
        public AddFabricAction() {
            super(FabricTreeControl.getResource("menu.fabric.add"));
        }

        public AddFabricAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public AddFabricAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FabricTreeControl.this.addFabric();
        }
    }

    class SaveFabricsAsAction
    extends AbstractAction {
        public SaveFabricsAsAction() {
            super(FabricTreeControl.getResource("menu.file.saveViewAs"));
        }

        public SaveFabricsAsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FcFabricsFile.saveFabricsAs();
        }
    }

    class SaveFabricsAction
    extends AbstractAction {
        public SaveFabricsAction() {
            super(FabricTreeControl.getResource("menu.file.saveView"));
        }

        public SaveFabricsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FcFabricsFile.saveFabrics();
        }
    }

    class OpenFabricsAction
    extends AbstractAction {
        public OpenFabricsAction() {
            super(FabricTreeControl.getResource("menu.file.openView"));
        }

        public OpenFabricsAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FcFabricsFile.openFabrics();
        }
    }

    class UserPreferencesAction
    extends AbstractAction {
        public UserPreferencesAction() {
            super(FabricTreeControl.getResource("menu.file.preferences"));
        }

        public UserPreferencesAction(String string) {
            Image image = SbmUtilities.getImage(string);
            ImageIcon imageIcon = new ImageIcon(image);
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UserPreferencesDialog userPreferencesDialog = new UserPreferencesDialog((JFrame)MainFrame.instance(), true);
            userPreferencesDialog.setVisible(true);
        }
    }

    class ChangePasswordAction
    extends AbstractAction {
        public ChangePasswordAction() {
            super(FabricTreeControl.getResource("menu.file.password"));
        }

        public ChangePasswordAction(String string) {
            Image image = SbmUtilities.getImage(string);
            ImageIcon imageIcon = new ImageIcon(image);
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChangePasswordDialog changePasswordDialog = new ChangePasswordDialog((Frame)MainFrame.instance());
            changePasswordDialog.setVisible(true);
        }
    }

    class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(FabricTreeControl.getResource("menu.file.exit"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.instance().requestShutdown();
        }
    }
}

