/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.ForeignSwitch;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.Status;
import com.qlogic.device.fcfabric.User;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SbmUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class FaceplateStatusPanel
extends JPanel
implements SwingConstants {
    private static final ImageIcon UNREACHABLE_ICON = new ImageIcon(SbmUtilities.getImage("StatusUnknown.gif"));
    private static final ImageIcon WARNING_ICON = new ImageIcon(SbmUtilities.getImage("StatusWarning.gif"));
    private static final ImageIcon CRITICAL_ICON = new ImageIcon(SbmUtilities.getImage("StatusCritical.gif"));
    private static final ImageIcon NORMAL_ICON = new ImageIcon(SbmUtilities.getImage("StatusNormal.gif"));
    private static String LAST_KNOWN_STATE = FabricTreeControl.getResource("FaceplateStatusPanel.LastKnownState");
    private static String READ_ONLY_ACCESS = FabricTreeControl.getResource("FaceplateStatusPanel.ReadOnlyAccess");
    private static final String unknownName = FabricTreeControl.getResource("AbstractFaceplate.unknownLongName");
    private JLabel alertLabel = new JLabel();
    private JTextField nameField = new JTextField(48);
    private JLabel statusLabel = new JLabel();
    private JLabel statusIcon = new JLabel();

    public FaceplateStatusPanel(Chassis chassis) {
        this.alertLabel.setVisible(false);
        this.nameField.setEditable(false);
        this.nameField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.nameField.setText(chassis instanceof SanboxChassis ? ((SanboxChassis)chassis).toString() : unknownName);
        int n = chassis.getOverallStatus();
        ImageIcon imageIcon = this.getStatusIcon(n);
        String string = SbmUtilities.reasonToString(chassis.getReasonForStatus());
        this.statusIcon.setIcon(imageIcon);
        this.statusLabel.setText(string);
        if (n != 0) {
            if (n == 3) {
                this.statusLabel.setForeground(Color.white);
            } else {
                this.statusLabel.setForeground(Color.black);
            }
            this.statusLabel.setBackground(Status.getColor((int)n));
            this.statusLabel.setOpaque(true);
        } else {
            this.statusLabel.setForeground(Color.black);
            this.statusLabel.setOpaque(false);
        }
        if (!(chassis instanceof ForeignSwitch)) {
            User user = ((SanboxChassis)chassis).getLoginInfo();
            if (n == 3) {
                this.alertLabel.setText(LAST_KNOWN_STATE);
            } else if (user.hasReadOnlyAccess()) {
                this.alertLabel.setText(READ_ONLY_ACCESS);
            }
            this.alertLabel.setVisible(n == 3 || user.hasReadOnlyAccess());
        }
        this.layoutPanel();
        this.doLayout();
        this.validate();
    }

    private void layoutPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.add((Component)this.nameField, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 8, 0, 0), 0, 0));
        this.add((Component)this.alertLabel, new GridBagConstraints(2, 0, 8, 1, 0.0, 0.0, 13, 0, new Insets(4, 8, 0, 8), 4, 0));
        this.alertLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.alertLabel.setHorizontalAlignment(0);
        this.add((Component)this.statusIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 8, 0, 0), 0, 0));
        this.add((Component)this.statusLabel, new GridBagConstraints(1, 1, 9, 1, 1.0, 0.0, 17, 0, new Insets(4, 8, 0, 0), 0, 0));
    }

    public void setSwStatus(final Chassis chassis) {
        final int n = chassis.getOverallStatus();
        final String string = SbmUtilities.reasonToString(chassis.getReasonForStatus());
        final ImageIcon imageIcon = this.getStatusIcon(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FaceplateStatusPanel.this.statusLabel.setText(string);
                FaceplateStatusPanel.this.statusIcon.setIcon(imageIcon);
                if (n != 0) {
                    if (n == 3) {
                        FaceplateStatusPanel.this.statusLabel.setForeground(Color.white);
                    } else {
                        FaceplateStatusPanel.this.statusLabel.setForeground(Color.black);
                    }
                    FaceplateStatusPanel.this.statusLabel.setBackground(Status.getColor((int)n));
                    FaceplateStatusPanel.this.statusLabel.setOpaque(true);
                } else {
                    FaceplateStatusPanel.this.statusLabel.setForeground(Color.black);
                    FaceplateStatusPanel.this.statusLabel.setOpaque(false);
                }
                if (!(chassis instanceof ForeignSwitch)) {
                    User user = ((SanboxChassis)chassis).getLoginInfo();
                    if (n == 3) {
                        FaceplateStatusPanel.this.alertLabel.setText(LAST_KNOWN_STATE);
                    } else if (user.hasReadOnlyAccess()) {
                        FaceplateStatusPanel.this.alertLabel.setText(READ_ONLY_ACCESS);
                    }
                    FaceplateStatusPanel.this.alertLabel.setVisible(n == 3 || user.hasReadOnlyAccess());
                }
            }
        });
    }

    public void setSwName(Chassis chassis) {
        final String string = chassis instanceof SanboxChassis ? ((SanboxChassis)chassis).toString() : unknownName;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FaceplateStatusPanel.this.nameField.setText(string);
            }
        });
    }

    private ImageIcon getStatusIcon(int n) {
        switch (n) {
            case 0: {
                return NORMAL_ICON;
            }
            case 1: {
                return WARNING_ICON;
            }
            case 2: {
                return CRITICAL_ICON;
            }
            case 3: {
                return UNREACHABLE_ICON;
            }
        }
        return UNREACHABLE_ICON;
    }
}

