/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.qms.fabric.BladeInfoPanel;
import com.qlogic.qms.fabric.ComDisplayPanel;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.NameServerPanel;
import com.qlogic.qms.fabric.PortCountersPanel;
import com.qlogic.qms.fabric.PortInfoPanel;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.SwitchCountersPanel;
import com.qlogic.qms.fabric.SwitchDisplayPanel;
import com.qlogic.qms.fabric.TrapLogPanel;
import com.qlogic.qms.fabric.ZoningPanel;
import com.qlogic.qms.fabric.zoning.ActivateZoneSetDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaceplateTabPanel
extends JPanel
implements ChassisEventListener,
ChangeListener,
MouseListener,
ActionListener {
    private Chassis fcSwitch;
    private Fabric fabric;
    public ComDisplayPanel comDisplayPanel;
    public JScrollPane comDisplayPane;
    public SwitchDisplayPanel switchDisplayPanel = null;
    public NameServerPanel nameServerPanel = new NameServerPanel();
    public SwitchCountersPanel switchCounterPanel = new SwitchCountersPanel();
    public TrapLogPanel trapLogPanel = new TrapLogPanel();
    public PortCountersPanel portCountersPanel = new PortCountersPanel();
    public PortInfoPanel portInfoPanel = new PortInfoPanel();
    public BladeInfoPanel bladeInfoPanel = new BladeInfoPanel();
    public ZoningPanel zoningPanel;
    private static final String alarmLogStr = FabricTreeControl.getResource("FaceplateTabPanel.alarmLog");
    private static final String trapLogStr = FabricTreeControl.getResource("FaceplateTabPanel.trapLog");
    private static final String zoningDbStr = FabricTreeControl.getResource("FaceplateTabPanel.zoningDatabase");
    private static final String activeZoneSetStr = FabricTreeControl.getResource("FaceplateTabPanel.activeZoneSet");
    private static final String nameServerStr = FabricTreeControl.getResource("FaceplateTabPanel.nameServer");
    private static final String switchStr = FabricTreeControl.getResource("FaceplateTabPanel.switch");
    private static final String countersStr = FabricTreeControl.getResource("FaceplateTabPanel.counters");
    private static final String portCountersStr = FabricTreeControl.getResource("FaceplateTabPanel.portCounters");
    private static final String portInfoStr = FabricTreeControl.getResource("FaceplateTabPanel.portInfo");
    private static final String bladeInfoStr = FabricTreeControl.getResource("FaceplateTabPanel.bladeInfo");
    JTabbedPane tabbedPane;
    protected JPopupMenu menu = new JPopupMenu();
    private JMenuItem activateZoneSetItem = new JMenuItem(FabricTreeControl.getResource("AbstractFaceplate.activateZoneSet"));

    public FaceplateTabPanel(Chassis chassis) {
        this.fabric = FabricList.getFabric((Chassis)chassis);
        this.zoningPanel = new ZoningPanel(this.fabric, null, false, false, this);
        try {
            this.jbInit(chassis);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tabbedPane.setSelectedIndex(0);
    }

    private void jbInit(Chassis chassis) throws Exception {
        Vector<Chassis> vector = new Vector<Chassis>();
        vector.add(chassis);
        this.switchDisplayPanel = new SwitchDisplayPanel(vector);
        this.setToolTipText(FabricTreeControl.getResource("FaceplateTabPanel.tabName"));
        this.tabbedPane = new JTabbedPane(3);
        this.tabbedPane.addChangeListener(this);
        String string = System.getProperty("monitor");
        if (string != null) {
            this.comDisplayPanel = new ComDisplayPanel(chassis.getComAgent());
            this.comDisplayPane = new JScrollPane(this.comDisplayPanel);
        }
        this.setSwitch(chassis, new Vector());
        this.setLayout(new GridLayout(1, 1));
        this.add(this.tabbedPane);
        this.activateZoneSetItem.addActionListener(this);
        this.menu.add(this.activateZoneSetItem);
    }

    public NameServerPanel getNameServerPanel() {
        return this.nameServerPanel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        FabricTreeControl fabricTreeControl = FabricTreeControl.instance();
        fabricTreeControl.setStatusBarText("");
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getChassis() != this.fcSwitch) {
            chassisEvent.getChassis().getEventHandler().removeChassisEventListener((ChassisEventListener)this);
            return;
        }
        if (chassisEvent.getEventType() == 219) {
            this.zoningPanel.repaint();
        }
        if ((chassisEvent.getEventType() == 241 || chassisEvent.getEventType() == 378) && chassisEvent.getChassis() instanceof SanboxChassis) {
            SanboxChassis sanboxChassis = (SanboxChassis)chassisEvent.getChassis();
            this.zoningPanel.setZones(this.fabric, sanboxChassis.getEportZoningDb());
        }
    }

    public void setSwitch(Chassis chassis, Vector vector) {
        if (this.fcSwitch != null) {
            this.fcSwitch.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
        }
        this.fcSwitch = chassis;
        Vector<Chassis> vector2 = new Vector<Chassis>();
        vector2.add(this.fcSwitch);
        this.switchDisplayPanel.setSwitchList(vector2);
        this.nameServerPanel.setSwitchList(vector2);
        this.switchCounterPanel.setSelectedSwitch(this.fcSwitch);
        this.portCountersPanel.setSelectedPorts(vector);
        this.portInfoPanel.setSelectedPorts(vector);
        this.bladeInfoPanel.setSelectedBlades(new Vector());
        this.trapLogPanel.setSelectedSwitch(this.fcSwitch);
        if (this.comDisplayPane != null) {
            this.comDisplayPanel.setAgent(this.fcSwitch.getComAgent());
            this.ensureTab("Com agent", this.comDisplayPane, true);
        }
        if (this.fcSwitch instanceof SanboxChassis) {
            SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
            this.ensureTab(nameServerStr, this.nameServerPanel, true, 0);
            this.ensureTab(switchStr, this.switchDisplayPanel, true);
            this.ensureTab(countersStr, this.switchCounterPanel, this.fcSwitch instanceof Sanbox);
            this.ensureTab(portCountersStr, this.portCountersPanel, true);
            this.ensureTab(portInfoStr, this.portInfoPanel, true);
            this.ensureTab(bladeInfoStr, this.bladeInfoPanel, this.fcSwitch instanceof Sanbox8000);
            this.ensureTab(zoningDbStr, this.zoningPanel, true);
            this.zoningPanel.setZones(this.fabric, sanboxChassis.getEportZoningDb());
            this.fcSwitch.getEventHandler().addChassisEventListener((ChassisEventListener)this);
        } else {
            this.ensureTab(nameServerStr, this.nameServerPanel, true);
            this.ensureTab(switchStr, this.switchDisplayPanel, true);
            this.ensureTab(countersStr, this.switchCounterPanel, false);
            this.ensureTab(portCountersStr, this.portCountersPanel, false);
            this.ensureTab(bladeInfoStr, this.bladeInfoPanel, false);
            this.ensureTab(portInfoStr, this.portInfoPanel, false);
            this.ensureTab(zoningDbStr, this.zoningPanel, false);
        }
        this.ensureTab(trapLogStr, this.trapLogPanel, this.fcSwitch instanceof Sanbox);
        this.doLayout();
        this.validate();
        this.repaint();
    }

    private void ensureTab(String string, Component component, boolean bl) {
        if (bl) {
            if (this.tabbedPane.indexOfTab(string) < 0) {
                this.tabbedPane.addTab(string, component);
            }
        } else if (this.tabbedPane.indexOfTab(string) >= 0) {
            this.tabbedPane.remove(component);
        }
    }

    private void ensureTab(String string, Component component, boolean bl, int n) {
        this.ensureTab(string, component, bl);
        int n2 = this.tabbedPane.indexOfTab(string);
        if (n2 >= 0 && n2 != n) {
            this.tabbedPane.remove(component);
            this.tabbedPane.insertTab(string, null, component, string, n);
        }
    }

    public void setPortsSelected(Vector vector) {
        this.portCountersPanel.setSelectedPorts(vector);
        this.portInfoPanel.setSelectedPorts(vector);
    }

    public void setBladesSelected(Vector vector) {
        this.bladeInfoPanel.setSelectedBlades(vector);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.zoningPanel.selectItemAtPoint(new Point(n, n2));
        int n3 = -1;
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            ZoneSet zoneSet = this.zoningPanel.getSelectedZoneSet();
            if ((this.fcSwitch.getComAgent().getLoginInfo().getLevel() == 2 || this.fcSwitch.getComAgent().getLoginInfo().getLevel() == 0 || this.fcSwitch.getComAgent().getLoginInfo().getLevel() == 3) && this.fcSwitch instanceof SanboxChassis && zoneSet != null && !zoneSet.getIsOrphanZoneSet()) {
                this.menu.show(this, n, n2);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ZoneSet zoneSet = this.zoningPanel.getSelectedZoneSet();
        if (this.fcSwitch instanceof SanboxChassis && zoneSet != null && !zoneSet.getIsOrphanZoneSet()) {
            SanboxChassis sanboxChassis = (SanboxChassis)this.fcSwitch;
            Zones zones = sanboxChassis.getEportZoningDb();
            JFrame jFrame = SbmUtilities.getFrame(this);
            ActivateZoneSetDialog activateZoneSetDialog = new ActivateZoneSetDialog((Frame)jFrame, sanboxChassis, zones, zoneSet);
            activateZoneSetDialog.setVisible(true);
        }
    }
}

