/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.SwitchBlade;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.qms.fabric.AbstractFaceplate;
import com.qlogic.qms.fabric.FaceplateListener;
import com.qlogic.qms.fabric.FaceplateStatusPanel;
import com.qlogic.qms.fabric.Sanbox16Faceplate;
import com.qlogic.qms.fabric.Sanbox2_16Faceplate;
import com.qlogic.qms.fabric.Sanbox2_8C_Faceplate;
import com.qlogic.qms.fabric.Sanbox2_8Faceplate;
import com.qlogic.qms.fabric.Sanbox8000Faceplate;
import com.qlogic.qms.fabric.Sanbox8Faceplate;
import com.qlogic.qms.fabric.SwitchBladeFaceplate;
import com.qlogic.qms.fabric.UnsupportedSwitchFaceplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;

public class FaceplateTopPanel
extends JPanel
implements ChassisEventListener,
Scrollable,
SwingConstants,
FabricEventListener {
    public static final int VIEW_PORT_TYPE = 0;
    public static final int VIEW_PORT_MODE = 1;
    public static final int VIEW_PORT_SPEED = 2;
    public static final int VIEW_GBIC_TYPE = 3;
    private static final int SCROLLPANE_PADDING = 4;
    private AbstractFaceplate faceplate;
    private Hashtable faceplateTable = new Hashtable();
    private FaceplateListener topListener;
    private FaceplateStatusPanel statusPanel;
    private Chassis fcSwitch;
    private int viewMode;
    private boolean topPanelSetup = false;
    private JPanel faceplatePanel;

    public FaceplateTopPanel(Chassis chassis, FaceplateListener faceplateListener, FaceplateStatusPanel faceplateStatusPanel) {
        this.statusPanel = faceplateStatusPanel;
        this.topListener = faceplateListener;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setSwitch(chassis);
    }

    public AbstractFaceplate getFaceplate() {
        return this.faceplate;
    }

    public Vector getMenuBarExtension() {
        return this.faceplate.getMenuBarExtension();
    }

    public void selectAll() {
        this.faceplate.selectAllPorts();
    }

    public void doZoning() {
        this.faceplate.doZoning();
    }

    public boolean zoningAllowed() {
        return this.faceplate.zoningAllowed();
    }

    public boolean placeFaceplateOnLeft() {
        return this.faceplate.placeFaceplateOnLeft();
    }

    public void setSwitch(Chassis chassis) {
        Object object;
        if (this.fcSwitch != null) {
            this.fcSwitch.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
        }
        this.fcSwitch = chassis;
        if (this.fcSwitch != null) {
            this.fcSwitch.getEventHandler().addChassisEventListener((ChassisEventListener)this);
            object = FabricList.getFabric((Chassis)this.fcSwitch);
            if (object != null) {
                object.addEventListener((FabricEventListener)this);
            }
        }
        object = null;
        object = (AbstractFaceplate)this.faceplateTable.get(this.fcSwitch);
        if (object == null) {
            if (this.fcSwitch instanceof Sanbox) {
                switch (this.fcSwitch.getPortCount()) {
                    case 8: {
                        object = new Sanbox8Faceplate((Sanbox)this.fcSwitch);
                        break;
                    }
                    case 16: {
                        object = new Sanbox16Faceplate((Sanbox)this.fcSwitch);
                    }
                }
            }
            if (this.fcSwitch instanceof Sanbox2) {
                if (this.fcSwitch instanceof Sanbox8000) {
                    object = new Sanbox8000Faceplate((Sanbox8000)this.fcSwitch);
                } else if (this.fcSwitch instanceof SwitchBlade) {
                    object = new SwitchBladeFaceplate((SwitchBlade)this.fcSwitch);
                } else {
                    switch (this.fcSwitch.getPortCount()) {
                        case 16: {
                            object = new Sanbox2_16Faceplate((Sanbox2)this.fcSwitch);
                            break;
                        }
                        case 8: {
                            if (this.fcSwitch.getChassisType() == 8) {
                                object = new Sanbox2_8Faceplate((Sanbox2)this.fcSwitch);
                            }
                            if (this.fcSwitch.getChassisType() != 30) break;
                            object = new Sanbox2_8C_Faceplate((Sanbox2)this.fcSwitch);
                        }
                    }
                }
            }
            if (object == null) {
                object = new UnsupportedSwitchFaceplate(this.fcSwitch);
            } else {
                ToolTipManager.sharedInstance().registerComponent((JComponent)object);
            }
            object.addListener(this.topListener);
            this.faceplateTable.put(this.fcSwitch, object);
        }
        if (this.faceplate != null) {
            this.faceplatePanel.remove(this.faceplate);
            this.faceplate.unregisterToListen();
        }
        this.faceplate = object;
        this.faceplate.registerToListen();
        this.faceplatePanel.add(this.faceplate);
        Dimension dimension = this.faceplate.getPreferredSize();
        this.faceplatePanel.setMaximumSize(dimension);
        this.faceplatePanel.setMinimumSize(dimension);
        this.faceplate.fireSelectionChanged();
        this.statusPanel.setSwStatus(this.fcSwitch);
        this.statusPanel.setSwName(this.fcSwitch);
        this.statusPanel.validate();
        this.doLayout();
        this.validate();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.faceplatePanel = new JPanel();
        this.add((Component)this.faceplatePanel, "West");
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        switch (fabricEvent.getEventType()) {
            case 2003: {
                Chassis chassis = (Chassis)fabricEvent.getValue();
                this.faceplateTable.remove(chassis);
            }
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.isSuccessful() && chassisEvent.getChassis().equals(this.fcSwitch)) {
            boolean bl = true;
            Chassis chassis = chassisEvent.getChassis();
            switch (chassisEvent.getEventType()) {
                case 208: {
                    this.statusPanel.setSwStatus(this.fcSwitch);
                    break;
                }
                case 200: 
                case 230: {
                    this.statusPanel.setSwName(this.fcSwitch);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                this.repaint();
            }
        }
    }

    public void setFaceplateMode(int n) {
        if (this.faceplate != null) {
            this.faceplate.setMode(n);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.faceplatePanel.getMinimumSize();
        return new Dimension((int)dimension.getWidth() + 5, (int)dimension.getHeight());
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    class RepaintFaceplateClass
    implements Runnable {
        RepaintFaceplateClass() {
        }

        public void run() {
            FaceplateTopPanel.this.invalidate();
            FaceplateTopPanel.this.repaint();
        }
    }
}

