/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.event.ComAgentEvent;
import com.qlogic.device.fcfabric.event.ComAgentEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import com.qlogic.qms.fabric.FabricTableModel;
import com.qlogic.ui.tools.SmartScrollingTable;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class NotificationPanel
extends JPanel
implements ComAgentEventListener {
    FabricTableModel tableModel = new FabricTableModel();
    JTable statTable = new SmartScrollingTable((TableModel)this.tableModel);
    ComAgent agent;
    Fabric fab;

    public NotificationPanel(Fabric fabric) {
        this.fab = fabric;
        this.agent = this.fab.getComAgent();
        this.fab.getComAgent().addComAgentListener((ComAgentEventListener)this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.tableModel.addColumn("Switch");
        this.tableModel.addColumn("Notification");
        this.tableModel.addColumn("Data");
        this.cleanoutTableData();
        this.setLayout(new GridLayout(1, 1));
        this.statTable.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.statTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.statTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.add(jScrollPane);
    }

    void cleanoutTableData() {
        this.tableModel.setRowCount(0);
    }

    public void receiveEvent(ComAgentEvent comAgentEvent) {
        if (comAgentEvent.getEventType() == 2) {
            SwingUtilities.invokeLater(new UpdateTableDataClass(comAgentEvent));
        }
    }

    public void updateTableData(ComAgentEvent comAgentEvent) {
        int n = this.tableModel.getRowCount();
        if (this.agent != null) {
            UtilMsgSml utilMsgSml = (UtilMsgSml)comAgentEvent.getValue();
            String string = utilMsgSml.getResponseStr();
            int n2 = string.indexOf("(");
            int n3 = string.indexOf(")");
            if (n2 > -1 && n3 > -1) {
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1, n3);
                if (string3.indexOf("NotifySwitchPing") >= 0) {
                    return;
                }
                String string4 = string.substring(n3 + 2);
                Chassis chassis = this.fab.getSwitchByWWN(new WorldWideName(string2));
                Vector vector = new Vector();
                this.tableModel.addRow(chassis);
                this.tableModel.setValueAt(string3, n, 1);
                this.tableModel.setValueAt(string4, n, 2);
                this.repaint();
            } else {
                this.tableModel.addRow("Unknown notification type");
                this.tableModel.setValueAt(string, n, 1);
                this.tableModel.setValueAt("Unable to strip data", n, 2);
            }
        }
    }

    class UpdateTableDataClass
    implements Runnable {
        ComAgentEvent evt;

        public UpdateTableDataClass(ComAgentEvent comAgentEvent) {
            this.evt = comAgentEvent;
        }

        public void run() {
            NotificationPanel.this.updateTableData(this.evt);
        }
    }
}

