/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.qms.fabric.AbstractFaceplate;
import com.qlogic.qms.fabric.SbmUtilities;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Sanbox16Faceplate
extends AbstractFaceplate {
    ImageIcon faceplateIcon;

    public Sanbox16Faceplate(Sanbox sanbox) throws IllegalArgumentException {
        super((Chassis)sanbox);
        if (this.faceplateIcon == null) {
            switch (sanbox.getModelType()) {
                case 1: {
                    this.faceplateIcon = new ImageIcon(SbmUtilities.getImage("Sanbox16FaceplateAB.gif"));
                    break;
                }
                default: {
                    this.faceplateIcon = new ImageIcon(SbmUtilities.getImage("Sanbox16Faceplate.gif"));
                }
            }
        }
        this.setFaceplateIcon(this.faceplateIcon);
        if (this.fcSwitch.getPortCount() != 16) {
            throw new IllegalArgumentException();
        }
    }

    protected int getPowerSupplyCount() {
        return this.fcSwitch.getPowerSupplyCount();
    }

    protected void paintPowerSupply(int n, Graphics graphics) {
        int n2 = 1;
        int n3 = 3;
        int n4 = 56;
        int n5 = 43;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 542;
                break;
            }
            default: {
                return;
            }
        }
        this.paintPowerSupply(n, graphics, n2, n3, n4, n5);
    }

    protected Icon getGbicIcon(FCPort fCPort, int n) {
        return this.getGBICIcon(fCPort, n);
    }

    public Rectangle getPort(int n) {
        if (n % 2 == 0) {
            return new Rectangle(37 + 65 * (n / 2), 78, 40, 15);
        }
        return new Rectangle(67 + 65 * ((n - 1) / 2), 59, 40, 15);
    }

    public int getPortCount() {
        return 16;
    }
}

