/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.qms.fabric.AbstractFaceplate;
import com.qlogic.qms.fabric.SbmUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Sanbox2_8C_Faceplate
extends AbstractFaceplate {
    private Rectangle[] portLocations = new Rectangle[8];
    private static final int FIRST_PORT_X = 118;
    private static final int FIRST_PORT_Y = 30;
    private static final int PORT_OFFSET_X = 23;
    private static final int PORT_WIDTH = 22;
    private static final int PORT_HEIGHT = 17;
    private static final int ROW_COUNT = 1;
    private static final int COLUMN_COUNT = 8;
    static ImageIcon faceplateIcon;

    public Sanbox2_8C_Faceplate(Sanbox2 sanbox2) throws IllegalArgumentException {
        super((Chassis)sanbox2);
        if (faceplateIcon == null) {
            faceplateIcon = new ImageIcon(SbmUtilities.getImage("Sanbox2_8CFaceplate.gif"));
        }
        this.setFaceplateIcon(faceplateIcon);
        if (this.fcSwitch.getPortCount() != 8) {
            throw new IllegalArgumentException();
        }
    }

    protected Icon getGbicIcon(FCPort fCPort, int n) {
        return this.getSFPIcon(fCPort, n);
    }

    public Rectangle getPort(int n) {
        if (this.portLocations[n] == null) {
            int n2 = 30;
            int n3 = 118 + 23 * n;
            this.portLocations[n] = new Rectangle(n3, n2, 22, 17);
        }
        return this.portLocations[n];
    }

    public int getPortCount() {
        return 8;
    }

    protected void paintLeds(Graphics graphics) {
    }

    protected Color getFanColor(int n) {
        switch (n) {
            case 0: {
                return Color.black;
            }
            case 1: {
                return Color.orange;
            }
            case 2: {
                return Color.red;
            }
        }
        return Color.blue;
    }

    protected Color getPowerColor(int n) {
        switch (n) {
            case 0: {
                return Color.green;
            }
            case 1: {
                return Color.orange;
            }
            case 2: {
                return Color.red;
            }
        }
        return Color.blue;
    }

    protected Color getTemperatureColor(int n) {
        switch (n) {
            case 0: {
                return Color.black;
            }
            case 1: {
                return Color.orange;
            }
            case 2: {
                return Color.red;
            }
        }
        return Color.blue;
    }

    protected int getPowerSupplyCount() {
        return 1;
    }

    protected void paintPowerSupply(int n, Graphics graphics) {
        int n2 = 11;
        int n3 = 10;
        int n4 = 36;
        int n5 = 50;
        this.paintPowerSupply(n, graphics, n2, n3, n4, n5);
    }

    protected String getPortModeTooltip(FCPort fCPort) {
        String string = "";
        PortStates portStates = fCPort.getPortStates();
        if (portStates != null) {
            switch (portStates.getConfigPortType()) {
                case 7: {
                    string = "E-port";
                    break;
                }
                case 2: {
                    string = "FL-port";
                    break;
                }
                case 1: {
                    string = "F-port";
                    break;
                }
                case 4: {
                    string = "SL-port";
                    break;
                }
                case 5: {
                    string = "TL-port";
                    break;
                }
                case 3: {
                    string = "T-port";
                    break;
                }
                case 8: {
                    string = "G-port";
                    break;
                }
                case 9: {
                    string = "GL-port";
                    break;
                }
                case 0: {
                    string = "Inactive";
                }
            }
        } else {
            string = "Unknown";
        }
        if (fCPort instanceof S16Port) {
            string = string + " " + AbstractFaceplate.getOperPortSpeedString(fCPort);
        }
        return string;
    }
}

