/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.FixedLengthTextField;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TrapConfigDialogSanbox
extends QDialog
implements ChassisEventListener {
    private Sanbox sanbox;
    private int[] traps = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 29, 30};
    public static final int OK_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private int option = 1;
    JPanel dataPanel;
    GridBagLayout dataLayout;
    JLabel trapsEnableLabel;
    JCheckBox trapsEnableBox;
    JLabel trapNameLabel;
    JComboBox trapNameComboBox;
    int lastTrapName = -1;
    JLabel risingLabel;
    FixedLengthTextField risingTextField;
    JLabel fallingLabel;
    FixedLengthTextField fallingTextField;
    JLabel enableLabel;
    JCheckBox enableBox;
    JLabel sampleIntervalLabel;
    FixedLengthTextField sampleIntervalTextField;
    JPanel buttonPanel;
    GridLayout buttonLayout;
    JButton okItemButton;
    JButton cancelButton;
    GridBagLayout newFabricLayout;
    String nameStr;
    Frame parentFrame;

    public TrapConfigDialogSanbox(Frame frame, Sanbox sanbox) {
        super(frame);
        this.parentFrame = frame;
        this.sanbox = sanbox;
        try {
            this.jbInit();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (this.sanbox.getNumberOfTraps() == 0) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("TrapConfigDialogSanbox.mustWait"));
            this.setVisible(false);
            return;
        }
        this.setTitle(FabricTreeControl.getResource("TrapConfigDialogSanbox.titleBarText") + " - " + VendorProperties.getFrameTitle());
        this.sanbox.setEditingTrapConfig(true);
        this.sanbox.addChassisEventListener((ChassisEventListener)this);
        this.setModal(true);
        this.dataPanel = new JPanel();
        this.dataLayout = new GridBagLayout();
        this.trapsEnableLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialogSanbox.enableAll"));
        this.trapsEnableBox = new JCheckBox();
        this.trapNameLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialogSanbox.trap"));
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.traps.length) {
            vector.add(this.sanbox.getTrapDef(this.traps[n]));
            ++n;
        }
        this.trapNameComboBox = new JComboBox(vector);
        this.trapNameComboBox.addActionListener(new MyComboBoxListener());
        this.risingLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialog.risingThresh"));
        this.risingTextField = new FixedLengthTextField(4);
        this.fallingLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialog.fallingThresh"));
        this.fallingTextField = new FixedLengthTextField(4);
        this.enableLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialog.enable"));
        this.enableBox = new JCheckBox();
        this.sampleIntervalLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialogSanbox.sampleInterval"));
        this.sampleIntervalTextField = new FixedLengthTextField(5);
        this.buttonPanel = new JPanel();
        this.buttonLayout = new GridLayout(1, 2, 8, 0);
        this.okItemButton = new JButton(new OkItemAction());
        this.cancelButton = new JButton(new CancelAction());
        this.newFabricLayout = new GridBagLayout();
        this.getContentPane().setLayout(this.newFabricLayout);
        this.trapNameLabel.setPreferredSize(new Dimension(160, 21));
        this.dataPanel.setLayout(this.dataLayout);
        this.dataPanel.add((Component)this.trapsEnableLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.trapsEnableBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.sampleIntervalLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.sampleIntervalTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.trapNameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.trapNameComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(20, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.risingLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.risingTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.fallingLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.fallingTextField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.enableLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.enableBox, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.getContentPane().add((Component)this.dataPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.add((Component)this.okItemButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.trapConfigDialogSanboxHelp"));
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getRootPane().setDefaultButton(this.okItemButton);
        this.fillTrapData(0);
        this.sampleIntervalTextField.setText(Integer.toString(this.sanbox.getSampleInterval()));
        this.trapsEnableBox.setSelected(this.sanbox.getTrapsEnabled());
        this.pack();
        this.trapNameLabel.requestFocus();
    }

    public int getOption() {
        return this.option;
    }

    private int takeTrapData(int n) {
        if (n >= 0) {
            int n2 = this.traps[n];
            int n3 = 0;
            try {
                n3 = Integer.parseInt("0" + this.risingTextField.getText());
            }
            catch (Exception exception) {
                PopupDialog.showDialog(this.parentFrame, 3, FabricTreeControl.getResource("TrapConfigDialogSanbox.invalidRisingThresh"));
                return -1;
            }
            int n4 = 0;
            try {
                n4 = Integer.parseInt("0" + this.fallingTextField.getText());
            }
            catch (Exception exception) {
                PopupDialog.showDialog(this.parentFrame, 3, FabricTreeControl.getResource("TrapConfigDialogSanbox.invalidFallingThresh"));
                return -1;
            }
            boolean bl = this.enableBox.isSelected();
            boolean bl2 = this.trapsEnableBox.isSelected();
            int n5 = 0;
            try {
                n5 = Integer.parseInt("0" + this.sampleIntervalTextField.getText());
            }
            catch (Exception exception) {
                PopupDialog.showDialog(this.parentFrame, 3, FabricTreeControl.getResource("TrapConfigDialogSanbox.invalidSampleInterval"));
                return -1;
            }
            this.sanbox.setTrapsEnabled(bl2);
            this.sanbox.setTrapConfig(n2, n3, n4, bl);
            this.sanbox.setSampleInterval(n5);
            return 1;
        }
        return -1;
    }

    private void fillTrapData(int n) {
        if (n >= 0) {
            int n2 = this.traps[n];
            this.enableBox.setSelected(this.sanbox.getTrapEnable(n2));
            this.risingTextField.setText(Integer.toString(this.sanbox.getTrapRisingThreadhold(n2)));
            this.fallingTextField.setText(Integer.toString(this.sanbox.getTrapFallingThreadhold(n2)));
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getChassis() != this.sanbox) {
            chassisEvent.getChassis().getEventHandler().removeChassisEventListener((ChassisEventListener)this);
            return;
        }
        if (chassisEvent.getEventType() == 275) {
            SwingUtilities.invokeLater(new ApplyDoneClass(chassisEvent));
        }
    }

    private void shutdownDialog() {
        this.sanbox.setEditingTrapConfig(false);
        this.sanbox.removeChassisEventListener((ChassisEventListener)this);
        this.sanbox.updateTrapInfo();
        this.setVisible(false);
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(FabricTreeControl.getResource("TrapConfigDialog.cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TrapConfigDialogSanbox.this.option = 2;
            TrapConfigDialogSanbox.this.shutdownDialog();
        }
    }

    class OkItemAction
    extends AbstractAction {
        public OkItemAction() {
            super(FabricTreeControl.getResource("TrapConfigDialog.ok"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TrapConfigDialogSanbox.this.trapNameComboBox.getSelectedIndex();
            if (n < 0) {
                PopupDialog.showDialog(TrapConfigDialogSanbox.this.parentFrame, 3, FabricTreeControl.getResource("TrapConfigDialogSanbox.invalidTrapSelection"));
                return;
            }
            if (TrapConfigDialogSanbox.this.takeTrapData(n) >= 0) {
                TrapConfigDialogSanbox.this.option = 1;
                TrapConfigDialogSanbox.this.sanbox.applyTrapConfig();
            }
        }
    }

    class MyComboBoxListener
    implements ActionListener {
        int lastIndex = 0;

        public void actionPerformed(ActionEvent actionEvent) {
            TrapConfigDialogSanbox.this.takeTrapData(this.lastIndex);
            this.lastIndex = TrapConfigDialogSanbox.this.trapNameComboBox.getSelectedIndex();
            if (this.lastIndex >= 0) {
                TrapConfigDialogSanbox.this.fillTrapData(this.lastIndex);
            }
        }
    }

    class ApplyDoneClass
    implements Runnable {
        ChassisEvent evt;

        public ApplyDoneClass(ChassisEvent chassisEvent) {
            this.evt = chassisEvent;
        }

        public void run() {
            if (this.evt.isSuccessful()) {
                JOptionPane.showMessageDialog(TrapConfigDialogSanbox.this, FabricTreeControl.getResource("TrapConfigDialogSanbox.trapConfiguredOk"));
                TrapConfigDialogSanbox.this.shutdownDialog();
            } else {
                JOptionPane.showMessageDialog(TrapConfigDialogSanbox.this, FabricTreeControl.getResource("TrapConfigDialogSanbox.trapConfigureFailed") + " " + FabricTreeControl.translateErrorType(this.evt.getErrorType()));
            }
        }
    }
}

