/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S43Port;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QColumnHeaderTextArea;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ExtCreditDialogSanbox
extends QDialog {
    JButton applyButton = new JButton(FabricTreeControl.getResource("ExtCreditDialog.apply"));
    JButton cancelButton = new JButton(FabricTreeControl.getResource("ExtCreditDialog.cancel"));
    GridBagLayout idLayout = new GridBagLayout();
    JLabel wwNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.wwNameLabel"));
    JLabel wwNameContent = new JLabel();
    JLabel ipAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.ipAddrLabel"));
    JLabel ipAddrContent = new JLabel();
    JLabel fcAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.fcAddrLabel"));
    JLabel fcAddrContent = new JLabel();
    JLabel curChassisNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.chassisNameLabel"));
    JLabel curChassisNameContent = new JLabel();
    QColumnHeaderTextArea portNumberLabel = new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.extCreditPortNumber"));
    QColumnHeaderTextArea portModeLabel = new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.extCreditPortMode"));
    QColumnHeaderTextArea extCreditModeLabel = new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.extCreditMode"));
    QColumnHeaderTextArea donorPortsLabel = new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donorPorts"));
    String noExtCredits = new String(FabricTreeControl.getResource("ExtCreditDialog.allPorts.normal"));
    String port0Ext16 = new String(FabricTreeControl.getResource("ExtCreditDialog.port0.ext16"));
    String port0Ext24 = new String(FabricTreeControl.getResource("ExtCreditDialog.port0.ext24"));
    String port0Ext32 = new String(FabricTreeControl.getResource("ExtCreditDialog.port0.ext32"));
    String port4Ext16 = new String(FabricTreeControl.getResource("ExtCreditDialog.port4.ext16"));
    String port4Ext24 = new String(FabricTreeControl.getResource("ExtCreditDialog.port4.ext24"));
    String port4Ext32 = new String(FabricTreeControl.getResource("ExtCreditDialog.port4.ext32"));
    String port8Ext16 = new String(FabricTreeControl.getResource("ExtCreditDialog.port8.ext16"));
    String port8Ext24 = new String(FabricTreeControl.getResource("ExtCreditDialog.port8.ext24"));
    String port8Ext32 = new String(FabricTreeControl.getResource("ExtCreditDialog.port8.ext32"));
    String port12Ext16 = new String(FabricTreeControl.getResource("ExtCreditDialog.port12.ext16"));
    String port12Ext24 = new String(FabricTreeControl.getResource("ExtCreditDialog.port12.ext24"));
    String port12Ext32 = new String(FabricTreeControl.getResource("ExtCreditDialog.port12.ext32"));
    String[] extCreditModeChoices = new String[]{FabricTreeControl.getResource("ExtCreditDialog.noExtCredits"), FabricTreeControl.getResource("ExtCreditDialog.ext16"), FabricTreeControl.getResource("ExtCreditDialog.ext24"), FabricTreeControl.getResource("ExtCreditDialog.ext32")};
    protected JLabel[] portNumberContent;
    protected JLabel[] portModeContent;
    protected JComboBox[] extCreditModeCombo;
    protected JLabel[] donorPortsContent;
    protected int[] curExtCreditMode;
    protected int[] curDonorPortMode;
    protected int[] reqExtCreditMode;
    protected int[] reqExtCreditPortNums;
    protected SanboxChassis blade = null;
    protected int portCount;
    protected ChassisEventAdapter eventAdapter = null;
    protected JFrame frame = null;
    protected JPanel donorPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel idPanel = null;
    protected boolean waitingOnApply = false;
    protected boolean waitingOnSave = false;

    public ExtCreditDialogSanbox(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("ExtCreditDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.portCount = this.blade.getPortCount();
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.donorPanel = this.createDonorPanel();
        this.buttonPanel = this.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.extCreditDialogSanboxHelp"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.idPanel = this.createIdPanel(this.blade);
        this.getContentPane().add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = this.portCount + 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.donorPanel, gridBagConstraints);
        gridBagConstraints.gridy = this.portCount + 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        this.validate();
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    protected void initIdPanel() {
        this.fcAddrContent.setText(this.blade.delimitFCAddress());
        this.curChassisNameContent.setText(this.blade.getChassisName());
        this.wwNameContent.setText(this.blade.getWWName().delimit());
        IPInfo iPInfo = this.blade.getIpInfo();
        if (iPInfo != null) {
            this.ipAddrContent.setText(iPInfo.getIpAddress().getHostAddress());
        } else {
            this.ipAddrContent.setText("unknown");
        }
    }

    protected void initExtCreditPanel() {
        this.portCount = this.blade.getPortCount();
        this.curDonorPortMode = new int[this.portCount];
        this.curExtCreditMode = new int[this.portCount / 4];
        this.reqExtCreditMode = new int[this.portCount / 4];
        this.reqExtCreditPortNums = new int[this.portCount / 4];
        int n = 0;
        while (n < this.portCount) {
            FCPort fCPort = this.blade.getPort(n);
            this.curDonorPortMode[n] = ((S43Port)fCPort).getDonorMode();
            if (n == 0 || n % 4 == 0) {
                int n2;
                this.reqExtCreditPortNums[n2] = n2 = n / 4;
                this.curExtCreditMode[n2] = ((Sanbox)this.blade).getExtCreditMode(n);
                this.reqExtCreditMode[n2] = ((Sanbox)this.blade).getExtCreditMode(n);
                this.extCreditModeCombo[n2].setSelectedIndex(this.curExtCreditMode[n2]);
                this.setDonorPortsContentText(n, this.curExtCreditMode[n2]);
                String string = this.getPortModeString(fCPort);
                this.portModeContent[n2].setText(string);
            }
            ++n;
        }
    }

    public JPanel createButtonPanel(ActionListener actionListener, ActionListener actionListener2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.applyButton.addActionListener(actionListener);
        this.applyButton.setMnemonic('O');
        this.cancelButton.addActionListener(actionListener2);
        this.cancelButton.setMnemonic('C');
        jPanel.add(this.applyButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public JPanel createIdPanel(SanboxChassis sanboxChassis) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = new JTextField().getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        jPanel.setLayout(this.idLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.wwNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.wwNameContent.setFont(font);
        this.wwNameContent.setForeground(Color.black);
        jPanel.add((Component)this.wwNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.curChassisNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.curChassisNameContent.setFont(font);
        this.curChassisNameContent.setForeground(Color.black);
        jPanel.add((Component)this.curChassisNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.fcAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.fcAddrContent.setFont(font);
        this.fcAddrContent.setForeground(Color.black);
        jPanel.add((Component)this.fcAddrContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.ipAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipAddrContent.setFont(font);
        this.ipAddrContent.setForeground(Color.black);
        jPanel.add((Component)this.ipAddrContent, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setBackground(Color.white);
        this.initIdPanel();
        return jPanel;
    }

    protected JPanel createDonorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.portNumberContent = new JLabel[this.portCount / 4];
        this.portModeContent = new JLabel[this.portCount / 4];
        this.extCreditModeCombo = new JComboBox[this.portCount / 4];
        this.donorPortsContent = new JLabel[this.portCount / 4];
        int n = new JTextField().getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        int n2 = 0;
        while (n2 < this.portCount / 4) {
            this.portNumberContent[n2] = new JLabel(Integer.toString(n2 * 4));
            this.portNumberContent[n2].setFont(font);
            this.portNumberContent[n2].setForeground(Color.black);
            this.portModeContent[n2] = new JLabel();
            this.portModeContent[n2].setFont(font);
            this.portModeContent[n2].setForeground(Color.black);
            this.extCreditModeCombo[n2] = new JComboBox<String>(this.extCreditModeChoices);
            this.extCreditModeCombo[n2].addActionListener(new ExtCreditComboListener(this, n2));
            this.donorPortsContent[n2] = new JLabel();
            Dimension dimension = new Dimension(200, 20);
            this.donorPortsContent[n2].setPreferredSize(dimension);
            this.donorPortsContent[n2].setFont(font);
            this.donorPortsContent[n2].setForeground(Color.black);
            ++n2;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 10, 1, 10);
        jPanel.add((Component)this.portNumberLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.portModeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.extCreditModeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.donorPortsLabel, gridBagConstraints);
        this.initExtCreditPanel();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.portCount / 4) {
            gridBagConstraints.gridy = n3++;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)this.portNumberContent[n4], gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)this.portModeContent[n4], gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)this.extCreditModeCombo[n4], gridBagConstraints);
            gridBagConstraints.gridx = 3;
            jPanel.add((Component)this.donorPortsContent[n4], gridBagConstraints);
            ++n4;
        }
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.validate();
        return jPanel;
    }

    protected String getPortModeString(FCPort fCPort) {
        String string = "";
        PortStates portStates = fCPort.getPortStates();
        if (portStates != null) {
            switch (portStates.getPortType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return this.getPortTypeString(portStates.getPortType());
                }
            }
            return this.getPortTypeString(portStates.getConfigPortType());
        }
        string = this.getPortTypeString(0);
        return string;
    }

    protected String getPortTypeString(int n) {
        String string = new String();
        switch (n) {
            case 6: {
                string = FabricTreeControl.getResource("AbstractFaceplate.donorPort");
                break;
            }
            case 7: {
                string = FabricTreeControl.getResource("AbstractFaceplate.ePort");
                break;
            }
            case 2: {
                string = FabricTreeControl.getResource("AbstractFaceplate.flPort");
                break;
            }
            case 1: {
                string = FabricTreeControl.getResource("AbstractFaceplate.fPort");
                break;
            }
            case 4: {
                string = FabricTreeControl.getResource("AbstractFaceplate.slPort");
                break;
            }
            case 5: {
                string = FabricTreeControl.getResource("AbstractFaceplate.tlPort");
                break;
            }
            case 3: {
                string = FabricTreeControl.getResource("AbstractFaceplate.tPort");
                break;
            }
            case 8: {
                string = FabricTreeControl.getResource("AbstractFaceplate.gPort");
                break;
            }
            case 9: {
                string = FabricTreeControl.getResource("AbstractFaceplate.glPort");
                break;
            }
            case 0: {
                string = FabricTreeControl.getResource("AbstractFaceplate.unknown");
                break;
            }
            default: {
                string = FabricTreeControl.getResource("AbstractFaceplate.inactivePort");
            }
        }
        return string;
    }

    protected void setDonorPortsContentText(int n, int n2) {
        if (n2 == 0) {
            this.donorPortsContent[n / 4].setText(this.noExtCredits);
        } else {
            block0 : switch (n) {
                case 0: {
                    switch (n2) {
                        case 1: {
                            this.donorPortsContent[n / 4].setText(this.port0Ext16);
                            break;
                        }
                        case 2: {
                            this.donorPortsContent[n / 4].setText(this.port0Ext24);
                            break;
                        }
                        case 3: {
                            this.donorPortsContent[n / 4].setText(this.port0Ext32);
                        }
                    }
                    break;
                }
                case 4: {
                    switch (n2) {
                        case 1: {
                            this.donorPortsContent[n / 4].setText(this.port4Ext16);
                            break;
                        }
                        case 2: {
                            this.donorPortsContent[n / 4].setText(this.port4Ext24);
                            break;
                        }
                        case 3: {
                            this.donorPortsContent[n / 4].setText(this.port4Ext32);
                        }
                    }
                    break;
                }
                case 8: {
                    switch (n2) {
                        case 1: {
                            this.donorPortsContent[n / 4].setText(this.port8Ext16);
                            break;
                        }
                        case 2: {
                            this.donorPortsContent[n / 4].setText(this.port8Ext24);
                            break;
                        }
                        case 3: {
                            this.donorPortsContent[n / 4].setText(this.port8Ext32);
                        }
                    }
                    break;
                }
                case 12: {
                    switch (n2) {
                        case 1: {
                            this.donorPortsContent[n / 4].setText(this.port12Ext16);
                            break block0;
                        }
                        case 2: {
                            this.donorPortsContent[n / 4].setText(this.port12Ext24);
                            break block0;
                        }
                        case 3: {
                            this.donorPortsContent[n / 4].setText(this.port12Ext32);
                        }
                    }
                }
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(300));
        return vector;
    }

    protected void registerForEvents() {
        this.eventAdapter.registerEventHandler(301, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(302, "receiveChassisEvent");
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.eventAdapter.unregisterEventHandler(301);
        this.eventAdapter.unregisterEventHandler(302);
    }

    public void disableButtons() {
        this.applyButton.setEnabled(false);
    }

    public void enableButtons() {
        this.applyButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyExtCreditRequests() {
        int n;
        this.waitingOnApply = true;
        this.waitingOnSave = true;
        this.registerForEvents();
        int n2 = 0;
        while (n2 < this.portCount / 4) {
            n = this.extCreditModeCombo[n2].getSelectedIndex();
            if (!((Sanbox)this.blade).isExtCreditModeValid(n2 * 4, n)) {
                int n3 = n2 * 4;
                PopupDialog.showDialog(this, 3, "Invalid selection for port " + n3 + ".\n" + "Borrowing credits from E-ports or TL-ports is not permitted.\n" + "Nor are TL-ports permitted to obtain extended credits.");
                return -1;
            }
            this.reqExtCreditMode[n2] = n;
            this.reqExtCreditPortNums[n2] = n2 * 4;
            ++n2;
        }
        n = ((Sanbox)this.blade).applyExtCredits(this.reqExtCreditPortNums, this.reqExtCreditMode) ? 1 : 0;
        if (n == 0) {
            PopupDialog.showDialog(this, 3, "Applying extended credit request failed.");
            return -1;
        }
        n = ((Sanbox)this.blade).applyActiveAdminPortTypesSave() ? 1 : 0;
        if (n == 0) {
            PopupDialog.showDialog(this, 3, "Saving extended credit request failed.");
            return -1;
        }
        return 1;
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        ExtCreditDialogSanbox dialog = null;

        public ApplyResponseHandler(ExtCreditDialogSanbox extCreditDialogSanbox2, ChassisEvent chassisEvent) {
            this.dialog = extCreditDialogSanbox2;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 301: {
                    ExtCreditDialogSanbox.this.waitingOnApply = false;
                    if (!this.evt.isSuccessful()) {
                        ExtCreditDialogSanbox.this.unregisterForEvents();
                        PopupDialog.showDialog(this.dialog, 3, "Setting extended credit request failed.\n[Reason: " + FabricTreeControl.translateErrorType(this.evt.getErrorType()) + "]");
                        ExtCreditDialogSanbox.this.enableButtons();
                        this.dialog.setVisible(false);
                    }
                    if (ExtCreditDialogSanbox.this.waitingOnSave) break;
                    ExtCreditDialogSanbox.this.unregisterForEvents();
                    ExtCreditDialogSanbox.this.enableButtons();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(ExtCreditDialogSanbox.this.frame, ExtCreditDialogSanbox.this.blade, ExtCreditDialogSanbox.this.getEventList(), FabricTreeControl.getResource("ExtCreditDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 302: {
                    ExtCreditDialogSanbox.this.waitingOnSave = false;
                    if (!this.evt.isSuccessful()) {
                        ExtCreditDialogSanbox.this.unregisterForEvents();
                        PopupDialog.showDialog(this.dialog, 3, "Saving extended credit request failed.\n[Reason: " + FabricTreeControl.translateErrorType(this.evt.getErrorType()) + "]");
                        ExtCreditDialogSanbox.this.enableButtons();
                        this.dialog.setVisible(false);
                    }
                    if (ExtCreditDialogSanbox.this.waitingOnApply) break;
                    ExtCreditDialogSanbox.this.unregisterForEvents();
                    ExtCreditDialogSanbox.this.enableButtons();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(ExtCreditDialogSanbox.this.frame, ExtCreditDialogSanbox.this.blade, ExtCreditDialogSanbox.this.getEventList(), FabricTreeControl.getResource("ExtCreditDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        ExtCreditDialogSanbox theDialog = null;

        public CancelButtonListener(ExtCreditDialogSanbox extCreditDialogSanbox2) {
            this.theDialog = extCreditDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExtCreditDialogSanbox.this.enableButtons();
            ExtCreditDialogSanbox.this.unregisterForEvents();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        ExtCreditDialogSanbox theDialog = null;

        public ApplyButtonListener(ExtCreditDialogSanbox extCreditDialogSanbox2) {
            this.theDialog = extCreditDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyExtCreditRequests() == 1) {
                if (ExtCreditDialogSanbox.this.waitingOnApply || ExtCreditDialogSanbox.this.waitingOnSave) {
                    ExtCreditDialogSanbox.this.disableButtons();
                }
            } else {
                ExtCreditDialogSanbox.this.unregisterForEvents();
                ExtCreditDialogSanbox.this.enableButtons();
            }
        }
    }

    class ExtCreditComboListener
    implements ActionListener {
        ExtCreditDialogSanbox theDialog = null;
        int index;

        public ExtCreditComboListener(ExtCreditDialogSanbox extCreditDialogSanbox2, int n) {
            this.theDialog = extCreditDialogSanbox2;
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ExtCreditDialogSanbox.this.extCreditModeCombo[this.index].getSelectedIndex();
            ExtCreditDialogSanbox.this.setDonorPortsContentText(this.index * 4, n);
        }
    }
}

