/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QColumnHeaderTextArea;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.Spinner;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ExtCreditDialogSanbox8000
extends QDialog {
    protected static int BLADE_COUNT = 8;
    protected static int PORT_COUNT = 8;
    JButton applyButton = new JButton(FabricTreeControl.getResource("ExtCreditDialog.apply"));
    JButton cancelButton = new JButton(FabricTreeControl.getResource("ExtCreditDialog.cancel"));
    GridBagLayout idLayout = new GridBagLayout();
    JLabel wwNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.wwNameLabel"));
    JLabel wwNameContent = new JLabel();
    JLabel ipAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.ipAddrLabel"));
    JLabel ipAddrContent = new JLabel();
    JLabel fcAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.fcAddrLabel"));
    JLabel fcAddrContent = new JLabel();
    JLabel curChassisNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.chassisNameLabel"));
    JLabel curChassisNameContent = new JLabel();
    QColumnHeaderTextArea[] portNumberLabel = new QColumnHeaderTextArea[]{new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portNumber")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portNumber")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portNumber")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portNumber")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portNumber")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portNumber")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portNumber")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portNumber"))};
    QColumnHeaderTextArea[] portModeLabel = new QColumnHeaderTextArea[]{new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portMode")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portMode")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portMode")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portMode")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portMode")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portMode")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portMode")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portMode"))};
    QColumnHeaderTextArea[] extCreditsLabel = new QColumnHeaderTextArea[]{new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.reqExtCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.reqExtCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.reqExtCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.reqExtCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.reqExtCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.reqExtCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.reqExtCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.reqExtCredits"))};
    QColumnHeaderTextArea[] maxCreditsLabel = new QColumnHeaderTextArea[]{new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.maxCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.maxCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.maxCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.maxCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.maxCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.maxCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.maxCredits")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.maxCredits"))};
    QColumnHeaderTextArea[] donatedToPortLabel = new QColumnHeaderTextArea[]{new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donatedToPort")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donatedToPort")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donatedToPort")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donatedToPort")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donatedToPort")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donatedToPort")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donatedToPort")), new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donatedToPort"))};
    JLabel[] creditPoolLabel = new JLabel[]{new JLabel(FabricTreeControl.getResource("ExtCreditDialog.creditPool")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.creditPool")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.creditPool")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.creditPool")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.creditPool")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.creditPool")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.creditPool")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.creditPool"))};
    JLabel[] note1Label = new JLabel[]{new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note1")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note1")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note1")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note1")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note1")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note1")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note1")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note1"))};
    JLabel[] note2Label = new JLabel[]{new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note2")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note2")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note2")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note2")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note2")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note2")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note2")), new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note2"))};
    JLabel[][] portNumberContent = new JLabel[BLADE_COUNT][PORT_COUNT];
    JLabel[][] portModeContent = new JLabel[BLADE_COUNT][PORT_COUNT];
    JLabel[][] maxCreditContent = new JLabel[BLADE_COUNT][PORT_COUNT];
    JLabel[][] donatedToPortContent = new JLabel[BLADE_COUNT][PORT_COUNT];
    JLabel[] creditPoolContent = new JLabel[BLADE_COUNT];
    Spinner[][] reqCreditSpinner = new Spinner[BLADE_COUNT][PORT_COUNT];
    protected Sanbox2 sanbox2 = null;
    protected int portCount;
    protected ChassisEventAdapter eventAdapter = null;
    protected JFrame frame = null;
    protected JPanel idPanel = null;
    protected JPanel buttonPanel = null;
    protected JTabbedPane tabPane = null;
    protected JPanel[] donorPanel = null;
    protected JPanel[] creditPoolPanel = null;
    protected boolean waitingOnApply = false;
    protected boolean waitingOnAdmin = false;
    protected int errCount = 0;
    protected boolean errAlreadyDisplayed = false;
    protected int responseCount = 0;
    protected int[] creditPool = new int[BLADE_COUNT];
    protected int[][] curExtCredits = new int[BLADE_COUNT][PORT_COUNT];
    protected int[][] maxExtCredits = new int[BLADE_COUNT][PORT_COUNT];
    protected int[][] minExtCredits = new int[BLADE_COUNT][PORT_COUNT];
    protected int[][] beholdenPort = new int[BLADE_COUNT][PORT_COUNT];

    public ExtCreditDialogSanbox8000(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("ExtCreditDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.sanbox2 = (Sanbox2)sanboxChassis;
        this.frame = jFrame;
        this.portCount = this.sanbox2.getPortCount();
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.sanbox2);
        this.tabPane = this.createTabPane();
        this.buttonPanel = this.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.extCreditDialogSanbox8000Help"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.idPanel = this.createIdPanel(this.sanbox2);
        this.getContentPane().add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 12;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        this.tabPane.setPreferredSize(new Dimension(550, 315));
        this.idPanel.setPreferredSize(new Dimension(550, 50));
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        this.validate();
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    protected void initIdPanel() {
        this.fcAddrContent.setText(this.sanbox2.delimitFCAddress());
        this.curChassisNameContent.setText(this.sanbox2.getChassisName());
        this.wwNameContent.setText(this.sanbox2.getWWName().delimit());
        IPInfo iPInfo = this.sanbox2.getIpInfo();
        if (iPInfo != null) {
            this.ipAddrContent.setText(iPInfo.getIpAddress().getHostAddress());
        } else {
            this.ipAddrContent.setText("unknown");
        }
    }

    protected void initTabPane() {
        int n = 0;
        while (n < BLADE_COUNT) {
            this.initExtCreditPanel(n);
            this.initCreditPoolPanel(n);
            ++n;
        }
    }

    protected void initCreditPoolPanel(int n) {
        Sanbox8000Blade sanbox8000Blade = ((Sanbox8000)this.sanbox2).getBlade(n);
        this.creditPool[n] = sanbox8000Blade.getUnusedCreditPool();
        this.creditPoolContent[n].setText(Integer.toString(this.creditPool[n]));
    }

    protected void initExtCreditPanel(int n) {
        int n2 = n * BLADE_COUNT;
        int n3 = n2 + PORT_COUNT;
        int n4 = 0;
        while (n4 < PORT_COUNT) {
            S16Port s16Port = (S16Port)this.sanbox2.getPort(n * BLADE_COUNT + n4);
            this.curExtCredits[n][n4] = s16Port.getExtCredits();
            this.minExtCredits[n][n4] = s16Port.getMinExtCredits();
            this.maxExtCredits[n][n4] = s16Port.getMaxCredits();
            this.beholdenPort[n][n4] = s16Port.getPortDonatedTo();
            String string = SbmUtilities.getPortConfigModeString(s16Port.getPortStates());
            if (string.equals("don")) {
                string = "Donor";
            }
            this.portModeContent[n][n4].setText(string);
            this.reqCreditSpinner[n][n4].setText(Integer.toString(this.curExtCredits[n][n4]));
            this.maxCreditContent[n][n4].setText(Integer.toString(this.maxExtCredits[n][n4]));
            this.setSpinnerEnables(n4, this.reqCreditSpinner[n][n4]);
            if (this.beholdenPort[n][n4] >= 0) {
                this.donatedToPortContent[n][n4].setText(Integer.toString(this.beholdenPort[n][n4]));
            } else {
                this.donatedToPortContent[n][n4].setText(FabricTreeControl.getResource("ExtCreditDialog.none"));
            }
            ++n4;
        }
    }

    public JPanel createButtonPanel(ActionListener actionListener, ActionListener actionListener2) {
        JPanel jPanel = new JPanel();
        this.applyButton.addActionListener(actionListener);
        this.applyButton.setMnemonic('O');
        this.cancelButton.addActionListener(actionListener2);
        this.cancelButton.setMnemonic('C');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.applyButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public JPanel createIdPanel(Sanbox2 sanbox2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = new JTextField().getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        jPanel.setLayout(this.idLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.wwNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.wwNameContent.setFont(font);
        this.wwNameContent.setForeground(Color.black);
        jPanel.add((Component)this.wwNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.curChassisNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.curChassisNameContent.setFont(font);
        this.curChassisNameContent.setForeground(Color.black);
        jPanel.add((Component)this.curChassisNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.fcAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.fcAddrContent.setFont(font);
        this.fcAddrContent.setForeground(Color.black);
        jPanel.add((Component)this.fcAddrContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.ipAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipAddrContent.setFont(font);
        this.ipAddrContent.setForeground(Color.black);
        jPanel.add((Component)this.ipAddrContent, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setBackground(Color.white);
        this.initIdPanel();
        return jPanel;
    }

    protected JTabbedPane createTabPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.donorPanel = new JPanel[BLADE_COUNT];
        this.creditPoolPanel = new JPanel[BLADE_COUNT];
        int n = 0;
        while (n < BLADE_COUNT) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.donorPanel[n] = this.createDonorPanel(n);
            this.creditPoolPanel[n] = this.createCreditPoolPanel(n);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 12;
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            jPanel.add((Component)this.donorPanel[n], gridBagConstraints);
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridheight = 1;
            jPanel.add((Component)this.creditPoolPanel[n], gridBagConstraints);
            String string = "Blade " + Integer.toString(n);
            jTabbedPane.add(string, jPanel);
            ++n;
        }
        return jTabbedPane;
    }

    protected JPanel createCreditPoolPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = new JTextField().getFont().getSize();
        Font font = new Font("Dialog", 0, n2);
        Font font2 = new Font("Dialog", 1, n2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 40, 1, 2);
        jPanel.add((Component)this.creditPoolLabel[n], gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(1, 2, 1, 40);
        gridBagConstraints.anchor = 17;
        this.creditPoolContent[n] = new JLabel();
        this.creditPoolContent[n].setFont(font);
        this.creditPoolContent[n].setForeground(Color.black);
        jPanel.add((Component)this.creditPoolContent[n], gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 60, 1, 4);
        this.note1Label[n].setFont(font2);
        jPanel.add((Component)this.note1Label[n], gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(1, 160, 1, 4);
        this.note2Label[n].setFont(font2);
        jPanel.add((Component)this.note2Label[n], gridBagConstraints);
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.initCreditPoolPanel(n);
        return jPanel;
    }

    protected JPanel createDonorPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = new JTextField().getFont().getSize();
        Font font = new Font("Dialog", 0, n2);
        int n3 = 0;
        while (n3 < PORT_COUNT) {
            this.portNumberContent[n][n3] = new JLabel(Integer.toString(n * BLADE_COUNT + n3));
            this.portNumberContent[n][n3].setFont(font);
            this.portNumberContent[n][n3].setForeground(Color.black);
            this.portModeContent[n][n3] = new JLabel();
            this.portModeContent[n][n3].setFont(font);
            this.portModeContent[n][n3].setForeground(Color.black);
            this.reqCreditSpinner[n][n3] = new Spinner();
            this.reqCreditSpinner[n][n3].setUpArrowAction(this, "upArrowAction");
            this.reqCreditSpinner[n][n3].setDownArrowAction(this, "downArrowAction");
            this.maxCreditContent[n][n3] = new JLabel();
            this.maxCreditContent[n][n3].setFont(font);
            this.maxCreditContent[n][n3].setForeground(Color.black);
            this.donatedToPortContent[n][n3] = new JLabel();
            this.donatedToPortContent[n][n3].setFont(font);
            this.donatedToPortContent[n][n3].setForeground(Color.black);
            ++n3;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 7, 1, 7);
        jPanel.add((Component)this.portNumberLabel[n], gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.portModeLabel[n], gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(1, 15, 1, 7);
        jPanel.add((Component)this.extCreditsLabel[n], gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(1, 7, 1, 7);
        jPanel.add((Component)this.maxCreditsLabel[n], gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel.add((Component)this.donatedToPortLabel[n], gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 20, 1, 20);
        int n4 = 0;
        while (n4 < PORT_COUNT) {
            gridBagConstraints.gridy = n4 + 1;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)this.portNumberContent[n][n4], gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)this.portModeContent[n][n4], gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)this.reqCreditSpinner[n][n4], gridBagConstraints);
            gridBagConstraints.gridx = 3;
            jPanel.add((Component)this.maxCreditContent[n][n4], gridBagConstraints);
            gridBagConstraints.gridx = 4;
            jPanel.add((Component)this.donatedToPortContent[n][n4], gridBagConstraints);
            ++n4;
        }
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.initExtCreditPanel(n);
        return jPanel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(288));
        return vector;
    }

    protected void registerForEvents() {
        this.eventAdapter.registerEventHandler(287, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(238, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(239, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(237, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(264, "receiveChassisEvent");
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.eventAdapter.unregisterEventHandler(287);
        this.eventAdapter.unregisterEventHandler(238);
        this.eventAdapter.unregisterEventHandler(239);
        this.eventAdapter.unregisterEventHandler(237);
        this.eventAdapter.unregisterEventHandler(264);
    }

    public void disableButtons() {
        this.applyButton.setEnabled(false);
    }

    public void enableButtons() {
        this.applyButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyExtCreditRequests() {
        this.waitingOnApply = true;
        this.waitingOnAdmin = true;
        this.errAlreadyDisplayed = false;
        this.responseCount = 0;
        this.errCount = 0;
        this.registerForEvents();
        this.sanbox2.requestAdmin();
        this.sanbox2.editConfig();
        int n = 0;
        while (n < BLADE_COUNT) {
            int n2 = 0;
            while (n2 < PORT_COUNT) {
                String string = this.reqCreditSpinner[n][n2].getText();
                int n3 = 0;
                try {
                    n3 = Integer.decode(string);
                    this.sanbox2.applyExtCredit(n * BLADE_COUNT + n2, n3);
                }
                catch (Exception exception) {
                    System.err.println("Non-integer value found in requested extended credit column");
                    this.waitingOnApply = false;
                    this.sanbox2.releaseAdmin();
                    return -1;
                }
                ++n2;
            }
            ++n;
        }
        this.sanbox2.saveConfig();
        this.sanbox2.activateConfigAndReleaseAdmin(20000, 3000);
        return 1;
    }

    private int getPortIndexOfSpinner(Spinner spinner, int n) {
        int n2 = 0;
        while (n2 < PORT_COUNT) {
            if (spinner.equals(this.reqCreditSpinner[n][n2])) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public void upArrowAction(Spinner spinner) {
        block2: {
            int n = this.tabPane.getSelectedIndex();
            int n2 = this.getPortIndexOfSpinner(spinner, n);
            S16Port s16Port = (S16Port)this.sanbox2.getPort(n2);
            String string = spinner.getText();
            if (string == null) break block2;
            try {
                int n3 = Integer.decode(string);
                n3 = n3 < s16Port.getMaxExtCredits() - 11 ? (n3 += 11) : s16Port.getMaxExtCredits();
                spinner.setText(Integer.toString(n3));
                this.setSpinnerEnables(n2, spinner);
            }
            catch (Exception exception) {}
        }
    }

    public void downArrowAction(Spinner spinner) {
        block2: {
            int n = this.tabPane.getSelectedIndex();
            int n2 = this.getPortIndexOfSpinner(spinner, n);
            S16Port s16Port = (S16Port)this.sanbox2.getPort(n2);
            String string = spinner.getText();
            if (string == null) break block2;
            try {
                int n3 = Integer.decode(string);
                n3 = n3 >= s16Port.getMinExtCredits() + 11 ? (n3 -= 11) : 0;
                spinner.setText(Integer.toString(n3));
                this.setSpinnerEnables(n2, spinner);
            }
            catch (Exception exception) {}
        }
    }

    private void setSpinnerEnables(int n, Spinner spinner) {
        S16Port s16Port;
        int n2 = Integer.parseInt(spinner.getText());
        spinner.downButtonSetEnabled(n2 > (s16Port = (S16Port)this.sanbox2.getPort(n)).getMinExtCredits());
        spinner.upButtonSetEnabled(n2 < s16Port.getMaxExtCredits());
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        ExtCreditDialogSanbox8000 dialog = null;
        String errStr = new String();

        public ApplyResponseHandler(ExtCreditDialogSanbox8000 extCreditDialogSanbox80002, ChassisEvent chassisEvent) {
            this.dialog = extCreditDialogSanbox80002;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 287: {
                    ++ExtCreditDialogSanbox8000.this.responseCount;
                    if (!this.evt.isSuccessful()) {
                        ++ExtCreditDialogSanbox8000.this.errCount;
                        this.errStr = this.errStr + FabricTreeControl.translateErrorType(this.evt.getErrorType());
                    }
                    if (ExtCreditDialogSanbox8000.this.responseCount != ExtCreditDialogSanbox8000.this.portCount) break;
                    if (ExtCreditDialogSanbox8000.this.errCount > 0) {
                        ExtCreditDialogSanbox8000.this.errAlreadyDisplayed = true;
                        String string = FabricTreeControl.getResource("ExtCreditDialog.error.applyRequestFailed") + " on " + Integer.toString(ExtCreditDialogSanbox8000.this.errCount) + " ports. \n" + "[Reason: " + this.errStr + "]";
                        PopupDialog.showDialog(this.dialog, 3, string);
                    }
                    ExtCreditDialogSanbox8000.this.waitingOnApply = false;
                    break;
                }
                case 238: {
                    ExtCreditDialogSanbox8000.this.waitingOnAdmin = false;
                    if (this.evt.isSuccessful()) break;
                    ExtCreditDialogSanbox8000.this.unregisterForEvents();
                    ExtCreditDialogSanbox8000.this.errAlreadyDisplayed = true;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("ExtCreditDialog.error.adminReqFailed") + "\n" + ExtCreditDialogSanbox8000.this.getFailedString(this.evt.getErrorType()));
                    ExtCreditDialogSanbox8000.this.enableButtons();
                    this.dialog.setVisible(false);
                    break;
                }
                case 264: {
                    if (!this.evt.isSuccessful() && !ExtCreditDialogSanbox8000.this.errAlreadyDisplayed) {
                        ExtCreditDialogSanbox8000.this.unregisterForEvents();
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("ExtCreditDialog.error.saveAndActivateConfigFailed") + "\n" + ExtCreditDialogSanbox8000.this.getFailedString(this.evt.getErrorType()));
                        ExtCreditDialogSanbox8000.this.errAlreadyDisplayed = true;
                        ExtCreditDialogSanbox8000.this.enableButtons();
                        this.dialog.setVisible(false);
                    }
                    if (ExtCreditDialogSanbox8000.this.waitingOnApply) break;
                    ExtCreditDialogSanbox8000.this.unregisterForEvents();
                    ExtCreditDialogSanbox8000.this.enableButtons();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(ExtCreditDialogSanbox8000.this.frame, (SanboxChassis)ExtCreditDialogSanbox8000.this.sanbox2, ExtCreditDialogSanbox8000.this.getEventList(), FabricTreeControl.getResource("ExtCreditDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 237: {
                    if (this.evt.isSuccessful() || ExtCreditDialogSanbox8000.this.errAlreadyDisplayed) break;
                    ExtCreditDialogSanbox8000.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("ExtCreditDialog.error.editConfigFailed") + "\n" + ExtCreditDialogSanbox8000.this.getFailedString(this.evt.getErrorType()));
                    ExtCreditDialogSanbox8000.this.errAlreadyDisplayed = true;
                    ExtCreditDialogSanbox8000.this.enableButtons();
                    this.dialog.setVisible(false);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        ExtCreditDialogSanbox8000 theDialog = null;

        public CancelButtonListener(ExtCreditDialogSanbox8000 extCreditDialogSanbox80002) {
            this.theDialog = extCreditDialogSanbox80002;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExtCreditDialogSanbox8000.this.enableButtons();
            ExtCreditDialogSanbox8000.this.unregisterForEvents();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        ExtCreditDialogSanbox8000 theDialog = null;

        public ApplyButtonListener(ExtCreditDialogSanbox8000 extCreditDialogSanbox80002) {
            this.theDialog = extCreditDialogSanbox80002;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyExtCreditRequests() == 1) {
                if (ExtCreditDialogSanbox8000.this.waitingOnApply || ExtCreditDialogSanbox8000.this.waitingOnAdmin) {
                    ExtCreditDialogSanbox8000.this.disableButtons();
                }
            } else {
                ExtCreditDialogSanbox8000.this.unregisterForEvents();
                ExtCreditDialogSanbox8000.this.enableButtons();
            }
        }
    }
}

