/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.SanboxUtil;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.DialogCreateException;
import com.qlogic.qms.fabric.propertyDialogs.SwitchProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.FixedLengthTextField;
import com.qlogic.ui.QDialog;
import com.qlogic.util.IpAddress;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NetworkPropertiesDialogSanbox
extends QDialog {
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter chassisEventAdapter = null;
    protected Fabric fabric = null;
    protected JFrame frame = null;
    protected JPanel networkPanel = null;
    protected JPanel buttonPanel = null;
    protected boolean waitingOnIpChange = false;
    protected boolean waitingOnSnmpChange = false;
    protected boolean waitingOnSnmpCommunities = false;
    protected boolean waitingOnReset = false;
    protected SwitchProperties properties = new SwitchProperties();
    InetAddress newIpAddress = null;
    boolean ipChangeSuccessful = false;
    GridBagLayout baseLayout = new GridBagLayout();
    String[] bootMethodChoices = new String[]{FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodChoice.0"), FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodChoice.1"), FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodChoice.2"), FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodChoice.3")};
    JPanel idPanel = new JPanel();
    GridBagLayout idLayout = new GridBagLayout();
    JLabel wwNameLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.wwNameLabel"));
    JLabel wwNameContent = new JLabel();
    JLabel opStateLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.opStateLabel"));
    JLabel opStateContent = new JLabel();
    JLabel fcAddrLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.fcAddrLabel"));
    JLabel fcAddrContent = new JLabel();
    JLabel firmwareLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.firmwareLabel"));
    JLabel firmwareContent = new JLabel();
    JLabel chassisNameLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.chassisNameLabel"));
    JLabel chassisNameContent = new JLabel();
    JLabel macAddrLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.macAddrLabel"));
    JLabel macAddrContent = new JLabel();
    JPanel ipPanel = new JPanel();
    GridBagLayout ipLayout = new GridBagLayout();
    JLabel ipLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.ipLabel"));
    JLabel ipAddrLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.ipAddrLabel"));
    JLabel subnetMaskLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.subnetMaskLabel"));
    JLabel gatewayLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.gatewayLabel"));
    JLabel bootMethodLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodLabel"));
    JTextField ipAddrText = new JTextField();
    JTextField subnetMaskText = new JTextField();
    JTextField gatewayText = new JTextField();
    JComboBox bootMethodCombo = new JComboBox<String>(this.bootMethodChoices);
    JPanel snmpPanel = new JPanel();
    GridBagLayout snmpLayout = new GridBagLayout();
    JLabel snmpLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.snmpLabel"));
    JLabel contactLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.contactLabel"));
    JLabel locationLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.locationLabel"));
    JLabel trapAddrLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapAddrLabel"));
    JLabel readCommLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.readCommLabel"));
    JLabel writeCommLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.writeCommLabel"));
    JLabel trapCommLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapCommLabel"));
    JLabel trapAuthLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapAuthLabel"));
    String[] trapAuthChoices = new String[]{FabricTreeControl.getResource("NetworkPropertiesDialog.trapAuthEnabled"), FabricTreeControl.getResource("NetworkPropertiesDialog.trapAuthDisabled")};
    public FixedLengthTextField contactText = new FixedLengthTextField(32);
    public FixedLengthTextField locationText = new FixedLengthTextField(32);
    public FixedLengthTextField trapAddrText = new FixedLengthTextField(32);
    public FixedLengthTextField readCommText = new FixedLengthTextField(32);
    public FixedLengthTextField writeCommText = new FixedLengthTextField(32);
    public FixedLengthTextField trapCommText = new FixedLengthTextField(32);
    public JComboBox trapAuthCombo = new JComboBox<String>(this.trapAuthChoices);

    public NetworkPropertiesDialogSanbox(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, Fabric fabric) throws DialogCreateException {
        super((Frame)jFrame, bl);
        if (sanboxChassis == null || sanboxChassis.getSnmpInfo() == null) {
            throw new DialogCreateException();
        }
        if (sanboxChassis.getIpInfo() == null) {
            throw new DialogCreateException();
        }
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.frame = jFrame;
        this.setTitle(FabricTreeControl.getResource("NetworkPropertiesDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.networkPanel = this.buildPanel();
        this.bootMethodCombo.addActionListener(new BootMethodComboListener(this));
        this.resetPanel();
        this.buttonPanel = this.properties.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.networkPropertiesDialogSanboxHelp"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.networkPanel, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.properties.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void setSwitch(SanboxChassis sanboxChassis, Fabric fabric) {
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.unregisterForEvents();
        this.resetDialog();
    }

    public void resetDialog() {
        this.resetPanel();
        this.setEnabled(true);
    }

    public void resetDialog(SanboxChassis sanboxChassis, Fabric fabric) throws DialogCreateException {
        this.unregisterForEvents();
        this.waitingOnIpChange = false;
        this.waitingOnSnmpChange = false;
        this.waitingOnSnmpCommunities = false;
        this.waitingOnReset = false;
        this.newIpAddress = null;
        this.ipChangeSuccessful = false;
        if (sanboxChassis == null || sanboxChassis.getSnmpInfo() == null) {
            throw new DialogCreateException();
        }
        if (sanboxChassis.getIpInfo() == null) {
            throw new DialogCreateException();
        }
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.resetDialog();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.bootMethodCombo.getSelectedIndex() == 2) {
            this.ipAddrText.setEnabled(false);
            this.ipAddrLabel.setEnabled(false);
        } else {
            this.ipAddrText.setEnabled(bl);
            this.ipAddrLabel.setEnabled(bl);
        }
        this.subnetMaskText.setEnabled(bl);
        this.gatewayText.setEnabled(bl);
        this.bootMethodCombo.setEnabled(bl);
        this.contactText.setEnabled(bl);
        this.locationText.setEnabled(bl);
        this.trapAddrText.setEnabled(bl);
        this.readCommText.setEnabled(bl);
        this.writeCommText.setEnabled(bl);
        this.trapCommText.setEnabled(bl);
        this.trapAuthCombo.setEnabled(bl);
    }

    public void resetPanel() {
        this.wwNameContent.setText(this.blade.getWWName().delimit());
        int n = this.blade.getAdminMode();
        switch (n) {
            case 1: {
                this.opStateContent.setText(FabricTreeControl.getResource("NetworkPropertiesDialog.opStateContent.0"));
                break;
            }
            case 2: {
                this.opStateContent.setText(FabricTreeControl.getResource("NetworkPropertiesDialog.opStateContent.1"));
                break;
            }
            case 3: {
                this.opStateContent.setText(FabricTreeControl.getResource("NetworkPropertiesDialog.opStateContent.2"));
            }
        }
        this.fcAddrContent.setText(this.blade.delimitFCAddress());
        this.firmwareContent.setText(this.blade.getFlashVersionString());
        this.chassisNameContent.setText(this.blade.getChassisName());
        this.macAddrContent.setText(this.blade.delimitMacAddress());
        int n2 = this.wwNameContent.getFont().getSize();
        Font font = new Font("Dialog", 0, n2);
        this.wwNameContent.setFont(font);
        this.wwNameContent.setForeground(Color.black);
        this.opStateContent.setFont(font);
        this.opStateContent.setForeground(Color.black);
        this.fcAddrContent.setFont(font);
        this.fcAddrContent.setForeground(Color.black);
        this.firmwareContent.setFont(font);
        this.firmwareContent.setForeground(Color.black);
        this.chassisNameContent.setFont(font);
        this.chassisNameContent.setForeground(Color.black);
        this.macAddrContent.setFont(font);
        this.macAddrContent.setForeground(Color.black);
        IPInfo iPInfo = this.blade.getIpInfo();
        this.ipAddrText.setText(iPInfo.getIpAddress().getHostAddress());
        this.subnetMaskText.setText(SwitchProperties.intToIpString(iPInfo.getNetMask()));
        this.gatewayText.setText(iPInfo.getGateway().getHostAddress());
        int n3 = iPInfo.getIpBootProcess();
        switch (n3) {
            case 0: {
                this.bootMethodCombo.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.bootMethodCombo.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.bootMethodCombo.setSelectedIndex(2);
                this.ipAddrText.setEnabled(false);
                this.ipAddrLabel.setEnabled(false);
                break;
            }
            case 3: {
                this.bootMethodCombo.setSelectedIndex(3);
            }
        }
        SnmpInfo snmpInfo = this.blade.getSnmpInfo();
        this.contactText.setText(snmpInfo.getContact());
        this.contactText.setCaretPosition(0);
        this.locationText.setText(snmpInfo.getLocation());
        this.locationText.setCaretPosition(0);
        if (snmpInfo.getTrapAddress() != null) {
            this.trapAddrText.setText(snmpInfo.getTrapAddress().getHostAddress());
        }
        this.readCommText.setText("");
        this.writeCommText.setText("");
        this.trapCommText.setText("");
        this.trapAuthCombo.setSelectedIndex(snmpInfo.getDoAuthTrap() == 1L ? 0 : 1);
        this.validate();
    }

    protected JPanel buildPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.baseLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 4;
        jPanel.add((Component)this.ipPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        jPanel.add((Component)this.snmpPanel, gridBagConstraints);
        this.idPanel.setLayout(this.idLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        this.idPanel.add((Component)this.wwNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.wwNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.opStateLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.opStateContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.chassisNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.chassisNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.fcAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.fcAddrContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.firmwareLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.firmwareContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.macAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.macAddrContent, gridBagConstraints);
        this.idPanel.setBorder(BorderFactory.createEtchedBorder());
        this.idPanel.setBackground(Color.white);
        this.ipPanel.setLayout(this.ipLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.ipPanel.add((Component)this.ipLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.ipAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.ipAddrText.setColumns(14);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.ipAddrText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.subnetMaskLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.subnetMaskText.setColumns(12);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.subnetMaskText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.gatewayLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.gatewayText.setColumns(12);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.gatewayText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.bootMethodLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.bootMethodCombo, gridBagConstraints);
        this.ipPanel.setBorder(BorderFactory.createEtchedBorder());
        this.snmpPanel.setLayout(this.snmpLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.snmpPanel.add((Component)this.snmpLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.snmpPanel.add((Component)this.contactLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.contactText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.contactText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.locationText, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapAddrText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapAuthLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapAuthCombo, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.snmpPanel.add((Component)this.readCommLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.readCommText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.writeCommLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.writeCommText, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapCommLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapCommText, gridBagConstraints);
        this.snmpPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public void disableButtons() {
        this.properties.applyButton.setEnabled(false);
        this.networkPanel.setEnabled(false);
        this.setEnabled(false);
    }

    public void enableButtons() {
        this.properties.applyButton.setEnabled(true);
        this.properties.cancelButton.setEnabled(true);
        this.networkPanel.setEnabled(true);
        this.setEnabled(true);
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyNetworkProperties() {
        int n;
        IPInfo iPInfo;
        int n2 = 0;
        int n3 = 0;
        InetAddress inetAddress = null;
        this.waitingOnIpChange = false;
        this.waitingOnSnmpChange = false;
        this.waitingOnSnmpCommunities = false;
        this.waitingOnReset = false;
        this.newIpAddress = null;
        this.ipChangeSuccessful = false;
        String string = this.ipAddrText.getText().trim();
        String string2 = this.subnetMaskText.getText().trim();
        String string3 = this.gatewayText.getText().trim();
        if (string.length() == 0) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidIpAddr"));
            return -1;
        }
        if (IpAddress.isNumeric(string) && !IpAddress.isValidNumeric(string)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidIpAddr"));
            return -1;
        }
        try {
            this.newIpAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidIpAddr"));
            return -1;
        }
        if (IpAddress.isNumeric(string2) && !IpAddress.isValidMask(string2)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidNetMask"));
            return -1;
        }
        try {
            InetAddress inetAddress2 = InetAddress.getByName(string2);
            if (inetAddress2 == null) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.inetAddrFailed"));
                return -1;
            }
            n3 = SwitchProperties.inetToInt(inetAddress2);
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidNetMask"));
            return -1;
        }
        boolean bl = false;
        if (string2.length() == 0) {
            bl = true;
            iPInfo = this.blade.getIpInfo();
            n3 = iPInfo.getNetMask();
        }
        if (IpAddress.isNumeric(string3) && !IpAddress.isValidNumeric(string3)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidGateway"));
            return -1;
        }
        try {
            inetAddress = InetAddress.getByName(string3);
        }
        catch (UnknownHostException unknownHostException) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidGateway"));
            return -1;
        }
        boolean bl2 = false;
        if (string3.length() == 0) {
            bl2 = true;
            iPInfo = this.blade.getIpInfo();
            inetAddress = iPInfo.getGateway();
        }
        if ((n = this.bootMethodCombo.getSelectedIndex()) < 0) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidBootMethod"));
            return -1;
        }
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        iPInfo = this.blade.getIpInfo();
        IPInfo iPInfo2 = new IPInfo();
        if (!this.newIpAddress.equals(iPInfo.getIpAddress()) || !inetAddress.equals(iPInfo.getGateway()) || n3 != iPInfo.getNetMask() || n2 != iPInfo.getIpBootProcess()) {
            this.chassisEventAdapter.registerEventHandler(202, "receiveChassisEvent");
            this.waitingOnIpChange = true;
            iPInfo2.setIpAddress(this.newIpAddress);
            iPInfo2.setGateway(inetAddress);
            iPInfo2.setNetMask(n3);
            iPInfo2.setIpBootProcess(n2);
        }
        String string4 = this.contactText.getText().trim();
        String string5 = this.locationText.getText().trim();
        String string6 = this.trapAddrText.getText().trim();
        if (IpAddress.isNumeric(string6) && !IpAddress.isValidTrapAddress(string6)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrapAddr"));
            return -1;
        }
        String string7 = this.readCommText.getText().trim();
        String string8 = this.writeCommText.getText().trim();
        String string9 = this.trapCommText.getText().trim();
        int n4 = this.trapAuthCombo.getSelectedIndex();
        if (n4 < 0) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidTrapAuthentication"));
            return -1;
        }
        int n5 = n4 == 0 ? 1 : 0;
        SnmpInfo snmpInfo = this.blade.getSnmpInfo();
        SnmpInfo snmpInfo2 = this.properties.copySnmpInfo(snmpInfo);
        if (!(string4.equals(snmpInfo.getContact()) && string5.equals(snmpInfo.getLocation()) && string6.equals(snmpInfo.getTrapAddress().getHostAddress()) && string7.equals(snmpInfo.getReadComm()) && string8.equals(snmpInfo.getWriteComm()) && string9.equals(snmpInfo.getTrapComm()) && n5 == (int)snmpInfo.getDoAuthTrap())) {
            this.chassisEventAdapter.registerEventHandler(214, "receiveChassisEvent");
            this.waitingOnSnmpChange = true;
            snmpInfo2.setName(snmpInfo.getName());
            snmpInfo2.setContact(string4);
            snmpInfo2.setLocation(string5);
            try {
                snmpInfo2.setTrapAddress(InetAddress.getByName(string6));
            }
            catch (Exception exception) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrapAddr"));
                return -1;
            }
            snmpInfo2.setDoAuthTrap((long)n5);
            snmpInfo2.setReadComm(string7);
            snmpInfo2.setWriteComm(string8);
            snmpInfo2.setTrapComm(string9);
            if (string7.length() > 0 || string8.length() > 0 || string9.length() > 0) {
                this.waitingOnSnmpCommunities = true;
                this.chassisEventAdapter.registerEventHandler(270, "receiveChassisEvent");
                snmpInfo2.setReadComm(string7);
                snmpInfo2.setWriteComm(string8);
                snmpInfo2.setTrapComm(string9);
            }
        }
        if (this.waitingOnSnmpChange) {
            this.blade.applySnmpInfo(snmpInfo2);
        }
        if (this.waitingOnSnmpCommunities) {
            ((SanboxUtil)this.blade).applySnmpCommunities(snmpInfo2);
        }
        if (this.waitingOnIpChange) {
            boolean bl3 = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.resetNeeded"));
            this.blade.applyIpInfo(iPInfo2);
            if (bl3) {
                this.waitingOnReset = true;
                this.chassisEventAdapter.registerEventHandler(252, "receiveChassisEvent");
                this.blade.reset();
                PopupDialog.showDialog(this, 2, FabricTreeControl.getResource("SwitchPropertiesDialog.resetTakesTime"));
            } else {
                PopupDialog.showDialog(this, 2, FabricTreeControl.getResource("SwitchPropertiesDialog.noReset"));
            }
        }
        return 1;
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(201));
        vector.add(new Integer(213));
        vector.add(new Integer(312));
        return vector;
    }

    protected void unregisterForEvents() {
        this.chassisEventAdapter.unregisterEventHandler(214);
        this.chassisEventAdapter.unregisterEventHandler(202);
        this.chassisEventAdapter.unregisterEventHandler(270);
        this.chassisEventAdapter.unregisterEventHandler(252);
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        NetworkPropertiesDialogSanbox dialog = null;

        public ApplyResponseHandler(NetworkPropertiesDialogSanbox networkPropertiesDialogSanbox2, ChassisEvent chassisEvent) {
            this.dialog = networkPropertiesDialogSanbox2;
            this.evt = chassisEvent;
        }

        public void run() {
            int n = this.evt.getEventType();
            switch (n) {
                case 214: {
                    if (!NetworkPropertiesDialogSanbox.this.waitingOnSnmpChange) break;
                    NetworkPropertiesDialogSanbox.this.waitingOnSnmpChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.snmpChangeFailed") + "\n" + NetworkPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (NetworkPropertiesDialogSanbox.this.waitingOnIpChange || NetworkPropertiesDialogSanbox.this.waitingOnSnmpCommunities || NetworkPropertiesDialogSanbox.this.waitingOnReset) break;
                    NetworkPropertiesDialogSanbox.this.enableButtons();
                    NetworkPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(NetworkPropertiesDialogSanbox.this.frame, NetworkPropertiesDialogSanbox.this.blade, NetworkPropertiesDialogSanbox.this.getEventList(), FabricTreeControl.getResource("NetworkPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 270: {
                    WaitForUpdateDialog waitForUpdateDialog;
                    NetworkPropertiesDialogSanbox.this.waitingOnSnmpCommunities = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.error.snmpStringsFailed") + "\n" + NetworkPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (!(NetworkPropertiesDialogSanbox.this.waitingOnSnmpChange || NetworkPropertiesDialogSanbox.this.waitingOnIpChange || NetworkPropertiesDialogSanbox.this.waitingOnReset)) {
                        NetworkPropertiesDialogSanbox.this.enableButtons();
                        NetworkPropertiesDialogSanbox.this.unregisterForEvents();
                        this.dialog.setVisible(false);
                        waitForUpdateDialog = WaitForUpdateDialog.getInstance(NetworkPropertiesDialogSanbox.this.frame, NetworkPropertiesDialogSanbox.this.blade, NetworkPropertiesDialogSanbox.this.getEventList(), FabricTreeControl.getResource("NetworkPropertiesDialog.updating"));
                        waitForUpdateDialog.setVisible(true);
                    }
                }
                case 202: {
                    NetworkPropertiesDialogSanbox.this.waitingOnIpChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.ipChangeFailed") + "\n" + NetworkPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    } else {
                        NetworkPropertiesDialogSanbox.this.ipChangeSuccessful = true;
                    }
                    if (NetworkPropertiesDialogSanbox.this.waitingOnSnmpChange || NetworkPropertiesDialogSanbox.this.waitingOnSnmpCommunities || NetworkPropertiesDialogSanbox.this.waitingOnReset) break;
                    NetworkPropertiesDialogSanbox.this.enableButtons();
                    NetworkPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(NetworkPropertiesDialogSanbox.this.frame, NetworkPropertiesDialogSanbox.this.blade, NetworkPropertiesDialogSanbox.this.getEventList(), FabricTreeControl.getResource("NetworkPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 252: {
                    NetworkPropertiesDialogSanbox.this.waitingOnReset = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.ipChangeFailedReason") + "\n" + NetworkPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    } else if (NetworkPropertiesDialogSanbox.this.ipChangeSuccessful && NetworkPropertiesDialogSanbox.this.fabric != null && NetworkPropertiesDialogSanbox.this.fabric.getConnectionSwitch() == NetworkPropertiesDialogSanbox.this.blade) {
                        NetworkPropertiesDialogSanbox.this.fabric.getComAgent().setIpAddress(NetworkPropertiesDialogSanbox.this.newIpAddress);
                    }
                    NetworkPropertiesDialogSanbox.this.enableButtons();
                    NetworkPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                }
            }
        }
    }

    class BootMethodComboListener
    implements ActionListener {
        NetworkPropertiesDialogSanbox theDialog = null;

        public BootMethodComboListener(NetworkPropertiesDialogSanbox networkPropertiesDialogSanbox2) {
            this.theDialog = networkPropertiesDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NetworkPropertiesDialogSanbox.this.bootMethodCombo.getSelectedIndex() == 2) {
                NetworkPropertiesDialogSanbox.this.ipAddrText.setEnabled(false);
                NetworkPropertiesDialogSanbox.this.ipAddrLabel.setEnabled(false);
            } else {
                NetworkPropertiesDialogSanbox.this.ipAddrText.setEnabled(true);
                NetworkPropertiesDialogSanbox.this.ipAddrLabel.setEnabled(true);
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        NetworkPropertiesDialogSanbox theDialog = null;

        public CancelButtonListener(NetworkPropertiesDialogSanbox networkPropertiesDialogSanbox2) {
            this.theDialog = networkPropertiesDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkPropertiesDialogSanbox.this.enableButtons();
            NetworkPropertiesDialogSanbox.this.unregisterForEvents();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        NetworkPropertiesDialogSanbox theDialog = null;

        public ApplyButtonListener(NetworkPropertiesDialogSanbox networkPropertiesDialogSanbox2) {
            this.theDialog = networkPropertiesDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyNetworkProperties() == 1) {
                if (NetworkPropertiesDialogSanbox.this.waitingOnIpChange || NetworkPropertiesDialogSanbox.this.waitingOnSnmpChange || NetworkPropertiesDialogSanbox.this.waitingOnSnmpCommunities || NetworkPropertiesDialogSanbox.this.waitingOnReset) {
                    NetworkPropertiesDialogSanbox.this.disableButtons();
                } else {
                    NetworkPropertiesDialogSanbox.this.enableButtons();
                    NetworkPropertiesDialogSanbox.this.unregisterForEvents();
                    this.theDialog.setVisible(false);
                    NetworkPropertiesDialogSanbox.this.blade.updateAll();
                }
            }
        }
    }
}

